function result = FluctuationRationalityRecNW(m,forecasterror,x1,x2)
%   INPUT: m=size of rolling window
%	forecasterror=actual - forecast
%	x1 is the variable you want to test coefficients equal to zero, x2 is the other regressors
%   if want to test all coefficients, specify x2 = []
%   cvtable below has the critical values reported in our Table 1, panel C
%   for 10% significance level

cvtable = [
       NaN    0.1000    0.2000    0.3000    0.4000    0.5000    0.6000    0.7000    0.8000    0.9000
    1.0000   11.8290   10.5637    8.9252    8.1468    8.1409    7.2803    6.4978    6.0837    5.4695
    2.0000   14.9966   13.0846   12.8141   10.9084   11.1314    9.9386    9.1724    9.0589    7.8305
    3.0000   17.6768   15.7548   15.0608   13.4383   13.2113   12.6018   10.9597   10.8426    9.4727
    4.0000   19.8434   17.6051   17.0158   16.3186   15.1404   14.7573   13.5928   13.1087   10.8243
    5.0000   21.7091   20.4659   18.7186   18.2152   17.1092   15.6317   15.4842   13.9418   13.6335
    6.0000   24.2721   22.4870   20.9717   20.2839   20.2971   17.8602   16.5583   15.4633   14.4789
    7.0000   26.2869   24.2644   22.8543   21.6818   20.5974   20.1200   19.0697   17.7064   15.9126
    8.0000   28.3030   25.7461   24.3315   23.4497   22.4328   21.1563   20.3632   19.1440   18.1475
    9.0000   29.5489   27.9249   26.8101   25.2662   24.2510   22.7821   21.7109   20.2745   19.7147
   10.0000   31.7548   29.4709   27.5980   27.0357   25.3011   25.3250   23.4556   22.6180   21.6647];

P = size(forecasterror,1); 
nreg = size(x1,2);
mu = m/P; cvcol = round(mu*10)+1; 
if cvcol == 1; cvcol = 2; end; if cvcol > 10; cvcol = 10; end; 
cv = cvtable(nreg+1,cvcol); 

resultcum=[]; coeff = [];  
for t=m:P  
    if (isempty(x2) == 1)
        [out coef] = olsWaldtestNW(forecasterror(t-m+1:t,:),x1(t-m+1:t,:)); 
    else
        [out coef] = olsWaldtestNW(forecasterror(t-m+1:t,:),x1(t-m+1:t,:),x2(t-m+1:t,:));
    end        
    resultcum=[resultcum; out];
    coeff = [coeff; coef'];
end
     
result.MZ = max(resultcum);
result.MZrej = (sum(resultcum > cv*ones(size(resultcum,1),1))) > 0;
result.cv = cv;
result.wseries = resultcum;
result.coef = coeff;