% Executable to get the critical values reported in Table 1, Panel B.
clear all
matlabpool close force local

MC = 1000; 
T = 1000;
Rmvalues = [0.5 0.25; 0.5 0.3; 0.3 0.25; 0.3 0.3];
sizev = [1; 5; 10];
elvec = 1:10;

cvtablematrix = nan*ones(size(elvec,2),size(Rmvalues,1),size(sizev,1)); 
for el = elvec
    for combn = 1:4
        combinhere = Rmvalues(combn,:);
        rho = combinhere(1,1); 
        mu = combinhere(1,2);
        cv = CriticalValuesTable(rho, mu, T, MC, sizev, el);
        cvtablematrix(el,combn,:) = cv;
    end
end
delete cvtable.out; diary cvtable.out; 
disp(['Critical values, size=',num2str(sizev(1,1))])
disp(cvtablematrix(:,:,1))
disp(['Critical values, size=',num2str(sizev(2,1))])
disp(cvtablematrix(:,:,2))
disp(['Critical values, size=',num2str(sizev(3,1))])
disp(cvtablematrix(:,:,3))
diary off      