function [Omegatau Omegataumu sigmaf sigmah sigmahmu] = RollWeights(j,R,m,T,l,k)
% Rolling Weights approximated as suggested in the paper.
if nargin < 5
    error('not enough arguments specified for this function')
end

rho = R/T; 
mu = m/T;
tau = j/T;

for t = 1:j
    s = t/T;
    if j-R >=R
        if t <= R
            sigmah(t,1) = s/rho;
        elseif (t > R && t <= j-R)
            sigmah(t,1) = 1;
        elseif (t > j-R && t < j)
            sigmah(t,1) = (tau - s)/rho;
        end
    elseif j-R<R
        if t <= j-R
            sigmah(t,1) = s/rho;
        elseif (t > j-R && t <= R)
            sigmah(t,1) = (tau - rho)/rho;
        elseif (t > R && t < j)
            sigmah(t,1) = (tau - s)/rho;
        end
    end

    if j-m-R >=R
        if t <= R
            sigmahmu(t,1) = s/rho;
        elseif (t > R && t <= j-m-R)
            sigmahmu(t,1) = 1;
        elseif (t > j-m-R && t < j-m)
            sigmahmu(t,1) = (tau-mu-s)/rho;
        end
    elseif j-m-R<R
        if t <= j-m-R
            sigmahmu(t,1) = s/rho;
        elseif (t > j-m-R && t <= R)
            sigmahmu(t,1) = (tau-mu-rho)/rho;
        elseif (t > R && t < j-m)
            sigmahmu(t,1) = (tau-mu-s)/rho;
        end
    end

    if (t >= R && t < j)
        sigmaf(t,1) = 1;
    else
        sigmaf(t,1) = 0;
    end

    if nargin > 5
    	if (t < j)
        	Omegatau(:,:,t) = [eye(l)*sigmaf(t,1) zeros(l,k); zeros(l,k)' eye(k)*sigmah(t,1)];
    	end
    	if (t < j-m)
        	Omegataumu(:,:,t) = [eye(l)*sigmaf(t,1) zeros(l,k); zeros(l,k)' eye(k)*sigmahmu(t,1)];
    	end
    else 
        Omegatau = [];
        Omegataumu = [];
   end
end