% executable file to get the critical values corresponding to footnote 14
% in the paper
clear all
matlabpool close force local

mc = 1000; 
T = 1000;
rhovalues = [0.3; 0.5];
sizev = [1; 5; 10];
elvec = 1:2;
mu = 0.25;

cvtablematrix = nan*ones(size(elvec,2),size(rhovalues,1),size(sizev,1));

for el = elvec
    for i  = 1:size(rhovalues,1)
        rho = rhovalues(i,:);
        cv = CriticalValuesTableRecursivem(rho, mu, T, mc, sizev, el);
        cvtablematrix(el,i,:) = cv;
    end
end
delete cvtable.out; diary cvtable.out; 
disp(['Critical values, size=',num2str(sizev(1,1))])
disp(cvtablematrix(:,:,1))
disp(['Critical values, size=',num2str(sizev(2,1))])
disp(cvtablematrix(:,:,2))
disp(['Critical values, size=',num2str(sizev(3,1))])
disp(cvtablematrix(:,:,3))
diary off      