function [Omegatau sigmaf sigmah] = RecWeights(j,R,T,l,k)
% Recursive Weights when the second stage regression is conducted
% recursively. mu is not a nuisance parameter in this case.
if nargin < 4
    error('not enough arguments specified for this function')
end

rho = R/T; 
tau = j/T;

for t = 1:j
    s = t/T;
    if t <= R
        sigmah(t,1) = log(tau) - log(rho);
    elseif (t > R && t < j)
        sigmah(t,1) = log(tau) - log(s);
    end

    if (t >= R && t < j)
        sigmaf(t,1) = 1;
    else
        sigmaf(t,1) = 0;
    end

    if nargin > 4
    	if (t < j)
        	Omegatau(:,:,t) = [eye(l)*sigmaf(t,1) zeros(l,k); zeros(l,k)' eye(k)*sigmah(t,1)];
        end
    else 
        Omegatau = [];
   end
end