function results = CriticalValuesTableRecursivem(rho, mu, T, mc, sizev, l)
% Calculates the critical values under the West and McCracken condition
% in Proposition 7 and the results in Proposition 4. Estimation is recursive, m is also recursive.
% Corresponds to footnotes 10 and 14 in the paper.
R = round(rho*T);
m = round(mu*T);

parfor i = 1:mc
    stream = RandStream('mrg32k3a','seed',4829575);
    stream.Substream = i;
    eps = randn(stream,l,T+1);
    
    BappxtauWM = [];    
    WaldcritgenWM = zeros(T-(R+m)+1,1);

    for j = R+m:T+1         
        [~, sigmaf, sigmah] = RecWeights(j,R,T,l);
        
        BrWM = 0;
        for t = 1:j-1
            % Here we do not have (sigmaf(t,1) - sigmah(t,1))^2, since the
            % terms related to sigmah disappear by Propostion 4
            littleomegatildawm = (sigmaf(t,1))^2;
            littleomegatildawm = sqrt(littleomegatildawm)*eye(l);
            BrWM = BrWM + littleomegatildawm*eps(:,t)*sqrt(1/T);
        end
        BappxgenWM = [BappxtauWM; BrWM']; 
        
        WaldcritgenWM(j-(R+m)+1,1) = BappxgenWM(end,:)*BappxgenWM(end,:)';    
    end
    supWaldcritgenWM(:,i) =  max(WaldcritgenWM,[],1);
end
results(:,1) = prctile(supWaldcritgenWM, 100-sizev(1,1), 2);
results(:,2) = prctile(supWaldcritgenWM, 100-sizev(2,1), 2);
results(:,3) = prctile(supWaldcritgenWM, 100-sizev(3,1), 2);