function [Omegatau Omegataumu sigmaf sigmah sigmahmu] = RecWeights(j,R,m,T,l,k)
% Recursive Weights as approximations calculated in the paper
if nargin < 5
    error('not enough arguments specified for this function')
end

rho = R/T; 
mu = m/T;
tau = j/T;

for t = 1:j
    s = t/T;
    if t <= R
        sigmah(t,1) = log(tau) - log(rho);
    elseif (t > R && t < j)
        sigmah(t,1) = log(tau) - log(s);
    end
    
    if t <= R
        sigmahmu(t,1) = log(tau - mu) - log(rho);
    elseif (t > R && t < j-m)
        sigmahmu(t,1) = log(tau - mu) - log(s);
    end

    if (t >= R && t < j)
        sigmaf(t,1) = 1;
    else
        sigmaf(t,1) = 0;
    end

    if nargin > 5
    	if (t < j)
        	Omegatau(:,:,t) = [eye(l)*sigmaf(t,1) zeros(l,k); zeros(l,k)' eye(k)*sigmah(t,1)];
    	end
    	if (t < j-m)
        	Omegataumu(:,:,t) = [eye(l)*sigmaf(t,1) zeros(l,k); zeros(l,k)' eye(k)*sigmahmu(t,1)];
    	end
    else 
        Omegatau = [];
        Omegataumu = [];
   end
end