function results = CriticalValuesTable(rho, mu, T, mc, sizev, l)
% Calculates the critical values under the West and McCracken condition
% in Proposition 7 and the results in Proposition 4. Estimation window is recursive, m is rolling.
R = round(rho*T);
m = round(mu*T);

parfor i = 1:mc
    stream = RandStream('mrg32k3a','seed',4829575);
    stream.Substream = i;
    eps = randn(stream,l, T+1);
    
    BappxtauWM = [];
    BappxtaumuWM = []; 
    WaldcritgenWM = zeros(T-(R+m)+1,1);
    
    for j = R+m:T+1
        lambda = 1;
         
        [~, ~, sigmaf, sigmah, sigmahmu] = RecWeights(j,R,m,T,l);
        
        BrWM = 0;
        for t = 1:j-1
            % Here we do not have (sigmaf(t,1) - sigmah(t,1))^2, since the
            % terms related to sigmah disappear by Propostion 4
            littleomegatildawm = mu^(-1)*(sigmaf(t,1))^2;
            littleomegatildawm = sqrt(littleomegatildawm)*eye(l);
            BrWM = BrWM + littleomegatildawm*eps(:,t)*sqrt(1/T);
        end
        BappxtauWM = [BappxtauWM; BrWM'];

        BrmWM = 0;
        for t = 1:j-m-1
            % Here we do not have (sigmaf(t,1) - sigmah(t,1))^2, since the
            % terms related to sigmahmu disappear by Propostion 4
            littleomegamtildawm = mu^(-1)*(sigmaf(t,1))^2;
            littleomegamtildawm = sqrt(littleomegamtildawm)*eye(l);
            BrmWM = BrmWM + littleomegamtildawm*eps(:,t)*sqrt(1/T);
        end
        BappxtaumuWM = [BappxtaumuWM; BrmWM'];
        
        BappxgenWM = BappxtauWM - BappxtaumuWM;

        vtwm = lambda;              
        WaldcritgenWM(j-R-m+1,1) = BappxgenWM(end,:)*inv(vtwm)*BappxgenWM(end,:)';    
    end
    supWaldcritgenWM(:,i) =  max(WaldcritgenWM,[],1);
end
results(:,1) = prctile(supWaldcritgenWM, 100-sizev(1,1), 2);
results(:,2) = prctile(supWaldcritgenWM, 100-sizev(2,1), 2);
results(:,3) = prctile(supWaldcritgenWM, 100-sizev(3,1), 2);