% executable file to get the critical values corresponding to Table 1,
% Panel C.
clear all;
P = 1000; 
MC = 1000;
randn('seed',13);
lvec = 1:1:10; 
muv = 0.1:0.1:0.9;

tableSUPwald90 = zeros(size(lvec,2), size(muv,2));
tableSUPwald95 = zeros(size(lvec,2), size(muv,2));
tableSUPwald99 = zeros(size(lvec,2), size(muv,2));

muindex = 0; lindex = 0; 
for l = lvec 
    lindex = lindex+1;
    muindex = 0;
    for mu = muv  
        m = round(mu*P); 
        muindex = muindex+1; 
        MCvSUPwald = []; 
        for rep = 1:MC
            eps = randn(P,l);
            Wv = [];
            for tau = m:P
                Asum = []; 
                for s = 1:l
                    Asum = [Asum; (sum(eps(tau-m+1:tau,s),1)/sqrt(m))]; 
                end
                Wv = [Wv; Asum'*Asum];
            end
            MCvSUPwald = [MCvSUPwald; max(Wv)];
        end
        
        MCvS = sort(MCvSUPwald);
        tableSUPwald90(lindex,muindex) = MCvS(0.9*MC);
        tableSUPwald95(lindex,muindex) = MCvS(0.95*MC);
        tableSUPwald99(lindex,muindex) = MCvS(0.99*MC); 
    end
end

delete CvTableSurvey.out; diary CvTableSurvey.out;
disp('90% critical values'); disp([nan,muv; [lvec',tableSUPwald90] ]);  
disp('95% critical values'); disp([nan,muv; [lvec',tableSUPwald95] ]); 
disp('99% critical values'); disp([nan,muv; [lvec',tableSUPwald99] ]);  
diary off;