/*

If you have any questions, contact:

David E. Rapach
Department of Economics
Saint Louis University
3674 Lindell Boulevard
Saint Louis, MO 63108-3397
rapachde@slu.edu
http://pages.slu.edu/faculty/rapachde/

*/

load data[129,3]=c:\research\preg\Data.txt;
data=data[1:127,.];
/*output file=c:\research\preg\Pe_nl.out reset;*/
ny=rows(data);
p=ln(data[2:ny,1]);
d=ln(data[1:ny-1,3]);
z=p-d;
"P/E";

/* Expressing z in deviation form */

t=rows(z);
xd=ones(t,1);
bd=z/xd;
z=z-xd*bd;
p=1;
{z,zlag}=varlags(z,p);
b0=-1;

/* Estimating ESTAR model */

{b,f,g,retcode}=sqpsolve(&ssr_est,b0);?;
"Return code = " retcode;?;
xx=vvf_est(b);
u=z-xx;
ssr0=u'u;
s2=ssr0/rows(z);
db=gradp(&vvf_est,b);
covb=s2*invpd(db'db);
seb=sqrt(diag(covb));
tstat=b./seb;
r2=1-(u'u/z'z);
dw=sumc((u[2:t-p,.]-u[1:t-p-1,.])^2)/sumc(u^2);
q=1;
dg=gradp(&vvf_est,b);
{uhat,uhatlag}=varlags(u,q);
{dg,dglag}=varlags(dg,q);
xlm=uhatlag~dg;
blm=uhat/xlm;
ulm=uhat-xlm*blm;
ssrlm=ulm'ulm;
flm=((ssr0-ssrlm)/q)/(ssrlm/(rows(ulm)-cols(dg)-q));

/* Computing marginal significance level for t-stat */

dz=z-zlag;
s2ur=dz'dz/rows(z);
__output=0;
repl=500;
extra=100;
tstatstar=zeros(repl,1);
iter=1;
do until iter>repl;
   estar=sqrt(s2ur)*rndn(t+extra,1);
   estar=estar-meanc(estar);
   dz=estar;
   z=cumsumc(dz);
   z=z[extra+1:t+extra,.];
   {z,zlag}=varlags(z,p);
   {bstar,f,g,retcode}=sqpsolve(&ssr_est,b0);
   xxstar=vvf_est(bstar);
   ustar=z-xxstar;
   s2star=ustar'ustar/rows(z);
   dbstar=gradp(&vvf_est,bstar);
   covbstar=s2star*inv(dbstar'dbstar);
   sebstar=sqrt(diag(covbstar));
   tstatstar0=bstar./sebstar;
   tstatstar[iter,.]=tstatstar0;
   "iter " iter;
   if g>.00001;
      iter=iter;
   else;
      iter=iter+1;
   endif;
endo;
tstatstar=sortc(tstatstar,1);
tsig=counts(tstatstar,tstat)/repl;
?;
"Coefficient estimates and t-statistics";?;
b~tstat;?;
"gamma t-stat sig level = " tsig;
"R-squared              = " r2;
"s                      = " sqrt(s2);
"DW                     = " dw;
"q                      = " q;
"AR(q) F-stat           = " flm;
"F-stat p-value         = " cdffc(flm,q,rows(ulm)-cols(dg)-q);?;

/* Transition function */

z=ln(data[.,1])-ln(data[.,3]);
t=rows(z);
xd=ones(t,1);
bd=z/xd;
z=z-xd*bd;
{z,zlag}=varlags(z,p);
zlag=sortc(zlag[.,1],1);
tf=exp(b[1,.]*zlag[.,1]^2);
"Transition function";
zlag~tf;?;

/* Procedure definition area */

/**********************  PROC VARLAGS  *****************************
**   last update: 5 Dec 95      previous: 15 June 94
**   AUTHOR
**        Alan G. Isaac
**   FORMAT
**        {x,xlags} = varlags(var,lags)
**   INPUT
**        var  - T x K matrix
**        lags - scalar, number of lags of var (a positive integer)
**   OUTPUT
**        x -     (T - lags) x K matrix, the last T-lags rows of var
**        xlags - (T - lags) x lags*cols(var) matrix,
**                being the 1st through lags-th
**                values of var corresponding to the values in x
**                i.e, the appropriate rows of x(-1)~x(-2)~etc.
**   GLOBAL VARIABLES: none
**********************************************************************/
proc(2)=varlags(var,lags);
    local xlags;
    xlags = shiftr((ones(1,lags) .*. var)',seqa(1-lags,1,lags)
                                            .*. ones(cols(var),1),miss(0,0))';
    retp(trimr(var,lags,0),trimr(xlags,0,lags));
endp;

proc(1)=ssr_est(b0);
   local resid,ssr;
   resid=z-((exp(b0[1,.]*zlag^2)).*zlag);
   ssr=sumc(resid^2);
   retp(ssr);
endp;

proc(1)=vvf_est(b0);
   local d;
   d=(exp(b0[1,.]*zlag^2)).*zlag;
   retp(d);
endp;

proc(1)=gcompute(b0);
   local g;
   g=gradp(&ssr_est,b0);
   retp(g');
endp;
