########### Bayesian EASI###########
##### Date: 19/02/2020
##### Author: Andres Ramirez Hassan

rm(list = ls())
set.seed(123)

######## Data##################
mydata <- read.csv("EASIdata.csv")
attach(mydata)
str(mydata)

##############EXOGENEOUS ESTIMATION USING STONE INDEX###########
W <- cbind(sfoodh, sfoodr, srent, soper, sfurn, scloth, stranop, srecr)
Z <- cbind(age, hsex, carown, tran, time)
w_bar <- colMeans(W)
Stone <- pfoodh * sfoodh + pfoodr * sfoodr + prent * srent + poper * soper + pfurn * sfurn + pcloth * scloth + ptranop * stranop + precr * srecr + ppers * spers
P <- cbind(pfoodh - ppers, pfoodr - ppers, prent - ppers, poper - ppers, pfurn - ppers, pcloth - ppers, ptranop - ppers, precr - ppers)
PLarge <- cbind(pfoodh, pfoodr, prent, poper, pfurn, pcloth, ptranop, precr, ppers)
J <- dim(W)[2]
IJ <- diag(J)
DJ <- matrixcalc::duplication.matrix(J)

######## Frequentist estimation########
Matrices <- as.matrix(read.csv("ResultsMatrices.csv", header = TRUE, sep = ",")[, -1])

b0 <- Matrices[, 1]
b1 <- Matrices[, 2]
b2 <- Matrices[, 3]
b3 <- Matrices[, 4]
b4 <- Matrices[, 5]
b5 <- Matrices[, 6]
C <- Matrices[, 7:11]
D <- Matrices[, 12:16]
A0 <- Matrices[, 17:24]
B <- Matrices[, 25:32]
A1 <- Matrices[, 33:40]
A2 <- Matrices[, 41:48]
A3 <- Matrices[, 49:56]
A4 <- Matrices[, 57:64]
A5 <- Matrices[, 65:72]

############# TAKING INTO ACCOUNT ENDOGENEITY USING AS INSTRUMENT LASPEYRES##########
############# INDEX AND NONLINEARITY #############
bp <- 1697 # Base period for prices
Laspeyres <- pfoodh * mean(sfoodh) + pfoodr * mean(sfoodr) + prent * mean(srent) + poper * mean(soper) + pfurn * mean(sfurn) + pcloth * mean(scloth) + ptranop * mean(stranop) + precr * mean(srecr) + ppers * mean(spers)

####### Instruments#######
yInst <- log_y - Laspeyres
YZInst <- cbind(yInst, yInst^2, yInst^3, yInst^4, yInst^5, yInst * Z)

######## Initial y assuming Al=B=0#########
y <- log_y - Stone
YZ <- cbind(y, y^2, y^3, y^4, y^5, y * Z)
XEnd <- cbind(YZ, y * P)
kEnd <- dim(YZ)[2] + dim(P)[2] #Number of endogeneous variables
IkEnd <- diag(kEnd)

GenY <- function(h){
  Yh <- (log_y[h] - Stone[h] + 0.5*(t(PLarge[h, ])%*%A0Post%*%PLarge[h, ] + Z[h, 1]*t(PLarge[h, ])%*%A1Post%*%PLarge[h, ] + Z[h, 2]*t(PLarge[h, ])%*%A2Post%*%PLarge[h, ] +
                                      Z[h, 3]*t(PLarge[h, ])%*%A3Post%*%PLarge[h, ] + Z[h, 4]*t(PLarge[h, ])%*%A4Post%*%PLarge[h, ] + Z[h, 5]*t(PLarge[h, ])%*%A5Post%*%PLarge[h, ]))/(1 - 0.5*t(PLarge[h, ])%*%BPost%*%PLarge[h, ])
}

###### Regressors########
H <- dim(mydata)[1]

GenX <- function(h) {
  cbind(kronecker(IJ, t(YZ[h, ])), kronecker(IJ, y[h] * t(P[h, ])) %*% DJ)
} 

X <- lapply(1:H, GenX)

GenS1 <- function(h) {
  cbind(
    kronecker(IJ, t(c(1, Z[h, ]))), kronecker(IJ, t(P[h, ])) %*% DJ, kronecker(IJ, Z[h, 1] * t(P[h, ])) %*% DJ, kronecker(IJ, Z[h, 2] * t(P[h, ])) %*% DJ, kronecker(IJ, Z[h, 3] * t(P[h, ])) %*% DJ,
    kronecker(IJ, Z[h, 4] * t(P[h, ])) %*% DJ, kronecker(IJ, Z[h, 5] * t(P[h, ])) %*% DJ
  )
} 

S1 <- lapply(1:H, GenS1)

GenINST <- function(h) {
  cbind(kronecker(IkEnd, t(YZInst[h, ])), kronecker(IkEnd, yInst[h] * t(P[h, ])))
}

INST <- lapply(1:H, GenINST)

GenS2 <- function(h) {
  cbind(
    kronecker(IkEnd, t(c(1, Z[h, ]))), kronecker(IkEnd, t(P[h, ])), kronecker(IkEnd, Z[h, 1] * t(P[h, ])), kronecker(IkEnd, Z[h, 2] * t(P[h, ])), kronecker(IkEnd, Z[h, 3] * t(P[h, ])),
    kronecker(IkEnd, Z[h, 4] * t(P[h, ])), kronecker(IkEnd, Z[h, 5] * t(P[h, ]))
  )
}

S2 <- lapply(1:H, GenS2)

thetaX <- matrix(0, kEnd - J, J)
thetaS1 <- matrix(0, 1 + dim(Z)[2], J)
for (i in 1:J) {
  thetaX[, i] <- c(b1[i], b2[i], b3[i], b4[i], b5[i], D[i, ])
  thetaS1[, i] <- c(b0[i], C[i, ])
}

require(matrixcalc)
PHI <- c(thetaX, vech(t(B)), thetaS1, vech(t(A0)), vech(t(A1)), vech(t(A2)), vech(t(A3)), vech(t(A4)), vech(t(A5)))
K1 <- length(PHI)
PHI <- rep(0, K1)
K2 <- dim(S2[[H]])[2] + dim(INST[[H]])[2]

######## Priors: Hyperparameters#######
phi0 <- rep(0, K1)
PHI0 <- 10000 * diag(K1)
PHI0I <- solve(PHI0)

psi0 <- rep(0, K2)
PSI0 <- 10000 * diag(K2)
PSI0I <- solve(PSI0)

r0 <- J + kEnd + 1
dimS <- J + kEnd
R0 <- diag(dimS)
R0I <- solve(R0)

######### Posteriors###############
sample_LatShares <- function(wh, S1h, S2h, Xh, INSTh, XEndh, PHI, PSI, SIGMA){
  Index <- which(wh==0)
  if(sum(Index) != 0){
    SIGMA12 <- SIGMA[Index, -Index]
    SIGMA22 <- SIGMA[-Index, -Index]
    SIGMA22I <- solve(SIGMA22)
    SIGMA21 <- SIGMA[-Index, Index]
    SIGMA11 <- SIGMA[Index, Index]
    SIGMA1222I <- SIGMA12%*%SIGMA22I
    VARp <- SIGMA11-SIGMA1222I%*%SIGMA21
    Mh <- cbind(Xh, S1h)
    MPHIph <- Mh %*% PHI
    Gh <- cbind(INSTh, S2h)
    GPSIh <- Gh %*% PSI
    Meanp <- as.vector(MPHIph[Index,] + SIGMA1222I%*%c(wh[-Index]- MPHIph[-Index,], XEndh - GPSIh))
    if(sum(Index)==1){
      whLn <- truncnorm::rtruncnorm(1, a=-Inf, b=0, mean = Meanp, sd = VARp^0.5)
    } else{
      whLn <- tmvtnorm::rtmvnorm(1, mean = Meanp, sigma = VARp, lower=rep(-Inf, length = length(Meanp)),
                                 upper=rep( 0, length = length(Meanp)), algorithm = "gibbs")}
    whLn[which(whLn == -Inf)] <- 0
    whLn[which(is.na(whLn))] <- 0
    whLp <- wh[-Index]*(1 - sum(whLn))
    whL <- wh
    whL[Index] <- whLn
    whL[-Index] <- whLp
  } else{
    whL <- wh
  }
  return(whL)
}

sample_PSI_END <- function(PHI, SIGMA, WL) {
  Sigmav <- SIGMA[(J + 1):(J + kEnd), (J + 1):(J + kEnd)]
  Sigmave <- SIGMA[(J + 1):(J + kEnd), 1:J]
  Sigmae <- SIGMA[1:J, 1:J]
  Sigmaev <- t(Sigmave)
  SigmaeI <- solve(Sigmae)
  Sigmav_eI <- solve(Sigmav - Sigmave %*% SigmaeI %*% Sigmaev)
  GvarG <- matrix(0, K2, K2)
  GvarX <- matrix(0, K2, 1)
  for (h in 1:H) {
    G <- cbind(INST[[h]], S2[[h]])
    M <- cbind(X[[h]], S1[[h]])
    GvarGh <- t(G) %*% Sigmav_eI %*% G
    GvarG <- GvarG + GvarGh
    GvarXh <- t(G) %*% Sigmav_eI %*% (XEnd[h, ] - Sigmave %*% SigmaeI %*% (WL[h, ] - M %*% PHI))
    GvarX <- GvarX + GvarXh
  }
  Var_PSI <- solve(GvarG + PSI0I)
  Mean_PSI <- Var_PSI %*% (GvarX + PSI0I %*% psi0)
  PSI <- MASS::mvrnorm(n = 1, mu = Mean_PSI, Sigma = Var_PSI)
  return(PSI)
}

sample_PHI_END <- function(PSI, SIGMA, WL) {
  Sigmav <- SIGMA[(J + 1):(J + kEnd), (J + 1):(J + kEnd)]
  Sigmave <- SIGMA[(J + 1):(J + kEnd), 1:J]
  Sigmae <- SIGMA[1:J, 1:J]
  Sigmaev <- t(Sigmave)
  SigmavI <- solve(Sigmav)
  Sigmae_vI <- solve(Sigmae - Sigmaev %*% SigmavI %*% Sigmave)
  MvarM <- matrix(0, K1, K1)
  MvarW <- matrix(0, K1, 1)
  for (h in 1:H) {
    G <- cbind(INST[[h]], S2[[h]])
    M <- cbind(X[[h]], S1[[h]])
    MvarMh <- t(M) %*% Sigmae_vI %*% M
    MvarM <- MvarM + MvarMh
    MvarWh <- t(M) %*% Sigmae_vI %*% (WL[h, ] - Sigmaev %*% SigmavI %*% (XEnd[h, ] - G %*% PSI))
    MvarW <- MvarW + MvarWh
  }
  Var_PHI <- solve(MvarM + PHI0I)
  Mean_PHI <- Var_PHI %*% (MvarW + PHI0I %*% phi0)
  PHI <- MASS::mvrnorm(n = 1, mu = Mean_PHI, Sigma = Var_PHI)
  return(PHI)
}

sample_SIGMA <- function(PHI, PSI, WL) {
  WX_PTHETA <- matrix(0, dimS, dimS)
  for (h in 1:H) {
    G <- cbind(INST[[h]], S2[[h]])
    M <- cbind(X[[h]], S1[[h]])
    W_MPHI <- WL[h, ] - M %*% PHI
    X_GPSI <- XEnd[h, ] - G %*% PSI
    WX_PTHETAh <- rbind(W_MPHI, X_GPSI)
    WX_PTHETAhh <- WX_PTHETAh %*% t(WX_PTHETAh)
    WX_PTHETA <- WX_PTHETA + WX_PTHETAhh
  }
  R <- solve(WX_PTHETA + R0I)
  r <- r0 + H
  SIGMAI <- rWishart(n = 1, r, R)
  SIGMA <- solve(matrix(SIGMAI, dimS, dimS))
  return(SIGMA)
}

############ Gibbs sampler########
Iter <- 6000
WLl <- array(0, c(H, J, Iter))
YYl <- matrix(0, H, Iter) 
PHIs <- matrix(0, K1, Iter)
PHIs[, 1] <- PHI 
PSIs <- matrix(0, K2, Iter)
VAR <- matrix(0, dimS * (dimS + 1) / 2, Iter)
SIGMA <- diag(dimS)

A0Post <- matrix(0, nrow = J + 1, ncol = J + 1)
A1Post <- matrix(0, nrow = J + 1, ncol = J + 1)
A2Post <- matrix(0, nrow = J + 1, ncol = J + 1)
A3Post <- matrix(0, nrow = J + 1, ncol = J + 1)
A4Post <- matrix(0, nrow = J + 1, ncol = J + 1)
A5Post <- matrix(0, nrow = J + 1, ncol = J + 1)
BPost <- matrix(0, nrow = J + 1, ncol = J + 1)

WL <- W
tic <- Sys.time()
Gibbs_END <- function(Iter, Burnin) {
  for (l in 2:Iter) {
    BPost[-9, -9] <- ks::invvech(PHIs[81:116, Iter-1])
    A0Post[-9, -9] <- ks::invvech(PHIs[165:200, Iter-1])
    A1Post[-9, -9] <- ks::invvech(PHIs[201:236, Iter-1])
    A2Post[-9, -9] <- ks::invvech(PHIs[237:272, Iter-1])
    A3Post[-9, -9] <- ks::invvech(PHIs[273:308, Iter-1])
    A4Post[-9, -9] <- ks::invvech(PHIs[309:344, Iter-1])
    A5Post[-9, -9] <- ks::invvech(PHIs[345:380, Iter-1])
    
    A0_9 <- -colSums(A0Post[, -9])
    A0Post[, ] <- cbind(rbind(A0Post[ -9, -9], A0_9), c(A0_9, -sum(A0_9)))
    A1_9 <- -colSums(A1Post[, -9])
    A1Post[, ] <- cbind(rbind(A1Post[ -9, -9], A1_9), c(A1_9, -sum(A1_9)))
    A2_9 <- -colSums(A2Post[, -9])
    A2Post[, ] <- cbind(rbind(A2Post[ -9, -9], A2_9), c(A2_9, -sum(A2_9)))
    A3_9 <- -colSums(A3Post[, -9])
    A3Post[, ] <- cbind(rbind(A3Post[ -9, -9], A3_9), c(A3_9, -sum(A3_9)))
    A4_9 <- -colSums(A4Post[, -9])
    A4Post[, ] <- cbind(rbind(A4Post[ -9, -9], A4_9), c(A4_9, -sum(A4_9)))
    A5_9 <- -colSums(A5Post[, -9])
    A5Post[, ] <- cbind(rbind(A5Post[ -9, -9], A5_9), c(A5_9, -sum(A5_9)))
    B_9 <- -colSums(BPost[, -9])
    BPost[, ] <- cbind(rbind(BPost[ -9, -9], B_9), c(B_9, -sum(B_9)))
    
    GenY <- function(h){
      Yh <- (log_y[h] - Stone[h] + 0.5*(t(PLarge[h, ])%*%A0Post%*%PLarge[h, ] + Z[h, 1]*t(PLarge[h, ])%*%A1Post%*%PLarge[h, ] + Z[h, 2]*t(PLarge[h, ])%*%A2Post%*%PLarge[h, ] +
                                          Z[h, 3]*t(PLarge[h, ])%*%A3Post%*%PLarge[h, ] + Z[h, 4]*t(PLarge[h, ])%*%A4Post%*%PLarge[h, ] + Z[h, 5]*t(PLarge[h, ])%*%A5Post%*%PLarge[h, ]))/(1 - 0.5*t(PLarge[h, ])%*%BPost%*%PLarge[h, ])
    }
    
    y <- sapply(1:H, GenY)
    YYl[, l] <- y
    YZ <- cbind(y, y^2, y^3, y^4, y^5, y * Z)
    XEnd <- cbind(YZ, y * P)
    X <- lapply(1:H, GenX)
    
    PSI <- sample_PSI_END(PHI, SIGMA, WL)
    PSIs[, l] <- PSI
    
    SIGMA <- sample_SIGMA(PHI, PSI, WL)
    VAR[, l] <- matrixcalc::vech(SIGMA)
    
    PHI <- sample_PHI_END(PSI, SIGMA, WL)
    PHIs[, l] <- PHI
    
    WL <- t(sapply(1:H, function(h){sample_LatShares(wh = W[h, ], S1h = S1[[h]], S2h = S2[[h]], 
                                                     Xh = X[[h]], INSTh = INST[[h]], XEndh = XEnd[h, ],
                                                     PHI = PHI, PSI = PSI, SIGMA = SIGMA)})) 
    
    WLl[, , l] <- WL
    print(l)
  }
  return(list(PHI = PHIs[, -c(1:Burnin)], PSI = PSIs[, -c(1:Burnin)], VAR = VAR[, -c(1:Burnin)], YYl = YYl, WL = WLl[, , c((Iter-99):Iter)]))
}

Burnin <- 1000
Posterior <- Gibbs_END(Iter, Burnin)
tac <- Sys.time()

timel <- tac-tic
timel
PHICoda <- coda::mcmc(t(Posterior$PHI))
summary(PHICoda)
write.csv(PHICoda, file = "PHI.csv")

PSICoda <- coda::mcmc(t(Posterior$PSI))
summary(PSICoda)
write.csv(PSICoda, file = "PSI.csv")

VARCoda <- coda::mcmc(t(Posterior$VAR))
summary(VARCoda)
write.csv(VARCoda, file = "VAR.csv")

save.image(file = "BayesianEASI.RData")