set term epslatex
set output 'multiplot.eps'
set style function lines
set size 1.3, 1.5
set origin 0.0, 0.0
set multiplot
set size 0.65,0.75
set grid
unset key
set ylabel 'Prestige'
set xlabel 'Income (K)'
set xrange [0:30]
set yrange [0:110]

set origin 0.0,0.75
set title 'Undersmoothed ($10^{-1}\sigma_x n^{-1/5}$)'
plot 'prestige.dat' u 2:1 notitle ps 0.5, 'mean.dat.0.1' notitle w l

set origin 0.65,0.75
set title 'Plug-in ($1.08\sigma_x n^{-1/5}$)'
plot 'prestige.dat' u 2:1 notitle ps 0.5, 'localpoly.dat' notitle w l

set origin 0.0,0.0
set title 'AIC$_c$ \& CV ($3.54\sigma_x n^{-1/5}$, $3.45\sigma_x n^{-1/5}$)'
plot 'prestige.dat' u 2:1 notitle ps 0.5, 'mean.dat.aic' notitle w l

set origin 0.65,0.0
set title 'Oversmoothed ($10^3\sigma_x n^{-1/5}$)'
plot 'prestige.dat' u 2:1 notitle ps 0.5, 'mean.dat.1000' notitle w l

