/*
*-----------------------------------------------------------------------------
*	file:	mattran.c
*	desc:	matrix mathematics
*	by:	ko shu pui, patrick
*	date:	v0.1 - 24 nov 91
*	revi:	v0.2 - 14 may 92
*	ref:
*       [1] Mary L.Boas, "Mathematical Methods in the Physical Sciene,"
*	John Wiley & Sons, 2nd Ed., 1983. Chap 3.
*
*-----------------------------------------------------------------------------
*/

#include <stdio.h>
#include <math.h>

#include "matrix.h"

/*
*-----------------------------------------------------------------------------
*	funct:	mat_tran
*	desct:	transpose of a matrix
*	given:	A = matrix A to be transposed
*	retrn:	allocated matrix for A^t
*	comen:
*-----------------------------------------------------------------------------
*/
MATRIX mat_tran( MATRIX A, MATRIX At )
{
	int	i, j;

#ifdef CONFORM_CHECK	

  if(MatCol(A)!=MatRow(At)) {
        fprintf(stderr, "\nUnformable matrices in routine mat_tran(): Col(A)!=Row(At): exit(0)\n");
        exit(0);
  }

  if(MatRow(A)!=MatCol(At)) {
        fprintf(stderr, "\nUnformable matrices in routine mat_tran(): Row(A)!=Col(At): exit(0)\n");
        exit(0);
  }

#endif

	/*
	*	Transposing ...
	*/
	for (i=0; i<MatCol(A); i++)
	for (j=0; j<MatRow(A); j++)
		{
		At[i][j] = A[j][i];
		}
	return (At);
}
