/* Modified to copy, not point - freeing part of matrix...
   jracine 7/7/96, 12.08pm*/

/*
*-----------------------------------------------------------------------------
* file: matsubmm.c
* desc: return a submatrix pointing to elements of another matrix
* excluding a range of rows in main matrix
* by: Jeff Racine
* date: November 22 1994
* revi:
* ref:
*-----------------------------------------------------------------------------
*/
#include <stdio.h>
#include "matrix.h"

/*
*-----------------------------------------------------------------------------
* funct:  mat_sub_rem_mat
* desct:  return a submatrix S pointing to elements of A
* given:  A = main matrix, S=submatrix
* il,iu = range of rows (l=lower, u=upper) of A to be
* removed from A and then remaining (smaller) matrix placed in S
* retrn:  S - not copied, simply points to existing matrix
*-----------------------------------------------------------------------------
*/

MATRIX mat_sub_rem_mat( MATRIX A, int il, int iu, MATRIX S )
{

  int i, j, k;

  /* Set pointers to rows */

#ifdef CONFORM_CHECK

  fprintf(stderr, "\n%d Rows in A",MatRow(A));
  fprintf(stderr, "\n%d Rows in S",MatRow(S));
  fprintf(stderr, "\n%d columns in A",MatCol(A));
  fprintf(stderr, "\n%d columns in S",MatCol(S));
  fprintf(stderr, "\nil = %d ",il);
  fprintf(stderr, "\niu = %d ",iu);

  if(iu<il) {
    fprintf(stderr, "\nIn mat_sub_rem_mat() iu should exceed il: exit(0)\n");
    exit(0);
  }

  if((il<0)||(iu > MatRow(A))) {
    fprintf(stderr, "\nImproper iu or il in routine mat_sub_rem_mat(): exit(0)\n");
    exit(0);
  }

  if((MatRow(A)-(iu-il+1))!=MatRow(S)) {
    fprintf(stderr, "\nUnformable matrices in routine mat_sub_rem_mat(): Row(A)-(iu-il+1)!=Row(S): exit(0)\n");
    exit(0);
  }

  if(MatCol(A)!=MatCol(S)) {
    fprintf(stderr, "\nUnformable matrices in routine mat_sub_rem_mat(): Col(A)!=Col(S): exit(0)\n");
    exit(0);
  }

#endif

/* Apparently the problem... points to memory, freed, corrupts original
   data at memory location */

/*  for(i=0, j=0;i < MatRow(A); i++) {
    if(i < il) S[j++] = A[i];
    if(i > iu) S[j++] = A[i];
  }*/

  for(i=0, j=0;i < MatRow(A); i++) {
    if(i < il) {
      for(k=0; k < MatCol(A); k++) {
        S[j][k] = A[i][k];
      }
      j++;
    }
    if(i > iu) {
      for(k=0; k < MatCol(A); k++) {
        S[j][k] = A[i][k];
      }
      j++;
    }
  }

  /* Return pointer to array of pointers to rows */

  return(S);
}
