/* Modified to copy, not point - freeing part of matrix...
   jracine 7/7/96, 12.08pm*/

/*
*-----------------------------------------------------------------------------
*	file:	matsubm.c
*	desc:	return a submatrix pointing to elements of another matrix
*	by:	Jeff Racine
*	date:	November 22 1994
*	revi:
*	ref:
*-----------------------------------------------------------------------------
*/
#include <stdio.h>
#include "matrix.h"

/*
*-----------------------------------------------------------------------------
*	funct:	mat_sub_mat
*	desct:	return a submatrix S pointing to elements of A
*	given:	A = main matrix, S=submatrix
*	il,iu,jl,ju = range of rows and columns (l=lower, u=upper) of A to be placed in S
*	retrn:	S - not copied, simply points to existing matrix
*-----------------------------------------------------------------------------
*/
MATRIX mat_sub_mat( MATRIX A, int il, int iu, MATRIX S, int jl, int ju )
{
	int	i, j, k;

#ifdef CONFORM_CHECK

  if((il < 0 )||(il > iu )||(il > MatRow(A))) {
  	fprintf(stderr, "\nIllegal value of il in mat_sub_mat(): exit(0)\n");
  	exit(0);
  }
  if((iu < 0 )||(iu > MatRow(A))) {
  	fprintf(stderr, "\nIllegal value of iu in mat_sub_mat(): exit(0)\n");
  	exit(0);
  }
  if((jl < 0 )||(jl > iu )||(jl > MatRow(A))) {
  	fprintf(stderr, "\nIllegal value of jl in mat_sub_mat(): exit(0)\n");
  	exit(0);
  }
  if((ju < 0 )||(ju > MatRow(A))) {
  	fprintf(stderr, "\nIllegal value of ju in mat_sub_mat(): exit(0)\n");
  	exit(0);
  }

#endif  

	/* Set pointers to rows */
/*	for(i=il, j=0; i <= iu; i++, j++) {
    S[j] = A[i] + jl;
  }*/

	for(i=il, j=0; i <= iu; i++, j++) {
		for(k=0; k < MatCol(A); k++) {
    S[j][k] = A[i][k];
    }
  }

	/* Return pointer to array of pointers to rows */

	return(S);

}
