/*
*-----------------------------------------------------------------------------
*	file:	matsub.c
*	desc:	matrix substraction
*	by:	ko shu pui, patrick
*	date:	24 nov 91 v0.1
* revi: Nov 25 1994 by J. Racine - added error checking, passing matrix
*       rather than allocating
*	ref:
*       [1] Mary L.Boas, "Mathematical Methods in the Physical Sciene,"
*	John Wiley & Sons, 2nd Ed., 1983. Chap 3.
*
*-----------------------------------------------------------------------------
*/
#include <stdio.h>
#include "matrix.h"

/*
*-----------------------------------------------------------------------------
*	funct:	mat_sub
*	desct:	subtraction of two matrice
*	given:	A, B = compatible matrice to be added
*	retrn:	NULL if malloc() fails
*		else A - B returned in C
*	comen:
*-----------------------------------------------------------------------------
*/
MATRIX mat_sub( MATRIX A, MATRIX B , MATRIX C )
{
	int	i, j;

#ifdef CONFORM_CHECK

  if(MatCol(A)!=MatCol(B)) {
  	fprintf(stderr, "\nUnformable matrices in routine mat_sub(): Col(A)!=Col(B): exit(0)\n");
  	exit(0);
  }
  if(MatCol(A)!=MatCol(C)) {
  	fprintf(stderr, "\nUnformable matrices in routine mat_sub(): Col(A)!=Col(C): exit(0)\n");
  	exit(0);
  }

  if(MatRow(A)!=MatRow(B)) {
  	fprintf(stderr, "\nUnformable matrices in routine mat_sub(): Row(A)!=Row(B): exit(0)\n");
  	exit(0);
  }
  if(MatRow(A)!=MatRow(C)) {
  	fprintf(stderr, "\nUnformable matrices in routine mat_sub(): Row(A)!=Row(C): exit(0)\n");
  	exit(0);
  }

#endif  
  	
	for (i=0; i<MatRow(A); i++)
	for (j=0; j<MatCol(A); j++)
		{
		C[i][j] = A[i][j] - B[i][j];
		}
	return (C);
}
