/*
*-----------------------------------------------------------------------------
* file: matrix.h
* desc: matrix mathematics header file
* by: ko shu pui, patrick
* date: 24 nov 91 v0.1b
* revi: Nov 25 1994 by J. Racine. Changed allocation, added bounds checking
* ref:
* [1] Mary L.Boas, "Mathematical Methods in the Physical Sciene,"
* John Wiley & Sons, 2nd Ed., 1983. Chap 3.
*
*-----------------------------------------------------------------------------
*/

/* For conformability checking, define CONFORM_CHECK. For run time
 for most apps, do not define to reduce overhead: Added by Racine */

/*#define CONFORM_CHECK*/

/*
*-----------------------------------------------------------------------------
* internal matrix structure
*-----------------------------------------------------------------------------
*/
typedef struct {
 unsigned int row;
 unsigned int col;
 } MATHEAD;

typedef struct {
 MATHEAD head;
 /*
 * only the starting address of the following will be
 * returned to the C programmer, like malloc() concept
 */
 double *matrix;
 } MATBODY;

typedef double **MATRIX;

#define Mathead(a) ((MATHEAD *)((MATHEAD *)(a) - 1))
#define MatRow(a) (Mathead(a)->row)
#define MatCol(a) (Mathead(a)->col)

/*
*----------------------------------------------------------------------------
* mat_errors definitions
*----------------------------------------------------------------------------
*/
#define MAT_MALLOC 1
#define MAT_FNOTOPEN 2
#define MAT_FNOTGETMAT 3

/*
*----------------------------------------------------------------------------
* matrice types
*----------------------------------------------------------------------------
*/
#define UNDEFINED -1
#define ZERO_MATRIX 0
#define UNIT_MATRIX 1


MATRIX mat_error( int errno );
MATRIX _mat_creat( unsigned int row, unsigned int col );
MATRIX mat_creat( unsigned int row, unsigned int col, int type );
MATRIX mat_fill( MATRIX A, int type );
int mat_free( MATRIX A );
MATRIX mat_copy( MATRIX A, MATRIX C );
MATRIX mat_colcopy1( MATRIX A, MATRIX B, int cola, int colb );
int fgetmat( MATRIX A, FILE *fp );
MATRIX mat_dump( MATRIX A );
MATRIX mat_dumpf( MATRIX, char * );
MATRIX mat_fdump( MATRIX A, FILE *fp );
MATRIX mat_fdumpf( MATRIX A, char *s, FILE *fp );

MATRIX mat_add( MATRIX A, MATRIX B , MATRIX C );
MATRIX mat_sub( MATRIX A, MATRIX B , MATRIX C );
MATRIX mat_mul( MATRIX A, MATRIX B , MATRIX C );
double mat_diagmul( MATRIX A );
MATRIX mat_tran( MATRIX A, MATRIX At );
MATRIX mat_inv( MATRIX a , MATRIX C );

int mat_lu( MATRIX A, MATRIX P );
MATRIX mat_backsubs1( MATRIX A, MATRIX B, MATRIX X, MATRIX P, int xcol );
MATRIX mat_lsolve( MATRIX a, MATRIX b );

MATRIX mat_submat( MATRIX A, int i, int j );
MATRIX mat_sub_mat( MATRIX A, int il, int iu, MATRIX S, int jl, int ju );
MATRIX mat_sub_rem_mat( MATRIX A, int il, int iu, MATRIX S );
double mat_cofact( MATRIX A, int i, int j );
double mat_det( MATRIX a );
double mat_minor( MATRIX A, int i, int j );

