/*
*-----------------------------------------------------------------------------
*	file:	matinv.c
*	desc:	matrix inversion
*	by:	ko shu pui, patrick
*	date:	24 nov 91 v0.1
*	revi:	14 may 92 v0.2
* revi: Nov 25 1994 by J. Racine - added error checking, passing matrix
*       rather than allocating
*	ref:
*       [1] Mary L.Boas, "Mathematical Methods in the Physical Sciene,"
*	John Wiley & Sons, 2nd Ed., 1983. Chap 3.
*
*	[2] Kendall E.Atkinson, "An Introduction to Numberical Analysis,"
*	John Wiley & Sons, 1978.
*
*-----------------------------------------------------------------------------
*/
#include <stdio.h>
#include <math.h>

#include "matrix.h"

/*
*-----------------------------------------------------------------------------
*	funct:	mat_inv
*	desct:	find inverse of a matrix
*	given:	a = square matrix a, and C, return for inv(a)
*	retrn:	square matrix Inverse(A), C
*		NULL = fails, singular matrix
*-----------------------------------------------------------------------------
*/
MATRIX mat_inv( MATRIX a , MATRIX C)
{
	MATRIX	A, B, P;
	int	i, j, n;
	double	temp;

#ifdef CONFORM_CHECK

  if(MatCol(a)!=MatCol(C)) {
        fprintf(stderr, "\nUnformable matrices in routine mat_inv(): Col(A)!=Col(B): exit(0)\n");
        exit(0);
  }

  if(MatRow(a)!=MatRow(C)) {
        fprintf(stderr, "\nUnformable matrices in routine mat_inv(): Row(A)!=Row(B): exit(0)\n");
        exit(0);
  }

#endif  

	n = MatCol(a);
  A = mat_creat(MatRow(a), MatCol(a), UNDEFINED);
	A = mat_copy(a, A);
	B = mat_creat( n, 1, UNDEFINED );
	P = mat_creat( n, 1, UNDEFINED );

	/*
	*	- LU-decomposition -
	*	also check for singular matrix
	*/
	if (mat_lu(A, P) == -1)
		{
		mat_free(A);
		mat_free(B);
		mat_free(P);

		return (NULL);
		}

	for (i=0; i<n; i++)
		{
		mat_fill(B, ZERO_MATRIX);
		B[i][0] = 1.0;
		mat_backsubs1( A, B, C, P, i );
		}

	mat_free(A);
	mat_free(B);
	mat_free(P);

	return (C);
}
