(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[         0,          0]
NotebookDataLength[    200577,       3939]
NotebookOptionsPosition[    197736,       3882]
NotebookOutlinePosition[    198177,       3899]
CellTagsIndexPosition[    198134,       3896]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 StyleBox[
  RowBox[{"NNNNNNNNNNNNNNNN", " ", "code", " ", "NNNNNNNNNNNNNNNNNNN"}],
  FontSize->24]], "Input",
 CellChangeTimes->{
  3.498070433068594*^9, {3.498070539365469*^9, 3.498070540693594*^9}, {
   3.4989907701429996`*^9, 3.4989907823304996`*^9}, 3.545544893880168*^9, {
   3.5548336411796217`*^9, 3.5548336456238766`*^9}, {3.5575717184175797`*^9, 
   3.557571720289592*^9}, 3.5895272192604218`*^9, 3.720446103183881*^9, {
   3.7604297053980985`*^9, 
   3.760429707397601*^9}},ExpressionUUID->"fa5d429c-70c6-409b-a230-\
cddc787bcc5b"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"H", "[", "p_", "]"}], ":=", 
    RowBox[{"-", 
     RowBox[{"Chop", "[", 
      RowBox[{"p", ".", 
       RowBox[{"Log", "[", 
        RowBox[{"p", "+", "$MinMachineNumber"}], "]"}]}], "]"}]}]}], ";"}], 
  " ", 
  RowBox[{"(*", " ", 
   RowBox[{"entropy", " ", "of", " ", "the", " ", "distribution", " ", "p"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RH", "[", 
     RowBox[{"p_", ",", "q_"}], "]"}], ":=", 
    RowBox[{"Chop", "[", 
     RowBox[{"p", ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Log", "[", 
         RowBox[{"p", "+", "$MinMachineNumber"}], "]"}], "-", 
        RowBox[{"Log", "[", 
         RowBox[{"q", "+", "$MinMachineNumber"}], "]"}]}], ")"}]}], "]"}]}], 
   ";"}], " ", 
  RowBox[{"(*", 
   RowBox[{"relative", " ", "entropy", " ", "p", " ", "vs", " ", "q"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"RHB", "[", 
     RowBox[{"p_", ",", "\[Alpha]_"}], "]"}], ":=", " ", 
    RowBox[{"(*", 
     RowBox[{"relative", " ", "entropy", " ", "p", " ", "vs", " ", "Binomial", 
      RowBox[{"(", "\[Alpha]", ")"}]}], "*)"}], 
    RowBox[{"p", ".", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Log", "[", 
        RowBox[{"p", "+", "$MinMachineNumber"}], "]"}], "-", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Log", "[", 
           RowBox[{"Binomial", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"Length", "[", "p", "]"}], "-", "1"}], ",", "k"}], 
            "]"}], "]"}], "+", 
          RowBox[{"k", " ", 
           RowBox[{"Log", "[", 
            RowBox[{"Min", "[", 
             RowBox[{"\[Alpha]", ",", 
              RowBox[{"1", "-", "\[Alpha]"}]}], "]"}], "]"}]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Length", "[", "p", "]"}], "-", "1", "-", "k"}], ")"}], 
           RowBox[{"Log", "[", 
            RowBox[{"Max", "[", 
             RowBox[{"\[Alpha]", ",", 
              RowBox[{"1", "-", "\[Alpha]"}]}], "]"}], "]"}]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "0", ",", 
           RowBox[{
            RowBox[{"Length", "[", "p", "]"}], "-", "1"}]}], "}"}]}], "]"}]}],
       ")"}]}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MIs", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", 
      RowBox[{"NE_:", "$MaxMachineNumber"}], ",", 
      RowBox[{"quantiles_:", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"print_:", "False"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", "T", ",", "dim", ",", "z", ",", "a", ",", "c"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Computes", " ", "the", " ", 
         RowBox[{"(", "system", ")"}], " ", 
         RowBox[{"CTI", ":", " ", 
          RowBox[{
           RowBox[{"If", " ", "NE"}], " ", "\[LessEqual]", " ", 
           RowBox[{
           "0", " ", "it", " ", "computes", " ", "the", " ", "CTI", " ", 
            "\[Kappa]", 
            RowBox[{"(", "\[Alpha]", ")"}]}]}]}]}], ",", " ", 
        RowBox[{
         RowBox[{"if", " ", "NE"}], " ", "\[GreaterEqual]", " ", 
         RowBox[{
         "sample", " ", "size", " ", "T", " ", "it", " ", "computes", " ", 
          "the", " ", "system", " ", "CTI", " ", 
          OverscriptBox["\[Kappa]", "~"], 
          RowBox[{"(", "\[Alpha]", ")"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"z", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "quantiles", "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "\[Alpha]", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], "&"}], " ",
            "/@", " ", 
           RowBox[{"Transpose", "[", "l", "]"}]}], ",", "quantiles"}], 
         "]"}]}], ";", 
       RowBox[{"T", "=", 
        RowBox[{"Length", "[", "l", "]"}]}], ";", 
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"a", "=", "\[Alpha]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Transpose", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"z", "-", "#"}], "&"}], "/@", " ", "l"}], "]"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", ">", " ", ".5"}], ",", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"1", "-", "\[Alpha]"}]}], ";", 
          RowBox[{"z", "=", 
           RowBox[{"-", "z"}]}]}]}], "]"}], ";", 
       RowBox[{"c", "=", 
        RowBox[{"Clip", "[", 
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"Log", "[", "T", "]"}], "-", 
            RowBox[{"Log", "[", 
             RowBox[{"Max", "[", 
              RowBox[{"NE", ",", "$MinMachineNumber"}], "]"}], "]"}], "+", 
            RowBox[{"dim", " ", 
             RowBox[{"Log", "[", 
              RowBox[{"1", "-", "a"}], "]"}]}]}], 
           RowBox[{
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"1", "/", "a"}], "-", "1."}], "]"}], "+", 
            "$MinMachineNumber"}]], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "T"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Clip", "[", " ", 
           RowBox[{
            RowBox[{"Sign", "[", "#", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "&"}], "/@", " ", 
         "z"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Transpose", "[", "z", "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"c", "<", 
             RowBox[{"Total", "[", "#", "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"Total", "[", "#", "]"}], "}"}], ",", "#"}], "]"}], " ", 
          "&"}], "/@", "z"}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Tally", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "&"}], "/@", "z"}], ")"}], ",", 
          RowBox[{
           RowBox[{"#1", "\[Equal]", "#2"}], "&"}]}], "]"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "/", "T"}]}], "}"}], " ", "&"}],
          "/@", "z"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"print", ",", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<T = \>\"", ",", "T", ",", "\"\<, \[Alpha] = \>\"", ",", "a", 
           ",", "\"\<, dim = \>\"", ",", "dim", ",", "\"\<, c= \>\"", ",", 
           "c", ",", "\"\<, z= \>\"", ",", 
           RowBox[{"1.", "z"}]}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{"c", "<", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
              RowBox[{
               RowBox[{"Log", "[", 
                RowBox[{"Binomial", "[", 
                 RowBox[{"dim", ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], "+", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], 
                RowBox[{"Log", "[", "a", "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"dim", "-", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ")"}], 
                RowBox[{"Log", "[", 
                 RowBox[{"1", "-", "a"}], "]"}]}]}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], 
                RowBox[{"Log", "[", "a", "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"dim", "-", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ")"}], 
                RowBox[{"Log", "[", 
                 RowBox[{"1", "-", "a"}], "]"}]}]}]}], "}"}]}], "]"}], " ", 
          "&"}], "/@", "z"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Transpose", "[", "z", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        FractionBox[
         RowBox[{" ", 
          RowBox[{
           RowBox[{"z", "[", 
            RowBox[{"[", "1", "]"}], "]"}], ".", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Log", "[", 
              RowBox[{"z", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}], "-", 
             RowBox[{"z", "[", 
              RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}]}], "1"], " ", 
        "]"}]}]}], " ", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"/", 
        RowBox[{"(", 
         RowBox[{"dim", "-", "1"}], ")"}]}], 
       RowBox[{"H", "[", 
        RowBox[{"{", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"1", "-", "\[Alpha]"}]}], "}"}], "]"}]}], "*)"}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ExceedL", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", 
      RowBox[{"NE_:", "0"}], ",", 
      RowBox[{"quantiles_:", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"print_:", "False"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", "dim", ",", "z", ",", "a"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
         RowBox[{
         "Transforms", " ", "the", " ", "list", " ", "l", " ", "into", " ", 
          "a", " ", "list", " ", "of", " ", "\[Alpha]"}], "-", 
         RowBox[{"JTs", " ", "indicators", " ", "if", " ", "NE"}]}], " ", 
        "\[LessEqual]", " ", 
        RowBox[{
         RowBox[{
         "0", " ", "or", " ", "a", " ", "list", " ", "of", " ", "#", " ", 
          "of", " ", "\[Alpha]"}], "-", 
         RowBox[{"exceedences", " ", "if", " ", "NE"}]}], " ", 
        "\[GreaterEqual]", " ", "T"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"z", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "quantiles", "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "\[Alpha]", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], "&"}], " ",
            "/@", " ", 
           RowBox[{"Transpose", "[", "l", "]"}]}], ",", "quantiles"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"T", "=", 
        RowBox[{"Length", "[", "l", "]"}]}], ";", 
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"a", "=", "\[Alpha]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Transpose", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"z", "-", "#"}], "&"}], "/@", " ", "l"}], "]"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", ">", " ", ".5"}], ",", 
         RowBox[{
          RowBox[{"a", "=", 
           RowBox[{"1", "-", "\[Alpha]"}]}], ";", 
          RowBox[{"z", "=", 
           RowBox[{"-", "z"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"print", ",", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<T = \>\"", ",", "T", ",", "\"\<, \[Alpha] = \>\"", ",", 
           "\[Alpha]", ",", "\"\<, dim = \>\"", ",", "dim"}], "]"}]}], "]"}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Clip", "[", " ", 
           RowBox[{
            RowBox[{"Sign", "[", "#", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "&"}], "/@", " ", 
         "z"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Transpose", "[", "z", "]"}]}], ";", " ", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"T", "*", 
              SuperscriptBox["a", 
               RowBox[{"Total", "[", "#", "]"}]], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", "a"}], ")"}], 
               RowBox[{"dim", "-", 
                RowBox[{"Total", "[", "#", "]"}]}]]}], "<", "NE"}], ",", 
            RowBox[{"{", 
             RowBox[{"Total", "[", "#", "]"}], "}"}], ",", "#"}], "]"}], " ", 
          "&"}], "/@", "z"}]}], ";", " ", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", "z", "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
      "**"}], "*", " ", "EWMA", 
     RowBox[{"(", "\[Lambda]", ")"}]}], "  ", 
    "********************************)"}],
   FontSize->18]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"JTPr\[Lambda]s", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", 
      RowBox[{"\[Lambda]_:", "1"}], ",", 
      RowBox[{"NE_:", "0"}], ",", 
      RowBox[{"quantiles_:", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"print_:", "False"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", "dim", ",", "z", ",", "\[Lambda]T"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Computes", " ", "the", " ", "EWMA", 
         RowBox[{"(", "\[Lambda]", ")"}], " ", "probabilities", " ", "of", 
         " ", "JTs", " ", "if", " ", "NE"}], " ", "\[LessEqual]", " ", 
        RowBox[{
        "0", " ", "and", " ", "of", " ", "#", " ", "of", " ", "exceedances", 
         " ", "if", " ", "NE"}], " ", "\[GreaterEqual]", " ", "T"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"T", "=", 
        RowBox[{"Length", "[", "l", "]"}]}], ";", 
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"\[Lambda]T", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"\[Lambda]", "\[GreaterEqual]", " ", "1"}], ",", 
          FractionBox["1.", "T"], ",", 
          FractionBox[
           RowBox[{"1.", "-", "\[Lambda]"}], 
           RowBox[{"1", "-", 
            SuperscriptBox["\[Lambda]", "T"]}]]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"ExceedL", "[", 
         RowBox[{
         "\[Alpha]", ",", "l", ",", "NE", ",", "quantiles", ",", "print"}], 
         "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Normal", "[", 
         RowBox[{"PositionIndex", "[", "z", "]"}], "]"}]}], ";", " ", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "1", "]"}], "]"}], ",", 
            RowBox[{"\[Lambda]T", " ", 
             RowBox[{"Chop", "[", " ", 
              RowBox[{"Total", "[", " ", 
               SuperscriptBox[
                RowBox[{"Max", "[", 
                 RowBox[{"\[Lambda]", ",", "$MachineEpsilon"}], "]"}], 
                RowBox[{
                 RowBox[{"#", "[", 
                  RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]], "]"}], 
              "]"}]}]}], "}"}], "&"}], "/@", "z"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"Select", "[", 
         RowBox[{"z", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ">", "0"}], "&"}]}], "]"}], 
        "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"MI\[Lambda]s", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", 
      RowBox[{"\[Lambda]_:", "1"}], ",", 
      RowBox[{"NE_:", "0"}], ",", 
      RowBox[{"quantiles_:", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"print_:", "True"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"T", ",", "dim", ",", "z", ",", "a", ",", "\[Lambda]T"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Computes", " ", "first", " ", "the", " ", "EWMA", 
         RowBox[{"(", "\[Lambda]", ")"}], " ", "probabilities"}], ",", " ", 
        RowBox[{
        "where", " ", "all", " ", "cells", " ", "with", " ", "less", " ", 
         "than", " ", "NE", " ", "expected", " ", "obs", " ", "are", " ", 
         "lumped", " ", "together"}], ",", " ", 
        RowBox[{
         RowBox[{
         "and", " ", "then", " ", "the", " ", "MI", "\[IndentingNewLine]", 
          " ", "NE"}], " ", "\[LessEqual]", " ", 
         RowBox[{"0", " ", "computes", " ", "\[Kappa]", 
          RowBox[{"(", "\[Alpha]", ")"}]}]}], ",", " ", 
        RowBox[{"NE", " ", "\[GreaterEqual]", " ", 
         RowBox[{"T", " ", "computes", " ", 
          OverscriptBox["\[Kappa]", "~"], 
          RowBox[{"(", "\[Alpha]", ")"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"T", "=", 
        RowBox[{"Length", "[", "l", "]"}]}], ";", 
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"a", "=", 
        RowBox[{"Min", "[", 
         RowBox[{
          RowBox[{"1", "-", "\[Alpha]"}], ",", "\[Alpha]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"JTPr\[Lambda]s", "[", 
         RowBox[{
         "\[Alpha]", ",", "l", ",", "\[Lambda]", ",", "NE", ",", "quantiles", 
          ",", "print"}], "]"}]}], ";", " ", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Total", "[", 
             RowBox[{"#", "[", 
              RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
            RowBox[{"#", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "}"}], "&"}], "/@", "z"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"If", "[", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"T", "*", 
              SuperscriptBox["a", 
               RowBox[{"#", "[", 
                RowBox[{"[", "1", "]"}], "]"}]], 
              SuperscriptBox[
               RowBox[{"(", 
                RowBox[{"1", "-", "a"}], ")"}], 
               RowBox[{"dim", "-", 
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}]}]]}], "<", "NE"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
              RowBox[{
               RowBox[{"Log", "[", 
                RowBox[{"Binomial", "[", 
                 RowBox[{"dim", ",", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "]"}], "+", 
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], 
                RowBox[{"Log", "[", "a", "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"dim", "-", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ")"}], 
                RowBox[{"Log", "[", 
                 RowBox[{"1", "-", "a"}], "]"}]}]}]}], "}"}], ",", 
            "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{
               RowBox[{
                RowBox[{"#", "[", 
                 RowBox[{"[", "1", "]"}], "]"}], 
                RowBox[{"Log", "[", "a", "]"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"dim", "-", 
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}]}], ")"}], 
                RowBox[{"Log", "[", 
                 RowBox[{"1", "-", "a"}], "]"}]}]}]}], "}"}]}], "]"}], " ", 
          "&"}], "/@", "z"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Transpose", "[", "z", "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", " ", 
        RowBox[{
         RowBox[{"z", "[", 
          RowBox[{"[", "1", "]"}], "]"}], ".", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Log", "[", 
            RowBox[{"z", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "]"}], "-", 
           RowBox[{"z", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], ")"}]}], "]"}]}]}], " ", 
     RowBox[{"(*", 
      RowBox[{
       RowBox[{"/", 
        RowBox[{"(", 
         RowBox[{"dim", "-", "1"}], ")"}]}], 
       RowBox[{"H", "[", 
        RowBox[{"{", 
         RowBox[{"a", ",", 
          RowBox[{"1", "-", "a"}]}], "}"}], "]"}]}], "*)"}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"ML\[Lambda]", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", 
      RowBox[{"Min\[Lambda]_:", "0.9"}], ",", 
      RowBox[{"Max\[Lambda]_:", "1"}], ",", 
      RowBox[{"ini_:", "$MaxMachineNumber"}], ",", 
      RowBox[{"quantiles_:", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"print_:", "True"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "i", ",", "T", ",", "dim", ",", "z", ",", "\[Lambda]", ",", "p0", ",", 
        "p", ",", "pM", ",", "LogL", ",", "MinLL", ",", "\[Lambda]\[Lambda]", 
        ",", "f"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{
        "ML", " ", "estimate", " ", "of", " ", "\[Lambda]", " ", "in", " ", 
         "EWMA", " ", "p", 
         RowBox[{"(", 
          RowBox[{"t", "+", "1"}], ")"}]}], "=", " ", 
        RowBox[{
         RowBox[{"\[Lambda]p", 
          RowBox[{"(", "t", ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Lambda]"}], ")"}], "u", 
          RowBox[{"(", "t", ")"}]}]}]}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"T", "=", 
        RowBox[{"Length", "[", "l", "]"}]}], ";", 
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"\[Lambda]\[Lambda]", "=", "Min\[Lambda]"}], ";", 
       RowBox[{"MinLL", "=", 
        RowBox[{"-", "$MaxMachineNumber"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"p0", "=", 
        RowBox[{"JTPr\[Lambda]s", "[", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"l", "[", 
           RowBox[{"[", 
            RowBox[{";;", 
             RowBox[{"Min", "[", 
              RowBox[{"ini", ",", "T"}], "]"}]}], "]"}], "]"}], ",", "1", ",",
           "T", ",", 
          RowBox[{"{", "}"}], ",", "print"}], "]"}]}], ";", 
       RowBox[{"p0", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Flatten", "[", "#", "]"}], "&"}], "/@", "p0"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"p0", "=", 
        RowBox[{"Sort", "[", 
         RowBox[{
          RowBox[{"p0", "~", "Join", "~", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"i", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "0", ",", "dim"}], "}"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"p0", "=", 
        RowBox[{"GatherBy", "[", 
         RowBox[{"p0", ",", "First"}], "]"}]}], ";", 
       RowBox[{"p0", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "#", "]"}], "&"}], "/@", "p0"}]}], ";", 
       RowBox[{"p0", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", " ", "p0"}]}], ";", 
       RowBox[{"pM", "=", "p0"}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "p0", "]"}], "\[NotEqual]", " ", 
          RowBox[{"dim", "+", "1"}]}], ",", 
         RowBox[{
          RowBox[{
          "Print", "[", "\"\<Error: Length[p]\[NotEqual] dim+1 \>\"", "]"}], 
          ";", 
          RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"ExceedL", "[", 
          RowBox[{"\[Alpha]", ",", "l", ",", "T", ",", 
           RowBox[{"{", "}"}], ",", "False"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"For", "[", 
          RowBox[{
           RowBox[{"\[Lambda]", "=", "Min\[Lambda]"}], ",", 
           RowBox[{"\[Lambda]", "\[LessEqual]", "Max\[Lambda]"}], ",", 
           RowBox[{"\[Lambda]", "=", 
            RowBox[{"\[Lambda]", "+", 
             RowBox[{"Max", "[", 
              RowBox[{"$MachineEpsilon", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"Max\[Lambda]", "-", "Min\[Lambda]"}], ")"}], "/", 
                "100"}]}], "]"}]}]}], ",", 
           RowBox[{
            RowBox[{"LogL", "=", "0"}], ";", 
            RowBox[{"p", "=", 
             RowBox[{"{", "p0", "}"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"For", "[", 
             RowBox[{
              RowBox[{"i", "=", "1"}], ",", 
              RowBox[{"i", "\[LessEqual]", "T"}], ",", 
              RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
              RowBox[{
               RowBox[{"LogL", "=", 
                RowBox[{"LogL", "+", 
                 RowBox[{"Log", "[", 
                  RowBox[{"$MachineEpsilon", "+", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"Last", "[", "p", "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{
                    RowBox[{"z", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "+", "1"}], "]"}], "]"}], 
                    ")"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
               RowBox[{"(*", 
                RowBox[{
                 RowBox[{"f", "=", 
                  FractionBox[
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"dim", "-", "1"}], ")"}], "\[Alpha]"}], 
                   RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"z", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "-", "1"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"dim", "-", "1"}], ")"}], "\[Alpha]"}]}], 
                    "]"}]]}], ";", " ", 
                 RowBox[{"f", "=", 
                  RowBox[{
                   RowBox[{"{", 
                    RowBox[{"1", "-", "f", "+", 
                    RowBox[{"f", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"1", "-", 
                    FractionBox["a", "f"]}], ")"}], "dim"]}]}], "}"}], "~", 
                   "Join", "~", 
                   RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"f", " ", 
                    RowBox[{"PDF", "[", 
                    RowBox[{
                    RowBox[{"BinomialDistribution", "[", 
                    RowBox[{"dim", ",", 
                    FractionBox["a", "f"]}], "]"}], ",", "s"}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"s", ",", "1", ",", "dim"}], "}"}]}], "]"}]}]}], 
                 ";", 
                 RowBox[{
                  RowBox[{"factor", " ", "probability", " ", "f"}], "=", " ", 
                  RowBox[{
                   FractionBox[
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"dim", "-", "1"}], ")"}], "a"}], 
                    RowBox[{"k", "-", "1"}]], " ", "\[Element]", " ", 
                   RowBox[{
                    RowBox[{"[", 
                    RowBox[{"a", ",", "1"}], "]"}], "  ", "ML", " ", 
                    "estimated", " ", "for", " ", "k", " ", 
                    "exceedances"}]}]}]}], "*)"}], "\[IndentingNewLine]", 
               RowBox[{"p", "=", 
                RowBox[{"Append", "[", 
                 RowBox[{"p", ",", 
                  RowBox[{
                   RowBox[{"\[Lambda]", " ", 
                    RowBox[{"Last", "[", "p", "]"}]}], " ", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "-", "\[Lambda]"}], ")"}], 
                    RowBox[{"UnitVector", "[", 
                    RowBox[{
                    RowBox[{"dim", "+", "1"}], ",", 
                    RowBox[{
                    RowBox[{"z", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "+", "1"}]}], "]"}]}]}]}],
                  "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"LogL", ">", "MinLL"}], ",", 
              RowBox[{
               RowBox[{"MinLL", "=", "LogL"}], ";", 
               RowBox[{"\[Lambda]\[Lambda]", "=", "\[Lambda]"}]}], ",", 
              RowBox[{"pM", "=", 
               RowBox[{"Last", "[", "p", "]"}]}]}], "]"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Lambda]", ",", "\[Lambda]\[Lambda]", ",", "MinLL"}], 
          "}"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"Min\[Lambda]", "==", "Max\[Lambda]"}], ",", 
         RowBox[{"Return", "[", 
          RowBox[{
           RowBox[{
            FractionBox[
             RowBox[{"RHB", "[", 
              RowBox[{"#", ",", "\[Alpha]"}], "]"}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"dim", "-", "1"}], ")"}], 
              RowBox[{"H", "[", 
               RowBox[{"{", 
                RowBox[{"\[Alpha]", ",", 
                 RowBox[{"1", "-", "\[Alpha]"}]}], "}"}], "]"}]}]], "&"}], "/@",
            " ", "p"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{"\[Lambda]\[Lambda]", ",", "MinLL", ",", "LogL", ",", 
          RowBox[{
           RowBox[{"Range", "[", 
            RowBox[{"0", ",", "dim"}], "]"}], ".", "pM"}], ",", 
          RowBox[{
           RowBox[{"Range", "[", 
            RowBox[{"0", ",", "dim"}], "]"}], ".", "p0"}]}], "}"}], "]"}]}]}],
      "]"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Dyn\[Lambda]s", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", "\[Lambda]_", ",", 
      RowBox[{"\[Upsilon]_:", "1"}], ",", 
      RowBox[{"ini_:", "$MaxMachineNumber"}], ",", 
      RowBox[{"quantiles_:", 
       RowBox[{"{", "}"}]}], ",", 
      RowBox[{"print_:", "True"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "t", ",", "T", ",", "dim", ",", "z", ",", "p", ",", "\[Kappa]", ",", 
        "v"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"List", " ", "of", " ", "dynamic", " ", 
        OverscriptBox["\[Kappa]", "~"], 
        RowBox[{"(", "\[Alpha]", ")"}], " ", "and", " ", 
        RowBox[{"Pr", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"#", " ", "\[Alpha]"}], "-", "exceed"}], " ", ">", " ", 
          RowBox[{"dim", "-", "v"}]}], "]"}], " ", "for", " ", "EWMA", 
        RowBox[{"(", "\[Lambda]", ")"}], " ", "PDF", " ", "of", " ", "the", 
        " ", "#", " ", "of", " ", "exceedances"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"T", "=", 
        RowBox[{"Length", "[", "l", "]"}]}], ";", 
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"\[Kappa]", "=", 
        RowBox[{"v", "=", 
         RowBox[{"{", "}"}]}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"p", "=", 
        RowBox[{"JTPr\[Lambda]s", "[", 
         RowBox[{"\[Alpha]", ",", 
          RowBox[{"l", "[", 
           RowBox[{"[", 
            RowBox[{";;", 
             RowBox[{"Min", "[", 
              RowBox[{"ini", ",", "T"}], "]"}]}], "]"}], "]"}], ",", "1", ",",
           "T", ",", 
          RowBox[{"{", "}"}], ",", "print"}], "]"}]}], ";", 
       RowBox[{"p", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Flatten", "[", "#", "]"}], "&"}], "/@", "p"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"p", "=", 
        RowBox[{"Sort", "[", 
         RowBox[{
          RowBox[{"p", "~", "Join", "~", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"i", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "0", ",", "dim"}], "}"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"p", "=", 
        RowBox[{"GatherBy", "[", 
         RowBox[{"p", ",", "First"}], "]"}]}], ";", 
       RowBox[{"p", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "#", "]"}], "&"}], "/@", "p"}]}], ";", 
       RowBox[{"p", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", " ", "p"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{"print", ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<p= \>\"", ",", "p"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Length", "[", "p", "]"}], "\[NotEqual]", " ", 
          RowBox[{"dim", "+", "1"}]}], ",", 
         RowBox[{
          RowBox[{
          "Print", "[", "\"\<Error: Length[p]\[NotEqual] dim+1 \>\"", "]"}], 
          ";", 
          RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Flatten", "[", 
         RowBox[{"ExceedL", "[", 
          RowBox[{"\[Alpha]", ",", "l", ",", "T", ",", 
           RowBox[{"{", "}"}], ",", "print"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"t", "=", "1"}], ",", 
         RowBox[{"t", "\[LessEqual]", " ", "T"}], ",", 
         RowBox[{"t", "++"}], ",", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"\[Kappa]", "=", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"\[Kappa]", ",", 
             RowBox[{"RHB", "[", 
              RowBox[{"p", ",", "\[Alpha]"}], "]"}]}], "]"}]}], ";", " ", 
          RowBox[{"(*", 
           RowBox[{
            OverscriptBox["\[Kappa]", "~"], 
            RowBox[{"(", "\[Alpha]", ")"}], " ", "forecast", " ", "for", " ", 
            "period", " ", "t"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"v", "=", 
           RowBox[{"AppendTo", "[", 
            RowBox[{"v", ",", 
             RowBox[{"Total", "[", 
              RowBox[{"p", "[", 
               RowBox[{"[", 
                RowBox[{
                 RowBox[{"-", "\[Upsilon]"}], ";;"}], "]"}], "]"}], "]"}]}], 
            "]"}]}], ";", 
          RowBox[{"(*", " ", 
           RowBox[{
            RowBox[{"Pr", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"#", " ", "\[Alpha]"}], "-", "exceed"}], " ", ">", " ", 
              RowBox[{"dim", "-", "v"}]}], "]"}], " ", "forecast", " ", "for",
             " ", "period", " ", "t"}], "*)"}], "\[IndentingNewLine]", 
          RowBox[{"p", "=", " ", 
           RowBox[{"p", " ", "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "\[Lambda]"}], ")"}], 
             RowBox[{"UnitVector", "[", 
              RowBox[{
               RowBox[{"dim", "+", "1"}], ",", 
               RowBox[{
                RowBox[{"z", "[", 
                 RowBox[{"[", "t", "]"}], "]"}], "+", "1"}]}], "]"}]}]}]}], 
          ";", "\[IndentingNewLine]", 
          RowBox[{"p", "=", 
           RowBox[{"p", " ", 
            RowBox[{"Min", "[", " ", 
             RowBox[{
              FractionBox[
               RowBox[{"dim", " ", "\[Alpha]"}], 
               RowBox[{
                RowBox[{"Range", "[", 
                 RowBox[{"0", ",", "dim"}], "]"}], ".", "p"}]], ",", "1"}], 
             "]"}]}]}], ";", 
          RowBox[{
           RowBox[{"p", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "=", 
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"1", "-", 
              RowBox[{"Total", "[", 
               RowBox[{"Rest", "[", "p", "]"}], "]"}]}], ",", "0"}], 
            "]"}]}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        FractionBox[
         RowBox[{"{", 
          RowBox[{"\[Kappa]", ",", "v"}], "}"}], 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"dim", "-", "1"}], ")"}], 
          RowBox[{"H", "[", 
           RowBox[{"{", 
            RowBox[{"\[Alpha]", ",", 
             RowBox[{"1", "-", "\[Alpha]"}]}], "}"}], "]"}]}]], "]"}]}]}], 
     "]"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", 
      "**"}], "*", " ", "EWMA", 
     RowBox[{"(", "\[Lambda]", ")"}]}], "  ", 
    "********************************)"}],
   FontSize->18]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"SysCI", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", 
      RowBox[{"iter_:", "1000"}], ",", 
      RowBox[{"minbin_:", "0"}], ",", 
      RowBox[{"print_:", "False"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "x", ",", "i", ",", "j", ",", "T", ",", "dim", ",", "z", ",", "Bi", 
        ",", "k"}], "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"Computes", " ", "the", " ", "bootstrap", " ", "5", "%"}], 
        "-", 
        RowBox[{"CI", " ", "for", " ", "the", " ", "sys", " ", "\[Alpha]"}], 
        "-", "CTI"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"T", "=", 
        RowBox[{"Length", "[", "l", "]"}]}], ";", 
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"x", "=", "l"}], ";", "\[IndentingNewLine]", 
       RowBox[{"Bi", "=", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"PDF", "[", 
           RowBox[{
            RowBox[{"BinomialDistribution", "[", 
             RowBox[{"dim", ",", 
              RowBox[{"Min", "[", 
               RowBox[{"\[Alpha]", ",", 
                RowBox[{"1", "-", "\[Alpha]"}]}], "]"}]}], "]"}], ",", "i"}], 
           "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"i", ",", "0", ",", "dim"}], "}"}]}], "]"}]}], ";", 
       RowBox[{"j", "=", "0"}], ";", 
       RowBox[{"k", "=", 
        RowBox[{"{", "}"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"i", "=", 
        RowBox[{"LengthWhile", "[", 
         RowBox[{
          RowBox[{"Sort", "[", 
           RowBox[{"Bi", ",", "Greater"}], "]"}], ",", 
          RowBox[{
           RowBox[{"#", ">", 
            RowBox[{"minbin", "/", "T"}]}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{"print", ",", 
         RowBox[{"Print", "[", 
          RowBox[{
          "\"\<T = \>\"", ",", "T", ",", "\"\<, \[Alpha] = \>\"", ",", 
           "\[Alpha]", ",", "\"\<, dim = \>\"", ",", "dim", ",", 
           "\"\<, Pr cutoff at = \>\"", ",", "i"}], "]"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"While", "[", 
          RowBox[{
           RowBox[{"j", "<", "iter"}], ",", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"z", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"Flatten", "[", "#", "]"}], "&"}], "/@", 
              RowBox[{"JTPr\[Lambda]s", "[", 
               RowBox[{"\[Alpha]", ",", "x", ",", "1", ",", "T"}], "]"}]}]}], 
            ";", "\[IndentingNewLine]", 
            RowBox[{"z", "=", 
             RowBox[{"Sort", "[", 
              RowBox[{
               RowBox[{"z", "~", "Join", "~", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{"i", ",", "0"}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "0", ",", "dim"}], "}"}]}], "]"}]}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{"#1", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], "<", 
                 RowBox[{"#2", "[", 
                  RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"z", "=", 
             RowBox[{"GatherBy", "[", 
              RowBox[{"z", ",", "First"}], "]"}]}], ";", 
            RowBox[{"z", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"Total", "[", "#", "]"}], "&"}], "/@", "z"}]}], ";", 
            RowBox[{"z", "=", 
             RowBox[{
              RowBox[{
               RowBox[{"#", "[", 
                RowBox[{"[", "2", "]"}], "]"}], "&"}], "/@", "z"}]}], ";", 
            RowBox[{"z", "=", 
             RowBox[{"Transpose", "[", 
              RowBox[{"{", 
               RowBox[{"z", ",", "Bi"}], "}"}], "]"}]}], ";", 
            RowBox[{"z", "=", 
             RowBox[{
              RowBox[{"Sort", "[", 
               RowBox[{"z", ",", 
                RowBox[{
                 RowBox[{
                  RowBox[{"#1", "[", 
                   RowBox[{"[", "2", "]"}], "]"}], ">", 
                  RowBox[{"#2", "[", 
                   RowBox[{"[", "2", "]"}], "]"}]}], "&"}]}], "]"}], "[", 
              RowBox[{"[", 
               RowBox[{";;", "i"}], " ", "]"}], "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"If", "[", 
             RowBox[{
              RowBox[{"i", "\[LessEqual]", " ", "dim"}], ",", 
              RowBox[{"z", "=", 
               RowBox[{"Append", "[", 
                RowBox[{"z", ",", 
                 RowBox[{"Chop", "[", 
                  RowBox[{"1.", "-", 
                   RowBox[{"Total", "[", "z", "]"}]}], "]"}]}], "]"}]}]}], 
             "]"}], ";", 
            RowBox[{"z", "=", 
             RowBox[{"Transpose", "[", "z", "]"}]}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{"k", "=", 
             RowBox[{"Append", "[", 
              RowBox[{"k", ",", " ", 
               FractionBox[
                RowBox[{
                 RowBox[{"z", "[", 
                  RowBox[{"[", "1", "]"}], "]"}], ".", 
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"Log", "[", 
                    RowBox[{"$MachineEpsilon", "+", 
                    RowBox[{"z", "[", 
                    RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "-", 
                   RowBox[{"Log", "[", 
                    RowBox[{"z", "[", 
                    RowBox[{"[", "2", "]"}], "]"}], "]"}]}], ")"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"dim", "-", "1"}], ")"}], 
                 RowBox[{"H", "[", 
                  RowBox[{"{", 
                   RowBox[{"\[Alpha]", ",", 
                    RowBox[{"1", "-", "\[Alpha]"}]}], "}"}], "]"}]}]]}], " ", 
              "]"}]}], ";", 
            RowBox[{"x", "=", 
             RowBox[{"RandomChoice", "[", 
              RowBox[{"l", ",", "T"}], "]"}]}], ";", 
            RowBox[{"j", "++"}]}]}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"k", "[", 
            RowBox[{"[", "j", "]"}], "]"}]}], "}"}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"k", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"Quantile", "[", 
           RowBox[{"k", ",", ".025", ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
          RowBox[{"Quantile", "[", 
           RowBox[{"k", ",", 
            RowBox[{"1", "-", ".025"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]}], "}"}]}], 
       ";", "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"z", "~", "Join", "~", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"z", "[", 
            RowBox[{"[", "3", "]"}], "]"}], "-", 
           RowBox[{"z", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "]"}]}]}], "]"}]}], 
   ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CRX2", "[", 
     RowBox[{"T_", ",", 
      RowBox[{"dim_:", "2"}], ",", 
      RowBox[{"q_:", "0.01"}], ",", 
      RowBox[{"\[Alpha]list_:", "ticks50"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Quantile", "[", 
        RowBox[{
         RowBox[{"ChiSquareDistribution", "[", 
          RowBox[{
           RowBox[{"NrNonEmptyCells", "[", 
            RowBox[{"T", ",", "dim", ",", "#"}], "]"}], "-", "dim", "-", 
           "1"}], "]"}], ",", 
         RowBox[{"1.", "-", "q"}]}], "]"}], 
       RowBox[{"2", "T", "*", 
        RowBox[{"(", 
         RowBox[{"dim", "-", "1"}], ")"}], " ", 
        RowBox[{"H", "[", 
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"1.", "-", "#"}]}], "}"}], "]"}]}]], "&"}], "/@", 
     "\[Alpha]list"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["Chi", "2"], " ", "q", "%", " ", "critical", " ", 
     "region", " ", "for", " ", "the", " ", "\[Kappa]", 
     RowBox[{"(", "\[Alpha]", ")"}], " ", "statistic", " ", "for", " ", 
     "sample", " ", "size", " ", "T"}], ",", " ", 
    RowBox[{
    "dimension", " ", "dim", " ", "and", " ", "all", " ", "\[Alpha]", " ", 
     "in", " ", 
     RowBox[{"\[Alpha]list", ".", " ", "For"}], " ", "example"}], ",", " ", 
    RowBox[{"CR", "[", "10000", "]"}]}], "*)"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CRX2compacted", "[", 
     RowBox[{"T_", ",", 
      RowBox[{"dim_:", "2"}], ",", 
      RowBox[{"q_:", "0.01"}], ",", 
      RowBox[{"\[Alpha]list_:", "ticks50"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"Quantile", "[", 
        RowBox[{
         RowBox[{"ChiSquareDistribution", "[", 
          RowBox[{"dim", "-", "1"}], "]"}], ",", 
         RowBox[{"1.", "-", "q"}]}], "]"}], 
       RowBox[{"2", "T", "*", 
        RowBox[{"(", 
         RowBox[{"dim", "-", "1"}], ")"}], " ", 
        RowBox[{"H", "[", 
         RowBox[{"{", 
          RowBox[{"#", ",", 
           RowBox[{"1.", "-", "#"}]}], "}"}], "]"}]}]], "&"}], "/@", 
     "\[Alpha]list"}]}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     SuperscriptBox["Chi", "2"], " ", "q", "%", " ", "critical", " ", 
     "region", " ", "for", " ", "the", " ", "compacted", " ", "\[Kappa]", 
     RowBox[{"(", "\[Alpha]", ")"}], " ", "statistic", " ", "for", " ", 
     "sample", " ", "size", " ", "T"}], ",", " ", 
    RowBox[{
    "dimension", " ", "dim", " ", "and", " ", "all", " ", "\[Alpha]", " ", 
     "in", " ", 
     RowBox[{"\[Alpha]list", ".", " ", "For"}], " ", "example"}], ",", " ", 
    RowBox[{"CR", "[", "10000", "]"}]}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Tallyz", "[", 
     RowBox[{"\[Alpha]_", ",", "l_", ",", 
      RowBox[{"quantiles_:", 
       RowBox[{"{", "}"}]}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "z", "}"}], ",", 
      RowBox[{"(*", " ", 
       RowBox[{
       "counts", " ", "obs", " ", "in", " ", "the", " ", "list", " ", "l", 
        " ", "falling", " ", "into", " ", "different", " ", "JTs"}], " ", 
       "*)"}], " ", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"z", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Length", "[", "quantiles", "]"}], "\[Equal]", "0"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Quantile", "[", 
             RowBox[{"#", ",", "\[Alpha]", ",", 
              RowBox[{"{", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"1", "/", "2"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}], "&"}], " ",
            "/@", " ", 
           RowBox[{"Transpose", "[", "l", "]"}]}], ",", "quantiles"}], 
         "]"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Transpose", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"z", "-", "#"}], "&"}], "/@", " ", "l"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"\[Alpha]", "\[LessEqual]", " ", ".5"}], ",", 
         RowBox[{"z", "=", 
          RowBox[{"Total", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Clip", "[", 
              RowBox[{"#", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "&"}], "/@", " ", 
            "z"}], "]"}]}], ",", 
         RowBox[{"z", "=", 
          RowBox[{"Total", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"Clip", "[", 
              RowBox[{"#", ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "0"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "&"}], "/@", " ", 
            RowBox[{"-", "z"}]}], "]"}]}]}], "]"}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"z", "=", 
        RowBox[{"Tally", "[", 
         RowBox[{
          RowBox[{"z", "~", "Join", "~", 
           RowBox[{"Range", "[", 
            RowBox[{"0", ",", 
             RowBox[{"Length", "[", 
              RowBox[{"l", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "]"}]}], "]"}]}], ",", 
          "Equal"}], "]"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"Sort", "[", 
         RowBox[{"z", ",", 
          RowBox[{
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "1", "]"}], "]"}], "<", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "&"}]}], "]"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"Transpose", "[", "z", "]"}], "[", 
          RowBox[{"[", "2", "]"}], "]"}], "-", "1"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "z", "]"}], "\[NotEqual]", 
          RowBox[{"Length", "[", "l", "]"}]}], ",", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<****** \[Sum]z= \>\"", ",", 
            RowBox[{"Total", "[", "z", "]"}], ",", 
            "\"\< \[NotEqual] Length[l]= \>\"", ",", 
            RowBox[{"Length", "[", "l", "]"}], ",", 
            "\"\< .... Aborting...\>\""}], "]"}], ";", 
          RowBox[{"Abort", "[", "]"}]}], ",", 
         RowBox[{"Return", "[", "z", "]"}]}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"CondSymBin", "[", 
     RowBox[{"\[Alpha]_", ",", "l1_", ",", "l2_", ",", 
      RowBox[{"max_:", "1000"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "dim", ",", "p", ",", "len1", ",", "len2", ",", "z1", ",", "z2", ",", 
        "z", ",", "x", ",", "randMH", ",", "chi2"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"conditional", " ", 
        RowBox[{"(", 
         RowBox[{"generalized", " ", "Fisher"}], ")"}], " ", "test", " ", 
        "of", " ", "asymmetry", " ", "between", " ", "two", " ", "tail", " ", 
        "interdep", " ", "structures", " ", 
        RowBox[{
         RowBox[{"(", "TIS", ")"}], ".", " ", 
         RowBox[{"Usage", ":", " ", 
          RowBox[{
           RowBox[{"CondAsym", "[", 
            RowBox[{".4", ",", "x", ",", "y"}], "]"}], "\[IndentingNewLine]", 
           "To", " ", "test", " ", "the", " ", 
           RowBox[{"upper", "/", "lower"}], " ", "tail", " ", "symmetry"}], 
          ":", " ", 
          RowBox[{"CondAsym", "[", 
           RowBox[{".4", ",", "x", ",", 
            RowBox[{"-", "x"}]}], "]"}]}]}]}], " ", "*)"}], " ", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"dim", "=", 
        RowBox[{"Length", "[", 
         RowBox[{"l1", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"dim", "\[NotEqual]", " ", 
          RowBox[{"Length", "[", 
           RowBox[{"l2", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "]"}]}], ",", 
         RowBox[{
          RowBox[{
          "Print", "[", "\"\<******* dim l1 \[NotEqual] dim l2 *******\>\"", 
           "]"}], ";", 
          RowBox[{"Abort", "[", "]"}]}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"z1", "=", 
        RowBox[{"Tallyz", "[", 
         RowBox[{"\[Alpha]", ",", "l1"}], "]"}]}], ";", 
       RowBox[{"z2", "=", 
        RowBox[{"Tallyz", "[", 
         RowBox[{"\[Alpha]", ",", "l2"}], "]"}]}], ";", 
       RowBox[{"z", "=", 
        RowBox[{"z1", "+", "z2"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Total", "[", "z1", "]"}], "\[NotEqual]", " ", 
          RowBox[{"Total", "[", "z2", "]"}]}], ",", 
         RowBox[{"Print", "[", 
          RowBox[{"\"\<***** \[Sum]l1= \>\"", ",", 
           RowBox[{"Total", "[", "z1", "]"}], ",", 
           "\"\< \[NotEqual] \[Sum]l2 = \>\"", ",", 
           RowBox[{"Total", "[", "z2", "]"}], ",", "\"\< *****\>\""}], 
          "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Min", "[", "z", "]"}], "\[LessEqual]", " ", "0."}], ",", 
         RowBox[{
          RowBox[{"z1", "=", 
           RowBox[{"Pick", "[", 
            RowBox[{"z1", ",", " ", 
             RowBox[{"Sign", "[", "z", "]"}], ",", "1"}], "]"}]}], ";", 
          RowBox[{"z2", "=", 
           RowBox[{"Pick", "[", 
            RowBox[{"z2", ",", " ", 
             RowBox[{"Sign", "[", "z", "]"}], ",", "1"}], "]"}]}], ";", 
          RowBox[{"z", "=", 
           RowBox[{"Pick", "[", 
            RowBox[{"z", ",", " ", 
             RowBox[{"Sign", "[", "z", "]"}], ",", "1"}], "]"}]}]}]}], " ", 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"len1", "=", 
        RowBox[{"Total", "[", "z1", "]"}]}], ";", 
       RowBox[{"len2", "=", 
        RowBox[{"Total", "[", "z2", "]"}]}], ";", 
       RowBox[{"p", "=", 
        RowBox[{"1.", 
         RowBox[{"z", "/", 
          RowBox[{"Total", "[", "z", "]"}]}]}]}], ";", "\[IndentingNewLine]", 
       "\[IndentingNewLine]", 
       RowBox[{"chi2", "=", 
        RowBox[{
         RowBox[{"Total", "[", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z1", "-", 
              RowBox[{"len1", " ", "p"}]}], ")"}], "2"], "/", 
           RowBox[{"(", 
            RowBox[{"len1", " ", "p"}], ")"}]}], "]"}], "+", 
         RowBox[{"Total", "[", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"z2", "-", 
              RowBox[{"len2", " ", "p"}]}], ")"}], "2"], "/", 
           RowBox[{"(", 
            RowBox[{"len2", " ", "p"}], ")"}]}], "]"}]}]}], ";", 
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
       RowBox[{"x", "=", 
        RowBox[{"PDF", "[", 
         RowBox[{
          RowBox[{"MultivariateHypergeometricDistribution", "[", 
           RowBox[{"len1", ",", "z"}], "]"}], ",", "z1"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"randMH", "=", 
        RowBox[{"RandomVariate", "[", 
         RowBox[{
          RowBox[{"MultivariateHypergeometricDistribution", "[", 
           RowBox[{"len1", ",", "z"}], "]"}], ",", 
          StyleBox["max", "DesignDiscussion"]}], 
         StyleBox["]", "DesignDiscussion"]}]}], 
       StyleBox[";", "DesignDiscussion"], 
       RowBox[{"randMH", "=", 
        RowBox[{
         RowBox[{
          RowBox[{"PDF", "[", 
           RowBox[{
            RowBox[{"MultivariateHypergeometricDistribution", "[", 
             RowBox[{"len1", ",", "z"}], "]"}], ",", "#"}], "]"}], "&"}], " ",
          "/@", " ", "randMH"}]}], 
       StyleBox[";", "DesignDiscussion"], "\[IndentingNewLine]", 
       RowBox[{"Return", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"1.", 
           RowBox[{
            RowBox[{
             RowBox[{"BinCounts", "[", 
              RowBox[{
               RowBox[{"-", "randMH"}], ",", 
               RowBox[{"{", 
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "max"}], ",", 
                  RowBox[{"-", "x"}], ",", "max"}], "}"}], "}"}]}], "]"}], 
             "[", 
             RowBox[{"[", "2", "]"}], "]"}], "/", "max"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"chi2", ",", 
            RowBox[{"1.", "-", 
             RowBox[{"Quiet", "[", 
              RowBox[{"CDF", "[", 
               RowBox[{
                RowBox[{"ChiSquareDistribution", "[", 
                 RowBox[{"Max", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"2", "-", "1"}], ")"}], 
                    RowBox[{"Length", "[", "z", "]"}]}], "-", "1"}], ",", 
                   "1"}], "]"}], "]"}], ",", "chi2"}], "]"}], "]"}]}]}], 
           "}"}]}], "}"}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.5832555006162453`*^9, 3.5832555072150564`*^9}, {
   3.583255544951523*^9, 3.583255546761126*^9}, {3.5832555857143946`*^9, 
   3.583255620284055*^9}, {3.5832556773645554`*^9, 3.583255696006588*^9}, {
   3.583255727113043*^9, 3.5832557379862623`*^9}, {3.5832558717544975`*^9, 
   3.5832558726436996`*^9}, {3.583256708419168*^9, 3.583256750601642*^9}, {
   3.583256814982955*^9, 3.5832568351381907`*^9}, 3.583257194687622*^9, {
   3.5832576047499423`*^9, 3.5832576883348894`*^9}, {3.5832577485041947`*^9, 
   3.583257810202303*^9}, {3.5832579064544725`*^9, 3.5832579093404775`*^9}, {
   3.5832579493233476`*^9, 3.583257949479348*^9}, 3.583258078335574*^9, {
   3.5832582065677996`*^9, 3.5832582666591053`*^9}, {3.583258433048997*^9, 
   3.583258490535098*^9}, {3.5832585305335684`*^9, 3.583258587333268*^9}, {
   3.583258627128938*^9, 3.583258660466197*^9}, {3.5832588469021244`*^9, 
   3.583258873359771*^9}, {3.5832589668507347`*^9, 3.583259047222076*^9}, {
   3.58325915196066*^9, 3.5832591762343025`*^9}, {3.583259211318764*^9, 
   3.5832592170283747`*^9}, {3.58325946510001*^9, 3.5832595012920732`*^9}, {
   3.583259600633048*^9, 3.5832596085890617`*^9}, {3.5832596533611407`*^9, 
   3.583259654375142*^9}, 3.583260754535875*^9, {3.5832609104425488`*^9, 
   3.583260915247357*^9}, {3.5832609806270723`*^9, 3.5832610196583405`*^9}, {
   3.5832613045616407`*^9, 3.5832613829049788`*^9}, {3.583261482214753*^9, 
   3.5832615090312*^9}, 3.583261557906086*^9, {3.5832616347518206`*^9, 
   3.5832616536278543`*^9}, {3.5832616944687257`*^9, 
   3.5832618066017227`*^9}, {3.58326193027874*^9, 3.583261932119543*^9}, {
   3.583262168413158*^9, 3.583262172531565*^9}, {3.583262253043307*^9, 
   3.5832622821841583`*^9}, {3.5832624023979692`*^9, 
   3.5832624147999907`*^9}, {3.583262446265246*^9, 3.5832624847037134`*^9}, {
   3.5832628663235846`*^9, 3.583262922795684*^9}, {3.583262998268616*^9, 
   3.583263034242279*^9}, {3.5832636008196745`*^9, 3.5832636903014317`*^9}, {
   3.5832659131669364`*^9, 3.583265916442942*^9}, {3.5832664876535454`*^9, 
   3.5832665119895887`*^9}, {3.583266544734046*^9, 3.5832665480412517`*^9}, 
   3.5832669347323327`*^9, {3.583266994620838*^9, 3.583266999222846*^9}, {
   3.5832670512021375`*^9, 3.583267057286148*^9}, {3.583267100030223*^9, 
   3.583267116878253*^9}, {3.583267454743646*^9, 3.583267457707651*^9}, {
   3.5832675329309835`*^9, 3.5832675552546225`*^9}, 3.5832676062979126`*^9, {
   3.583298562182768*^9, 3.5832985862380095`*^9}, {3.5832987639687214`*^9, 
   3.5832987858867598`*^9}, {3.5833000172281227`*^9, 3.583300040846564*^9}, {
   3.5833000940738573`*^9, 3.5833000943234577`*^9}, {3.5833017711704025`*^9, 
   3.58330177538241*^9}, 3.583301817455684*^9, {3.5833020137508287`*^9, 
   3.583302123902622*^9}, {3.5833021575674815`*^9, 3.5833022704336796`*^9}, {
   3.583302337981798*^9, 3.5833023601026373`*^9}, {3.5833027294800863`*^9, 
   3.5833027735813637`*^9}, {3.5833028138294344`*^9, 3.583302814094635*^9}, {
   3.583303097281932*^9, 3.583303160555643*^9}, {3.5833032242661552`*^9, 
   3.583303232019369*^9}, {3.583303263640624*^9, 3.5833032729694405`*^9}, {
   3.5833034889050198`*^9, 3.583303490480623*^9}, {3.5833035302138925`*^9, 
   3.583303531898696*^9}, {3.583303596358009*^9, 3.5833036035964212`*^9}, {
   3.5833037107374096`*^9, 3.583303714200616*^9}, {3.583303765743106*^9, 
   3.5833037734495196`*^9}, {3.5833038439928436`*^9, 3.583303894755333*^9}, {
   3.5833039687462626`*^9, 3.5833039828642874`*^9}, {3.5833040386343856`*^9, 
   3.5833040886168733`*^9}, {3.583304343661721*^9, 3.583304457994322*^9}, {
   3.5833045122824173`*^9, 3.58330451952083*^9}, {3.58330458780215*^9, 
   3.5833045973025665`*^9}, {3.5833046901383295`*^9, 3.58330478132049*^9}, 
   3.5833049353551607`*^9, {3.583304994541664*^9, 3.58330503179453*^9}, {
   3.583305187358003*^9, 3.5833051956104174`*^9}, {3.5833052726433525`*^9, 
   3.583305297072996*^9}, {3.583305642130002*^9, 3.5833056482608128`*^9}, {
   3.5833057353557653`*^9, 3.5833057363853674`*^9}, {3.583305923367296*^9, 
   3.5833059369081197`*^9}, {3.5833125968336997`*^9, 
   3.5833126371909704`*^9}, {3.5833127294651327`*^9, 3.583312795858849*^9}, {
   3.583312890847416*^9, 3.583312894653823*^9}, {3.583313399330309*^9, 
   3.583313406100721*^9}, {3.583315873135854*^9, 3.5833158995623007`*^9}, {
   3.583315970963626*^9, 3.583316007935691*^9}, {3.583316407857993*^9, 
   3.583316416188408*^9}, {3.5833164651568937`*^9, 3.583316531847011*^9}, {
   3.583316564341868*^9, 3.583316585557905*^9}, {3.5833168901796403`*^9, 
   3.5833168942512474`*^9}, {3.583316947384941*^9, 3.5833169869466105`*^9}, {
   3.5833170985648065`*^9, 3.5833172023517885`*^9}, {3.5833172365158486`*^9, 
   3.5833172984791574`*^9}, {3.583317354639256*^9, 3.5833175225111513`*^9}, {
   3.583317697871059*^9, 3.5833177354515247`*^9}, {3.5833182589260445`*^9, 
   3.583318270766465*^9}, {3.5833184241615343`*^9, 3.5833184458455725`*^9}, 
   3.5833185225353074`*^9, {3.5833185758718014`*^9, 3.583318619130677*^9}, {
   3.583318713994444*^9, 3.5833187366768837`*^9}, {3.5833188106990137`*^9, 
   3.5833188221650333`*^9}, {3.5833193509799633`*^9, 
   3.5833193974524446`*^9}, {3.583319455203746*^9, 3.58331946886937*^9}, {
   3.58331950850904*^9, 3.5833195224086637`*^9}, {3.583320280211195*^9, 
   3.583320281864798*^9}, {3.583326340206643*^9, 3.583326414213173*^9}, {
   3.583326447160431*^9, 3.5833265396061935`*^9}, {3.583326905146035*^9, 
   3.5833269099352436`*^9}, 3.5833274365765686`*^9, {3.5833277209650683`*^9, 
   3.58332773336709*^9}, {3.5833278224588466`*^9, 3.5833278243776503`*^9}, 
   3.583328297900882*^9, {3.5833284452587404`*^9, 3.583328446163542*^9}, {
   3.5833285991686106`*^9, 3.583328602195016*^9}, {3.583328665156727*^9, 
   3.583328737150853*^9}, {3.5833296373816347`*^9, 3.5833296385516367`*^9}, 
   3.583329986276247*^9, {3.5833300374911375`*^9, 3.5833300513595614`*^9}, {
   3.583330089252028*^9, 3.583330112605269*^9}, {3.5833389320280514`*^9, 
   3.583338933073253*^9}, 3.5833397277618484`*^9, 3.5833397720503263`*^9, {
   3.58334000183873*^9, 3.583340005333136*^9}, {3.5833403438225307`*^9, 
   3.5833404267522764`*^9}, 3.5833426347971573`*^9, {3.5833498152591324`*^9, 
   3.583349891824067*^9}, {3.583349945410161*^9, 3.5833500400399275`*^9}, {
   3.5833501516893234`*^9, 3.5833501579917345`*^9}, {3.583350232185465*^9, 
   3.58335026366632*^9}, {3.583350297299979*^9, 3.583350300029984*^9}, {
   3.5833503646140976`*^9, 3.583350365674899*^9}, {3.583350397592555*^9, 
   3.583350402724964*^9}, {3.583351475925652*^9, 3.5833515000120945`*^9}, {
   3.5833517568509455`*^9, 3.5833517677241645`*^9}, {3.5834000151396155`*^9, 
   3.583400020412425*^9}, {3.5834000518464804`*^9, 3.5834000765725236`*^9}, {
   3.583400107834978*^9, 3.583400113310588*^9}, {3.5834001439022417`*^9, 
   3.583400271604066*^9}, {3.583400315268543*^9, 3.583400391037876*^9}, {
   3.5834007900865765`*^9, 3.5834008145474195`*^9}, {3.5834008518782854`*^9, 
   3.5834009429980454`*^9}, {3.5834012463561783`*^9, 3.583401250224985*^9}, {
   3.583401397614044*^9, 3.583401403354854*^9}, {3.583401575204756*^9, 
   3.5834016888041553`*^9}, {3.583401989541484*^9, 3.5834020761996355`*^9}, {
   3.583402197630249*^9, 3.583402204634661*^9}, {3.5834023301212816`*^9, 
   3.5834023304956827`*^9}, {3.5834104441300907`*^9, 
   3.5834105127702117`*^9}, {3.5834105449218683`*^9, 3.583410740733412*^9}, {
   3.5834107797958803`*^9, 3.5834108011055183`*^9}, {3.583410843287992*^9, 
   3.583410886016467*^9}, {3.583411259044322*^9, 3.583411260105124*^9}, {
   3.5834114543410654`*^9, 3.5834115191435795`*^9}, {3.5834116416661944`*^9, 
   3.5834116448486*^9}, 3.583430797118597*^9, {3.5834309111391973`*^9, 
   3.5834309232136183`*^9}, {3.583432995078458*^9, 3.5834330214113045`*^9}, {
   3.583434851700119*^9, 3.583434879514968*^9}, {3.58347210015948*^9, 
   3.5834721206109495`*^9}, {3.583472358255574*^9, 3.5834723642607656`*^9}, {
   3.5834730700363026`*^9, 3.583473093030408*^9}, {3.583473140578598*^9, 
   3.5834731505312705`*^9}, {3.5834731957706904`*^9, 3.5834732120880814`*^9}, 
   3.583473322192874*^9, {3.583474505100252*^9, 3.5834745052406564`*^9}, {
   3.58348692474459*^9, 3.5834869477551794`*^9}, {3.5834871778737645`*^9, 
   3.5834871933179626`*^9}, {3.5834872556251283`*^9, 
   3.5834872572319384`*^9}, {3.583487487895017*^9, 3.5834874884566207`*^9}, {
   3.583487792700976*^9, 3.5834878168967314`*^9}, {3.58348824190377*^9, 
   3.5834882478942084`*^9}, {3.5834884396987424`*^9, 3.58348844245996*^9}, {
   3.583488482521017*^9, 3.583488518167245*^9}, {3.583488881222963*^9, 
   3.583488893890894*^9}, {3.5834889275888376`*^9, 3.583488944078989*^9}, {
   3.5834891139623775`*^9, 3.5834891345237045`*^9}, {3.5834892088752112`*^9, 
   3.583489250325474*^9}, 3.58348930124494*^9, {3.583489371851445*^9, 
   3.5834893874828453`*^9}, 3.583489549397321*^9, 3.583490134798421*^9, {
   3.5834902238749924`*^9, 3.583490228102619*^9}, {3.583556166542838*^9, 
   3.5835561842495565`*^9}, {3.583556548078508*^9, 3.583556571721286*^9}, {
   3.5835567070497627`*^9, 3.5835567686014433`*^9}, {3.5835602799160967`*^9, 
   3.583560285828648*^9}, {3.5835603502583*^9, 3.5835604109594564`*^9}, {
   3.5835606512820835`*^9, 3.583560654807751*^9}, {3.5835612099371176`*^9, 
   3.583561224960592*^9}, {3.583561259952962*^9, 3.5835612996099415`*^9}, {
   3.5835613485805387`*^9, 3.58356136510168*^9}, 3.583561556779067*^9, {
   3.583561613844964*^9, 3.583561623080342*^9}, {3.5835618642602034`*^9, 
   3.583562030215131*^9}, {3.583562163268445*^9, 3.583562186465645*^9}, 
   3.583562283201245*^9, {3.583562617731157*^9, 3.5835626532525845`*^9}, {
   3.583573134470754*^9, 3.5835731627693357`*^9}, {3.583573247056676*^9, 
   3.5835732471034765`*^9}, {3.583578457633478*^9, 3.5835784893172817`*^9}, {
   3.583578678527069*^9, 3.583578727780057*^9}, {3.5835787584676175`*^9, 
   3.583578758966856*^9}, {3.583578834101368*^9, 3.5835788617924333`*^9}, 
   3.5835789244600434`*^9, {3.583579165975786*^9, 3.5835791800472565`*^9}, {
   3.583598480442422*^9, 3.583598486261232*^9}, {3.583598562514166*^9, 
   3.5835986125278535`*^9}, {3.5835988630330935`*^9, 
   3.5835988935623474`*^9}, {3.5835990838514814`*^9, 
   3.5835991522576017`*^9}, {3.583599187622864*^9, 3.583599239024954*^9}, {
   3.5835993246691046`*^9, 3.5835993612043686`*^9}, {3.5835996384636555`*^9, 
   3.5835996385104556`*^9}, {3.5836001326881237`*^9, 
   3.5836001503161545`*^9}, {3.5836004256254377`*^9, 3.5836004451098723`*^9}, 
   3.5836008994450703`*^9, {3.5836009333751297`*^9, 3.583600938460739*^9}, 
   3.583601987131785*^9, {3.583602223241*^9, 3.583602228638609*^9}, {
   3.58360253065514*^9, 3.583602544570364*^9}, {3.583602574631617*^9, 
   3.5836025989208593`*^9}, {3.583602643490138*^9, 3.583602663551773*^9}, {
   3.583602742550312*^9, 3.583602748213122*^9}, {3.5836029412946615`*^9, 
   3.5836029479714727`*^9}, {3.583603036392428*^9, 3.5836030714144897`*^9}, {
   3.5836032734816446`*^9, 3.5836032737468452`*^9}, {3.5836035788365808`*^9, 
   3.5836035827365875`*^9}, {3.583603782292138*^9, 3.5836038098105865`*^9}, {
   3.583603886328721*^9, 3.583603978493683*^9}, 3.5836040089917364`*^9, {
   3.5836041013282986`*^9, 3.583604629404826*^9}, {3.5836046638808866`*^9, 
   3.5836047488230357`*^9}, {3.583604831534381*^9, 3.583604914729327*^9}, {
   3.5836051210084896`*^9, 3.5836051210396895`*^9}, {3.5836052607067347`*^9, 
   3.5836052820163727`*^9}, {3.583605615420158*^9, 3.5836056171985607`*^9}, {
   3.583605700892708*^9, 3.5836057027647114`*^9}, {3.5836058172689123`*^9, 
   3.583605848406567*^9}, {3.5836067771697984`*^9, 3.5836067888698187`*^9}, {
   3.5836068234082794`*^9, 3.5836068439847155`*^9}, {3.5836068827819843`*^9, 
   3.583606939191683*^9}, {3.583607030951044*^9, 3.583607081526333*^9}, 
   3.5836071798377056`*^9, 3.583607215842569*^9, {3.5836073665076337`*^9, 
   3.5836074116385126`*^9}, {3.5836074593433967`*^9, 
   3.5836074632902036`*^9}, {3.5836075050670767`*^9, 
   3.5836075140682926`*^9}, {3.5836076137056675`*^9, 3.583607615499671*^9}, {
   3.583607687181797*^9, 3.5836076915966043`*^9}, {3.5836081173837523`*^9, 
   3.5836081338261814`*^9}, {3.5836090398601723`*^9, 
   3.5836090406713743`*^9}, {3.5836091369547434`*^9, 
   3.5836092076072674`*^9}, {3.583609326183076*^9, 3.583609420485241*^9}, {
   3.583655489481412*^9, 3.5836555676077137`*^9}, {3.583655628807691*^9, 
   3.583655629681308*^9}, {3.5836707402279463`*^9, 3.583670762614233*^9}, {
   3.5836708250331335`*^9, 3.583670875218977*^9}, {3.583671047923191*^9, 
   3.583671048765602*^9}, {3.583673644240235*^9, 3.583673648935985*^9}, {
   3.583673738420453*^9, 3.5836737427261915`*^9}, {3.583673827764517*^9, 
   3.583673838825271*^9}, {3.583673934917617*^9, 3.583673965447404*^9}, {
   3.583674240963996*^9, 3.5836742428360205`*^9}, {3.5836742774372635`*^9, 
   3.5836742902918286`*^9}, {3.5836743274203043`*^9, 3.583674328917924*^9}, {
   3.583675450639513*^9, 3.5836754708733616`*^9}, {3.583675508314562*^9, 
   3.583675508720175*^9}, 3.5836759216333494`*^9, {3.5836760036715345`*^9, 
   3.5836760130317144`*^9}, {3.583676103856661*^9, 3.5836761783324933`*^9}, {
   3.5836762562715635`*^9, 3.583676310451058*^9}, {3.583730515677224*^9, 
   3.583730560524706*^9}, {3.5837307628067875`*^9, 3.5837307672053957`*^9}, {
   3.583734791454058*^9, 3.5837348032634096`*^9}, {3.58373488210682*^9, 
   3.583734884322049*^9}, {3.583735635229576*^9, 3.583735637647607*^9}, 
   3.5837357983764677`*^9, {3.5837401950315104`*^9, 3.5837402158889775`*^9}, {
   3.583740310301388*^9, 3.583740312485416*^9}, {3.583740453651626*^9, 
   3.5837404667245936`*^9}, {3.583740506801507*^9, 3.5837405774860134`*^9}, {
   3.5837490488000307`*^9, 3.583749091435651*^9}, {3.5838166919343257`*^9, 
   3.583816743523856*^9}, {3.5838168238489213`*^9, 3.583817105884937*^9}, {
   3.583817136476929*^9, 3.5838171417341967`*^9}, {3.58381718338673*^9, 
   3.5838172591881027`*^9}, {3.5838199093370104`*^9, 3.5838199167315054`*^9}, 
   3.583819978133892*^9, {3.5838203229030457`*^9, 3.583820339860572*^9}, {
   3.5838203738692255`*^9, 3.5838204058966417`*^9}, {3.583821135606415*^9, 
   3.5838211356532145`*^9}, {3.5838220221990213`*^9, 3.583822023103833*^9}, {
   3.5838363076610966`*^9, 3.583836327878956*^9}, {3.5838374563407307`*^9, 
   3.5838374713328114`*^9}, {3.5843526883538847`*^9, 3.584352695592377*^9}, {
   3.584958610971243*^9, 3.584958623311001*^9}, {3.5850382076825123`*^9, 
   3.585038207729313*^9}, {3.5850419465670047`*^9, 3.5850419466450057`*^9}, {
   3.585044487378725*^9, 3.5850444895471525`*^9}, {3.5850456303489304`*^9, 
   3.5850456308949413`*^9}, 3.5850457793332825`*^9, {3.5850458711560593`*^9, 
   3.585045882715808*^9}, {3.585046342112997*^9, 3.5850463423782005`*^9}, {
   3.5851221673063803`*^9, 3.585122169646514*^9}, {3.585122690731318*^9, 
   3.58512271051945*^9}, {3.585122746382501*^9, 3.585122751993822*^9}, 
   3.5851228213157873`*^9, {3.5851245228521094`*^9, 3.585124523581151*^9}, {
   3.5851257775918765`*^9, 3.5851258290668206`*^9}, 3.5851259220411386`*^9, {
   3.5851260065379715`*^9, 3.5851260132163534`*^9}, {3.5851261368804264`*^9, 
   3.585126207801483*^9}, {3.5851262420414414`*^9, 3.585126266212824*^9}, {
   3.585126471065541*^9, 3.5851265000501986`*^9}, 3.585126874803633*^9, {
   3.585146332012189*^9, 3.5851463331752553`*^9}, {3.585147234893831*^9, 
   3.5851472396521025`*^9}, {3.5851477831591897`*^9, 3.585147836858261*^9}, {
   3.585148454950614*^9, 3.5851484758368087`*^9}, {3.585227400541739*^9, 
   3.585227415363587*^9}, {3.585227461023198*^9, 3.5852275100160007`*^9}, {
   3.5852275700674353`*^9, 3.585227603931372*^9}, {3.585227725101303*^9, 
   3.585227728478496*^9}, {3.5852285973631935`*^9, 3.585228600533375*^9}, {
   3.5852287589314346`*^9, 3.5852287606425323`*^9}, {3.585229565300556*^9, 
   3.5852295677726974`*^9}, {3.5852896573967447`*^9, 3.585289768751686*^9}, {
   3.585291494298218*^9, 3.585291607151115*^9}, {3.585298786373563*^9, 
   3.5852988002891197`*^9}, {3.5852990827059603`*^9, 3.585299150582865*^9}, {
   3.5852991850595284`*^9, 3.5852991926256733`*^9}, {3.585299272452409*^9, 
   3.585299286289875*^9}, {3.585299331171765*^9, 3.5852994264421864`*^9}, {
   3.5852994628842535`*^9, 3.5852995154881277`*^9}, {3.5852995637239466`*^9, 
   3.585299671708531*^9}, {3.585299718774334*^9, 3.58529972623123*^9}, {
   3.585299973415799*^9, 3.5853000165659523`*^9}, {3.5853000931785345`*^9, 
   3.585300094504552*^9}, {3.5853003143660774`*^9, 3.5853003261754284`*^9}, 
   3.585302119699222*^9, 3.5858459555812554`*^9, {3.5858459881351175`*^9, 
   3.5858459977216654`*^9}, {3.585846158946887*^9, 3.5858461760878677`*^9}, {
   3.5858468131763067`*^9, 3.585846843350033*^9}, {3.5858472042046723`*^9, 
   3.5858472171524134`*^9}, {3.585847362057701*^9, 3.5858473927784586`*^9}, {
   3.5858474455294757`*^9, 3.585847563329213*^9}, {3.585847604237553*^9, 
   3.5858476047995853`*^9}, {3.5858477077274723`*^9, 3.585847716123953*^9}, {
   3.5858477477667627`*^9, 3.585847753372083*^9}, {3.5858477966845603`*^9, 
   3.5858478079972076`*^9}, 3.5858481798154745`*^9, {3.5858916860302887`*^9, 
   3.585891691521383*^9}, {3.5858926190347204`*^9, 3.5858926445098467`*^9}, {
   3.585892746316752*^9, 3.5858927712614717`*^9}, {3.5858928196375437`*^9, 
   3.5858928260959845`*^9}, {3.5858929388535075`*^9, 
   3.5858929604908466`*^9}, {3.5858931009385467`*^9, 
   3.5858931016093507`*^9}, {3.585893211184453*^9, 3.585893211714857*^9}, {
   3.585894064263849*^9, 3.585894070394845*^9}, {3.5858942004237537`*^9, 
   3.5858942058994236`*^9}, {3.5858945376889796`*^9, 3.5858945640687923`*^9}, 
   3.5858950947137966`*^9, {3.5858953361347446`*^9, 3.585895336758749*^9}, {
   3.585895630691161*^9, 3.5858956603943224`*^9}, {3.5858959182266808`*^9, 
   3.5858959258863792`*^9}, {3.585905369289638*^9, 3.585905380631129*^9}, 
   3.5859055465233126`*^9, 3.585905783723821*^9, {3.585905814206417*^9, 
   3.585905839166577*^9}, {3.5859059509256935`*^9, 3.585905990518747*^9}, {
   3.585906478727249*^9, 3.585906518257902*^9}, {3.585906552968125*^9, 
   3.585906553030525*^9}, {3.585906599986826*^9, 3.585906600127227*^9}, {
   3.5859073237320137`*^9, 3.5859073365710607`*^9}, {3.58590739632771*^9, 
   3.5859074218966017`*^9}, {3.585907587023799*^9, 3.585907603544305*^9}, {
   3.585907643527361*^9, 3.585907663199087*^9}, {3.5859077215122614`*^9, 
   3.585907735801953*^9}, {3.585907815409263*^9, 3.5859078720532265`*^9}, {
   3.585908290412614*^9, 3.5859082924250264`*^9}, {3.58590843026751*^9, 
   3.5859084461172113`*^9}, {3.585908552931096*^9, 3.585908561776353*^9}, {
   3.5859086298863897`*^9, 3.5859086357676277`*^9}, {3.5859086743310747`*^9, 
   3.5859086919635887`*^9}, {3.5859088337781024`*^9, 
   3.5859088892988586`*^9}, {3.585908958781704*^9, 3.5859089638985367`*^9}, {
   3.5859091811455293`*^9, 3.5859091976660347`*^9}, {3.5859093027483087`*^9, 
   3.585909316585597*^9}, {3.585909499886772*^9, 3.585909506267213*^9}, {
   3.5859095804456887`*^9, 3.5859096259355803`*^9}, {3.5859096763133035`*^9, 
   3.5859096776861124`*^9}, 3.585909856400858*^9, {3.5859099129512205`*^9, 
   3.5859099312813377`*^9}, {3.5859110905699916`*^9, 
   3.5859110920209312`*^9}, {3.5872949539121356`*^9, 3.5872949546921453`*^9}, 
   3.587450350752166*^9, {3.5874508026743593`*^9, 3.58745080272116*^9}, {
   3.587451102267396*^9, 3.587451186463203*^9}, {3.587451271313779*^9, 
   3.5874512752918806`*^9}, {3.587451346367303*^9, 3.587451380610181*^9}, {
   3.587451722926096*^9, 3.5874517561233215`*^9}, {3.587452246979244*^9, 
   3.587452256354904*^9}, {3.587453521183085*^9, 3.5874535434289703`*^9}, {
   3.5874535757369843`*^9, 3.5874536108530345`*^9}, {3.587453651787959*^9, 
   3.587453668854578*^9}, {3.5874539739948797`*^9, 3.5874540002345843`*^9}, {
   3.587454030421165*^9, 3.5874540599213324`*^9}, {3.5874540920735507`*^9, 
   3.5874540963948336`*^9}, 3.587454250697401*^9, {3.5874641457061343`*^9, 
   3.5874641654247875`*^9}, 3.5874642053612995`*^9, {3.587464266935305*^9, 
   3.587464285530863*^9}, {3.587464333860592*^9, 3.587464340365917*^9}, {
   3.5874645536064177`*^9, 3.58746455370002*^9}, 3.5874646096580057`*^9, {
   3.5874647327123833`*^9, 3.587464752571438*^9}, {3.587465947156526*^9, 
   3.587465988653058*^9}, {3.5874661012709017`*^9, 3.587466240799091*^9}, 
   3.5874667210009637`*^9, {3.587468291731621*^9, 3.5874683015597467`*^9}, 
   3.5874683414962587`*^9, {3.5874683984684324`*^9, 3.5874684023061066`*^9}, 
   3.5874684679365683`*^9, {3.5877926238923426`*^9, 3.5877926240483427`*^9}, {
   3.5877927189432554`*^9, 3.5877928125438557`*^9}, {3.587793212908211*^9, 
   3.5877932974144945`*^9}, {3.5877935847545786`*^9, 3.587793629605153*^9}, {
   3.5877937566219816`*^9, 3.587793819896393*^9}, {3.5877941273869734`*^9, 
   3.587794148821258*^9}, {3.587794241532058*^9, 3.587794242795658*^9}, {
   3.587795516530792*^9, 3.5877955364235473`*^9}, {3.587795573754826*^9, 
   3.5877956006339703`*^9}, {3.587795637044837*^9, 3.5877956379340487`*^9}, {
   3.5877956962163963`*^9, 3.587795903221536*^9}, {3.587795941818658*^9, 
   3.5877960429917912`*^9}, {3.5877968613385725`*^9, 
   3.5877968624305935`*^9}, {3.587796897250463*^9, 3.587796918669675*^9}, {
   3.5877970093977995`*^9, 3.5877970142805367`*^9}, {3.5877983496955886`*^9, 
   3.5877983773861213`*^9}, {3.5877984874462376`*^9, 
   3.5877985086988463`*^9}, {3.5877985434875154`*^9, 
   3.5877986496319566`*^9}, {3.5877986802085447`*^9, 
   3.5877987111907406`*^9}, {3.5877987577888365`*^9, 3.587798795291958*^9}, {
   3.5877989014676*^9, 3.5877989556162405`*^9}, 3.587798991933305*^9, 
   3.5877990870933046`*^9, {3.587799148697705*^9, 3.587799153689705*^9}, {
   3.587799230894105*^9, 3.587799275588185*^9}, {3.5877993102674294`*^9, 
   3.587799375211062*^9}, {3.5877994086266904`*^9, 3.5877994331970053`*^9}, {
   3.587799488328112*^9, 3.5877995133352327`*^9}, {3.587799559558625*^9, 
   3.5877996210237446`*^9}, {3.5877996630821533`*^9, 
   3.5877996926759224`*^9}, {3.5877997497418203`*^9, 
   3.5877997844368873`*^9}, {3.587803268993227*^9, 3.58780326952363*^9}, {
   3.5878035742718863`*^9, 3.587803626126951*^9}, {3.587803658497366*^9, 
   3.5878036862969227`*^9}, {3.5878037390411987`*^9, 
   3.5878038323771954`*^9}, {3.587803877726977*^9, 3.5878038873679004`*^9}, {
   3.5878039315632668`*^9, 3.58780395335682*^9}, {3.587804026602106*^9, 
   3.587804111766328*^9}, {3.5878041855360427`*^9, 3.5878042023379965`*^9}, {
   3.5878043071268215`*^9, 3.5878043098256903`*^9}, {3.5878043901053486`*^9, 
   3.5878044368129463`*^9}, {3.5878045842521143`*^9, 
   3.5878046146414986`*^9}, {3.5878048483651934`*^9, 
   3.5878048607517695`*^9}, {3.5878048934965897`*^9, 
   3.5878048961486235`*^9}, {3.5878050224478426`*^9, 
   3.5878050498885946`*^9}, {3.5878052093070383`*^9, 3.587805264937351*^9}, {
   3.587805301660222*^9, 3.587805310677138*^9}, {3.587805361861394*^9, 
   3.5878053689906855`*^9}, {3.5878055296727457`*^9, 3.587805544789339*^9}, {
   3.587805794080535*^9, 3.587805804002262*^9}, {3.5878058650146446`*^9, 
   3.587805876823996*^9}, {3.587805947492902*^9, 3.587805993482306*^9}, {
   3.5878060704702797`*^9, 3.58780608176497*^9}, {3.5878061139953957`*^9, 
   3.5878061506095347`*^9}, {3.5878062353509073`*^9, 3.587806258642305*^9}, 
   3.587806330029252*^9, {3.5878063648332987`*^9, 3.5878064120707045`*^9}, {
   3.5878064791047635`*^9, 3.58780648116399*^9}, {3.5878066553402233`*^9, 
   3.5878067058380704`*^9}, {3.5878069368302317`*^9, 
   3.5878069427427073`*^9}, {3.587808601912856*^9, 3.5878086194473686`*^9}, {
   3.5878086673579483`*^9, 3.5878087309287634`*^9}, {3.587808768244442*^9, 
   3.587808768306843*^9}, {3.5878088856047463`*^9, 3.587808892531235*^9}, {
   3.587809245301908*^9, 3.5878093319626856`*^9}, {3.587809372555168*^9, 
   3.587809429652266*^9}, {3.587809474799534*^9, 3.5878095123962574`*^9}, {
   3.587809546391811*^9, 3.587809601148864*^9}, {3.587809659649989*^9, 
   3.587809760802334*^9}, {3.587809795793807*^9, 3.5878097966362233`*^9}, {
   3.587809844763149*^9, 3.5878098891928034`*^9}, {3.587809927616342*^9, 
   3.587809965306667*^9}, {3.5878100002043514`*^9, 3.587810024010257*^9}, {
   3.5878100680727215`*^9, 3.5878101776329265`*^9}, {3.587810236695284*^9, 
   3.5878102367576847`*^9}, {3.5878103620584908`*^9, 3.5878103651785307`*^9}, 
   3.5878104087498894`*^9, {3.5878104443651457`*^9, 3.587810447095181*^9}, {
   3.587810490838142*^9, 3.58781049381778*^9}, {3.5878106127849054`*^9, 
   3.587810703702871*^9}, {3.587810734170061*^9, 3.587810737664506*^9}, 
   3.5878107874915447`*^9, {3.587810855867222*^9, 3.5878108686437855`*^9}, {
   3.5878109560673065`*^9, 3.5878110237122736`*^9}, {3.5878110641791925`*^9, 
   3.587811082431426*^9}, {3.5878111332725687`*^9, 3.587811213083704*^9}, 
   3.587811278043353*^9, {3.587811528140665*^9, 3.587811534677149*^9}, {
   3.58781157533127*^9, 3.5878115940983105`*^9}, {3.5878116419753246`*^9, 
   3.587811674486141*^9}, {3.5878117639688883`*^9, 3.587811772361796*^9}, {
   3.5878119051468067`*^9, 3.5878119109032803`*^9}, 3.5878121636734953`*^9, {
   3.587812421749258*^9, 3.5878124274433675`*^9}, {3.587812514773345*^9, 
   3.5878125184549923`*^9}, {3.5878125611371393`*^9, 
   3.5878125680168276`*^9}, {3.5878127363298855`*^9, 3.587812744519991*^9}, {
   3.5878127921786013`*^9, 3.5878127925686064`*^9}, {3.5878129364804516`*^9, 
   3.5878129367144547`*^9}, {3.587813679159173*^9, 3.5878136829188213`*^9}, {
   3.5878137439312034`*^9, 3.587813751247697*^9}, {3.587813932199417*^9, 
   3.587813938221094*^9}, {3.5878140394663925`*^9, 3.587814066017933*^9}, {
   3.5878141150025606`*^9, 3.5878141192614155`*^9}, 3.587814533211676*^9, 
   3.587814614240416*^9, 3.587815160109514*^9, {3.587835566704579*^9, 
   3.5878355872654147`*^9}, {3.5878356377939034`*^9, 3.587835661115945*^9}, 
   3.587835712720835*^9, {3.5879024406048117`*^9, 3.5879024731776686`*^9}, {
   3.5879026703308153`*^9, 3.587902670596016*^9}, {3.587902727036915*^9, 
   3.587902728893318*^9}, {3.587904122630967*^9, 3.5879042401615734`*^9}, {
   3.5879043233253193`*^9, 3.587904348737764*^9}, {3.5879043923866405`*^9, 
   3.5879044294367056`*^9}, {3.5879047772105165`*^9, 3.58790477956612*^9}, {
   3.5879060289707174`*^9, 3.587906062697976*^9}, {3.587912763549346*^9, 
   3.587912768900155*^9}, {3.5879631054537663`*^9, 3.587963105671279*^9}, {
   3.5879631413433123`*^9, 3.5879631870053797`*^9}, {3.5879632275556936`*^9, 
   3.5879632487565355`*^9}, {3.587963431167889*^9, 3.5879634498763466`*^9}, 
   3.5879637217857933`*^9, {3.5879671033098555`*^9, 3.5879671070226793`*^9}, {
   3.5880520658604507`*^9, 3.588052073754101*^9}, {3.588052878816923*^9, 
   3.588052917473971*^9}, {3.5880530961892805`*^9, 3.588053102569762*^9}, {
   3.5880613675702457`*^9, 3.5880614877541866`*^9}, {3.5880618231740866`*^9, 
   3.588061895356212*^9}, {3.5880619659315166`*^9, 3.5880621101865664`*^9}, {
   3.5880659320840263`*^9, 3.588065954273861*^9}, {3.5880661276301556`*^9, 
   3.5880661319507737`*^9}, {3.5880662021725197`*^9, 
   3.5880662207340207`*^9}, {3.5883959310520325`*^9, 
   3.5883959649330606`*^9}, {3.5884169892223415`*^9, 
   3.5884169893003426`*^9}, {3.588417096317254*^9, 3.588417097846103*^9}, {
   3.5884223745099525`*^9, 3.5884223991425695`*^9}, {3.588423514769885*^9, 
   3.588423523194209*^9}, {3.58850652962665*^9, 3.5885065612782383`*^9}, {
   3.588506594208994*^9, 3.5885065981712923`*^9}, {3.588574689293651*^9, 
   3.5885747896557293`*^9}, 3.5885748409867926`*^9, {3.5885916010373783`*^9, 
   3.5885916035958114`*^9}, {3.588591649975206*^9, 3.588591652096833*^9}, {
   3.5887651733636255`*^9, 3.588765276589007*^9}, {3.5887653084442625`*^9, 
   3.5887653264934945`*^9}, {3.5887653743543787`*^9, 3.588765390079206*^9}, {
   3.5887654251636677`*^9, 3.5887654307172775`*^9}, {3.588765708881366*^9, 
   3.588765738552618*^9}, {3.588765776741485*^9, 3.588765785851901*^9}, {
   3.588765907454115*^9, 3.58876591611213*^9}, {3.5887659487785873`*^9, 
   3.588765975626234*^9}, {3.5887660822056217`*^9, 3.5887660895844345`*^9}, 
   3.588766292884393*^9, {3.5887683396171865`*^9, 3.588768396760087*^9}, 
   3.5887685178163*^9, 3.5887687368094845`*^9, 3.58876887089172*^9, {
   3.5887707930774965`*^9, 3.588770899937684*^9}, {3.5887709969542546`*^9, 
   3.5887710071566725`*^9}, {3.5887712473970947`*^9, 
   3.5887713305140405`*^9}, {3.5887726524603624`*^9, 
   3.5887726749556017`*^9}, {3.588773313433523*^9, 3.588773331857156*^9}, {
   3.5887733642740126`*^9, 3.5887733716684256`*^9}, {3.5887737324658594`*^9, 
   3.5887737462718835`*^9}, {3.588774328995307*^9, 3.588774357356157*^9}, 
   3.5887746721023097`*^9, {3.5887750984822583`*^9, 3.5887751053462706`*^9}, {
   3.5887752221280756`*^9, 3.5887752279936857`*^9}, {3.5887758270503383`*^9, 
   3.5887758670644083`*^9}, {3.588776007480255*^9, 3.5887760114426622`*^9}, {
   3.5887762078938074`*^9, 3.588776222776233*^9}, {3.5887763803365097`*^9, 
   3.5887763919273305`*^9}, {3.588776924044265*^9, 3.588776931610278*^9}, 
   3.5887771491526604`*^9, {3.588777256730449*^9, 3.58877725715165*^9}, {
   3.5887774919632626`*^9, 3.5887775202305117`*^9}, {3.588777581070619*^9, 
   3.5887775826774216`*^9}, 3.588866936929682*^9, {3.589107016606743*^9, 
   3.589107102877862*^9}, {3.5891071703767366`*^9, 3.5891071773176265`*^9}, {
   3.589107297854488*^9, 3.589107297948089*^9}, 3.5891076397475667`*^9, {
   3.5891077741004763`*^9, 3.5891077742096777`*^9}, {3.58912893000684*^9, 
   3.589128970301711*^9}, 3.5891290644322767`*^9, {3.5891292196837487`*^9, 
   3.5891292216025524`*^9}, {3.5891292758438473`*^9, 3.589129307433903*^9}, 
   3.589129637592883*^9, 3.5892603358410215`*^9, {3.5892811145043325`*^9, 
   3.589281119028391*^9}, {3.5892889418725014`*^9, 3.5892889422313023`*^9}, {
   3.5892889757245607`*^9, 3.5892889793125668`*^9}, {3.5892891196660137`*^9, 
   3.589289130242832*^9}, 3.589289262468664*^9, {3.589289295493922*^9, 
   3.5892893756156635`*^9}, {3.5892907770917253`*^9, 3.589290834453026*^9}, {
   3.589291378223181*^9, 3.589291441543692*^9}, {3.5892924799035163`*^9, 
   3.589292496174345*^9}, {3.5892925478416357`*^9, 3.5892925580128536`*^9}, {
   3.589292922133093*^9, 3.5892929227258945`*^9}, 3.589292968059574*^9, 
   3.58929314235868*^9, {3.589293247144064*^9, 3.5892932501860695`*^9}, {
   3.589293495948901*^9, 3.589293534636969*^9}, 3.5892938227538753`*^9, {
   3.5892938832039814`*^9, 3.589293893265999*^9}, {3.589294786507968*^9, 
   3.5892947931379795`*^9}, {3.5892948463496733`*^9, 
   3.5892948495320787`*^9}, {3.5892949277974157`*^9, 3.589294930527421*^9}, {
   3.589295186976271*^9, 3.589295303617676*^9}, 3.589295342290144*^9, {
   3.5892956434018726`*^9, 3.589295660483903*^9}, {3.589295987678878*^9, 
   3.589295997413295*^9}, {3.589296374965158*^9, 3.589296462871312*^9}, {
   3.589296499812177*^9, 3.589296517253008*^9}, {3.5892983493202257`*^9, 
   3.5892984773964505`*^9}, {3.589298722301281*^9, 3.589298831766673*^9}, {
   3.5892988622959266`*^9, 3.58929888719357*^9}, {3.589298930530446*^9, 
   3.589298945381673*^9}, {3.589298990060151*^9, 3.5892990905867276`*^9}, {
   3.589299168711665*^9, 3.5892991987417173`*^9}, {3.589299229614172*^9, 
   3.589299230409773*^9}, {3.5892993648664093`*^9, 3.5892993719176216`*^9}, {
   3.5892994845186195`*^9, 3.589299493051834*^9}, {3.5892995653111615`*^9, 
   3.5892996986445956`*^9}, {3.589299749984286*^9, 3.589299757066698*^9}, {
   3.589301487874138*^9, 3.589301548230644*^9}, {3.5893021399240837`*^9, 
   3.589302188596169*^9}, {3.5893718321961565`*^9, 3.5893718499021873`*^9}, {
   3.5893721128371863`*^9, 3.589372114427189*^9}, {3.589372156097247*^9, 
   3.5893723813675623`*^9}, {3.589372435207638*^9, 3.589372524587763*^9}, {
   3.5893725698278265`*^9, 3.589372695848003*^9}, 3.5893727305780516`*^9, {
   3.589372780948122*^9, 3.589372780998122*^9}, {3.589372846418214*^9, 
   3.5893728521482215`*^9}, {3.589372910608303*^9, 3.5893729628583765`*^9}, {
   3.5893730340584764`*^9, 3.589373056128507*^9}, {3.589374434642937*^9, 
   3.589374435242938*^9}, {3.589374836795504*^9, 3.5893748370055046`*^9}, {
   3.5893752022460155`*^9, 3.589375203896018*^9}, {3.5893752407360697`*^9, 
   3.589375273946116*^9}, {3.5893754291363335`*^9, 3.58937549831643*^9}, {
   3.5893756769166803`*^9, 3.589375678156682*^9}, {3.5893757922968416`*^9, 
   3.589375798786851*^9}, 3.58937662701801*^9, {3.5893782045402193`*^9, 
   3.589378294810345*^9}, {3.58937832654039*^9, 3.5893783441704144`*^9}, {
   3.589463653687679*^9, 3.589463736102624*^9}, {3.589523684096339*^9, 
   3.5895237250624647`*^9}, {3.5895239073664017`*^9, 3.589523907678406*^9}, {
   3.5895250533298845`*^9, 3.5895250672764025`*^9}, {3.5895251136242995`*^9, 
   3.589525119739539*^9}, {3.589525161875409*^9, 3.589525315895196*^9}, {
   3.5895253755811787`*^9, 3.5895253760803823`*^9}, {3.589525513736965*^9, 
   3.5895255218696175`*^9}, {3.58952560645336*^9, 3.5895256068433623`*^9}, {
   3.589525659197298*^9, 3.589525661740114*^9}, {3.589525922027783*^9, 
   3.589525931075841*^9}, {3.5895260481857915`*^9, 3.5895260786683865`*^9}, {
   3.5895261225539684`*^9, 3.589526131368025*^9}, {3.589526209462149*^9, 
   3.589526217106247*^9}, {3.589526258805582*^9, 3.589526259023985*^9}, {
   3.5895264676941605`*^9, 3.589526517411923*^9}, {3.5895267029595127`*^9, 
   3.5895267808508115`*^9}, {3.589527318355928*^9, 3.5895273417875786`*^9}, {
   3.5895274252335835`*^9, 3.5895274347497663`*^9}, {3.589527504685911*^9, 
   3.589527505091519*^9}, {3.5895286934194736`*^9, 3.5895287426221886`*^9}, {
   3.589528817081466*^9, 3.589528835739186*^9}, {3.589529369049808*^9, 
   3.589529383168803*^9}, 3.5895294176316333`*^9, {3.58952949190847*^9, 
   3.589529529897149*^9}, {3.5895296079662895`*^9, 3.5895296223187494`*^9}, {
   3.589529670617897*^9, 3.5895296755788565`*^9}, {3.5895304661384635`*^9, 
   3.5895304695704856`*^9}, {3.5895305302704744`*^9, 3.5895305325324893`*^9}, 
   3.589530774802042*^9, {3.589534053290185*^9, 3.589534053648988*^9}, {
   3.5895341036005077`*^9, 3.589534181055004*^9}, {3.589544123277646*^9, 
   3.5895441607704716`*^9}, {3.58954419594495*^9, 3.589544198115892*^9}, {
   3.5896220065784416`*^9, 3.5896220579830484`*^9}, {3.589622151431685*^9, 
   3.5896221740135345`*^9}, {3.5896222063579793`*^9, 
   3.5896222394198036`*^9}, {3.58962352749885*^9, 3.5896235958420935`*^9}, {
   3.5898666597335205`*^9, 3.5898666730560913`*^9}, {3.5903176850820627`*^9, 
   3.590317724113331*^9}, {3.5903285466191435`*^9, 3.5903285480231466`*^9}, {
   3.5903297382504377`*^9, 3.5903297426964455`*^9}, {3.590331786144035*^9, 
   3.5903318299489117`*^9}, {3.591023158719961*^9, 3.5910231737115874`*^9}, {
   3.5910232094980507`*^9, 3.5910232383893013`*^9}, {3.5910233814571524`*^9, 
   3.591023394904376*^9}, {3.5910234754785175`*^9, 3.5910234917181463`*^9}, {
   3.5910236931769*^9, 3.591023725016556*^9}, {3.5922369526603775`*^9, 
   3.5922369603979907`*^9}, {3.5922370308789144`*^9, 3.592237147223919*^9}, {
   3.5922372307464657`*^9, 3.592237363034698*^9}, {3.5922374236720047`*^9, 
   3.592237424124405*^9}, 3.5922382981003404`*^9, {3.6013086751482744`*^9, 
   3.601308697565514*^9}, {3.601308728157968*^9, 3.601308784489667*^9}, {
   3.601308976713205*^9, 3.601308992516032*^9}, {3.6013090539801407`*^9, 
   3.6013091959091897`*^9}, {3.60130927592173*^9, 3.6013092786049347`*^9}, {
   3.601309333407831*^9, 3.6013093733907013`*^9}, {3.6013094139039726`*^9, 
   3.6013095655206385`*^9}, {3.6013097434701514`*^9, 3.601309758165377*^9}, {
   3.6013099756297593`*^9, 3.6013099871269794`*^9}, {3.601310077061137*^9, 
   3.6013100781063395`*^9}, 3.601310133158836*^9, {3.6013101855125275`*^9, 
   3.6013102012217555`*^9}, {3.601310241781827*^9, 3.6013102467426357`*^9}, {
   3.6013103042131367`*^9, 3.6013103077075424`*^9}, 3.601313164925331*^9, {
   3.6013132213194304`*^9, 3.601313224236635*^9}, {3.6013133200832033`*^9, 
   3.601313421015381*^9}, {3.6013594166244936`*^9, 3.60135942692056*^9}, {
   3.601454641417448*^9, 3.6014546935839396`*^9}, {3.6015553714617434`*^9, 
   3.601555376999753*^9}, {3.601555757562422*^9, 3.601555763443632*^9}, {
   3.601555863159007*^9, 3.601555863783008*^9}, {3.601556751625367*^9, 
   3.6015567519061675`*^9}, {3.608388264250212*^9, 3.608388267651018*^9}, {
   3.6083924630810385`*^9, 3.6083924649421453`*^9}, {3.6083952771589947`*^9, 
   3.60839531203699*^9}, 3.60839791288575*^9, {3.6083980212519484`*^9, 
   3.608398033924673*^9}, {3.6083982320900073`*^9, 3.608398241381539*^9}, {
   3.608398351604843*^9, 3.6083983727990556`*^9}, {3.6084529334433928`*^9, 
   3.6084529649029713`*^9}, {3.608453048161261*^9, 3.6084530838785424`*^9}, {
   3.608454479599946*^9, 3.608454505282514*^9}, {3.6084560163252153`*^9, 
   3.6084561026812153`*^9}, {3.6084561875262156`*^9, 
   3.6084562685262156`*^9}, {3.608456416864215*^9, 3.6084564201942153`*^9}, {
   3.6084564985802155`*^9, 3.608456503397215*^9}, {3.6084566538573647`*^9, 
   3.6084566545674353`*^9}, {3.6084644420659275`*^9, 3.608464474442165*^9}, {
   3.608525319266219*^9, 3.6085253665713444`*^9}, {3.6085254062575703`*^9, 
   3.6085254066792326`*^9}, {3.6085317044602475`*^9, 3.608531716908492*^9}, {
   3.6085614158341885`*^9, 3.6085614185033407`*^9}, {3.608562284888895*^9, 
   3.608562308454243*^9}, {3.6085728484947276`*^9, 3.6085728580352736`*^9}, 
   3.608578462093807*^9, {3.608578647762427*^9, 3.6085786695816746`*^9}, {
   3.608578765732174*^9, 3.60857877369763*^9}, 3.608578963796503*^9, {
   3.608826772395772*^9, 3.6088267795261803`*^9}, {3.608826829937063*^9, 
   3.6088268304810944`*^9}, {3.6088269690750217`*^9, 3.6088269694050407`*^9}, 
   3.6088270130465364`*^9, {3.608830362539117*^9, 3.60883045719153*^9}, {
   3.6089191976259513`*^9, 3.608919204840364*^9}, 3.608969394766054*^9, 
   3.608969488257403*^9, {3.608969520054582*^9, 3.608969548615438*^9}, {
   3.608969718032378*^9, 3.6089697268232565`*^9}, {3.6112957752379103`*^9, 
   3.611295816705057*^9}, {3.6195196556704164`*^9, 3.619519659831416*^9}, {
   3.6196302594717865`*^9, 3.6196303031362634`*^9}, {3.61963198614522*^9, 
   3.619632002104048*^9}, 3.619632057000544*^9, {3.6196321893043766`*^9, 
   3.6196321900999775`*^9}, {3.6196921641516724`*^9, 
   3.6196921878632164`*^9}, {3.619692341444208*^9, 3.619692344423789*^9}, {
   3.6203790815333433`*^9, 3.6203791698831778`*^9}, {3.62037920080427*^9, 
   3.6203794010592933`*^9}, {3.620713972818327*^9, 3.62071397622268*^9}, {
   3.620714010547308*^9, 3.6207140445706053`*^9}, {3.6207140764844666`*^9, 
   3.620714087595796*^9}, 3.620714381516427*^9, {3.62071507900896*^9, 
   3.620715145761788*^9}, {3.620715278709347*^9, 3.6207153016419325`*^9}, {
   3.620715712433051*^9, 3.6207157198097887`*^9}, {3.6207159524430494`*^9, 
   3.620716023287133*^9}, {3.6207165820184116`*^9, 3.6207165887874117`*^9}, {
   3.6207268944424043`*^9, 3.620726931286088*^9}, {3.620726990059965*^9, 
   3.6207270607740355`*^9}, {3.620727118171775*^9, 3.620727129290887*^9}, {
   3.6207287559757566`*^9, 3.6207288427684345`*^9}, {3.6207307433670716`*^9, 
   3.620730865239258*^9}, {3.6208134341232347`*^9, 3.620813440550435*^9}, {
   3.620816905932535*^9, 3.6208169864441347`*^9}, {3.620817865160935*^9, 
   3.620817974314135*^9}, {3.620819565914135*^9, 3.6208195664445353`*^9}, {
   3.620821845919735*^9, 3.620821890738535*^9}, {3.620821942795735*^9, 
   3.620821951079335*^9}, 3.620822015101735*^9, 3.620824376545735*^9, {
   3.620824773833435*^9, 3.620824780681835*^9}, {3.620825652168735*^9, 
   3.620825676832335*^9}, {3.6208865265516596`*^9, 3.6208865334780717`*^9}, {
   3.6208865823979716`*^9, 3.6208865872922516`*^9}, {3.620886646374631*^9, 
   3.6208866553911467`*^9}, {3.6208877334028053`*^9, 3.620887736585987*^9}, {
   3.620888199924489*^9, 3.6208882050637827`*^9}, {3.6208883519191823`*^9, 
   3.620888413397699*^9}, {3.6208884435574236`*^9, 3.620888456794181*^9}, {
   3.6208884894300475`*^9, 3.6208885366027455`*^9}, {3.620888687493376*^9, 
   3.620888688940459*^9}, {3.6208892826204157`*^9, 3.620889350137277*^9}, {
   3.620889392001672*^9, 3.6208894213533506`*^9}, {3.6208927430793424`*^9, 
   3.6208927456124873`*^9}, 3.6208927900570292`*^9, {3.6208929158922267`*^9, 
   3.6208929173773117`*^9}, {3.6209048502084503`*^9, 3.620904874792856*^9}, 
   3.620904957777603*^9, {3.6209050137118025`*^9, 3.6209050552291765`*^9}, {
   3.6209052268749943`*^9, 3.620905231561262*^9}, 3.6209053948115997`*^9, {
   3.620905484563733*^9, 3.6209054908790946`*^9}, {3.620906765534999*^9, 
   3.6209068097285266`*^9}, {3.620907130670883*^9, 3.6209071318089485`*^9}, {
   3.6209071706241684`*^9, 3.620907199025793*^9}, 3.620907470086297*^9, {
   3.6212300650800653`*^9, 3.6212300860890656`*^9}, {3.6212321361156654`*^9, 
   3.621232137253665*^9}, 3.621232169848665*^9, {3.6212325565096655`*^9, 
   3.6212326192146654`*^9}, {3.6212327352076654`*^9, 3.621232783599665*^9}, {
   3.621232860187665*^9, 3.621232889036665*^9}, 3.6212329853706656`*^9, {
   3.6212330276896653`*^9, 3.6212330726706653`*^9}, {3.6212333590028653`*^9, 
   3.6212333691908655`*^9}, {3.6212334321218653`*^9, 
   3.6212334455498652`*^9}, {3.621233495132865*^9, 3.621233496925865*^9}, {
   3.621242449595748*^9, 3.621242526826748*^9}, {3.621242588006748*^9, 
   3.621242600243748*^9}, {3.621242650290748*^9, 3.621242662920748*^9}, {
   3.6212428844177485`*^9, 3.6212428845637484`*^9}, {3.6212432431172485`*^9, 
   3.621243338971248*^9}, 3.621245713686448*^9, {3.621245763580448*^9, 
   3.621245764195448*^9}, 3.621246384235448*^9, {3.6212616207474327`*^9, 
   3.6212616458829455`*^9}, {3.6212616931356707`*^9, 3.621261707663123*^9}, {
   3.621261767781134*^9, 3.621261770258382*^9}, {3.62126224448542*^9, 
   3.62126227993042*^9}, {3.62126273356242*^9, 3.62126276944342*^9}, {
   3.62126286555842*^9, 3.6212629176184196`*^9}, 3.6212629829784203`*^9, 
   3.6212642541625695`*^9, 3.621264372210373*^9, {3.6212651487952037`*^9, 
   3.6212651651618404`*^9}, {3.6212652155148754`*^9, 
   3.6212652183541594`*^9}, {3.621266475258376*^9, 3.621266486483376*^9}, {
   3.621269017096332*^9, 3.6212690374023323`*^9}, {3.6213186799642735`*^9, 
   3.6213187228642387`*^9}, 3.6213203610739374`*^9, {3.621340169162577*^9, 
   3.62134024759157*^9}, {3.621362576483272*^9, 3.621362674389044*^9}, {
   3.621362863289776*^9, 3.6213628965958347`*^9}, {3.621363002800821*^9, 
   3.621363005421625*^9}, {3.6213630796309557`*^9, 3.6213631282250414`*^9}, 
   3.621363159612296*^9, 3.6213632020443707`*^9, {3.621363451707209*^9, 
   3.6213634683368387`*^9}, {3.621363542093768*^9, 3.621363597739066*^9}, {
   3.621363644507948*^9, 3.6213637034760513`*^9}, 3.62136373679771*^9, {
   3.6213637974974165`*^9, 3.6213638032850266`*^9}, 3.6213638394770904`*^9, {
   3.6213639056368065`*^9, 3.6213639074308095`*^9}, {3.6213653744261866`*^9, 
   3.6213654022410355`*^9}, {3.6213660092069016`*^9, 3.62136603667855*^9}, 
   3.6213665138053875`*^9, {3.6213668593147945`*^9, 3.621366871124015*^9}, {
   3.621366913166089*^9, 3.6213669147104917`*^9}, 3.6214298706438255`*^9, {
   3.6224834311022468`*^9, 3.622483441616665*^9}, {3.6224849534540205`*^9, 
   3.6224849562308254`*^9}, {3.6224849953556943`*^9, 3.622485028692953*^9}, {
   3.622485110031496*^9, 3.622485110827097*^9}, {3.622485209684471*^9, 
   3.6224852186544867`*^9}, 3.6225735567375813`*^9, {3.62257365866816*^9, 
   3.6225737226750727`*^9}, {3.622575203117673*^9, 3.622575235238129*^9}, {
   3.622576160210554*^9, 3.622576172128975*^9}, {3.62257624938031*^9, 
   3.6225763024672036`*^9}, {3.6225763979705715`*^9, 
   3.6225763984385724`*^9}, {3.622576491726736*^9, 3.622576543128826*^9}, 
   3.6225765830492964`*^9, {3.6225766955878944`*^9, 3.622576697787498*^9}, {
   3.622618017507019*^9, 3.622618081264331*^9}, {3.6226181431028395`*^9, 
   3.6226181506532526`*^9}, {3.6226183660428314`*^9, 
   3.6226184118913116`*^9}, {3.622619280484439*^9, 3.6226192809524393`*^9}, {
   3.622619720795212*^9, 3.622619749733263*^9}, {3.622619886061902*^9, 
   3.622619910522745*^9}, 3.622619962564437*^9, {3.6226201219967165`*^9, 
   3.622620142635553*^9}, {3.6226201728216057`*^9, 3.6226201743036084`*^9}, {
   3.6226202094816704`*^9, 3.6226202329129114`*^9}, {3.6226202635201654`*^9, 
   3.622620270727378*^9}, {3.6226205772523165`*^9, 3.622620592680743*^9}, {
   3.622620893433672*^9, 3.6226208980824795`*^9}, {3.6226211934377985`*^9, 
   3.622621201019412*^9}, 3.6226213283156357`*^9, {3.622621415909789*^9, 
   3.6226214207769976`*^9}, {3.622621497981533*^9, 3.6226215117719574`*^9}, {
   3.622621914549065*^9, 3.622622009459632*^9}, {3.6226222518060575`*^9, 
   3.6226222728036947`*^9}, {3.6226228856039705`*^9, 
   3.6226229356956587`*^9}, {3.622623015754999*^9, 3.6226230318698273`*^9}, {
   3.622623502709854*^9, 3.622623565468765*^9}, {3.62262359685602*^9, 
   3.622623620521261*^9}, {3.622998572422287*^9, 3.622998684165283*^9}, {
   3.6229987322289677`*^9, 3.6229987461129923`*^9}, {3.6229988217731247`*^9, 
   3.6229988317727423`*^9}, {3.622998953936557*^9, 3.622998964341775*^9}, 
   3.6229990605159445`*^9, {3.6229993834833117`*^9, 3.6229993903629236`*^9}, {
   3.6229995210287533`*^9, 3.622999556456415*^9}, 3.6229996029600973`*^9, {
   3.62299974708875*^9, 3.62299975850797*^9}, {3.622999789630025*^9, 
   3.622999897878615*^9}, {3.6229999359738817`*^9, 3.623000082270939*^9}, {
   3.623000191439931*^9, 3.623000194450736*^9}, {3.6230002912177057`*^9, 
   3.6230003725094485`*^9}, {3.623000585621423*^9, 3.623000681608392*^9}, {
   3.623000766768941*^9, 3.6230007703881474`*^9}, {3.6230009081186733`*^9, 
   3.623000919712336*^9}, {3.623001164739351*^9, 3.623001178936163*^9}, {
   3.6230013124848013`*^9, 3.623001322123353*^9}, {3.6230016546383715`*^9, 
   3.623001662080797*^9}, 3.623001695786725*^9, {3.623001732084801*^9, 
   3.623001758582317*^9}, {3.623001807691126*^9, 3.6230018236890407`*^9}, {
   3.6230052637720003`*^9, 3.6230052886374226`*^9}, {3.6230055423399334`*^9, 
   3.623005555440683*^9}, {3.6230057111165867`*^9, 3.6230057249743795`*^9}, {
   3.6230057748232307`*^9, 3.6230058608343487`*^9}, {3.623005957836897*^9, 
   3.6230059760199366`*^9}, 3.623235911167398*^9, {3.623241926390318*^9, 
   3.6232419282368765`*^9}, 3.6232420348834486`*^9, {3.623242302209396*^9, 
   3.62324235763589*^9}, {3.623242463494093*^9, 3.623242490356666*^9}, {
   3.6232425251952844`*^9, 3.6232425253513713`*^9}, {3.6232427083536887`*^9, 
   3.6232427418843207`*^9}, {3.623242835782573*^9, 3.6232428384506693`*^9}, {
   3.62324307825863*^9, 3.623243080427141*^9}, 3.62324320612239*^9, {
   3.6232456655689974`*^9, 3.6232456664425974`*^9}, {3.623245712774597*^9, 
   3.6232457654713974`*^9}, {3.6232457986525974`*^9, 
   3.6232458158125973`*^9}, {3.6232458828613977`*^9, 
   3.6232459879273977`*^9}, {3.6232460852713976`*^9, 
   3.6232460950369973`*^9}, {3.623246549150017*^9, 3.6232465543915157`*^9}, {
   3.623246604544551*^9, 3.6232466061513205`*^9}, {3.623246808777293*^9, 
   3.623246963933899*^9}, {3.6232470685161047`*^9, 3.623247076581305*^9}, 
   3.623247127218905*^9, 3.6232471686057053`*^9, {3.623247273359705*^9, 
   3.623247290519705*^9}, {3.623247396147305*^9, 3.623247412340105*^9}, 
   3.623247460901728*^9, 3.62324761945366*^9, {3.6232476771409807`*^9, 
   3.623247687889105*^9}, {3.62324792293361*^9, 3.6232479722920103`*^9}, {
   3.6232480662976103`*^9, 3.6232480723660097`*^9}, {3.62324810604641*^9, 
   3.6232481828608103`*^9}, {3.62324835332201*^9, 3.62324837823521*^9}, 
   3.62324843129081*^9, 3.6232591663369884`*^9, {3.6233207283486986`*^9, 
   3.623320730283102*^9}, 3.6233327465082207`*^9, {3.6233328123483367`*^9, 
   3.623332843111591*^9}, {3.623749647714127*^9, 3.6237496629176474`*^9}, 
   3.623749799817336*^9, {3.6237498370450583`*^9, 3.6237498448578396`*^9}, {
   3.6237499890452566`*^9, 3.6237500174811*^9}, {3.6237609202735033`*^9, 
   3.623760928251301*^9}, {3.6237618935438204`*^9, 3.6237618952149878`*^9}, {
   3.623762759765131*^9, 3.6237627642215767`*^9}, {3.6237637202123613`*^9, 
   3.623763774452651*^9}, {3.6239210894700165`*^9, 3.6239210914431295`*^9}, {
   3.624011620928132*^9, 3.624011635594599*^9}, {3.62401174451849*^9, 
   3.6240117706190996`*^9}, {3.6240841900396094`*^9, 
   3.6240842328460093`*^9}, {3.6240843013456097`*^9, 3.6240843140752096`*^9}, 
   3.624084488951209*^9, {3.62410109037753*^9, 3.6241010919766903`*^9}, {
   3.6241243771636033`*^9, 3.624124385821618*^9}, 3.624124430047696*^9, 
   3.624124505037028*^9, {3.624125040227168*^9, 3.624125075296029*^9}, {
   3.6241262913015666`*^9, 3.624126291426367*^9}, {3.624126334778843*^9, 
   3.6241263390220504`*^9}, {3.6241793829474835`*^9, 
   3.6241793907419295`*^9}, {3.62418182343827*^9, 3.6241818387111435`*^9}, {
   3.636958684046238*^9, 3.636958685732238*^9}, {3.636958716413238*^9, 
   3.636958736685238*^9}, {3.670749685177288*^9, 3.6707497213972883`*^9}, {
   3.670749775927288*^9, 3.670749813427288*^9}, {3.670752680650652*^9, 
   3.6707526892906523`*^9}, {3.670752746940652*^9, 3.670752752450652*^9}, {
   3.6707543824911766`*^9, 3.6707543869811764`*^9}, {3.670827735862714*^9, 
   3.670827821282714*^9}, {3.6913241634302564`*^9, 3.691324166828277*^9}, 
   3.7012613967266984`*^9, {3.7012616706512923`*^9, 3.701261672518311*^9}, {
   3.7181138639009085`*^9, 3.718113889074072*^9}, 3.7181140840179715`*^9, {
   3.7181153121293507`*^9, 3.718115323051382*^9}, {3.7181156901969643`*^9, 
   3.71811569243498*^9}, {3.7181163275233974`*^9, 3.7181163411534805`*^9}, {
   3.7204465340055227`*^9, 3.7204465532726245`*^9}, {3.7204495937315283`*^9, 
   3.720449610407482*^9}, 3.720522359694775*^9, {3.7206989339558067`*^9, 
   3.720699065818349*^9}, {3.720699357024005*^9, 3.720699402198589*^9}, 
   3.7206995437406845`*^9, 3.7207017912902365`*^9, {3.720702036954288*^9, 
   3.7207020431536427`*^9}, {3.720702125374346*^9, 3.72070216077137*^9}, {
   3.720702474404309*^9, 3.720702497399624*^9}, {3.720702554203873*^9, 
   3.7207025921450434`*^9}, {3.720702724739627*^9, 3.7207027263917217`*^9}, {
   3.7207027590275884`*^9, 3.720702760570677*^9}, {3.7207028305556793`*^9, 
   3.7207028694979067`*^9}, {3.7207029564288793`*^9, 3.720702957929965*^9}, {
   3.7207042573642883`*^9, 3.7207043247561426`*^9}, {3.7213936355330353`*^9, 
   3.72139364279805*^9}, {3.7213961870000615`*^9, 3.7213961906251354`*^9}, {
   3.7213969935300074`*^9, 3.721397016697547*^9}, {3.7220024253182726`*^9, 
   3.7220025059402514`*^9}, {3.7220029090903497`*^9, 3.722002978659749*^9}, {
   3.722003288684497*^9, 3.722003288838673*^9}, {3.7220036758654566`*^9, 
   3.722003680459306*^9}, 3.7220037265666265`*^9, 3.7220149856374807`*^9, {
   3.7220150232276306`*^9, 3.7220150278288937`*^9}, {3.722015074150543*^9, 
   3.7220150752456055`*^9}, {3.722015206568117*^9, 3.7220153927457657`*^9}, {
   3.7220154667309976`*^9, 3.722015477105591*^9}, {3.722015607767064*^9, 
   3.7220156245460243`*^9}, {3.7220157131630926`*^9, 3.72201573881656*^9}, {
   3.7220170450212708`*^9, 3.722017121292633*^9}, {3.7220171695673943`*^9, 
   3.7220171733886127`*^9}, {3.7220173330207434`*^9, 3.722017440211874*^9}, {
   3.7220176425544477`*^9, 3.722017678320493*^9}, {3.722017738303924*^9, 
   3.7220177566309724`*^9}, 3.7220178200465994`*^9, {3.722017901744272*^9, 
   3.7220180082203627`*^9}, {3.7220180623804603`*^9, 3.722018099662593*^9}, 
   3.7220764268884654`*^9, {3.726235178857644*^9, 3.726235180831784*^9}, {
   3.7262368830710588`*^9, 3.726236885476204*^9}, {3.7262922639355927`*^9, 
   3.726292282365303*^9}, {3.7262923207545*^9, 3.726292327505996*^9}, {
   3.7262923750289*^9, 3.7262924087402425`*^9}, 3.7265644458082714`*^9, {
   3.7265652103741055`*^9, 3.7265652160653515`*^9}, {3.7265655945964317`*^9, 
   3.7265656548889055`*^9}, {3.726565685285125*^9, 3.726565692934935*^9}, 
   3.726565756098983*^9, {3.726565837963772*^9, 3.7265658537863193`*^9}, 
   3.726565950761439*^9, {3.7265664887990894`*^9, 3.726566491410283*^9}, {
   3.7265686667582903`*^9, 3.726568668045739*^9}, {3.727084277116455*^9, 
   3.7270842946239495`*^9}, {3.7270844068230395`*^9, 3.727084415596337*^9}, {
   3.727787394308074*^9, 3.7277873950411797`*^9}, {3.728380483795041*^9, 
   3.7283805101055946`*^9}, {3.728380598544202*^9, 3.728380601118743*^9}, {
   3.72838939896944*^9, 3.728389412667265*^9}, {3.728389760996008*^9, 
   3.7283898042992363`*^9}, {3.728389899483177*^9, 3.728389902990821*^9}, {
   3.7283907455207186`*^9, 3.7283907494291363`*^9}, {3.7288196368914957`*^9, 
   3.728819652348536*^9}, {3.728819739632059*^9, 3.7288197455580997`*^9}, {
   3.7288224196986637`*^9, 3.728822536623413*^9}, {3.7288225933377504`*^9, 
   3.728822623995948*^9}, {3.728822684881328*^9, 3.728822688367365*^9}, 
   3.728822726622579*^9, {3.728823056788438*^9, 3.7288230742285423`*^9}, {
   3.7288231335258827`*^9, 3.7288232950908117`*^9}, {3.7288234005934086`*^9, 
   3.72882340748845*^9}, {3.728823573696478*^9, 3.7288235811585045`*^9}, {
   3.728823706642223*^9, 3.7288237111242447`*^9}, {3.7288238383480005`*^9, 
   3.7288238854202585`*^9}, {3.7288239520266266`*^9, 3.728823953528644*^9}, {
   3.728824316022807*^9, 3.728824320397829*^9}, {3.728824795446515*^9, 
   3.7288247983735323`*^9}, {3.728824911357175*^9, 3.728824922133222*^9}, {
   3.7288249648574753`*^9, 3.728825005698677*^9}, {3.7288252973454485`*^9, 
   3.7288253019874716`*^9}, {3.7288254273692102`*^9, 3.728825482260559*^9}, {
   3.728892989790204*^9, 3.7288929942062845`*^9}, {3.7288930902859073`*^9, 
   3.728893104022334*^9}, {3.729232087262964*^9, 3.729232105507456*^9}, {
   3.729232162993438*^9, 3.7292322262633324`*^9}, {3.72923242985833*^9, 
   3.7292324345693507`*^9}, {3.729232540338478*^9, 3.729232584432646*^9}, {
   3.729232644131674*^9, 3.729232660858854*^9}, {3.729232759974152*^9, 
   3.7292327713015594`*^9}, 3.7292329035088477`*^9, {3.7292331067804327`*^9, 
   3.729233146373388*^9}, {3.729233220562092*^9, 3.729233288028865*^9}, {
   3.729233380929598*^9, 3.7292334535358596`*^9}, 3.729233499645751*^9, {
   3.729233534253166*^9, 3.7292335575442924`*^9}, {3.7292350219255815`*^9, 
   3.7292350273050966`*^9}, {3.7292352450537386`*^9, 
   3.7292352516058736`*^9}, {3.729235473848155*^9, 3.729235477621795*^9}, {
   3.729235583120895*^9, 3.729235613880819*^9}, {3.729235663118092*^9, 
   3.729235697893244*^9}, 3.729235779506962*^9, 3.729235870790373*^9, {
   3.7292360689401426`*^9, 3.729236073051221*^9}, {3.729236123859091*^9, 
   3.7292361336041574`*^9}, {3.7292364386357327`*^9, 3.729236516820588*^9}, {
   3.7292368612593956`*^9, 3.729236869949583*^9}, {3.7292583119100904`*^9, 
   3.729258336014698*^9}, {3.7293166691385*^9, 3.7293166955353947`*^9}, {
   3.7293260042032003`*^9, 3.7293261602660365`*^9}, {3.729341100999133*^9, 
   3.7293411061812086`*^9}, {3.729341136497311*^9, 3.7293412425952773`*^9}, {
   3.729348145217677*^9, 3.7293482152458687`*^9}, {3.7294039797110925`*^9, 
   3.729404037332333*^9}, {3.729404122079891*^9, 3.7294041228442183`*^9}, 
   3.7294051777811537`*^9, {3.7294072903919*^9, 3.729407291293962*^9}, 
   3.729412848321061*^9, {3.729414510430237*^9, 3.7294145107625127`*^9}, {
   3.729414561806944*^9, 3.729414616145782*^9}, {3.7294146759206214`*^9, 
   3.7294147121755953`*^9}, {3.7294148418080435`*^9, 
   3.7294148573318677`*^9}, {3.729500544960293*^9, 3.7295005488694754`*^9}, {
   3.7295006246290283`*^9, 3.729500629641511*^9}, {3.7295007092830315`*^9, 
   3.7295007954872665`*^9}, {3.7295008292154503`*^9, 3.729500841466454*^9}, {
   3.7296652918353915`*^9, 3.729665292374709*^9}, {3.7296901042314415`*^9, 
   3.7296901216420836`*^9}, {3.7298322575668774`*^9, 
   3.7298323043661375`*^9}, {3.729832404203791*^9, 3.729832496910512*^9}, 
   3.7298328321347504`*^9, {3.729832950211988*^9, 3.7298329506444864`*^9}, {
   3.729832987372317*^9, 3.729833001284584*^9}, {3.7298331046478515`*^9, 
   3.729833123765126*^9}, {3.729833376068478*^9, 3.729833376537726*^9}, {
   3.7298334425540113`*^9, 3.7298334465263953`*^9}, 3.7298337492839413`*^9, 
   3.7298436072403064`*^9, 3.729851076807768*^9, {3.7300261214444785`*^9, 
   3.7300262052810717`*^9}, {3.7300262785961447`*^9, 
   3.7300262800999336`*^9}, {3.7300263145972977`*^9, 
   3.7300263842246866`*^9}, {3.730027606460003*^9, 3.730027609954043*^9}, {
   3.7300276847282834`*^9, 3.730027705422838*^9}, {3.7300277387160482`*^9, 
   3.730027766597595*^9}, {3.730029946336887*^9, 3.730029946874567*^9}, {
   3.7300306159337783`*^9, 3.7300306159838104`*^9}, {3.730030698339354*^9, 
   3.7300308124173183`*^9}, {3.73003084620135*^9, 3.730030853695404*^9}, {
   3.730030910847119*^9, 3.730030981653365*^9}, 3.7301204922292457`*^9, {
   3.730186089758935*^9, 3.7301860975626335`*^9}, {3.7301861623760266`*^9, 
   3.7301862365459347`*^9}, {3.7301863080540457`*^9, 3.730186363179368*^9}, {
   3.730190894725549*^9, 3.7301909220853643`*^9}, 3.7301910299311523`*^9, {
   3.7301949070623226`*^9, 3.730195015788677*^9}, {3.730195084553152*^9, 
   3.7301951049753294`*^9}, {3.7301951393798428`*^9, 3.730195233587894*^9}, {
   3.7301964907617636`*^9, 3.730196499152363*^9}, 3.730196564870855*^9, {
   3.73019674262525*^9, 3.7301967584540253`*^9}, {3.7301969921063833`*^9, 
   3.730197160996705*^9}, {3.730200886296423*^9, 3.730200887197362*^9}, {
   3.730285545361225*^9, 3.7302855822976327`*^9}, 3.730285876721367*^9, {
   3.7302865626289806`*^9, 3.730286564248189*^9}, {3.7302865944657507`*^9, 
   3.7302866190892353`*^9}, {3.7302908061700583`*^9, 
   3.7302908274604387`*^9}, {3.730290862310704*^9, 3.7302908727718973`*^9}, {
   3.7302910416256657`*^9, 3.7302910610785804`*^9}, 3.7302911299151664`*^9, 
   3.730527029296195*^9, 3.730546509794794*^9, {3.731330066859403*^9, 
   3.7313300688250065`*^9}, {3.7313305748483295`*^9, 3.73133057781155*^9}, {
   3.73133063492325*^9, 3.731330638043256*^9}, {3.731330733641655*^9, 
   3.7313307567296953`*^9}, 3.7313309192333965`*^9, {3.7313323476441083`*^9, 
   3.73133234853331*^9}, 3.7313323957674084`*^9, {3.7313353310267057`*^9, 
   3.7313353330577087`*^9}, {3.7313357051837845`*^9, 3.731335716375854*^9}, 
   3.7313358666626053`*^9, {3.7313360025532703`*^9, 3.731336060685561*^9}, {
   3.7313361191738243`*^9, 3.731336130920873*^9}, {3.731336231484275*^9, 
   3.731336238125318*^9}, 3.7313362810805173`*^9, {3.7314779281159134`*^9, 
   3.73147794288495*^9}, {3.7480629226599164`*^9, 3.748062944562479*^9}, {
   3.748081877268029*^9, 3.748081882397508*^9}, {3.7480823198087654`*^9, 
   3.748082342267175*^9}, 3.7500681673703585`*^9, 3.750068517540387*^9, {
   3.750069540770912*^9, 3.7500695602300253`*^9}, {3.750069864682439*^9, 
   3.750069892169011*^9}, {3.750069995626929*^9, 3.7500700087376785`*^9}, 
   3.7503152528391266`*^9, 3.7504061903654313`*^9, {3.7504303122340994`*^9, 
   3.7504303395990934`*^9}, {3.750486459420306*^9, 3.7504865084190397`*^9}, {
   3.750487753328032*^9, 3.750487761971034*^9}, {3.7505847751299477`*^9, 
   3.750584780784271*^9}, {3.750585705104139*^9, 3.750585761278352*^9}, {
   3.75058596300889*^9, 3.7505859709363437`*^9}, {3.7505896438614225`*^9, 
   3.750589716123556*^9}, {3.750590000946847*^9, 3.7505900106494017`*^9}, {
   3.7505900672546396`*^9, 3.750590140949855*^9}, {3.750590210991861*^9, 
   3.750590211620897*^9}, {3.750590277078641*^9, 3.7505902810388675`*^9}, {
   3.750592388884429*^9, 3.750592390237507*^9}, {3.7505928566711855`*^9, 
   3.7505928709019995`*^9}, {3.7505933642812185`*^9, 3.750593372711701*^9}, {
   3.750610651437399*^9, 3.7506106563126783`*^9}, {3.750610702010292*^9, 
   3.750610723030494*^9}, {3.7506108987125425`*^9, 3.7506109145494485`*^9}, {
   3.7506109696215982`*^9, 3.750610984706461*^9}, {3.7506110544324493`*^9, 
   3.750611080576945*^9}, {3.750611118594119*^9, 3.7506111477137847`*^9}, {
   3.7506112328336535`*^9, 3.7506112513117104`*^9}, {3.7506112827775097`*^9, 
   3.750611308884003*^9}, {3.7506120123222375`*^9, 3.7506120372696643`*^9}, {
   3.7506121486330338`*^9, 3.7506121754895697`*^9}, {3.7506579685289288`*^9, 
   3.750657996080967*^9}, {3.7506582232898197`*^9, 3.7506582323448343`*^9}, {
   3.7531644998490686`*^9, 3.7531645035252275`*^9}, {3.7531645375300503`*^9, 
   3.7531645514780455`*^9}, 3.7531645916732664`*^9, {3.753164665161236*^9, 
   3.753164667182734*^9}, {3.760429244912402*^9, 3.7604292490790186`*^9}, {
   3.7604292959548187`*^9, 3.7604294363058453`*^9}, {3.7604294762676225`*^9, 
   3.7604294777868834`*^9}, {3.76042960938752*^9, 3.760429655825754*^9}, {
   3.760429699521614*^9, 3.7604297000007944`*^9}, {3.760429740241263*^9, 
   3.7604297414071136`*^9}, {3.7604299252650104`*^9, 
   3.7604299365909505`*^9}},ExpressionUUID->"d1302ae8-5c93-43a8-b104-\
343c603cad4d"],

Cell[BoxData[
 StyleBox[
  RowBox[{
  "NNNNNNNNNNNNNNNNNNNN", "        ", "Synthetic", " ", "data", "         ", 
   "NNNNNNNNNNNNNNNNNNNNNNNNNNN"}],
  FontSize->24]], "Input",
 CellChangeTimes->{
  3.720445917639268*^9, {3.760429943235361*^9, 
   3.7604299453571415`*^9}},ExpressionUUID->"3266c4b9-52f9-4640-bdbd-\
52d666a17f6b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Rho]", "=", "0.7"}], ";", 
  RowBox[{"dim", "=", "4"}], ";", 
  RowBox[{"T", "=", "2500"}], ";", 
  RowBox[{"x", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"MultinormalDistribution", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{"0", ",", 
         RowBox[{"{", "dim", "}"}]}], "]"}], ",", 
       RowBox[{
        RowBox[{"\[Rho]", " ", 
         RowBox[{"Table", "[", 
          RowBox[{"1", ",", 
           RowBox[{"{", "dim", "}"}], ",", 
           RowBox[{"{", "dim", "}"}]}], "]"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Rho]"}], ")"}], 
         RowBox[{"IdentityMatrix", "[", "dim", "]"}]}]}]}], "]"}], ",", 
     RowBox[{"{", "T", "}"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6088305327668533`*^9, 3.608830536292055*^9}, 
   3.608917359468815*^9, {3.6089175155757437`*^9, 3.608917520981053*^9}, {
   3.608917790086445*^9, 3.6089177937376537`*^9}, {3.6089182705119233`*^9, 
   3.6089182917601385`*^9}, 3.6089184547854633`*^9, {3.608918762512064*^9, 
   3.6089187627650785`*^9}, 3.6089192316138954`*^9, {3.6089620402016435`*^9, 
   3.6089620908157043`*^9}, 3.6089628850091157`*^9, {3.6089629166342783`*^9, 
   3.608962928363451*^9}, {3.608963111042717*^9, 3.6089631343720493`*^9}, 
   3.6089688906336465`*^9, {3.608969350026581*^9, 3.608969355890167*^9}, 
   3.6089694111646943`*^9, {3.608979173573613*^9, 3.6089791854277983`*^9}, {
   3.608979270310286*^9, 3.6089793090501595`*^9}, 3.6089798271109605`*^9, {
   3.611302535012644*^9, 3.6113025449896417`*^9}, {3.619629158421853*^9, 
   3.619629158640253*^9}, {3.6203940165029817`*^9, 3.6203940302303543`*^9}, {
   3.6203940808927774`*^9, 3.6203940809387636`*^9}, 3.620814515348535*^9, {
   3.620816246564835*^9, 3.620816274894435*^9}, {3.620816320696035*^9, 
   3.620816320742835*^9}, {3.620816362566435*^9, 3.6208163652184353`*^9}, {
   3.620816431924035*^9, 3.620816438897235*^9}, {3.6208166793556347`*^9, 
   3.620816689870035*^9}, {3.620816723238435*^9, 3.620816724112035*^9}, {
   3.620817110666935*^9, 3.6208171140365353`*^9}, 3.620817355571335*^9, 
   3.620817557060935*^9, {3.620818000428535*^9, 3.620818001005735*^9}, {
   3.620821587256135*^9, 3.6208215878177347`*^9}, {3.620821618144135*^9, 
   3.620821658236135*^9}, {3.620822130416935*^9, 3.620822164986535*^9}, {
   3.620822545782535*^9, 3.620822547982135*^9}, {3.620822625748135*^9, 
   3.620822626106935*^9}, 3.620824064164235*^9, {3.6208240982346354`*^9, 
   3.620824144847435*^9}, {3.6208260232413206`*^9, 3.620826023927496*^9}, {
   3.6208868190745087`*^9, 3.620886821098624*^9}, 3.6208869818998213`*^9, 
   3.6208872311070757`*^9, {3.6208876612756796`*^9, 3.62088766669899*^9}, {
   3.62089204003413*^9, 3.6208920488596354`*^9}, {3.620895832444044*^9, 
   3.620895834947187*^9}, {3.6208959182519517`*^9, 3.6208959258353853`*^9}, {
   3.620905072432161*^9, 3.6209050753593283`*^9}, {3.6209065009528656`*^9, 
   3.620906525768285*^9}, 3.620906612976273*^9, {3.6209066822722363`*^9, 
   3.6209066875355377`*^9}, {3.6209067273448143`*^9, 
   3.6209067275758276`*^9}, {3.6209068925762653`*^9, 3.620906894384369*^9}, {
   3.6209069549268312`*^9, 3.6209069708557425`*^9}, {3.620907023926778*^9, 
   3.620907024854831*^9}, {3.620907223408188*^9, 3.620907224079226*^9}, {
   3.620907704192687*^9, 3.6209077401127415`*^9}, {3.6209080732477956`*^9, 
   3.6209080775270405`*^9}, 3.6209081177363405`*^9, {3.620908155583505*^9, 
   3.620908166992158*^9}, 3.6209088710724287`*^9, {3.6209089025202274`*^9, 
   3.6209089176080904`*^9}, {3.620908948919881*^9, 3.6209089493349047`*^9}, {
   3.620912795913026*^9, 3.620912967241825*^9}, {3.620913217530141*^9, 
   3.6209132353621607`*^9}, {3.6209133074582844`*^9, 3.620913309729414*^9}, {
   3.6209133433383365`*^9, 3.6209133767142453`*^9}, 3.620913523713653*^9, {
   3.621230196792065*^9, 3.6212301968220654`*^9}, {3.6212429830152483`*^9, 
   3.621242984543248*^9}, 3.621245153291448*^9, {3.621245463263448*^9, 
   3.621245490725448*^9}, {3.621245596903448*^9, 3.6212456466834483`*^9}, {
   3.621246254228448*^9, 3.6212462562604485`*^9}, {3.6212462986424484`*^9, 
   3.6212462990504484`*^9}, 3.621246359527448*^9, {3.621246398916448*^9, 
   3.621246455367448*^9}, {3.6212465482744484`*^9, 3.6212465614804482`*^9}, 
   3.621246605054448*^9, {3.621246850046448*^9, 3.6212468879724483`*^9}, 
   3.621261731747531*^9, {3.621261847264082*^9, 3.6212618854649014`*^9}, 
   3.62126215260742*^9, {3.62126230446942*^9, 3.62126232403642*^9}, {
   3.62126274108142*^9, 3.6212627424574203`*^9}, {3.6212632476008883`*^9, 
   3.6212632543045588`*^9}, {3.621263439759102*^9, 3.62126344223835*^9}, 
   3.621263532104336*^9, {3.6212638112644167`*^9, 3.6212638113604164`*^9}, {
   3.6212640050204163`*^9, 3.6212640120754166`*^9}, 3.621264338027955*^9, {
   3.621264936006415*^9, 3.621264949573415*^9}, {3.6212656957008886`*^9, 
   3.6212657691192303`*^9}, {3.621265845865904*^9, 3.621265935293846*^9}, {
   3.621266492210376*^9, 3.621266551302376*^9}, {3.621266587652376*^9, 
   3.621266611962376*^9}, {3.6212668741053762`*^9, 3.621266879377376*^9}, 
   3.621267553514828*^9, {3.621269094043332*^9, 3.621269098602332*^9}, 
   3.6212802738210564`*^9, {3.6212818340957966`*^9, 3.621281834204997*^9}, 
   3.6212840301116543`*^9, 3.621284632662712*^9, {3.6212847380720973`*^9, 
   3.621284754764127*^9}, {3.6212848689095273`*^9, 3.6212848690655274`*^9}, 
   3.6212849646468954`*^9, {3.6212850086701727`*^9, 3.6212850164857864`*^9}, {
   3.6212850911787176`*^9, 3.621285094267523*^9}, 3.6212856137952356`*^9, 
   3.621285672669739*^9, {3.621317638058099*^9, 3.621317645155962*^9}, {
   3.621317961600031*^9, 3.6213179866068316`*^9}, {3.621320379341186*^9, 
   3.62132038434869*^9}, {3.621320427123067*^9, 3.6213204471844587`*^9}, 
   3.621320502501704*^9, {3.6213371018408475`*^9, 3.6213371500085535`*^9}, {
   3.6213372822485538`*^9, 3.6213372908955536`*^9}, {3.621337463724554*^9, 
   3.621337525478554*^9}, {3.621340109712633*^9, 3.621340119392601*^9}, {
   3.62134028515757*^9, 3.6213403343145695`*^9}, {3.6213404496985693`*^9, 
   3.62134045469057*^9}, {3.621340698098769*^9, 3.6213407066417694`*^9}, 
   3.6213408033797693`*^9, {3.6213408594717693`*^9, 3.6213408666467695`*^9}, 
   3.621340896765769*^9, {3.6213410285954695`*^9, 3.621341050620469*^9}, {
   3.621341099009466*^9, 3.6213411065622215`*^9}, {3.621361791505493*^9, 
   3.621361803642315*^9}, 3.6213618678832273`*^9, {3.621362702250693*^9, 
   3.6213627285367393`*^9}, {3.6213629484347253`*^9, 
   3.6213629484971256`*^9}, {3.6213639505336857`*^9, 3.621363980392138*^9}, {
   3.6213641470316305`*^9, 3.621364171742074*^9}, {3.621365470491155*^9, 
   3.621365471021556*^9}, {3.621365538257674*^9, 3.621365563311318*^9}, {
   3.6213656108290014`*^9, 3.621365636803047*^9}, {3.62136574647124*^9, 
   3.6213657896053157`*^9}, 3.6213661849100103`*^9, {3.6213664137780123`*^9, 
   3.6213664346664486`*^9}, {3.621366890514849*^9, 3.62136689084245*^9}, {
   3.6213669265977125`*^9, 3.6213669505125546`*^9}, {3.621367366331285*^9, 
   3.621367374396499*^9}, {3.622483220018276*^9, 3.6224832234658823`*^9}, {
   3.6224847631311865`*^9, 3.622484764051588*^9}, {3.6224857946230984`*^9, 
   3.6224858193959417`*^9}, {3.622574526872085*^9, 3.622574527839287*^9}, 
   3.6225752734425964`*^9, {3.6226181732888927`*^9, 3.622618180932906*^9}, {
   3.622618214363765*^9, 3.622618220822176*^9}, {3.622618434916952*^9, 
   3.6226184413753633`*^9}, {3.62261887199852*^9, 3.622618880718935*^9}, {
   3.622618948953455*^9, 3.622618980715111*^9}, {3.6226197685000954`*^9, 
   3.6226197691084967`*^9}, 3.6226200182409344`*^9, {3.622620300102229*^9, 
   3.622620312972252*^9}, {3.6226207956839*^9, 3.6226208382095747`*^9}, {
   3.622622483216864*^9, 3.6226224843088655`*^9}, {3.6226225511705832`*^9, 
   3.622622572698621*^9}, {3.6226236502861137`*^9, 3.6226236503485136`*^9}, {
   3.622623731858657*^9, 3.6226237342298613`*^9}, 3.6229987703242345`*^9, {
   3.6229991756753464`*^9, 3.622999213021812*^9}, {3.6229994150889673`*^9, 
   3.6229994152449675`*^9}, {3.623000410323915*^9, 3.623000425065941*^9}, 
   3.6230005255769176`*^9, {3.6230018670715218`*^9, 3.623001885655585*^9}, {
   3.6230060088338137`*^9, 3.6230060202964697`*^9}, {3.623242798834906*^9, 
   3.6232428058562107`*^9}, {3.6232428596082015`*^9, 3.623242880391264*^9}, {
   3.6232431212700357`*^9, 3.623243137994093*^9}, {3.623247345774905*^9, 
   3.623247346710905*^9}, {3.6232477167796097`*^9, 3.62324775128681*^9}, 
   3.6232477946392097`*^9, 3.62324784800681*^9, {3.6232484689320655`*^9, 
   3.6232484718802958`*^9}, 3.6232485328727765`*^9, 3.623312900073546*^9, 
   3.6233129647668595`*^9, {3.623313016730551*^9, 3.6233130213481593`*^9}, {
   3.623316209917361*^9, 3.6233163647444324`*^9}, 3.6233206439993505`*^9, 
   3.623327095101392*^9, {3.623331132727676*^9, 3.6233311385932865`*^9}, 
   3.6233316169102373`*^9, {3.6233322446865396`*^9, 3.62333225640216*^9}, 
   3.623748471544522*^9, {3.623749673106666*^9, 3.6237496784421997`*^9}, {
   3.6237609441298885`*^9, 3.6237609464261184`*^9}, {3.623760979819457*^9, 
   3.623760985425018*^9}, {3.623761024420917*^9, 3.623761028101285*^9}, {
   3.623764642885651*^9, 3.623764644661651*^9}, {3.623767051339651*^9, 
   3.623767053186651*^9}, {3.624101187341226*^9, 3.6241011919566875`*^9}, {
   3.624101520985587*^9, 3.624101524966985*^9}, {3.6241017396734533`*^9, 
   3.6241017607625628`*^9}, 3.6241017989483805`*^9, {3.6241022654040213`*^9, 
   3.62410228889237*^9}, {3.624102435418021*^9, 3.624102445530032*^9}, {
   3.6241037142718925`*^9, 3.6241037230877733`*^9}, {3.62411916613861*^9, 
   3.6241191990984955`*^9}, 3.624119243635043*^9, {3.6241192760428963`*^9, 
   3.6241192793150835`*^9}, {3.6241231962259293`*^9, 3.624123218923969*^9}, {
   3.6241775499626427`*^9, 3.6241775589861593`*^9}, {3.624177596291293*^9, 
   3.6241775977143745`*^9}, 3.6241776332514067`*^9, {3.624182001491454*^9, 
   3.624182030026086*^9}, 3.6241822232671385`*^9, {3.624182277010213*^9, 
   3.6241822971463647`*^9}, {3.624182540402278*^9, 3.6241825470906606`*^9}, {
   3.6241826749629745`*^9, 3.624182684130499*^9}, {3.6369645307727375`*^9, 
   3.6369645380427375`*^9}, {3.6707498818272877`*^9, 3.670749883767288*^9}, {
   3.6708465306333833`*^9, 3.6708465391333833`*^9}, 3.670846603813383*^9, 
   3.6714334682761602`*^9, {3.671433657152178*^9, 3.671433673472178*^9}, 
   3.6714337524221783`*^9, 3.6714338179821777`*^9, 3.6714340830496316`*^9, {
   3.6714341478257446`*^9, 3.6714341478557425`*^9}, 3.688206820700506*^9, 
   3.6882077214340763`*^9, 3.688208155200664*^9, 3.6882098922138968`*^9, {
   3.688210479778021*^9, 3.6882104961278577`*^9}, {3.6882108708666134`*^9, 
   3.688210890256419*^9}, {3.688212179510624*^9, 3.688212250159917*^9}, {
   3.688212288937029*^9, 3.688212299936919*^9}, 3.718113593401533*^9, 
   3.720445917639268*^9, {3.72044657137766*^9, 3.7204465749778657`*^9}, {
   3.720447109665448*^9, 3.720447111361545*^9}, {3.720447141481268*^9, 
   3.7204471416012745`*^9}, 3.720448350641428*^9, 3.720448417857272*^9, {
   3.720449083428341*^9, 3.7204490878975964`*^9}, 3.7204498269458675`*^9, 
   3.7204498598097477`*^9, {3.720450174825765*^9, 3.7204501754738026`*^9}, {
   3.7204503253773766`*^9, 3.7204503591453075`*^9}, {3.7204505186094284`*^9, 
   3.72045051863343*^9}, {3.720450594665779*^9, 3.7204506153779635`*^9}, {
   3.7204506837298727`*^9, 3.7204506841928997`*^9}, {3.720450719850939*^9, 
   3.7204507198979416`*^9}, 3.7204510222102327`*^9, {3.720511444718262*^9, 
   3.720511447323887*^9}, {3.720516005573406*^9, 3.720516006994279*^9}, {
   3.7205164721094866`*^9, 3.720516502399305*^9}, {3.7205165618625784`*^9, 
   3.720516564147729*^9}, {3.7205190998564467`*^9, 3.720519114201044*^9}, 
   3.720519514871546*^9, 3.7205200583486953`*^9, 3.7205201826436715`*^9, 
   3.720699487240453*^9, 3.720701327240695*^9, 3.720701388328189*^9, {
   3.72070141893594*^9, 3.7207014219121094`*^9}, 3.720701461833393*^9, {
   3.7220011521273527`*^9, 3.7220011533458014`*^9}, {3.7220013363921213`*^9, 
   3.7220013582266364`*^9}, {3.7220014657945213`*^9, 3.722001467114111*^9}, {
   3.722002805580388*^9, 3.722002859628904*^9}, 3.7220030223161826`*^9, 
   3.7220031934570227`*^9, 3.722003248493759*^9, 3.7220148232141905`*^9, {
   3.722015110165603*^9, 3.7220151483257856`*^9}, 3.7220155051821966`*^9, {
   3.72201564055794*^9, 3.722015650549511*^9}, 3.726232318464796*^9, {
   3.726237309102473*^9, 3.7262373171372366`*^9}, 3.726237369610421*^9, 
   3.726293401163913*^9, 3.7262934385527215`*^9, {3.72629414943274*^9, 
   3.7262941506980996`*^9}, 3.726294286376116*^9, {3.7265643757938147`*^9, 
   3.726564384498351*^9}, 3.7265652449043827`*^9, 3.7265653035753593`*^9, 
   3.7265662746721773`*^9, {3.726567066959986*^9, 3.7265670691017923`*^9}, 
   3.7265741456461697`*^9, {3.7277847163436484`*^9, 3.72778471692332*^9}, {
   3.727784764920497*^9, 3.7277847731861753`*^9}, 3.728389742309025*^9, {
   3.7283899297009077`*^9, 3.7283899298036947`*^9}, {3.7283900563475676`*^9, 
   3.7283900690682693`*^9}, {3.728549283401575*^9, 3.7285492873291597`*^9}, {
   3.728549349019476*^9, 3.728549351747018*^9}, {3.7285495585795937`*^9, 
   3.7285495813310013`*^9}, 3.7285501174999123`*^9, 3.7285507468349266`*^9, {
   3.728551239706749*^9, 3.72855123974675*^9}, 3.728553809154639*^9, {
   3.728554225586902*^9, 3.728554261596607*^9}, {3.7285545862519217`*^9, 
   3.728554588979476*^9}, 3.728554941508134*^9, 3.7285557542198887`*^9, {
   3.7288196946838036`*^9, 3.728819695493805*^9}, {3.7288233377490635`*^9, 
   3.7288233459141073`*^9}, 3.7288236052936506`*^9, 3.7288243284728727`*^9, {
   3.7288244809777765`*^9, 3.728824485551799*^9}, 3.7288245501151905`*^9, 
   3.728824620200532*^9, 3.7288261175922194`*^9, {3.7292342491516232`*^9, 
   3.729234287961282*^9}, 3.729234357097692*^9, 3.7292357470018725`*^9, 
   3.729235833457224*^9, 3.7292374897708225`*^9, 3.729240053245455*^9, {
   3.729407543394476*^9, 3.729407549948161*^9}, 3.7296658626251507`*^9, 
   3.7296665113131795`*^9, 3.729666682843603*^9, 3.729668965628981*^9, {
   3.7296692401203012`*^9, 3.7296692424585447`*^9}, 3.7296692941067963`*^9, 
   3.7296696645657988`*^9, 3.729672938578678*^9, 3.729673179112355*^9, 
   3.7296732790228395`*^9, {3.7296733212806807`*^9, 3.7296733338523474`*^9}, 
   3.729673379697405*^9, {3.729680950395114*^9, 3.729680950548375*^9}, 
   3.7296810978146877`*^9, 3.729682228601615*^9, 3.729682350331196*^9, 
   3.7296833671871576`*^9, 3.7296834371687727`*^9, {3.7296836441550903`*^9, 
   3.729683658038329*^9}, {3.7296854958769045`*^9, 3.729685501982399*^9}, {
   3.7296855420076303`*^9, 3.7296855816296225`*^9}, 3.72968561857406*^9, {
   3.7296857377750096`*^9, 3.7296857709629493`*^9}, {3.729685828355568*^9, 
   3.729685865212877*^9}, {3.729686003149988*^9, 3.7296860295259733`*^9}, {
   3.729686116619073*^9, 3.7296861277326684`*^9}, {3.7296882684418736`*^9, 
   3.729688294777548*^9}, {3.7296885686624107`*^9, 3.7296885857433414`*^9}, 
   3.7298384295882244`*^9, 3.729840103327201*^9, 3.729840151533064*^9, 
   3.729840239165056*^9, {3.729840368118656*^9, 3.729840438267212*^9}, {
   3.729841239486012*^9, 3.7298414433187637`*^9}, {3.7298468404972506`*^9, 
   3.7298468423467946`*^9}, 3.7298511647141237`*^9, 3.7298617143615437`*^9, {
   3.7298618275424137`*^9, 3.729861827589289*^9}, {3.7298618981149483`*^9, 
   3.7298619433666887`*^9}, {3.7305340358139677`*^9, 
   3.7305340405453663`*^9}, {3.731330166278378*^9, 3.731330169710384*^9}, {
   3.7480020000540566`*^9, 3.7480020007094035`*^9}, {3.7480020683676805`*^9, 
   3.7480020780617533`*^9}, {3.748003351748345*^9, 3.7480033945153036`*^9}, {
   3.748004694892728*^9, 3.7480046950198145`*^9}, 3.748004840738036*^9, 
   3.748005612555193*^9, {3.7480077850677595`*^9, 3.7480077851778984`*^9}, 
   3.7480819000624466`*^9, {3.7505864015149713`*^9, 3.750586402653036*^9}, 
   3.7505864521488676`*^9, {3.750586513164357*^9, 3.750586531331396*^9}, {
   3.750588650437602*^9, 3.750588650555609*^9}, 3.7505893225910473`*^9, 
   3.7604297730756216`*^9, {3.760429837050125*^9, 3.7604298459280443`*^9}},
 CellLabel->
  "In[351]:=",ExpressionUUID->"e2fd5311-40b5-4f37-ab87-da852d4ce53b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MIs", "[", 
  RowBox[{".2", ",", "x", ",", "0"}], "]"}]], "Input",
 CellChangeTimes->{{3.7480020214455695`*^9, 3.7480020336931586`*^9}, {
  3.7480022851112366`*^9, 3.748002298924343*^9}, {3.7480023383476877`*^9, 
  3.7480023608183985`*^9}, {3.7480024061456585`*^9, 3.748002406343795*^9}, {
  3.748005432894117*^9, 3.7480054452602806`*^9}, {3.748081916864869*^9, 
  3.748081947933154*^9}, {3.74808198046173*^9, 3.7480819822285213`*^9}, {
  3.7604298086114535`*^9, 3.7604298086354723`*^9}, {3.7604298640483985`*^9, 
  3.7604298641345205`*^9}},
 CellLabel->
  "In[354]:=",ExpressionUUID->"ba34f3b8-2848-4b41-bee9-f0211cb21015"],

Cell[BoxData["0.3383645893228831`"], "Output",
 CellChangeTimes->{
  3.7480020345317593`*^9, {3.7480020742258534`*^9, 3.7480020882186337`*^9}, {
   3.7480022935523615`*^9, 3.748002299504079*^9}, {3.748002341006792*^9, 
   3.7480023618801327`*^9}, 3.748002407109563*^9, 3.7480054479878645`*^9, {
   3.7480819067392974`*^9, 3.748081948467087*^9}, {3.7604297874883037`*^9, 
   3.7604298093217015`*^9}, {3.760429849785465*^9, 3.7604298646869473`*^9}},
 CellLabel->
  "Out[354]=",ExpressionUUID->"627c1bdd-c9c1-4d69-8e3c-345d72c015dd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MIs", "[", 
  RowBox[{".2", ",", "x", ",", 
   RowBox[{"Length", "[", "x", "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.731331811685136*^9, 3.731331844289193*^9}, {
  3.7313324148150415`*^9, 3.7313324243622584`*^9}, {3.731332466310732*^9, 
  3.7313325114884114`*^9}, {3.7313357909401894`*^9, 3.7313357969002314`*^9}, {
  3.7604298669613853`*^9, 3.7604298670154247`*^9}},
 CellLabel->
  "In[355]:=",ExpressionUUID->"1a9bf7b5-6833-4612-8f9a-edfeb1e10d49"],

Cell[BoxData["0.335277706681987`"], "Output",
 CellChangeTimes->{{3.731331812059536*^9, 3.7313318448351936`*^9}, 
   3.731332228398283*^9, {3.7313324154702425`*^9, 3.731332425781861*^9}, {
   3.7313324669971333`*^9, 3.7313324830651617`*^9}, 3.7313325152792177`*^9, {
   3.731335787170184*^9, 3.731335797430232*^9}, 3.731335834069415*^9, 
   3.7604298140513515`*^9, {3.7604298510652914`*^9, 3.760429867600834*^9}},
 CellLabel->
  "Out[355]=",ExpressionUUID->"b39d71da-0e8d-4a2e-aec8-2c43e0febdbc"]
}, Open  ]],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", 
   RowBox[{
   "NNNNNNNNNNNNNNNNNNNN", "     ", "SP500", "   ", 
    "NNNNNNNNNNNNNNNNNNNNNNNNNNN"}], "*)"}],
  FontSize->24]], "Input",
 CellChangeTimes->{{3.7265702993573112`*^9, 3.7265703013153377`*^9}, {
  3.727093176112252*^9, 3.7270931767450457`*^9}, {3.730118437958886*^9, 
  3.7301184392605824`*^9}, {3.750488990797431*^9, 
  3.750488991093326*^9}},ExpressionUUID->"a7d95242-2d30-4c6f-8663-\
1a4b5f7d530d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
     "\"\<C:\\UEA\\projects\\Tail \
Interdependence\\data\\SP500\\\\RAWRETS_SP500.csv\>\"", ",", "\"\<CSV\>\""}], 
     "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";", 
  RowBox[{"(*", 
   RowBox[{
   "RAWRETS_SP500", ",", " ", "ARGARCHResids_SP500", ",", " ", 
    "FFCResids_SP500", ",", " ", "FFCGARCHResids_SP500"}], "*)"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.727676101754162*^9, 3.7276761083734875`*^9}, {
   3.7276763372169714`*^9, 3.7276763372552333`*^9}, 3.727676406842338*^9, {
   3.72768330979653*^9, 3.7276833098434067`*^9}, {3.72768340894925*^9, 
   3.7276834246217184`*^9}, {3.727684157465968*^9, 3.727684158105817*^9}, 
   3.7276841925072055`*^9, 3.7276851367386303`*^9, {3.7276853979752226`*^9, 
   3.727685398182008*^9}, {3.7277643668877263`*^9, 3.727764387399885*^9}, {
   3.7301186744897127`*^9, 3.730118691068842*^9}, 3.7301203700649424`*^9, {
   3.730120637193342*^9, 3.7301206570639925`*^9}, 3.73012110481306*^9, 
   3.7301870965818195`*^9, 3.730188473563262*^9, {3.730188815904708*^9, 
   3.7301888365783253`*^9}, 3.7301890195639896`*^9, 3.730189940209237*^9, 
   3.730197589248892*^9, 3.7301976988395863`*^9, 3.7302011419565086`*^9, 
   3.7302800809445925`*^9, 3.730281098557938*^9, 3.730281484969051*^9, 
   3.730289379185354*^9, 3.730290525679966*^9, 3.7304395036276083`*^9, 
   3.730526734712834*^9, {3.730546568666869*^9, 3.730546570439562*^9}, {
   3.731239845706324*^9, 3.731239854454827*^9}, 3.748063034947989*^9, 
   3.7480657770513887`*^9, 3.7480662550751295`*^9, {3.7480663918087935`*^9, 
   3.748066395100478*^9}, {3.7482432390646987`*^9, 3.748243240359853*^9}, {
   3.748243304141593*^9, 3.74824330820843*^9}, {3.748243395104604*^9, 
   3.748243407064011*^9}, {3.748322378539969*^9, 3.748322402331184*^9}, 
   3.7483224547614164`*^9, {3.7483236436655145`*^9, 3.7483236567297893`*^9}, 
   3.7483264582079954`*^9, 3.7483272885297413`*^9, 3.7483290343416696`*^9, {
   3.748331336812608*^9, 3.748331341140791*^9}, {3.7483313777397966`*^9, 
   3.7483313778033543`*^9}, 3.7483320797066827`*^9, 3.748332200619031*^9, {
   3.748332565591009*^9, 3.748332588331846*^9}, 3.748332666293395*^9, {
   3.7483327538361874`*^9, 3.7483327605452104`*^9}, 3.7483330403771553`*^9, {
   3.748333077519898*^9, 3.748333078359269*^9}, {3.7483334466939716`*^9, 
   3.7483334802908106`*^9}, {3.7483336008694215`*^9, 3.7483336030245657`*^9}, 
   3.7483386023511057`*^9, {3.7483386599320745`*^9, 3.74833866129852*^9}, 
   3.748600095714651*^9, 3.748603611805333*^9, 3.748604205894117*^9, 
   3.7486046249634705`*^9, {3.7486795294813747`*^9, 3.7486795929700365`*^9}, 
   3.7486796504078207`*^9, 3.7486798599301543`*^9, {3.748680534782898*^9, 
   3.7486805366068487`*^9}, {3.7486807996931715`*^9, 3.748680800195879*^9}, {
   3.7486938851832633`*^9, 3.7486939520955257`*^9}, 3.748694328858601*^9, {
   3.74895232939215*^9, 3.7489523327830334`*^9}, 3.7516993660039268`*^9, 
   3.7516995068263044`*^9, 3.751699564648137*^9, 3.7516996634741135`*^9, 
   3.751699992626861*^9, 3.7517002896885242`*^9, 3.751724461680778*^9, 
   3.7522322724623938`*^9, 3.752232358756223*^9, {3.752234313760754*^9, 
   3.7522343162401295`*^9}, {3.7522349942908673`*^9, 3.752235016938567*^9}, {
   3.752235237403367*^9, 3.7522352596541667`*^9}, {3.75223615148357*^9, 
   3.752236160069384*^9}, 3.752236298195991*^9, 3.752236428608302*^9, 
   3.752237570493331*^9, 3.752303963009087*^9, 3.7523041444544954`*^9, 
   3.7523042138231554`*^9, {3.7523046580612335`*^9, 3.7523046698856907`*^9}, 
   3.752304822037752*^9, 3.7523049379574833`*^9, 3.753163566466168*^9, {
   3.760429993882723*^9, 3.7604299977226286`*^9}, {3.7604300359546804`*^9, 
   3.7604300467612753`*^9}},
 CellLabel->
  "In[360]:=",ExpressionUUID->"0d1b0676-d65a-4f9e-be10-146fd3b5a533"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", "r", "]"}], "[", 
  RowBox[{"[", 
   RowBox[{"1", ";;", "10"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7604300204437957`*^9, 3.7604300217621307`*^9}, {
  3.7604300637466297`*^9, 3.7604300704410696`*^9}},
 CellLabel->
  "In[363]:=",ExpressionUUID->"d0bdc0e3-2d19-48e0-8544-c8d18b333174"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0006017573696144751`", ",", "0.0004992913832199496`", ",", 
   "0.0009104308390022688`", ",", "0.001186224489795918`", ",", 
   "0.0006231575963718791`", ",", "0.0007429138321995456`", ",", 
   "0.0006843820861678004`", ",", "0.000998582766439913`", ",", 
   "0.0004377834467120155`", ",", "0.0006607142857142815`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7604300226658487`*^9, {3.760430054076928*^9, 3.7604300716550465`*^9}},
 CellLabel->
  "Out[363]=",ExpressionUUID->"d4955893-d97f-4611-b574-789e4d025182"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"**", "**"}], "**"}], "**"}], "**"}], "**"}], "**"}], 
          "**"}], "**"}], "**"}], "**"}], "**"}], "**"}], "**"}], "**", "**", 
   "  ", "Contributions", "  ", "**", "**", "**", "**", "**", "**", "**", "**",
    "**", "**", "**", "**", "**", "**", "**", "**"}], "*******)"}]], "Input",
 CellChangeTimes->{{3.7301867881100917`*^9, 3.730186799640088*^9}, {
  3.730280120294835*^9, 
  3.7302801224155836`*^9}},ExpressionUUID->"477961e3-ad19-4b7c-b195-\
fa30d4d4c554"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", ".1"}], ";", 
  RowBox[{"zc", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"maxi", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "r", "]"}], "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Monitor", "[", 
    RowBox[{
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"i", "=", "1"}], ",", 
       RowBox[{"i", "\[LessEqual]", "maxi"}], ",", 
       RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{"AppendTo", "[", 
        RowBox[{"zc", ",", 
         RowBox[{"MIs", "[", 
          RowBox[{"a", ",", 
           RowBox[{"r", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", 
              RowBox[{"Delete", "[", 
               RowBox[{
                RowBox[{"Range", "[", "maxi", "]"}], ",", "i"}], "]"}]}], 
             "]"}], "]"}], ",", 
           RowBox[{"Length", "[", "r", "]"}]}], "]"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", "i", "}"}]}], "]"}], ";"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zc", "=", 
   RowBox[{
    RowBox[{"MIs", "[", 
     RowBox[{"a", ",", "r", ",", 
      RowBox[{"Length", "[", "r", "]"}]}], "]"}], "-", "zc"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7301868096106772`*^9, 3.730186872474949*^9}, {
   3.7301869320356264`*^9, 3.7301869982236347`*^9}, 3.730187084202276*^9, {
   3.7301871165711117`*^9, 3.7301871638910418`*^9}, {3.7301873909958873`*^9, 
   3.7301874401526623`*^9}, {3.730187694379903*^9, 3.730187734098271*^9}, {
   3.730188498063946*^9, 3.730188542595997*^9}, 3.7304395272728667`*^9, 
   3.730439686858816*^9, {3.7304399123708773`*^9, 3.730439912417755*^9}, 
   3.730546774419999*^9, 3.730546885285741*^9, 3.7312361748000045`*^9, 
   3.7312362879922967`*^9, 3.7312363901570854`*^9, {3.7312380214775915`*^9, 
   3.731238022852883*^9}, 3.731238205934479*^9, {3.7313341708884797`*^9, 
   3.731334172572493*^9}, 3.731334755739087*^9, 3.73133585223752*^9, {
   3.731336567825635*^9, 
   3.7313365678856354`*^9}},ExpressionUUID->"2cc748ed-2da1-4506-8f88-\
1705be46c759"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Sort", "[", 
    RowBox[{"zc", ",", "Greater"}], "]"}], ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Placed", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<\[Alpha]=0.1\>\"", ",", "\"\<\[Alpha]=0.5\>\"", ",", 
        "\"\<\[Alpha]=0.9\>\""}], "}"}], ",", "Above"}], "]"}]}], ",", 
   RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Black", ",", 
      RowBox[{"{", 
       RowBox[{"Black", ",", "Dotted"}], "}"}], ",", "Gray"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<i\>\"", ",", 
      "\"\<\!\(\*OverscriptBox[\(MI\), \
\(~\)]\)(\[Alpha])-\!\(\*SubscriptBox[OverscriptBox[\(MI\), \(~\)], \(-i\)]\)\
\[InvisiblePrefixScriptBase](\[Alpha])\>\""}], "}"}]}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]], "Input",Expression\
UUID->"0f3cbf56-debd-4a6b-8c1a-af7c0595b725"],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.007333333333333334], 
         AbsoluteThickness[1.6], 
         Dashing[{0, Small}], 
         GrayLevel[0.5]], 
        LineBox[CompressedData["
1:eJw11AtUjekaB/DXuAxFUs0sJmWLUUyiVOj6RFHpXlKodjdCSUUS5U3pgghF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         "]]}}}, {}, {}, {}, {}}, {
    DisplayFunction -> Identity, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, AxesOrigin -> {0., 0}, 
     PlotRange -> {{0., 254.}, {-0.007544215513515029, 0.02339621522470492}}, 
     PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
     Identity, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {
       FormBox["\"i\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*OverscriptBox[\\(MI\\), \
\\(~\\)]\\)(\[Alpha])-\\!\\(\\*SubscriptBox[OverscriptBox[\\(MI\\), \\(~\\)], \
\\(-i\\)]\\)\[InvisiblePrefixScriptBase](\[Alpha])\"", TraditionalForm]}, 
     AxesOrigin -> {0., 0}, DisplayFunction :> Identity, 
     Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0., 254.}, {-0.007544215513515029, 0.02339621522470492}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"\[Alpha]=0.1\"", "\"\[Alpha]=0.5\"", "\"\[Alpha]=0.9\""},
       "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.066], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small}], 
                    GrayLevel[0.5]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.066], 
                    AbsoluteThickness[1.6], 
                    Dashing[{0, Small}], 
                    GrayLevel[0.5]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"PointSize", "[", "0.007333333333333334`", "]"}], 
                 ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 RowBox[{"Dashing", "[", 
                   RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.33333333333333337`], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], "GrayLevel[0.5]"], Appearance -> None,
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                   DefaultBaseStyle -> {}, ButtonFunction :> 
                   With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  GrayLevel[0.5], Editable -> False, Selectable -> False]}], 
               "]"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", "True", "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}, {
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {2, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Above"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{3.731336488855359*^9, 3.7313365456455464`*^9, 
  3.7313367641847043`*^9},ExpressionUUID->"0e4f0a7b-42d9-4dd4-907d-\
de05f512c904"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cr", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
     "\"\<C:\\UEA\\projects\\Tail Interdependence\\JE\\Results & Diagrams \
SP500\\\\MI contributions to FFCGARCH.csv\>\"", ",", "\"\<CSV\>\""}], "]"}], 
    "[", 
    RowBox[{"[", 
     RowBox[{"2", ";;"}], "]"}], "]"}]}], ";", 
  RowBox[{"Dimensions", "[", "cr", "]"}]}]], "Input",
 CellChangeTimes->{{3.73029472843025*^9, 3.73029472849426*^9}, 
   3.730295172522579*^9, {3.7302952188320684`*^9, 3.730295223512561*^9}, 
   3.7304405282242556`*^9, {3.7347612275185375`*^9, 3.734761251818509*^9}},
 EmphasizeSyntaxErrors->
  True,ExpressionUUID->"9e908fdc-5783-4d80-a6cd-51d2890ba76f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"254", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{
  3.7302952258870354`*^9, 3.7304405597513976`*^9, 3.7305451009904003`*^9, {
   3.734761231470229*^9, 
   3.734761252582983*^9}},ExpressionUUID->"2afc1f2f-6367-4d1d-bd48-\
db8c26a5e4a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"G1", "=", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sort", "[", 
       RowBox[{"#", ",", "Greater"}], "]"}], "&"}], "/@", 
     RowBox[{"Transpose", "[", "cr", "]"}]}], ",", 
    RowBox[{"PlotLegends", "\[Rule]", 
     RowBox[{"Placed", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "\"\<\[Alpha]=0.1\>\"", ",", "\"\<\[Alpha]=0.5\>\"", ",", 
         "\"\<\[Alpha]=0.9\>\""}], "}"}], ",", "Above"}], "]"}]}], ",", 
    RowBox[{"Joined", "\[Rule]", " ", "True"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Black", ",", 
       RowBox[{"{", 
        RowBox[{"Black", ",", "Dotted"}], "}"}], ",", "Gray"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<i\>\"", ",", 
       "\"\<\!\(\*OverscriptBox[\(MI\), \
\(~\)]\)(\[Alpha])-\!\(\*SubscriptBox[OverscriptBox[\(MI\), \(~\)], \(-i\)]\)\
\[InvisiblePrefixScriptBase](\[Alpha])\>\""}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.7312364800632596`*^9, 3.7312364842697244`*^9}, {
  3.731236538747905*^9, 3.731236539321295*^9}, {3.7347612746092796`*^9, 
  3.7347612804744873`*^9}},ExpressionUUID->"751ee630-7eef-4426-a6a6-\
63c9d227d0aa"],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         AbsoluteThickness[1.6], 
         GrayLevel[0]], 
        LineBox[CompressedData["
1:eJw103k01fkfx/GrSUm0UKbG0tWvopKfJVoUL1tRyL4v37tyrWVrZW4LUslo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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         AbsoluteThickness[1.6], 
         GrayLevel[0], 
         Dashing[{0, Small}]], 
        LineBox[CompressedData["
1:eJw91ns4FPgex/FJmxQ50kVFmYR0U0RI8iFE5H4Z97lfDGYRleu0ESJdNqds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         "]]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.0055000000000000005`], 
         AbsoluteThickness[1.6], 
         GrayLevel[0.5]], 
        LineBox[CompressedData["
1:eJw1zQlczPkfx/FxLjkKOSsmqlW7ReRMendQRLrvxkxzT82EQmm1P5KUYpVF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         "]]}}}, {}, {}, {}, {}}, {
    DisplayFunction -> Identity, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, AxesOrigin -> {0., 0}, 
     PlotRange -> {{0., 254.}, {-0.021786108, 0.027563218}}, 
     PlotRangeClipping -> True, ImagePadding -> All, DisplayFunction -> 
     Identity, AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], 
     Axes -> {True, True}, AxesLabel -> {
       FormBox["\"i\"", TraditionalForm], 
       FormBox[
       "\"\\!\\(\\*OverscriptBox[\\(MI\\), \
\\(~\\)]\\)(\[Alpha])-\\!\\(\\*SubscriptBox[OverscriptBox[\\(MI\\), \\(~\\)], \
\\(-i\\)]\\)\[InvisiblePrefixScriptBase](\[Alpha])\"", TraditionalForm]}, 
     AxesOrigin -> {0., 0}, DisplayFunction :> Identity, 
     Frame -> {{False, False}, {False, False}}, 
     FrameLabel -> {{None, None}, {None, None}}, 
     FrameTicks -> {{Automatic, Automatic}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{0., 254.}, {-0.021786108, 0.027563218}}, 
     PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.05], 
        Scaled[0.05]}}, Ticks -> {Automatic, Automatic}}],FormBox[
    FormBox[
     TemplateBox[{"\"\[Alpha]=0.1\"", "\"\[Alpha]=0.5\"", "\"\[Alpha]=0.9\""},
       "PointLegend", DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.0495], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.0495], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.0495], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{0, Small}]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.0495], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0], 
                    Dashing[{0, Small}]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2, 
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.0495], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0.5]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.0495], 
                    AbsoluteThickness[1.6], 
                    GrayLevel[0.5]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {"Columns" -> {{0.8, 0.5}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxDividers -> {"Columns" -> {{None}}, "Rows" -> {{None}}}, 
             GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}}, 
             GridBoxSpacings -> {"Columns" -> {{0}}, "Rows" -> {{1}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
         FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
         False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                 "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False], 
                   ",", 
                   RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "Small"}], "}"}], "]"}]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.0055000000000000005`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}, DefaultBaseStyle -> 
                    "ColorSwatchGraphics", AspectRatio -> 1, Frame -> True, 
                    FrameStyle -> GrayLevel[0.33333333333333337`], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 
                    1.35 (CurrentValue["FontCapHeight"]/AbsoluteCurrentValue[
                    Magnification])}]], 
                    StyleBox[
                    RowBox[{"GrayLevel", "[", "0.5`", "]"}], NumberMarks -> 
                    False]], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0.5], Editable -> False, Selectable -> False]}],
                  "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", "}"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Row\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}, {
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {2, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "Above"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7312420367888737`*^9, {3.7347612599193773`*^9, 3.734761281595667*^9}, 
   3.7347613604944572`*^9},ExpressionUUID->"f1d41ceb-8b08-44ac-86cb-\
723fc24dcd1a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "[", 
  RowBox[{"[", 
   RowBox[{"Ordering", "[", "zc", "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7312403472396097`*^9, 
  3.7312403902061167`*^9}},ExpressionUUID->"edd83e42-8b98-4712-a93a-\
3cafe5c234df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"RESAPPLE\"\>", ",", "\<\"RESCISCOSYSTEMS\"\>", 
   ",", "\<\"RESMICROSOFT\"\>", ",", "\<\"RESORACLE\"\>", 
   ",", "\<\"RESINTEL\"\>", ",", "\<\"RESTEXASINSTRUME\"\>", 
   ",", "\<\"RESAPPLIEDMATS\"\>", ",", "\<\"RESSKYWORKSSOLUT\"\>", 
   ",", "\<\"RESLAMRESEARCH\"\>", ",", "\<\"RESADVANCEDMICRO\"\>", 
   ",", "\<\"RESJPMORGANCHASE\"\>", ",", "\<\"RESALOGDEVICES\"\>", 
   ",", "\<\"RESMICRONTECHNOL\"\>", ",", "\<\"RESINTERTIOLBUSM\"\>", 
   ",", "\<\"RESCORNING\"\>", ",", "\<\"RESKLATENCOR\"\>", 
   ",", "\<\"RESWESTERNDIGITA\"\>", ",", "\<\"RESCHARLESSCHWAB\"\>", 
   ",", "\<\"RESMOTOROLASOLUT\"\>", ",", "\<\"RESCA\"\>", 
   ",", "\<\"RESADOBESYSTEMS\"\>", ",", "\<\"RESCITIGROUP\"\>", 
   ",", "\<\"RESAMGEN\"\>", ",", "\<\"RESBANKOFAMERICA\"\>", 
   ",", "\<\"RESSYMANTEC\"\>", ",", "\<\"RESHALLIBURTON\"\>", 
   ",", "\<\"RESCELGENE\"\>", ",", "\<\"RESFORDMOTOR\"\>", 
   ",", "\<\"RESWILLIAMS\"\>", ",", "\<\"RESELECTRONICART\"\>", 
   ",", "\<\"RESSCHLUMBERGER\"\>", ",", "\<\"RESNEWMONTMINING\"\>", 
   ",", "\<\"RESAUTODESK\"\>", ",", "\<\"RESMOSAIC\"\>", 
   ",", "\<\"RESGENERALELECTR\"\>", ",", "\<\"RESHESS\"\>", 
   ",", "\<\"RESCADENCEDESIGN\"\>", ",", "\<\"RESCERNER\"\>", 
   ",", "\<\"RESHELMERICHPAYN\"\>", ",", "\<\"RESEOGRES\"\>", 
   ",", "\<\"RESAPACHE\"\>", ",", "\<\"RESBESTBUY\"\>", 
   ",", "\<\"RESDEVONENERGY\"\>", ",", "\<\"RESCONOCOPHILLIP\"\>", 
   ",", "\<\"RESWALTDISNEY\"\>", ",", "\<\"RESADARKOPETROLE\"\>", 
   ",", "\<\"RESCOMCASTA\"\>", ",", "\<\"RESAMERICANEXPRE\"\>", 
   ",", "\<\"RESCABOTOILGASA\"\>", ",", "\<\"RESNOBLEENERGY\"\>", 
   ",", "\<\"RESVALEROENERGY\"\>", ",", "\<\"RESPERKINELMER\"\>", 
   ",", "\<\"RESPEOPLESUNITED\"\>", ",", "\<\"RESCHEVRON\"\>", 
   ",", "\<\"RESATT\"\>", ",", "\<\"RESHOLOGIC\"\>", 
   ",", "\<\"RESSIGNETJEWELER\"\>", ",", "\<\"RESGAP\"\>", 
   ",", "\<\"RESEXXONMOBIL\"\>", ",", "\<\"RESHARRIS\"\>", 
   ",", "\<\"RESHUMA\"\>", ",", "\<\"RESMGMRESORTSINT\"\>", 
   ",", "\<\"RESWALMART\"\>", ",", "\<\"RESVERIZONCOMMUN\"\>", 
   ",", "\<\"RESEQT\"\>", ",", "\<\"RESNUCOR\"\>", 
   ",", "\<\"RESOCCIDENTALPTL\"\>", ",", "\<\"RESRAYMONDJAMESF\"\>", 
   ",", "\<\"RESPFIZER\"\>", ",", "\<\"RESZIONSBANCORP\"\>", 
   ",", "\<\"RESBANKOFNEWYORK\"\>", ",", "\<\"RESWELLSFARGOCO\"\>", 
   ",", "\<\"RESCENTURYLINK\"\>", ",", "\<\"RESCOOPERCOS\"\>", 
   ",", "\<\"RESLEUCADIATIOL\"\>", ",", "\<\"RESBRISTOLMYERSS\"\>", 
   ",", "\<\"RESKEYCORP\"\>", ",", "\<\"RESCOMERICA\"\>", 
   ",", "\<\"RESTIFFANYCO\"\>", ",", "\<\"RESNORTHERNTRUST\"\>", 
   ",", "\<\"RESTARGET\"\>", ",", "\<\"RESSOUTHWESTAIRL\"\>", 
   ",", "\<\"RESTHERMOFISHERS\"\>", ",", "\<\"RESHARLEYDAVIDSO\"\>", 
   ",", "\<\"RESUNIVERSALHEAL\"\>", ",", "\<\"RESAMERICANINTLG\"\>", 
   ",", "\<\"RESLABORATORYCOR\"\>", ",", "\<\"RESFOOTLOCKER\"\>", 
   ",", "\<\"RESKANSASCITYSOU\"\>", ",", "\<\"RESHRBLOCK\"\>", 
   ",", "\<\"RESROBERTHALFINT\"\>", ",", "\<\"RESSUNTRUSTBANKS\"\>", 
   ",", "\<\"RESOMNICOMGROUP\"\>", ",", "\<\"RESAET\"\>", 
   ",", "\<\"RESHOMEDEPOT\"\>", ",", "\<\"RESNORDSTROM\"\>", 
   ",", "\<\"RESHUNTJBTRANSPO\"\>", ",", "\<\"RESPNCFINLSVSGP\"\>", 
   ",", "\<\"RESSTATESTREET\"\>", ",", "\<\"RESINTERPUBLICGR\"\>", 
   ",", "\<\"RESARCHERDANLSMI\"\>", ",", "\<\"RESABBOTTLABORAT\"\>", 
   ",", "\<\"RESFLOWSERVE\"\>", ",", "\<\"RESPAYCHEX\"\>", 
   ",", "\<\"RESUSBANCORP\"\>", ",", "\<\"RESVARIANMEDICAL\"\>", 
   ",", "\<\"RESMARSHMCLENN\"\>", ",", "\<\"RESFRANKLINRESOU\"\>", 
   ",", "\<\"RESALASKAAIRGROU\"\>", ",", "\<\"RESCARNIVAL\"\>", 
   ",", "\<\"RESTROWEPRICEGRO\"\>", ",", "\<\"RESCSX\"\>", 
   ",", "\<\"RESGOODYEARTIRER\"\>", ",", "\<\"RESKROGER\"\>", 
   ",", "\<\"RESPVH\"\>", ",", "\<\"RESLINCOLNTIOL\"\>", 
   ",", "\<\"RESREGIONSFINLNE\"\>", ",", "\<\"RESELILILLY\"\>", 
   ",", "\<\"RESBOEING\"\>", ",", "\<\"RESMERCKCOMPANY\"\>", 
   ",", "\<\"RESNIKEB\"\>", ",", "\<\"RESMATTEL\"\>", 
   ",", "\<\"RESFASTEL\"\>", ",", "\<\"RESEXPEDITORINTL\"\>", 
   ",", "\<\"RESLENRA\"\>", ",", "\<\"RESJACOBSENGR\"\>", 
   ",", "\<\"RESCATERPILLAR\"\>", ",", "\<\"RESCIG\"\>", 
   ",", "\<\"RESBBT\"\>", ",", "\<\"RESONEOK\"\>", 
   ",", "\<\"RESUNITEDHEALTHG\"\>", ",", "\<\"RESHASBRO\"\>", 
   ",", "\<\"RESFISERV\"\>", ",", "\<\"RESDEERE\"\>", ",", "\<\"RESFMC\"\>", 
   ",", "\<\"RESFIFTHTHIRDBAN\"\>", ",", "\<\"RESTYSONFOODSA\"\>", 
   ",", "\<\"RESINTERTIOLPAPE\"\>", ",", "\<\"RESTJX\"\>", 
   ",", "\<\"RESJOHNSONJOHNSO\"\>", ",", "\<\"RESARTHURJGALLAG\"\>", 
   ",", "\<\"RESEMERSONELECTR\"\>", ",", "\<\"RESMTBANK\"\>", 
   ",", "\<\"RESBAXTERINTL\"\>", ",", "\<\"RESCUMMINS\"\>", 
   ",", "\<\"RESTOTALSYSTEMSE\"\>", ",", "\<\"RESBECTONDICKINS\"\>", 
   ",", "\<\"RESFEDEX\"\>", ",", "\<\"RESCINTAS\"\>", 
   ",", "\<\"RESCVSHEALTH\"\>", ",", "\<\"RESMOLSONCOORSBR\"\>", 
   ",", "\<\"RESROCKWELLAUTOM\"\>", ",", "\<\"RESPULTEGROUP\"\>", 
   ",", "\<\"RESHUNTINGTONBCS\"\>", ",", "\<\"RESALTRIAGROUP\"\>", 
   ",", "\<\"RESDOVER\"\>", ",", "\<\"RESWEYERHAEUSER\"\>", 
   ",", "\<\"RESROSSSTORES\"\>", ",", "\<\"RESUNUMGROUP\"\>", 
   ",", "\<\"RESAONCLASSA\"\>", ",", "\<\"RESWWGRAINGER\"\>", 
   ",", "\<\"RESMCDOLDS\"\>", ",", "\<\"RESLOWESCOMPANIE\"\>", 
   ",", "\<\"RESSMITH\"\>", ",", "\<\"RESCARDILHEALTH\"\>", 
   ",", "\<\"RESDAHER\"\>", ",", "\<\"RESAMETEK\"\>", 
   ",", "\<\"RESPACCAR\"\>", ",", "\<\"RESSTRYKER\"\>", 
   ",", "\<\"RESUNIONPACIFIC\"\>", ",", "\<\"RESPROCTERGAMBLE\"\>", 
   ",", "\<\"RESPARKERHANNIFI\"\>", ",", "\<\"RESGENERALDYMICS\"\>", 
   ",", "\<\"RESBALL\"\>", ",", "\<\"RESCONSTELLATION\"\>", 
   ",", "\<\"RESAUTOMATICDATA\"\>", ",", "\<\"RESLOEWS\"\>", 
   ",", "\<\"RESNORFOLKSOUTHE\"\>", ",", "\<\"RESUNITEDTECHNOL\"\>", 
   ",", "\<\"RESCOCACOLA\"\>", ",", "\<\"RESPROGRESSIVEOH\"\>", 
   ",", "\<\"RESPEPSICO\"\>", ",", "\<\"RESMASCO\"\>", 
   ",", "\<\"RESTRAVELERSCOS\"\>", ",", "\<\"RESRAYTHEONB\"\>", 
   ",", "\<\"RESVULCANMATERIA\"\>", ",", "\<\"RESHONEYWELLINTL\"\>", 
   ",", "\<\"RESNORTHROPGRUMM\"\>", ",", "\<\"RESAVERYDENNISON\"\>", 
   ",", "\<\"RESWASTEMAGEMENT\"\>", ",", "\<\"RESWHIRLPOOL\"\>", 
   ",", "\<\"RESEQUIFAX\"\>", ",", "\<\"RESJMSMUCKER\"\>", 
   ",", "\<\"RESPPGINDUSTRIES\"\>", ",", "\<\"RESCOGRABRANDS\"\>", 
   ",", "\<\"RESILLINOISTOOLW\"\>", ",", "\<\"RESAFLAC\"\>", 
   ",", "\<\"RESCHURCHDWIGHTC\"\>", ",", "\<\"RESVF\"\>", 
   ",", "\<\"RESSHERWINWILLIA\"\>", ",", "\<\"RESECOLAB\"\>", 
   ",", "\<\"RESAIRPRDSCHEMS\"\>", ",", "\<\"RESTEXTRON\"\>", 
   ",", "\<\"RESSYSCO\"\>", ",", "\<\"RESTORCHMARK\"\>", 
   ",", "\<\"RESNEWELLBRANDS\"\>", ",", "\<\"RESHOSTHOTELSRES\"\>", 
   ",", "\<\"RESCOLGATEPALM\"\>", ",", "\<\"RESSEALEDAIR\"\>", 
   ",", "\<\"RESHCP\"\>", ",", "\<\"RESSPON\"\>", 
   ",", "\<\"RESCAMPBELLSOUP\"\>", ",", "\<\"RESHORMELFOODS\"\>", 
   ",", "\<\"RESVENTAS\"\>", ",", "\<\"RESINTLFLAVORSFR\"\>", 
   ",", "\<\"RESGENERALMILLS\"\>", ",", "\<\"RESLEGGETTPLATT\"\>", 
   ",", "\<\"RESUDR\"\>", ",", "\<\"RESKIMBERLYCLARK\"\>", 
   ",", "\<\"RESCLOROX\"\>", ",", "\<\"RESTHREEM\"\>", 
   ",", "\<\"RESCINCINTIFINL\"\>", ",", "\<\"RESHERSHEY\"\>", 
   ",", "\<\"RESBROWNFORMANB\"\>", ",", "\<\"RESGENUINEPARTS\"\>", 
   ",", "\<\"RESMCCORMICKCOMP\"\>", ",", "\<\"RESFEDERALREALTY\"\>", 
   ",", "\<\"RESSTANLEYBLACKD\"\>", ",", "\<\"RESEXELON\"\>", 
   ",", "\<\"RESPGE\"\>", ",", "\<\"RESKELLOGG\"\>", 
   ",", "\<\"RESVORDOREALTYTR\"\>", ",", "\<\"RESFIRSTENERGY\"\>", 
   ",", "\<\"RESPUBLICSTORAGE\"\>", ",", "\<\"RESDUKEREALTY\"\>", 
   ",", "\<\"RESCENTERPOINTEN\"\>", ",", "\<\"RESSEMPRAEN\"\>", 
   ",", "\<\"RESPPL\"\>", ",", "\<\"RESCMSENERGY\"\>", 
   ",", "\<\"RESEDISONINTL\"\>", ",", "\<\"RESNISOURCE\"\>", 
   ",", "\<\"RESENTERGY\"\>", ",", "\<\"RESSOUTHERN\"\>", 
   ",", "\<\"RESPUBSERENTERGP\"\>", ",", "\<\"RESDOMINIONENERG\"\>", 
   ",", "\<\"RESALLIANTENERGY\"\>", ",", "\<\"RESSCA\"\>", 
   ",", "\<\"RESDTEENERGY\"\>", ",", "\<\"RESNEXTERAENERGY\"\>", 
   ",", "\<\"RESXCELENERGY\"\>", ",", "\<\"RESPINCLEWESTCAP\"\>", 
   ",", "\<\"RESCONSOLIDATEDE\"\>", ",", "\<\"RESAMERELECPWR\"\>", 
   ",", "\<\"RESAMEREN\"\>"}], "}"}]], "Output",
 CellChangeTimes->{{3.731240359018154*^9, 
  3.7312403914406013`*^9}},ExpressionUUID->"df5e7b17-6424-4a5b-85d9-\
a01be6954821"]
}, Open  ]]
},
WindowSize->{1902, 997},
WindowMargins->{{Automatic, -2}, {Automatic, 20}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
Magnification->1.5,
FrontEndVersion->"11.3 for Microsoft Windows (64-bit) (March 6, 2018)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[400, 13, 556, 11, 62, "Input",ExpressionUUID->"fa5d429c-70c6-409b-a230-cddc787bcc5b"],
Cell[959, 26, 121100, 2413, 4274, "Input",ExpressionUUID->"d1302ae8-5c93-43a8-b104-343c603cad4d"],
Cell[122062, 2441, 330, 9, 62, "Input",ExpressionUUID->"3266c4b9-52f9-4640-bdbd-52d666a17f6b"],
Cell[122395, 2452, 16136, 229, 131, "Input",ExpressionUUID->"e2fd5311-40b5-4f37-ab87-da852d4ce53b"],
Cell[CellGroupData[{
Cell[138556, 2685, 648, 11, 43, "Input",ExpressionUUID->"ba34f3b8-2848-4b41-bee9-f0211cb21015"],
Cell[139207, 2698, 530, 8, 49, "Output",ExpressionUUID->"627c1bdd-c9c1-4d69-8e3c-345d72c015dd"]
}, Open  ]],
Cell[CellGroupData[{
Cell[139774, 2711, 480, 9, 43, "Input",ExpressionUUID->"1a9bf7b5-6833-4612-8f9a-edfeb1e10d49"],
Cell[140257, 2722, 496, 7, 49, "Output",ExpressionUUID->"b39d71da-0e8d-4a2e-aec8-2c43e0febdbc"]
}, Open  ]],
Cell[140768, 2732, 456, 11, 62, "Input",ExpressionUUID->"a7d95242-2d30-4c6f-8663-1a4b5f7d530d"],
Cell[141227, 2745, 3881, 62, 102, "Input",ExpressionUUID->"0d1b0676-d65a-4f9e-be10-146fd3b5a533"],
Cell[CellGroupData[{
Cell[145133, 2811, 340, 8, 43, "Input",ExpressionUUID->"d0bdc0e3-2d19-48e0-8544-c8d18b333174"],
Cell[145476, 2821, 558, 11, 49, "Output",ExpressionUUID->"d4955893-d97f-4611-b574-789e4d025182"]
}, Open  ]],
Cell[146049, 2835, 744, 22, 43, "Input",ExpressionUUID->"477961e3-ad19-4b7c-b195-fa30d4d4c554"],
Cell[146796, 2859, 2092, 50, 131, "Input",ExpressionUUID->"2cc748ed-2da1-4506-8f88-1705be46c759"],
Cell[CellGroupData[{
Cell[148913, 2913, 1012, 26, 81, "Input",ExpressionUUID->"0f3cbf56-debd-4a6b-8c1a-af7c0595b725"],
Cell[149928, 2941, 11212, 225, 408, "Output",ExpressionUUID->"0e4f0a7b-42d9-4dd4-907d-de05f512c904"]
}, Open  ]],
Cell[CellGroupData[{
Cell[161177, 3171, 685, 16, 73, "Input",ExpressionUUID->"9e908fdc-5783-4d80-a6cd-51d2890ba76f"],
Cell[161865, 3189, 281, 7, 49, "Output",ExpressionUUID->"2afc1f2f-6367-4d1d-bd48-db8c26a5e4a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[162183, 3201, 1320, 33, 81, "Input",ExpressionUUID->"751ee630-7eef-4426-a6a6-63c9d227d0aa"],
Cell[163506, 3236, 25704, 499, 411, "Output",ExpressionUUID->"f1d41ceb-8b08-44ac-86cb-723fc24dcd1a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[189247, 3740, 244, 6, 43, "Input",ExpressionUUID->"edd83e42-8b98-4712-a93a-3cafe5c234df"],
Cell[189494, 3748, 8226, 131, 775, "Output",ExpressionUUID->"df5e7b17-6424-4a5b-85d9-a01be6954821"]
}, Open  ]]
}
]
*)

