% Matteo Picchio
% Ancona 30/03/2017
                                   
function[NL, g, H]=function_f(b,n,kx1,X1,X2,X3,cens1,cens2,cens3,sam2,sam3,dur1_1,dur1_2,dur1_3,dur1_4,dur1_5,dur1_6,dur1_7,...
                                  dur2_1,dur2_2,dur2_3,dur2_4,dur2_5,dur2_6,dur3_1,dur3_2,dur3_3,W3,lab_ear3,kw3,W6,lab_ear6,samw6,...
                                  W9,lab_ear9,samw9,W12,lab_ear12,samw12,W15,lab_ear15,samw15,W18,lab_ear18,samw18,W21,lab_ear21,samw21,...
                                  Ze,Zs,kze,kzs,nsib,emp_1,totday3,totday6,totday9,totday12,totday15,totday18,totday21)
                              
% [g_b]=createFullGradients(b);

save('results\b.mat','b')

%--------------------------------------------------------------------------
%1.1 Assign b to UH parameters
%--------------------------------------------------------------------------
lam1=b(1,1);
lam2=b(2,1);
lam3=b(3,1);
lam4=b(4,1);
lam5=b(5,1);
lam6=b(6,1);
lam7=b(7,1);
lam8=b(8,1);
lam9=b(9,1);
kh=9;

%PROBABILITY MASSES
Elam=1+exp(lam1)+exp(lam2)+exp(lam3)+exp(lam4)+exp(lam5)+exp(lam6)+exp(lam7)+exp(lam8)+exp(lam9);
P1  = exp(lam1)./Elam;
P2  = exp(lam2)./Elam;
P3  = exp(lam3)./Elam;
P4  = exp(lam4)./Elam;
P5  = exp(lam5)./Elam;
P6  = exp(lam6)./Elam;
P7  = exp(lam7)./Elam;
P8  = exp(lam8)./Elam;
P9  = exp(lam9)./Elam;
P10 =         1./Elam;

lf1   = b(kh+1,1);
lf2   = b(kh+2,1);
lf3   = b(kh+3,1);
elf   = b(kh+4,1);
slf   = b(kh+5,1);
lw6   = b(kh+6,1);
lw9   = b(kh+7,1);
lw12  = b(kh+8,1);
lw15  = b(kh+9,1);
lw18  = b(kh+10,1);
lw21  = b(kh+11,1);
lE3   = b(kh+12,1);
lE6   = b(kh+13,1);
lE9   = b(kh+14,1);
lE12  = b(kh+15,1);
lE15  = b(kh+16,1);
lE18  = b(kh+17,1);
lE21  = b(kh+18,1);
kh  = kh+18;

c_2  = b(kh+1,1);
c_3  = b(kh+2,1);
c_4  = b(kh+3,1);
c_5  = b(kh+4,1);
c_6  = b(kh+5,1);
c_7  = b(kh+6,1);
c_8  = b(kh+7,1);
c_9  = b(kh+8,1);
c_10 = b(kh+9,1);
kh  = kh+9;

%--------------------------------------------------------------------------
%1.1 Assign b to 1st childbirth equation
%--------------------------------------------------------------------------
    bX1 = b(kh+1:kh+kx1,1);
    va1_1 = b(kh+kx1+1,1);
    va2_1 = va1_1+exp(b(kh+kx1+2,1));
    va3_1 = va2_1+exp(b(kh+kx1+3,1));
    va4_1 = va3_1+exp(b(kh+kx1+4,1));
    va5_1 = va4_1+exp(b(kh+kx1+5,1));
    va6_1 = va5_1+exp(b(kh+kx1+6,1));
    va7_1 = va6_1+exp(b(kh+kx1+7,1));
    va1_2 = va1_1 + lf1.*c_2;
    va2_2 = va2_1 + lf1.*c_2.*lw6;
    va3_2 = va3_1 + lf1.*c_2.*lw9;
    va4_2 = va4_1 + lf1.*c_2.*lw12;
    va5_2 = va5_1 + lf1.*c_2.*lw15;
    va6_2 = va6_1 + lf1.*c_2.*lw18;
    va7_2 = va7_1 + lf1.*c_2.*lw21;    
    va1_3 = va1_1 + lf1.*c_3;
    va2_3 = va2_1 + lf1.*c_3.*lw6;
    va3_3 = va3_1 + lf1.*c_3.*lw9;
    va4_3 = va4_1 + lf1.*c_3.*lw12;
    va5_3 = va5_1 + lf1.*c_3.*lw15;
    va6_3 = va6_1 + lf1.*c_3.*lw18;
    va7_3 = va7_1 + lf1.*c_3.*lw21;    
    va1_4 = va1_1 + lf1.*c_4;
    va2_4 = va2_1 + lf1.*c_4.*lw6;
    va3_4 = va3_1 + lf1.*c_4.*lw9;
    va4_4 = va4_1 + lf1.*c_4.*lw12;
    va5_4 = va5_1 + lf1.*c_4.*lw15;
    va6_4 = va6_1 + lf1.*c_4.*lw18;
    va7_4 = va7_1 + lf1.*c_4.*lw21;    
    va1_5 = va1_1 + lf1.*c_5;
    va2_5 = va2_1 + lf1.*c_5.*lw6;
    va3_5 = va3_1 + lf1.*c_5.*lw9;
    va4_5 = va4_1 + lf1.*c_5.*lw12;
    va5_5 = va5_1 + lf1.*c_5.*lw15;
    va6_5 = va6_1 + lf1.*c_5.*lw18;
    va7_5 = va7_1 + lf1.*c_5.*lw21;    
    va1_6 = va1_1 + lf1.*c_6;
    va2_6 = va2_1 + lf1.*c_6.*lw6;
    va3_6 = va3_1 + lf1.*c_6.*lw9;
    va4_6 = va4_1 + lf1.*c_6.*lw12;
    va5_6 = va5_1 + lf1.*c_6.*lw15;
    va6_6 = va6_1 + lf1.*c_6.*lw18;
    va7_6 = va7_1 + lf1.*c_6.*lw21;    
    va1_7 = va1_1 + lf1.*c_7;
    va2_7 = va2_1 + lf1.*c_7.*lw6;
    va3_7 = va3_1 + lf1.*c_7.*lw9;
    va4_7 = va4_1 + lf1.*c_7.*lw12;
    va5_7 = va5_1 + lf1.*c_7.*lw15;
    va6_7 = va6_1 + lf1.*c_7.*lw18;
    va7_7 = va7_1 + lf1.*c_7.*lw21;    
    va1_8 = va1_1 + lf1.*c_8;
    va2_8 = va2_1 + lf1.*c_8.*lw6;
    va3_8 = va3_1 + lf1.*c_8.*lw9;
    va4_8 = va4_1 + lf1.*c_8.*lw12;
    va5_8 = va5_1 + lf1.*c_8.*lw15;
    va6_8 = va6_1 + lf1.*c_8.*lw18;
    va7_8 = va7_1 + lf1.*c_8.*lw21;    
    va1_9 = va1_1 + lf1.*c_9;
    va2_9 = va2_1 + lf1.*c_9.*lw6;
    va3_9 = va3_1 + lf1.*c_9.*lw9;
    va4_9 = va4_1 + lf1.*c_9.*lw12;
    va5_9 = va5_1 + lf1.*c_9.*lw15;
    va6_9 = va6_1 + lf1.*c_9.*lw18;
    va7_9 = va7_1 + lf1.*c_9.*lw21;    
    va1_10 = va1_1 + lf1.*c_10;
    va2_10 = va2_1 + lf1.*c_10.*lw6;
    va3_10 = va3_1 + lf1.*c_10.*lw9;
    va4_10 = va4_1 + lf1.*c_10.*lw12;
    va5_10 = va5_1 + lf1.*c_10.*lw15;
    va6_10 = va6_1 + lf1.*c_10.*lw18;
    va7_10 = va7_1 + lf1.*c_10.*lw21;
    kh  = kh+kx1+7;    
%--------------------------------------------------------------------------
%1.2 Assign b to 2nd childbirth equation
%--------------------------------------------------------------------------
    bX2 = [b(kh+1:kh+2,1); bX1];
    vb1_1 = b(kh+3,1);
    vb2_1 = vb1_1+exp(b(kh+4,1));
    vb3_1 = vb2_1+exp(b(kh+5,1));
    vb4_1 = vb3_1+exp(b(kh+6,1));
    vb5_1 = vb4_1+exp(b(kh+7,1));
    vb6_1 = vb5_1+exp(b(kh+8,1));
    vb1_2 = vb1_1 + lf2.*c_2;
    vb2_2 = vb2_1 + lf2.*c_2.*lw9;
    vb3_2 = vb3_1 + lf2.*c_2.*lw12;
    vb4_2 = vb4_1 + lf2.*c_2.*lw15;
    vb5_2 = vb5_1 + lf2.*c_2.*lw18;
    vb6_2 = vb6_1 + lf2.*c_2.*lw21;
    vb1_3 = vb1_1 + lf2.*c_3;
    vb2_3 = vb2_1 + lf2.*c_3.*lw9;
    vb3_3 = vb3_1 + lf2.*c_3.*lw12;
    vb4_3 = vb4_1 + lf2.*c_3.*lw15;
    vb5_3 = vb5_1 + lf2.*c_3.*lw18;
    vb6_3 = vb6_1 + lf2.*c_3.*lw21;
    vb1_4 = vb1_1 + lf2.*c_4;
    vb2_4 = vb2_1 + lf2.*c_4.*lw9;
    vb3_4 = vb3_1 + lf2.*c_4.*lw12;
    vb4_4 = vb4_1 + lf2.*c_4.*lw15;
    vb5_4 = vb5_1 + lf2.*c_4.*lw18;
    vb6_4 = vb6_1 + lf2.*c_4.*lw21;
    vb1_5 = vb1_1 + lf2.*c_5;
    vb2_5 = vb2_1 + lf2.*c_5.*lw9;
    vb3_5 = vb3_1 + lf2.*c_5.*lw12;
    vb4_5 = vb4_1 + lf2.*c_5.*lw15;
    vb5_5 = vb5_1 + lf2.*c_5.*lw18;
    vb6_5 = vb6_1 + lf2.*c_5.*lw21;
    vb1_6 = vb1_1 + lf2.*c_6;
    vb2_6 = vb2_1 + lf2.*c_6.*lw9;
    vb3_6 = vb3_1 + lf2.*c_6.*lw12;
    vb4_6 = vb4_1 + lf2.*c_6.*lw15;
    vb5_6 = vb5_1 + lf2.*c_6.*lw18;
    vb6_6 = vb6_1 + lf2.*c_6.*lw21;
    vb1_7 = vb1_1 + lf2.*c_7;
    vb2_7 = vb2_1 + lf2.*c_7.*lw9;
    vb3_7 = vb3_1 + lf2.*c_7.*lw12;
    vb4_7 = vb4_1 + lf2.*c_7.*lw15;
    vb5_7 = vb5_1 + lf2.*c_7.*lw18;
    vb6_7 = vb6_1 + lf2.*c_7.*lw21;
    vb1_8 = vb1_1 + lf2.*c_8;
    vb2_8 = vb2_1 + lf2.*c_8.*lw9;
    vb3_8 = vb3_1 + lf2.*c_8.*lw12;
    vb4_8 = vb4_1 + lf2.*c_8.*lw15;
    vb5_8 = vb5_1 + lf2.*c_8.*lw18;
    vb6_8 = vb6_1 + lf2.*c_8.*lw21;
    vb1_9 = vb1_1 + lf2.*c_9;
    vb2_9 = vb2_1 + lf2.*c_9.*lw9;
    vb3_9 = vb3_1 + lf2.*c_9.*lw12;
    vb4_9 = vb4_1 + lf2.*c_9.*lw15;
    vb5_9 = vb5_1 + lf2.*c_9.*lw18;
    vb6_9 = vb6_1 + lf2.*c_9.*lw21;
    vb1_10 = vb1_1 + lf2.*c_10;
    vb2_10 = vb2_1 + lf2.*c_10.*lw9;
    vb3_10 = vb3_1 + lf2.*c_10.*lw12;
    vb4_10 = vb4_1 + lf2.*c_10.*lw15;
    vb5_10 = vb5_1 + lf2.*c_10.*lw18;
    vb6_10 = vb6_1 + lf2.*c_10.*lw21;

    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.3 Assign b to 3rd childbirth equation
%--------------------------------------------------------------------------
    bX3 = [b(kh+1:kh+3,1); bX1];
    vc1_1 = b(kh+4,1);
    vc2_1 = vc1_1+exp(b(kh+5,1));
    vc3_1 = vc2_1+exp(b(kh+6,1));
    vc1_2 = vc1_1 + lf3.*c_2;
    vc2_2 = vc2_1 + lf3.*c_2.*lw15;
    vc3_2 = vc3_1 + lf3.*c_2.*lw18;
    vc1_3 = vc1_1 + lf3.*c_3;
    vc2_3 = vc2_1 + lf3.*c_3.*lw15;
    vc3_3 = vc3_1 + lf3.*c_3.*lw18;
    vc1_4 = vc1_1 + lf3.*c_4;
    vc2_4 = vc2_1 + lf3.*c_4.*lw15;
    vc3_4 = vc3_1 + lf3.*c_4.*lw18;
    vc1_5 = vc1_1 + lf3.*c_5;
    vc2_5 = vc2_1 + lf3.*c_5.*lw15;
    vc3_5 = vc3_1 + lf3.*c_5.*lw18;
    vc1_6 = vc1_1 + lf3.*c_6;
    vc2_6 = vc2_1 + lf3.*c_6.*lw15;
    vc3_6 = vc3_1 + lf3.*c_6.*lw18;
    vc1_7 = vc1_1 + lf3.*c_7;
    vc2_7 = vc2_1 + lf3.*c_7.*lw15;
    vc3_7 = vc3_1 + lf3.*c_7.*lw18;
    vc1_8 = vc1_1 + lf3.*c_8;
    vc2_8 = vc2_1 + lf3.*c_8.*lw15;
    vc3_8 = vc3_1 + lf3.*c_8.*lw18;
    vc1_9 = vc1_1 + lf3.*c_9;
    vc2_9 = vc2_1 + lf3.*c_9.*lw15;
    vc3_9 = vc3_1 + lf3.*c_9.*lw18;
    vc1_10 = vc1_1 + lf3.*c_10;
    vc2_10 = vc2_1 + lf3.*c_10.*lw15;
    vc3_10 = vc3_1 + lf3.*c_10.*lw18;

    kh  = kh+6;    
%--------------------------------------------------------------------------
%1.4 Assign b to earnings equation 3 years after diploma
%--------------------------------------------------------------------------
    bW3 = [b(kh+1,1); b(kh+1,1); b(kh+1,1); b(kh+2:kh+kw3-2,1)];
    vw3_1 = b(kh+kw3-2+1,1);
    vw3_2 = vw3_1 + c_2;
    vw3_3 = vw3_1 + c_3;
    vw3_4 = vw3_1 + c_4;
    vw3_5 = vw3_1 + c_5;
    vw3_6 = vw3_1 + c_6;
    vw3_7 = vw3_1 + c_7;
    vw3_8 = vw3_1 + c_8;
    vw3_9 = vw3_1 + c_9;
    vw3_10 = vw3_1 + c_10;
    sig3 = b(kh+kw3-2+2,1);
    kh  = kh+kw3-2+2;    
%--------------------------------------------------------------------------
%1.5 Assign b to earnings equation 6 years after diploma
%--------------------------------------------------------------------------
    bW6   = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); bW3(4:kw3)];
    vw6_1 = b(kh+4,1);
    vw6_2 = vw6_1 + lw6.*c_2;
    vw6_3 = vw6_1 + lw6.*c_3;
    vw6_4 = vw6_1 + lw6.*c_4;
    vw6_5 = vw6_1 + lw6.*c_5;
    vw6_6 = vw6_1 + lw6.*c_6;
    vw6_7 = vw6_1 + lw6.*c_7;
    vw6_8 = vw6_1 + lw6.*c_8;
    vw6_9 = vw6_1 + lw6.*c_9;
    vw6_10 = vw6_1 + lw6.*c_10;    
    sig6  = b(kh+5,1);
    kh  = kh+5;    
%--------------------------------------------------------------------------
%1.6 Assign b to earnings equation 9 years after diploma
%--------------------------------------------------------------------------
    bW9   = [b(kh+1,1); b(kh+2,1); b(kh+3,1);... %timing to 1st kid 3-years intervals
             b(kh+4,1); b(kh+4,1); b(kh+5,1);... %timing to 2nd kid 3-years intervals
             b(kh+6,1); b(kh+6,1); b(kh+6,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw9_1 = b(kh+7,1);
    vw9_2 = vw9_1 + lw9.*c_2;
    vw9_3 = vw9_1 + lw9.*c_3;
    vw9_4 = vw9_1 + lw9.*c_4;
    vw9_5 = vw9_1 + lw9.*c_5;
    vw9_6 = vw9_1 + lw9.*c_6;
    vw9_7 = vw9_1 + lw9.*c_7;
    vw9_8 = vw9_1 + lw9.*c_8;
    vw9_9 = vw9_1 + lw9.*c_9;
    vw9_10 = vw9_1 + lw9.*c_10;

    sig9  = b(kh+8,1);
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.7 Assign b to earnings equation 12 years after diploma
%--------------------------------------------------------------------------
    bW12  = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+4,1);... %timing to 1st kid 3-years intervals
             b(kh+5,1); b(kh+5,1); b(kh+6,1); b(kh+7,1);... %timing to 2nd kid 3-years intervals
             b(kh+8,1); b(kh+8,1); b(kh+8,1); b(kh+8,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw12_1= b(kh+9,1);
    vw12_2 = vw12_1 + lw12.*c_2;
    vw12_3 = vw12_1 + lw12.*c_3;
    vw12_4 = vw12_1 + lw12.*c_4;
    vw12_5 = vw12_1 + lw12.*c_5;
    vw12_6 = vw12_1 + lw12.*c_6;
    vw12_7 = vw12_1 + lw12.*c_7;
    vw12_8 = vw12_1 + lw12.*c_8;
    vw12_9 = vw12_1 + lw12.*c_9;
    vw12_10 = vw12_1 + lw12.*c_10;

    sig12 = b(kh+10,1);
    kh  = kh+10;
%--------------------------------------------------------------------------
%1.8 Assign b to earnings equation 15 years after diploma
%--------------------------------------------------------------------------
    bW15  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1);... %timing to 1st kid 3-years intervals
             b(kh+6,1);  b(kh+6,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);... %timing to 2nd kid 3-years intervals
             b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+11,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw15_1= b(kh+12,1);
    vw15_2 = vw15_1 + lw15.*c_2;
    vw15_3 = vw15_1 + lw15.*c_3;
    vw15_4 = vw15_1 + lw15.*c_4;
    vw15_5 = vw15_1 + lw15.*c_5;
    vw15_6 = vw15_1 + lw15.*c_6;
    vw15_7 = vw15_1 + lw15.*c_7;
    vw15_8 = vw15_1 + lw15.*c_8;
    vw15_9 = vw15_1 + lw15.*c_9;
    vw15_10 = vw15_1 + lw15.*c_10;
    sig15 = b(kh+13,1);
    kh  = kh+13;    
%--------------------------------------------------------------------------
%1.9 Assign b to earnings equation 18 years after diploma
%--------------------------------------------------------------------------
    bW18  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1) ;... %timing to 1st kid 3-years intervals
             b(kh+7,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1);... %timing to 2nd kid 3-years intervals
             b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+13,1); b(kh+14,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw18_1= b(kh+15,1);
    vw18_2 = vw18_1 + lw18.*c_2;
    vw18_3 = vw18_1 + lw18.*c_3;
    vw18_4 = vw18_1 + lw18.*c_4;
    vw18_5 = vw18_1 + lw18.*c_5;
    vw18_6 = vw18_1 + lw18.*c_6;
    vw18_7 = vw18_1 + lw18.*c_7;
    vw18_8 = vw18_1 + lw18.*c_8;
    vw18_9 = vw18_1 + lw18.*c_9;
    vw18_10 = vw18_1 + lw18.*c_10;

    sig18 = b(kh+16,1);
    kh  = kh+16;    
%--------------------------------------------------------------------------
%1.10 Assign b to earnings equation 21 years after diploma
%--------------------------------------------------------------------------
    bW21  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1);  b(kh+7,1) ;... %timing to 1st kid 3-years intervals
             b(kh+8,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1); b(kh+12,1); b(kh+13,1);... %timing to 2nd kid 3-years intervals
             b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+15,1); b(kh+16,1); b(kh+16,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw21_1= b(kh+17,1);
    vw21_2 = vw21_1 + lw21.*c_2;
    vw21_3 = vw21_1 + lw21.*c_3;
    vw21_4 = vw21_1 + lw21.*c_4;
    vw21_5 = vw21_1 + lw21.*c_5;
    vw21_6 = vw21_1 + lw21.*c_6;
    vw21_7 = vw21_1 + lw21.*c_7;
    vw21_8 = vw21_1 + lw21.*c_8;
    vw21_9 = vw21_1 + lw21.*c_9;
    vw21_10 = vw21_1 + lw21.*c_10;

    sig21 = b(kh+18,1);
    kh  = kh+18;    
%--------------------------------------------------------------------------
%1.11 Assign b to earnings equation 1 year before diploma
%--------------------------------------------------------------------------
    bZe    = b(kh+1:kh+kze,1);
    vze_1  = b(kh+kze+1,1);
    vze_2  = vze_1 + elf.*c_2;
    vze_3  = vze_1 + elf.*c_3;
    vze_4  = vze_1 + elf.*c_4;
    vze_5  = vze_1 + elf.*c_5;
    vze_6  = vze_1 + elf.*c_6;
    vze_7  = vze_1 + elf.*c_7;
    vze_8  = vze_1 + elf.*c_8;
    vze_9  = vze_1 + elf.*c_9;
    vze_10  = vze_1 + elf.*c_10;

    kh    = kh+kze+1;    
%--------------------------------------------------------------------------
%1.12 Assign b to siblings when 14 years old
%--------------------------------------------------------------------------
    bZs    = b(kh+1:kh+kzs,1);
    vzs_1  = b(kh+kzs+1,1);
    vzs_2  = vzs_1 + slf.*c_2;
    vzs_3  = vzs_1 + slf.*c_3;
    vzs_4  = vzs_1 + slf.*c_4;
    vzs_5  = vzs_1 + slf.*c_5;
    vzs_6  = vzs_1 + slf.*c_6;
    vzs_7  = vzs_1 + slf.*c_7;
    vzs_8  = vzs_1 + slf.*c_8;
    vzs_9  = vzs_1 + slf.*c_9;
    vzs_10  = vzs_1 + slf.*c_10;

    sig_zs = b(kh+kzs+2,1);
    kh    = kh+kzs+2;    
   
%--------------------------------------------------------------------------
%1.13 Assign b to employment equation 3 years after diploma
%--------------------------------------------------------------------------
    bE3 = [b(kh+1,1); b(kh+1,1); b(kh+1,1); b(kh+2:kh+kw3-2,1)];
    ve3_1 = b(kh+kw3-2+1,1);
    ve3_2 = ve3_1 + c_2.*lE3;
    ve3_3 = ve3_1 + c_3.*lE3;
    ve3_4 = ve3_1 + c_4.*lE3;
    ve3_5 = ve3_1 + c_5.*lE3;
    ve3_6 = ve3_1 + c_6.*lE3;
    ve3_7 = ve3_1 + c_7.*lE3;
    ve3_8 = ve3_1 + c_8.*lE3;
    ve3_9 = ve3_1 + c_9.*lE3;
    ve3_10 = ve3_1 + c_10.*lE3;

    sigE3 = b(kh+kw3-2+2,1);
    kh  = kh+kw3-2+2;    
%--------------------------------------------------------------------------
%1.14 Assign b to employment equation 6 years after diploma
%--------------------------------------------------------------------------
    bE6   = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); bE3(4:kw3)];
    ve6_1 = b(kh+4,1);
    ve6_2 = ve6_1 + c_2.*lE6;
    ve6_3 = ve6_1 + c_3.*lE6;
    ve6_4 = ve6_1 + c_4.*lE6;
    ve6_5 = ve6_1 + c_5.*lE6;
    ve6_6 = ve6_1 + c_6.*lE6;
    ve6_7 = ve6_1 + c_7.*lE6;
    ve6_8 = ve6_1 + c_8.*lE6;
    ve6_9 = ve6_1 + c_9.*lE6;
    ve6_10 = ve6_1 + c_10.*lE6;

    sigE6  = b(kh+5,1);
    kh  = kh+5;    
%--------------------------------------------------------------------------
%1.15 Assign b to employment equation 9 years after diploma
%--------------------------------------------------------------------------
    bE9   = [b(kh+1,1); b(kh+2,1); b(kh+3,1);... %timing to 1st kid 3-years intervals
             b(kh+4,1); b(kh+4,1); b(kh+5,1);... %timing to 2nd kid 3-years intervals
             b(kh+6,1); b(kh+6,1); b(kh+6,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve9_1 = b(kh+7,1);
    ve9_2 = ve9_1 + c_2.*lE9;
    ve9_3 = ve9_1 + c_3.*lE9;
    ve9_4 = ve9_1 + c_4.*lE9;
    ve9_5 = ve9_1 + c_5.*lE9;
    ve9_6 = ve9_1 + c_6.*lE9;
    ve9_7 = ve9_1 + c_7.*lE9;
    ve9_8 = ve9_1 + c_8.*lE9;
    ve9_9 = ve9_1 + c_9.*lE9;
    ve9_10 = ve9_1 + c_10.*lE9;

    sigE9  = b(kh+8,1);
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.16 Assign b to employment equation 12 years after diploma
%--------------------------------------------------------------------------
    bE12  = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+4,1);... %timing to 1st kid 3-years intervals
             b(kh+5,1); b(kh+5,1); b(kh+6,1); b(kh+7,1);... %timing to 2nd kid 3-years intervals
             b(kh+8,1); b(kh+8,1); b(kh+8,1); b(kh+8,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve12_1= b(kh+9,1);
    ve12_2 = ve12_1 + c_2.*lE12;
    ve12_3 = ve12_1 + c_3.*lE12;
    ve12_4 = ve12_1 + c_4.*lE12;
    ve12_5 = ve12_1 + c_5.*lE12;
    ve12_6 = ve12_1 + c_6.*lE12;
    ve12_7 = ve12_1 + c_7.*lE12;
    ve12_8 = ve12_1 + c_8.*lE12;
    ve12_9 = ve12_1 + c_9.*lE12;
    ve12_10 = ve12_1 + c_10.*lE12;

    sigE12 = b(kh+10,1);
    kh  = kh+10;
%--------------------------------------------------------------------------
%1.17 Assign b to employment equation 15 years after diploma
%--------------------------------------------------------------------------
    bE15  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1);... %timing to 1st kid 3-years intervals
             b(kh+6,1);  b(kh+6,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);... %timing to 2nd kid 3-years intervals
             b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+11,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve15_1= b(kh+12,1);
    ve15_2 = ve15_1 + c_2.*lE15;
    ve15_3 = ve15_1 + c_3.*lE15;
    ve15_4 = ve15_1 + c_4.*lE15;
    ve15_5 = ve15_1 + c_5.*lE15;
    ve15_6 = ve15_1 + c_6.*lE15;
    ve15_7 = ve15_1 + c_7.*lE15;
    ve15_8 = ve15_1 + c_8.*lE15;
    ve15_9 = ve15_1 + c_9.*lE15;
    ve15_10 = ve15_1 + c_10.*lE15;

    sigE15 = b(kh+13,1);
    kh  = kh+13;    
%--------------------------------------------------------------------------
%1.18 Assign b to employment equation 18 years after diploma
%--------------------------------------------------------------------------
    bE18  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1) ;... %timing to 1st kid 3-years intervals
             b(kh+7,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1);... %timing to 2nd kid 3-years intervals
             b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+13,1); b(kh+14,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve18_1= b(kh+15,1);
    ve18_2 = ve18_1 + c_2.*lE18;
    ve18_3 = ve18_1 + c_3.*lE18;
    ve18_4 = ve18_1 + c_4.*lE18;
    ve18_5 = ve18_1 + c_5.*lE18;
    ve18_6 = ve18_1 + c_6.*lE18;
    ve18_7 = ve18_1 + c_7.*lE18;
    ve18_8 = ve18_1 + c_8.*lE18;
    ve18_9 = ve18_1 + c_9.*lE18;
    ve18_10 = ve18_1 + c_10.*lE18;

    sigE18 = b(kh+16,1);
    kh  = kh+16;    
%--------------------------------------------------------------------------
%1.19 Assign b to employment equation 21 years after diploma
%--------------------------------------------------------------------------
    bE21  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1);  b(kh+7,1) ;... %timing to 1st kid 3-years intervals
             b(kh+8,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1); b(kh+12,1); b(kh+13,1);... %timing to 2nd kid 3-years intervals
             b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+15,1); b(kh+16,1); b(kh+16,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve21_1= b(kh+17,1);
    ve21_2 = ve21_1 + c_2.*lE21;
    ve21_3 = ve21_1 + c_3.*lE21;
    ve21_4 = ve21_1 + c_4.*lE21;
    ve21_5 = ve21_1 + c_5.*lE21;
    ve21_6 = ve21_1 + c_6.*lE21;
    ve21_7 = ve21_1 + c_7.*lE21;
    ve21_8 = ve21_1 + c_8.*lE21;
    ve21_9 = ve21_1 + c_9.*lE21;
    ve21_10 = ve21_1 + c_10.*lE21;

    sigE21 = b(kh+18,1);    
%--------------------------------------------------------------------------
%2.1 Contribution to the likelihood function of 1st childbirth
%--------------------------------------------------------------------------
lf1_1=ones(n,1);
lf1_1(:,1) = (  normcdf(va1_1 - X1*bX1).^dur1_1...
            .* (normcdf(va2_1 - X1*bX1)-normcdf(va1_1 - X1*bX1)).^dur1_2...
            .* (normcdf(va3_1 - X1*bX1)-normcdf(va2_1 - X1*bX1)).^dur1_3...
            .* (normcdf(va4_1 - X1*bX1)-normcdf(va3_1 - X1*bX1)).^dur1_4...
            .* (normcdf(va5_1 - X1*bX1)-normcdf(va4_1 - X1*bX1)).^dur1_5...
            .* (normcdf(va6_1 - X1*bX1)-normcdf(va5_1 - X1*bX1)).^dur1_6...
            .* (normcdf(va7_1 - X1*bX1)-normcdf(va6_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
             (( 1-normcdf(va1_1 - X1*bX1)).^dur1_1...
            .* (1-normcdf(va2_1 - X1*bX1)).^dur1_2...
            .* (1-normcdf(va3_1 - X1*bX1)).^dur1_3...
            .* (1-normcdf(va4_1 - X1*bX1)).^dur1_4...
            .* (1-normcdf(va5_1 - X1*bX1)).^dur1_5...
            .* (1-normcdf(va6_1 - X1*bX1)).^dur1_6...
            .* (1-normcdf(va7_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_2=ones(n,1);
lf1_2(:,1) = (normcdf(va1_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_2 - X1*bX1)-normcdf(va1_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_2 - X1*bX1)-normcdf(va2_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_2 - X1*bX1)-normcdf(va3_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_2 - X1*bX1)-normcdf(va4_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_2 - X1*bX1)-normcdf(va5_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_2 - X1*bX1)-normcdf(va6_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_2 - X1*bX1)).^dur1_7).^(cens1);

lf1_3=ones(n,1);
lf1_3(:,1) = (normcdf(va1_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_3 - X1*bX1)-normcdf(va1_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_3 - X1*bX1)-normcdf(va2_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_3 - X1*bX1)-normcdf(va3_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_3 - X1*bX1)-normcdf(va4_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_3 - X1*bX1)-normcdf(va5_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_3 - X1*bX1)-normcdf(va6_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_3 - X1*bX1)).^dur1_7).^(cens1);

lf1_4=ones(n,1);
lf1_4(:,1) = (normcdf(va1_4 - X1*bX1).^dur1_1...
          .* (normcdf(va2_4 - X1*bX1)-normcdf(va1_4 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_4 - X1*bX1)-normcdf(va2_4 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_4 - X1*bX1)-normcdf(va3_4 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_4 - X1*bX1)-normcdf(va4_4 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_4 - X1*bX1)-normcdf(va5_4 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_4 - X1*bX1)-normcdf(va6_4 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_4 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_4 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_4 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_4 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_4 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_4 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_4 - X1*bX1)).^dur1_7).^(cens1);

lf1_5=ones(n,1);
lf1_5(:,1) = (normcdf(va1_5 - X1*bX1).^dur1_1...
          .* (normcdf(va2_5 - X1*bX1)-normcdf(va1_5 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_5 - X1*bX1)-normcdf(va2_5 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_5 - X1*bX1)-normcdf(va3_5 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_5 - X1*bX1)-normcdf(va4_5 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_5 - X1*bX1)-normcdf(va5_5 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_5 - X1*bX1)-normcdf(va6_5 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_5 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_5 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_5 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_5 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_5 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_5 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_5 - X1*bX1)).^dur1_7).^(cens1);

lf1_6=ones(n,1);
lf1_6(:,1) = (normcdf(va1_6 - X1*bX1).^dur1_1...
          .* (normcdf(va2_6 - X1*bX1)-normcdf(va1_6 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_6 - X1*bX1)-normcdf(va2_6 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_6 - X1*bX1)-normcdf(va3_6 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_6 - X1*bX1)-normcdf(va4_6 - X1*bX1)).^dur1_6...
          .* (normcdf(va6_6 - X1*bX1)-normcdf(va5_6 - X1*bX1)).^dur1_5...
          .* (normcdf(va7_6 - X1*bX1)-normcdf(va6_6 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_6 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_6 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_6 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_6 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_6 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_6 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_6 - X1*bX1)).^dur1_7).^(cens1);

lf1_7=ones(n,1);
lf1_7(:,1) = (normcdf(va1_7 - X1*bX1).^dur1_1...
          .* (normcdf(va2_7 - X1*bX1)-normcdf(va1_7 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_7 - X1*bX1)-normcdf(va2_7 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_7 - X1*bX1)-normcdf(va3_7 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_7 - X1*bX1)-normcdf(va4_7 - X1*bX1)).^dur1_6...
          .* (normcdf(va6_7 - X1*bX1)-normcdf(va5_7 - X1*bX1)).^dur1_5...
          .* (normcdf(va7_7 - X1*bX1)-normcdf(va6_7 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_7 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_7 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_7 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_7 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_7 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_7 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_7 - X1*bX1)).^dur1_7).^(cens1);

lf1_8=ones(n,1);
lf1_8(:,1) = (normcdf(va1_8 - X1*bX1).^dur1_1...
          .* (normcdf(va2_8 - X1*bX1)-normcdf(va1_8 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_8 - X1*bX1)-normcdf(va2_8 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_8 - X1*bX1)-normcdf(va3_8 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_8 - X1*bX1)-normcdf(va4_8 - X1*bX1)).^dur1_6...
          .* (normcdf(va6_8 - X1*bX1)-normcdf(va5_8 - X1*bX1)).^dur1_5...
          .* (normcdf(va7_8 - X1*bX1)-normcdf(va6_8 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_8 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_8 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_8 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_8 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_8 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_8 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_8 - X1*bX1)).^dur1_7).^(cens1);

lf1_9=ones(n,1);
lf1_9(:,1) = (normcdf(va1_9 - X1*bX1).^dur1_1...
          .* (normcdf(va2_9 - X1*bX1)-normcdf(va1_9 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_9 - X1*bX1)-normcdf(va2_9 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_9 - X1*bX1)-normcdf(va3_9 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_9 - X1*bX1)-normcdf(va4_9 - X1*bX1)).^dur1_6...
          .* (normcdf(va6_9 - X1*bX1)-normcdf(va5_9 - X1*bX1)).^dur1_5...
          .* (normcdf(va7_9 - X1*bX1)-normcdf(va6_9 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_9 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_9 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_9 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_9 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_9 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_9 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_9 - X1*bX1)).^dur1_7).^(cens1);

lf1_10=ones(n,1);
lf1_10(:,1) = (normcdf(va1_10 - X1*bX1).^dur1_1...
          .* (normcdf(va2_10 - X1*bX1)-normcdf(va1_10 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_10 - X1*bX1)-normcdf(va2_10 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_10 - X1*bX1)-normcdf(va3_10 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_10 - X1*bX1)-normcdf(va4_10 - X1*bX1)).^dur1_6...
          .* (normcdf(va6_10 - X1*bX1)-normcdf(va5_10 - X1*bX1)).^dur1_5...
          .* (normcdf(va7_10 - X1*bX1)-normcdf(va6_10 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_10 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_10 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_10 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_10 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_10 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_10 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_10 - X1*bX1)).^dur1_7).^(cens1);

%--------------------------------------------------------------------------
%2.2 Contribution to the likelihood function of 2nd childbirth
%--------------------------------------------------------------------------
lf2_1=ones(n,1);
lf2_1(:,1) =(((  normcdf(vb1_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_1 - X2*bX2)-normcdf(vb1_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_1 - X2*bX2)-normcdf(vb2_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_1 - X2*bX2)-normcdf(vb3_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_1 - X2*bX2)-normcdf(vb4_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_1 - X2*bX2)-normcdf(vb5_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_2=ones(n,1);
lf2_2(:,1) =(((  normcdf(vb1_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_2 - X2*bX2)-normcdf(vb1_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_2 - X2*bX2)-normcdf(vb2_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_2 - X2*bX2)-normcdf(vb3_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_2 - X2*bX2)-normcdf(vb4_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_2 - X2*bX2)-normcdf(vb5_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_3=ones(n,1);
lf2_3(:,1) =(((  normcdf(vb1_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_3 - X2*bX2)-normcdf(vb1_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_3 - X2*bX2)-normcdf(vb2_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_3 - X2*bX2)-normcdf(vb3_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_3 - X2*bX2)-normcdf(vb4_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_3 - X2*bX2)-normcdf(vb5_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_4=ones(n,1);
lf2_4(:,1) =(((  normcdf(vb1_4 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_4 - X2*bX2)-normcdf(vb1_4 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_4 - X2*bX2)-normcdf(vb2_4 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_4 - X2*bX2)-normcdf(vb3_4 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_4 - X2*bX2)-normcdf(vb4_4 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_4 - X2*bX2)-normcdf(vb5_4 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_4 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_4 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_4 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_4 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_4 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_4 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_5=ones(n,1);
lf2_5(:,1) =(((  normcdf(vb1_5 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_5 - X2*bX2)-normcdf(vb1_5 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_5 - X2*bX2)-normcdf(vb2_5 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_5 - X2*bX2)-normcdf(vb3_5 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_5 - X2*bX2)-normcdf(vb4_5 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_5 - X2*bX2)-normcdf(vb5_5 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_5 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_5 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_5 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_5 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_5 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_5 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_6=ones(n,1);
lf2_6(:,1) =(((  normcdf(vb1_6 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_6 - X2*bX2)-normcdf(vb1_6 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_6 - X2*bX2)-normcdf(vb2_6 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_6 - X2*bX2)-normcdf(vb3_6 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_6 - X2*bX2)-normcdf(vb4_6 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_6 - X2*bX2)-normcdf(vb5_6 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_6 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_6 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_6 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_6 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_6 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_6 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_7=ones(n,1);
lf2_7(:,1) =(((  normcdf(vb1_7 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_7 - X2*bX2)-normcdf(vb1_7 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_7 - X2*bX2)-normcdf(vb2_7 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_7 - X2*bX2)-normcdf(vb3_7 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_7 - X2*bX2)-normcdf(vb4_7 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_7 - X2*bX2)-normcdf(vb5_7 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_7 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_7 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_7 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_7 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_7 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_7 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_8=ones(n,1);
lf2_8(:,1) =(((  normcdf(vb1_8 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_8 - X2*bX2)-normcdf(vb1_8 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_8 - X2*bX2)-normcdf(vb2_8 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_8 - X2*bX2)-normcdf(vb3_8 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_8 - X2*bX2)-normcdf(vb4_8 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_8 - X2*bX2)-normcdf(vb5_8 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_8 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_8 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_8 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_8 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_8 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_8 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_9=ones(n,1);
lf2_9(:,1) =(((  normcdf(vb1_9 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_9 - X2*bX2)-normcdf(vb1_9 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_9 - X2*bX2)-normcdf(vb2_9 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_9 - X2*bX2)-normcdf(vb3_9 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_9 - X2*bX2)-normcdf(vb4_9 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_9 - X2*bX2)-normcdf(vb5_9 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_9 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_9 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_9 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_9 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_9 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_9 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_10=ones(n,1);
lf2_10(:,1) =(((  normcdf(vb1_10 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_10 - X2*bX2)-normcdf(vb1_10 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_10 - X2*bX2)-normcdf(vb2_10 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_10 - X2*bX2)-normcdf(vb3_10 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_10 - X2*bX2)-normcdf(vb4_10 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_10 - X2*bX2)-normcdf(vb5_10 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_10 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_10 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_10 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_10 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_10 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_10 - X2*bX2)).^dur2_6).^cens2)).^sam2;

%--------------------------------------------------------------------------
%2.3 Contribution to the likelihood function of 3rd childbirth
%--------------------------------------------------------------------------
lf3_1=ones(n,1);
lf3_1(:,1) = ((( normcdf(vc1_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_1 - X3*bX3)-normcdf(vc1_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_1 - X3*bX3)-normcdf(vc2_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_1 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_2=ones(n,1);
lf3_2(:,1) = ((( normcdf(vc1_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_2 - X3*bX3)-normcdf(vc1_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_2 - X3*bX3)-normcdf(vc2_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_3=ones(n,1);
lf3_3(:,1) = ((( normcdf(vc1_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_3 - X3*bX3)-normcdf(vc1_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_3 - X3*bX3)-normcdf(vc2_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

lf3_4=ones(n,1);
lf3_4(:,1) = ((( normcdf(vc1_4 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_4 - X3*bX3)-normcdf(vc1_4 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_4 - X3*bX3)-normcdf(vc2_4 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_4 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_4 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_4 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

lf3_5=ones(n,1);
lf3_5(:,1) = ((( normcdf(vc1_5 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_5 - X3*bX3)-normcdf(vc1_5 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_5 - X3*bX3)-normcdf(vc2_5 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_5 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_5 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_5 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

lf3_6=ones(n,1);
lf3_6(:,1) = ((( normcdf(vc1_6 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_6 - X3*bX3)-normcdf(vc1_6 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_6 - X3*bX3)-normcdf(vc2_6 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_6 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_6 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_6 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

lf3_7=ones(n,1);
lf3_7(:,1) = ((( normcdf(vc1_7 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_7 - X3*bX3)-normcdf(vc1_7 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_7 - X3*bX3)-normcdf(vc2_7 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_7 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_7 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_7 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

lf3_8=ones(n,1);
lf3_8(:,1) = ((( normcdf(vc1_8 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_8 - X3*bX3)-normcdf(vc1_8 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_8 - X3*bX3)-normcdf(vc2_8 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_8 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_8 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_8 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

lf3_9=ones(n,1);
lf3_9(:,1) = ((( normcdf(vc1_9 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_9 - X3*bX3)-normcdf(vc1_9 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_9 - X3*bX3)-normcdf(vc2_9 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_9 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_9 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_9 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

lf3_10=ones(n,1);
lf3_10(:,1) = ((( normcdf(vc1_10 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_10 - X3*bX3)-normcdf(vc1_10 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_10 - X3*bX3)-normcdf(vc2_10 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_10 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_10 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_10 - X3*bX3)).^dur3_3).^cens3)).^sam3;       

%--------------------------------------------------------------------------
%2.4 Contribution to the likelihood function of earnings 3 years after diploma
%--------------------------------------------------------------------------
lw3_1=ones(n,1);
lw3_1(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_1).^2)./(2.*exp(sig3)));
lw3_2=ones(n,1);
lw3_2(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_2).^2)./(2.*exp(sig3)));
lw3_3=ones(n,1);
lw3_3(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_3).^2)./(2.*exp(sig3)));
lw3_4=ones(n,1);
lw3_4(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_4).^2)./(2.*exp(sig3)));
lw3_5=ones(n,1);
lw3_5(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_5).^2)./(2.*exp(sig3)));
lw3_6=ones(n,1);
lw3_6(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_6).^2)./(2.*exp(sig3)));
lw3_7=ones(n,1);
lw3_7(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_7).^2)./(2.*exp(sig3)));
lw3_8=ones(n,1);
lw3_8(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_8).^2)./(2.*exp(sig3)));
lw3_9=ones(n,1);
lw3_9(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_9).^2)./(2.*exp(sig3)));
lw3_10=ones(n,1);
lw3_10(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_10).^2)./(2.*exp(sig3)));

%--------------------------------------------------------------------------
%2.5 Contribution to the likelihood function of earnings 6 years after diploma
%--------------------------------------------------------------------------
lw6_1=ones(n,1);
lw6_1(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_2=ones(n,1);
lw6_2(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_3=ones(n,1);
lw6_3(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_4=ones(n,1);
lw6_4(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_4).^2)./(2.*exp(sig6)))).^samw6;
lw6_5=ones(n,1);
lw6_5(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_5).^2)./(2.*exp(sig6)))).^samw6;
lw6_6=ones(n,1);
lw6_6(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_6).^2)./(2.*exp(sig6)))).^samw6;
lw6_7=ones(n,1);
lw6_7(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_7).^2)./(2.*exp(sig6)))).^samw6;
lw6_8=ones(n,1);
lw6_8(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_8).^2)./(2.*exp(sig6)))).^samw6;
lw6_9=ones(n,1);
lw6_9(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_9).^2)./(2.*exp(sig6)))).^samw6;
lw6_10=ones(n,1);
lw6_10(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_10).^2)./(2.*exp(sig6)))).^samw6;

%--------------------------------------------------------------------------
%2.6 Contribution to the likelihood function of earnings 9 years after diploma
%--------------------------------------------------------------------------
lw9_1=ones(n,1);
lw9_1(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_2=ones(n,1);
lw9_2(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_3=ones(n,1);
lw9_3(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_4=ones(n,1);
lw9_4(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_4).^2)./(2.*exp(sig9)))).^samw9;
lw9_5=ones(n,1);
lw9_5(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_5).^2)./(2.*exp(sig9)))).^samw9;
lw9_6=ones(n,1);
lw9_6(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_6).^2)./(2.*exp(sig9)))).^samw9;
lw9_7=ones(n,1);
lw9_7(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_7).^2)./(2.*exp(sig9)))).^samw9;
lw9_8=ones(n,1);
lw9_8(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_8).^2)./(2.*exp(sig9)))).^samw9;
lw9_9=ones(n,1);
lw9_9(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_9).^2)./(2.*exp(sig9)))).^samw9;
lw9_10=ones(n,1);
lw9_10(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_10).^2)./(2.*exp(sig9)))).^samw9;

%--------------------------------------------------------------------------
%2.7 Contribution to the likelihood function of earnings 12 years after diploma
%--------------------------------------------------------------------------
lw12_1=ones(n,1);
lw12_1(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_2=ones(n,1);
lw12_2(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_3=ones(n,1);
lw12_3(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_4=ones(n,1);
lw12_4(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_4).^2)./(2.*exp(sig12)))).^samw12;
lw12_5=ones(n,1);
lw12_5(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_5).^2)./(2.*exp(sig12)))).^samw12;
lw12_6=ones(n,1);
lw12_6(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_6).^2)./(2.*exp(sig12)))).^samw12;
lw12_7=ones(n,1);
lw12_7(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_7).^2)./(2.*exp(sig12)))).^samw12;
lw12_8=ones(n,1);
lw12_8(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_8).^2)./(2.*exp(sig12)))).^samw12;
lw12_9=ones(n,1);
lw12_9(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_9).^2)./(2.*exp(sig12)))).^samw12;
lw12_10=ones(n,1);
lw12_10(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_10).^2)./(2.*exp(sig12)))).^samw12;

%--------------------------------------------------------------------------
%2.8 Contribution to the likelihood function of earnings 15 years after diploma
%--------------------------------------------------------------------------
lw15_1=ones(n,1);
lw15_1(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_2=ones(n,1);
lw15_2(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_3=ones(n,1);
lw15_3(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_4=ones(n,1);
lw15_4(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_4).^2)./(2.*exp(sig15)))).^samw15;
lw15_5=ones(n,1);
lw15_5(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_5).^2)./(2.*exp(sig15)))).^samw15;
lw15_6=ones(n,1);
lw15_6(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_6).^2)./(2.*exp(sig15)))).^samw15;
lw15_7=ones(n,1);
lw15_7(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_7).^2)./(2.*exp(sig15)))).^samw15;
lw15_8=ones(n,1);
lw15_8(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_8).^2)./(2.*exp(sig15)))).^samw15;
lw15_9=ones(n,1);
lw15_9(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_9).^2)./(2.*exp(sig15)))).^samw15;
lw15_10=ones(n,1);
lw15_10(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_10).^2)./(2.*exp(sig15)))).^samw15;

%--------------------------------------------------------------------------
%2.9 Contribution to the likelihood function of earnings 18 years after diploma
%--------------------------------------------------------------------------
lw18_1=ones(n,1);
lw18_1(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_2=ones(n,1);
lw18_2(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_3=ones(n,1);
lw18_3(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_4=ones(n,1);
lw18_4(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_4).^2)./(2.*exp(sig18)))).^samw18;
lw18_5=ones(n,1);
lw18_5(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_5).^2)./(2.*exp(sig18)))).^samw18;
lw18_6=ones(n,1);
lw18_6(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_6).^2)./(2.*exp(sig18)))).^samw18;
lw18_7=ones(n,1);
lw18_7(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_7).^2)./(2.*exp(sig18)))).^samw18;
lw18_8=ones(n,1);
lw18_8(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_8).^2)./(2.*exp(sig18)))).^samw18;
lw18_9=ones(n,1);
lw18_9(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_9).^2)./(2.*exp(sig18)))).^samw18;
lw18_10=ones(n,1);
lw18_10(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_10).^2)./(2.*exp(sig18)))).^samw18;

%--------------------------------------------------------------------------
%2.10 Contribution to the likelihood function of earnings 21 years after diploma
%--------------------------------------------------------------------------
lw21_1=ones(n,1);
lw21_1(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_2=ones(n,1);
lw21_2(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_3=ones(n,1);
lw21_3(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_4=ones(n,1);
lw21_4(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_4).^2)./(2.*exp(sig21)))).^samw21;
lw21_5=ones(n,1);
lw21_5(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_5).^2)./(2.*exp(sig21)))).^samw21;
lw21_6=ones(n,1);
lw21_6(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_6).^2)./(2.*exp(sig21)))).^samw21;
lw21_7=ones(n,1);
lw21_7(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_7).^2)./(2.*exp(sig21)))).^samw21;
lw21_8=ones(n,1);
lw21_8(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_8).^2)./(2.*exp(sig21)))).^samw21;
lw21_9=ones(n,1);
lw21_9(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_9).^2)./(2.*exp(sig21)))).^samw21;
lw21_10=ones(n,1);
lw21_10(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_10).^2)./(2.*exp(sig21)))).^samw21;

%--------------------------------------------------------------------------
%2.11 Contribution to the likelihood function of employment 1 year before diploma
%--------------------------------------------------------------------------
le_1=ones(n,1);
le_1(:,1) = (normcdf(Ze*bZe + vze_1).^emp_1).*((1-normcdf(Ze*bZe + vze_1)).^(1-emp_1));
le_2=ones(n,1);
le_2(:,1) = (normcdf(Ze*bZe + vze_2).^emp_1).*((1-normcdf(Ze*bZe + vze_2)).^(1-emp_1));
le_3=ones(n,1);
le_3(:,1) = (normcdf(Ze*bZe + vze_3).^emp_1).*((1-normcdf(Ze*bZe + vze_3)).^(1-emp_1));
le_4=ones(n,1);
le_4(:,1) = (normcdf(Ze*bZe + vze_4).^emp_1).*((1-normcdf(Ze*bZe + vze_4)).^(1-emp_1));
le_5=ones(n,1);
le_5(:,1) = (normcdf(Ze*bZe + vze_5).^emp_1).*((1-normcdf(Ze*bZe + vze_5)).^(1-emp_1));
le_6=ones(n,1);
le_6(:,1) = (normcdf(Ze*bZe + vze_6).^emp_1).*((1-normcdf(Ze*bZe + vze_6)).^(1-emp_1));
le_7=ones(n,1);
le_7(:,1) = (normcdf(Ze*bZe + vze_7).^emp_1).*((1-normcdf(Ze*bZe + vze_7)).^(1-emp_1));
le_8=ones(n,1);
le_8(:,1) = (normcdf(Ze*bZe + vze_8).^emp_1).*((1-normcdf(Ze*bZe + vze_8)).^(1-emp_1));
le_9=ones(n,1);
le_9(:,1) = (normcdf(Ze*bZe + vze_9).^emp_1).*((1-normcdf(Ze*bZe + vze_9)).^(1-emp_1));
le_10=ones(n,1);
le_10(:,1) = (normcdf(Ze*bZe + vze_10).^emp_1).*((1-normcdf(Ze*bZe + vze_10)).^(1-emp_1));

%--------------------------------------------------------------------------
%2.12 Contribution to the likelihood function of number of siblings at 14
%--------------------------------------------------------------------------
ls_1=ones(n,1);
ls_1(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_1).^2)./(2.*exp(sig_zs)));
ls_2=ones(n,1);
ls_2(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_2).^2)./(2.*exp(sig_zs)));
ls_3=ones(n,1);
ls_3(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_3).^2)./(2.*exp(sig_zs)));
ls_4=ones(n,1);
ls_4(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_4).^2)./(2.*exp(sig_zs)));
ls_5=ones(n,1);
ls_5(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_5).^2)./(2.*exp(sig_zs)));
ls_6=ones(n,1);
ls_6(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_6).^2)./(2.*exp(sig_zs)));
ls_7=ones(n,1);
ls_7(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_7).^2)./(2.*exp(sig_zs)));
ls_8=ones(n,1);
ls_8(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_8).^2)./(2.*exp(sig_zs)));
ls_9=ones(n,1);
ls_9(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_9).^2)./(2.*exp(sig_zs)));
ls_10=ones(n,1);
ls_10(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib      - Zs*bZs - vzs_10).^2)./(2.*exp(sig_zs)));
%--------------------------------------------------------------------------
%2.13 Contribution to the likelihood function of employment 3 years after diploma
%--------------------------------------------------------------------------
lE3_1=ones(n,1);
lE3_1(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_1).^2)./(2.*exp(sigE3)));
lE3_2=ones(n,1);
lE3_2(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_2).^2)./(2.*exp(sigE3)));
lE3_3=ones(n,1);
lE3_3(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_3).^2)./(2.*exp(sigE3)));
lE3_4=ones(n,1);
lE3_4(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_4).^2)./(2.*exp(sigE3)));
lE3_5=ones(n,1);
lE3_5(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_5).^2)./(2.*exp(sigE3)));
lE3_6=ones(n,1);
lE3_6(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_6).^2)./(2.*exp(sigE3)));
lE3_7=ones(n,1);
lE3_7(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_7).^2)./(2.*exp(sigE3)));
lE3_8=ones(n,1);
lE3_8(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_8).^2)./(2.*exp(sigE3)));
lE3_9=ones(n,1);
lE3_9(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_9).^2)./(2.*exp(sigE3)));
lE3_10=ones(n,1);
lE3_10(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_10).^2)./(2.*exp(sigE3)));

%--------------------------------------------------------------------------
%2.14 Contribution to the likelihood function of employment 6 years after diploma
%--------------------------------------------------------------------------
lE6_1=ones(n,1);
lE6_1(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_2=ones(n,1);
lE6_2(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_3=ones(n,1);
lE6_3(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_4=ones(n,1);
lE6_4(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_4).^2)./(2.*exp(sigE6)))).^samw6;
lE6_5=ones(n,1);
lE6_5(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_5).^2)./(2.*exp(sigE6)))).^samw6;
lE6_6=ones(n,1);
lE6_6(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_6).^2)./(2.*exp(sigE6)))).^samw6;
lE6_7=ones(n,1);
lE6_7(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_7).^2)./(2.*exp(sigE6)))).^samw6;
lE6_8=ones(n,1);
lE6_8(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_8).^2)./(2.*exp(sigE6)))).^samw6;
lE6_9=ones(n,1);
lE6_9(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_9).^2)./(2.*exp(sigE6)))).^samw6;
lE6_10=ones(n,1);
lE6_10(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_10).^2)./(2.*exp(sigE6)))).^samw6;

%--------------------------------------------------------------------------
%2.15 Contribution to the likelihood function of employment 9 years after diploma
%--------------------------------------------------------------------------
lE9_1=ones(n,1);
lE9_1(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_2=ones(n,1);
lE9_2(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_3=ones(n,1);
lE9_3(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_4=ones(n,1);
lE9_4(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_4).^2)./(2.*exp(sigE9)))).^samw9;
lE9_5=ones(n,1);
lE9_5(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_5).^2)./(2.*exp(sigE9)))).^samw9;
lE9_6=ones(n,1);
lE9_6(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_6).^2)./(2.*exp(sigE9)))).^samw9;
lE9_7=ones(n,1);
lE9_7(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_7).^2)./(2.*exp(sigE9)))).^samw9;
lE9_8=ones(n,1);
lE9_8(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_8).^2)./(2.*exp(sigE9)))).^samw9;
lE9_9=ones(n,1);
lE9_9(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_9).^2)./(2.*exp(sigE9)))).^samw9;
lE9_10=ones(n,1);
lE9_10(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_10).^2)./(2.*exp(sigE9)))).^samw9;

%--------------------------------------------------------------------------
%2.16 Contribution to the likelihood function of employment 12 years after diploma
%--------------------------------------------------------------------------
lE12_1=ones(n,1);
lE12_1(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_2=ones(n,1);
lE12_2(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_3=ones(n,1);
lE12_3(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_4=ones(n,1);
lE12_4(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_4).^2)./(2.*exp(sigE12)))).^samw12;
lE12_5=ones(n,1);
lE12_5(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_5).^2)./(2.*exp(sigE12)))).^samw12;
lE12_6=ones(n,1);
lE12_6(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_6).^2)./(2.*exp(sigE12)))).^samw12;
lE12_7=ones(n,1);
lE12_7(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_7).^2)./(2.*exp(sigE12)))).^samw12;
lE12_8=ones(n,1);
lE12_8(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_8).^2)./(2.*exp(sigE12)))).^samw12;
lE12_9=ones(n,1);
lE12_9(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_9).^2)./(2.*exp(sigE12)))).^samw12;
lE12_10=ones(n,1);
lE12_10(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_10).^2)./(2.*exp(sigE12)))).^samw12;

%--------------------------------------------------------------------------
%2.17 Contribution to the likelihood function of employment 15 years after diploma
%--------------------------------------------------------------------------
lE15_1=ones(n,1);
lE15_1(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_2=ones(n,1);
lE15_2(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_3=ones(n,1);
lE15_3(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_4=ones(n,1);
lE15_4(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_4).^2)./(2.*exp(sigE15)))).^samw15;
lE15_5=ones(n,1);
lE15_5(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_5).^2)./(2.*exp(sigE15)))).^samw15;
lE15_6=ones(n,1);
lE15_6(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_6).^2)./(2.*exp(sigE15)))).^samw15;
lE15_7=ones(n,1);
lE15_7(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_7).^2)./(2.*exp(sigE15)))).^samw15;
lE15_8=ones(n,1);
lE15_8(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_8).^2)./(2.*exp(sigE15)))).^samw15;
lE15_9=ones(n,1);
lE15_9(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_9).^2)./(2.*exp(sigE15)))).^samw15;
lE15_10=ones(n,1);
lE15_10(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_10).^2)./(2.*exp(sigE15)))).^samw15;

%--------------------------------------------------------------------------
%2.18 Contribution to the likelihood function of employment 18 years after diploma
%--------------------------------------------------------------------------
lE18_1=ones(n,1);
lE18_1(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_2=ones(n,1);
lE18_2(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_3=ones(n,1);
lE18_3(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_4=ones(n,1);
lE18_4(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_4).^2)./(2.*exp(sigE18)))).^samw18;
lE18_5=ones(n,1);
lE18_5(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_5).^2)./(2.*exp(sigE18)))).^samw18;
lE18_6=ones(n,1);
lE18_6(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_6).^2)./(2.*exp(sigE18)))).^samw18;
lE18_7=ones(n,1);
lE18_7(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_7).^2)./(2.*exp(sigE18)))).^samw18;
lE18_8=ones(n,1);
lE18_8(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_8).^2)./(2.*exp(sigE18)))).^samw18;
lE18_9=ones(n,1);
lE18_9(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_9).^2)./(2.*exp(sigE18)))).^samw18;
lE18_10=ones(n,1);
lE18_10(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_10).^2)./(2.*exp(sigE18)))).^samw18;

%--------------------------------------------------------------------------
%2.19 Contribution to the likelihood function of employment 21 years after diploma
%--------------------------------------------------------------------------
lE21_1=ones(n,1);
lE21_1(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_2=ones(n,1);
lE21_2(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_3=ones(n,1);
lE21_3(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_4=ones(n,1);
lE21_4(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_4).^2)./(2.*exp(sigE21)))).^samw21;
lE21_5=ones(n,1);
lE21_5(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_5).^2)./(2.*exp(sigE21)))).^samw21;
lE21_6=ones(n,1);
lE21_6(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_6).^2)./(2.*exp(sigE21)))).^samw21;
lE21_7=ones(n,1);
lE21_7(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_7).^2)./(2.*exp(sigE21)))).^samw21;
lE21_8=ones(n,1);
lE21_8(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_8).^2)./(2.*exp(sigE21)))).^samw21;
lE21_9=ones(n,1);
lE21_9(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_9).^2)./(2.*exp(sigE21)))).^samw21;
lE21_10=ones(n,1);
lE21_10(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_10).^2)./(2.*exp(sigE21)))).^samw21;

%--------------------------------------------------------------------------      
%3.1 Individual contribution to the likelihood      
%--------------------------------------------------------------------------
ll_1(:,1)=lf1_1.*lf2_1.*lf3_1.*lw3_1.*lw6_1.*lw9_1.*lw12_1.*lw15_1.*lw18_1.*lw21_1.*le_1.*ls_1.*lE3_1.*lE6_1.*lE9_1.*lE12_1.*lE15_1.*lE18_1.*lE21_1;      
ll_2(:,1)=lf1_2.*lf2_2.*lf3_2.*lw3_2.*lw6_2.*lw9_2.*lw12_2.*lw15_2.*lw18_2.*lw21_2.*le_2.*ls_2.*lE3_2.*lE6_2.*lE9_2.*lE12_2.*lE15_2.*lE18_2.*lE21_2;      
ll_3(:,1)=lf1_3.*lf2_3.*lf3_3.*lw3_3.*lw6_3.*lw9_3.*lw12_3.*lw15_3.*lw18_3.*lw21_3.*le_3.*ls_3.*lE3_3.*lE6_3.*lE9_3.*lE12_3.*lE15_3.*lE18_3.*lE21_3;      
ll_4(:,1)=lf1_4.*lf2_4.*lf3_4.*lw3_4.*lw6_4.*lw9_4.*lw12_4.*lw15_4.*lw18_4.*lw21_4.*le_4.*ls_4.*lE3_4.*lE6_4.*lE9_4.*lE12_4.*lE15_4.*lE18_4.*lE21_4;      
ll_5(:,1)=lf1_5.*lf2_5.*lf3_5.*lw3_5.*lw6_5.*lw9_5.*lw12_5.*lw15_5.*lw18_5.*lw21_5.*le_5.*ls_5.*lE3_5.*lE6_5.*lE9_5.*lE12_5.*lE15_5.*lE18_5.*lE21_5;      
ll_6(:,1)=lf1_6.*lf2_6.*lf3_6.*lw3_6.*lw6_6.*lw9_6.*lw12_6.*lw15_6.*lw18_6.*lw21_6.*le_6.*ls_6.*lE3_6.*lE6_6.*lE9_6.*lE12_6.*lE15_6.*lE18_6.*lE21_6;      
ll_7(:,1)=lf1_7.*lf2_7.*lf3_7.*lw3_7.*lw6_7.*lw9_7.*lw12_7.*lw15_7.*lw18_7.*lw21_7.*le_7.*ls_7.*lE3_7.*lE6_7.*lE9_7.*lE12_7.*lE15_7.*lE18_7.*lE21_7;      
ll_8(:,1)=lf1_8.*lf2_8.*lf3_8.*lw3_8.*lw6_8.*lw9_8.*lw12_8.*lw15_8.*lw18_8.*lw21_8.*le_8.*ls_8.*lE3_8.*lE6_8.*lE9_8.*lE12_8.*lE15_8.*lE18_8.*lE21_8;      
ll_9(:,1)=lf1_9.*lf2_9.*lf3_9.*lw3_9.*lw6_9.*lw9_9.*lw12_9.*lw15_9.*lw18_9.*lw21_9.*le_9.*ls_9.*lE3_9.*lE6_9.*lE9_9.*lE12_9.*lE15_9.*lE18_9.*lE21_9;      
ll_10(:,1)=lf1_10.*lf2_10.*lf3_10.*lw3_10.*lw6_10.*lw9_10.*lw12_10.*lw15_10.*lw18_10.*lw21_10.*le_10.*ls_10.*lE3_10.*lE6_10.*lE9_10.*lE12_10.*lE15_10.*lE18_10.*lE21_10;      

%-------------------------------------------------------------------------- 
%3.2 LOG-LIKELIHOOD FUNCTION
%--------------------------------------------------------------------------
NL = -sum(log(ll_1*P1+ll_2*P2+ll_3*P3+ll_4*P4+ll_5*P5+ll_6*P6+ll_7*P7+ll_8*P8+ll_9*P9+ll_10*P10));

% %{{{Derive the score an the gradient and compute the Hessian
% [nbr,nrc]=size(b);
% 
% %read the score:
% sc = zeros(n,nbr);
% sctemp=g_tmp_log_00000;
% sc = [sctemp{:}];
% 
% %read the gradient:
% gt = zeros(nbr,1);
% gtemp= g_NL(1);
% gt=[gtemp{:}]; 
% 
% g  = gt;					%gradient
% H  = sc'*sc;				%outer product
% %}}}
% 
% %EOF
