% Matteo Picchio
% Ancona 30/03/2017
                                   
function[NL, g, H]=function_f_rel(b,n,kx1,X1,X2,X3,cens1,cens2,cens3,sam2,sam3,dur1_1,dur1_2,dur1_3,dur1_4,dur1_5,dur1_6,dur1_7,...
                                  dur2_1,dur2_2,dur2_3,dur2_4,dur2_5,dur2_6,dur3_1,dur3_2,dur3_3,W3,lab_ear3,kw3,W6,lab_ear6,samw6,...
                                  W9,lab_ear9,samw9,W12,lab_ear12,samw12,W15,lab_ear15,samw15,W18,lab_ear18,samw18,W21,lab_ear21,samw21,...
                                  Ze,Zs,kze,kzs,nsib,emp_1,totday3,totday6,totday9,totday12,totday15,totday18,totday21,theta,wei)
                              
% [g_b]=createFullGradients(b);

save('results\b_rel.mat','b')

%--------------------------------------------------------------------------
%1.1 Assign b to UH parameters
%--------------------------------------------------------------------------
lam1=b(1,1);
lam2=b(2,1);

%PROBABILITY MASSES
P1  = exp(lam1)./(1+exp(lam1)+exp(lam2));
P2  = exp(lam2)./(1+exp(lam1)+exp(lam2));
P3  =         1./(1+exp(lam1)+exp(lam2));

%Means are normalizes so that the weighted mean is 0: P1*mean1+P2*mean2+P3*mean3=0
mean1=b(3,1);
mean2=b(4,1);
mean3=(-P1.*mean1-P2.*mean2)./P3;

%Standard deviations are not normalized
std1=exp(b(5,1));
std2=exp(b(6,1));
std3=exp(b(7,1));
kh  = 7;  

%Loading factors which multiply theta-N(0,1) (loading factor earnings 3
%normalized to 1: lfw3=1
lfe   = b(kh+1,1);
lfs   = b(kh+2,1);
lf1   = b(kh+3,1);
lf2   = b(kh+4,1);
lf3   = b(kh+5,1);
lfw6  = b(kh+6,1);
lfw9  = b(kh+7,1);
lfw12 = b(kh+8,1);
lfw15 = b(kh+9,1);
lfw18 = b(kh+10,1);
lfw21 = b(kh+11,1);
lE3   = b(kh+12,1);
lE6   = b(kh+13,1);
lE9   = b(kh+14,1);
lE12  = b(kh+15,1);
lE15  = b(kh+16,1);
lE18  = b(kh+17,1);
lE21  = b(kh+18,1);
kh  =kh+ 18;  
%--------------------------------------------------------------------------
%1.1 Assign b to 1st childbirth equation
%--------------------------------------------------------------------------
    bX1 = b(kh+1:kh+kx1,1);
    va1_1_1 = b(kh+kx1+1,1)              + lf1       .*(theta(1,1).*std1+mean1)                                       ;
    va2_1_1 = va1_1_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(1,1).*std1+mean1) + lf1.*lfw6 .*(theta(1,1).*std1+mean1);
    va3_1_1 = va2_1_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(1,1).*std1+mean1) + lf1.*lfw9 .*(theta(1,1).*std1+mean1);
    va4_1_1 = va3_1_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(1,1).*std1+mean1) + lf1.*lfw12.*(theta(1,1).*std1+mean1);
    va5_1_1 = va4_1_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(1,1).*std1+mean1) + lf1.*lfw15.*(theta(1,1).*std1+mean1);
    va6_1_1 = va5_1_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(1,1).*std1+mean1) + lf1.*lfw18.*(theta(1,1).*std1+mean1);
    va7_1_1 = va6_1_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(1,1).*std1+mean1) + lf1.*lfw21.*(theta(1,1).*std1+mean1);
    va1_2_1 = b(kh+kx1+1,1)              + lf1       .*(theta(2,1).*std1+mean1)                                       ;
    va2_2_1 = va1_2_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(2,1).*std1+mean1) + lf1.*lfw6 .*(theta(2,1).*std1+mean1);
    va3_2_1 = va2_2_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(2,1).*std1+mean1) + lf1.*lfw9 .*(theta(2,1).*std1+mean1);
    va4_2_1 = va3_2_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(2,1).*std1+mean1) + lf1.*lfw12.*(theta(2,1).*std1+mean1);
    va5_2_1 = va4_2_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(2,1).*std1+mean1) + lf1.*lfw15.*(theta(2,1).*std1+mean1);
    va6_2_1 = va5_2_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(2,1).*std1+mean1) + lf1.*lfw18.*(theta(2,1).*std1+mean1);
    va7_2_1 = va6_2_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(2,1).*std1+mean1) + lf1.*lfw21.*(theta(2,1).*std1+mean1);    
    va1_3_1 = b(kh+kx1+1,1)              + lf1       .*(theta(3,1).*std1+mean1)                                       ;
    va2_3_1 = va1_3_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(3,1).*std1+mean1) + lf1.*lfw6 .*(theta(3,1).*std1+mean1);
    va3_3_1 = va2_3_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(3,1).*std1+mean1) + lf1.*lfw9 .*(theta(3,1).*std1+mean1);
    va4_3_1 = va3_3_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(3,1).*std1+mean1) + lf1.*lfw12.*(theta(3,1).*std1+mean1);
    va5_3_1 = va4_3_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(3,1).*std1+mean1) + lf1.*lfw15.*(theta(3,1).*std1+mean1);
    va6_3_1 = va5_3_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(3,1).*std1+mean1) + lf1.*lfw18.*(theta(3,1).*std1+mean1);
    va7_3_1 = va6_3_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(3,1).*std1+mean1) + lf1.*lfw21.*(theta(3,1).*std1+mean1); 
    va1_4_1 = b(kh+kx1+1,1)              + lf1       .*(theta(4,1).*std1+mean1)                                       ;
    va2_4_1 = va1_4_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(4,1).*std1+mean1) + lf1.*lfw6 .*(theta(4,1).*std1+mean1);
    va3_4_1 = va2_4_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(4,1).*std1+mean1) + lf1.*lfw9 .*(theta(4,1).*std1+mean1);
    va4_4_1 = va3_4_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(4,1).*std1+mean1) + lf1.*lfw12.*(theta(4,1).*std1+mean1);
    va5_4_1 = va4_4_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(4,1).*std1+mean1) + lf1.*lfw15.*(theta(4,1).*std1+mean1);
    va6_4_1 = va5_4_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(4,1).*std1+mean1) + lf1.*lfw18.*(theta(4,1).*std1+mean1);
    va7_4_1 = va6_4_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(4,1).*std1+mean1) + lf1.*lfw21.*(theta(4,1).*std1+mean1);
    va1_5_1 = b(kh+kx1+1,1)              + lf1       .*(theta(5,1).*std1+mean1)                                       ;
    va2_5_1 = va1_5_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(5,1).*std1+mean1) + lf1.*lfw6 .*(theta(5,1).*std1+mean1);
    va3_5_1 = va2_5_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(5,1).*std1+mean1) + lf1.*lfw9 .*(theta(5,1).*std1+mean1);
    va4_5_1 = va3_5_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(5,1).*std1+mean1) + lf1.*lfw12.*(theta(5,1).*std1+mean1);
    va5_5_1 = va4_5_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(5,1).*std1+mean1) + lf1.*lfw15.*(theta(5,1).*std1+mean1);
    va6_5_1 = va5_5_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(5,1).*std1+mean1) + lf1.*lfw18.*(theta(5,1).*std1+mean1);
    va7_5_1 = va6_5_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(5,1).*std1+mean1) + lf1.*lfw21.*(theta(5,1).*std1+mean1);
    va1_6_1 = b(kh+kx1+1,1)              + lf1       .*(theta(6,1).*std1+mean1)                                       ;
    va2_6_1 = va1_6_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(6,1).*std1+mean1) + lf1.*lfw6 .*(theta(6,1).*std1+mean1);
    va3_6_1 = va2_6_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(6,1).*std1+mean1) + lf1.*lfw9 .*(theta(6,1).*std1+mean1);
    va4_6_1 = va3_6_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(6,1).*std1+mean1) + lf1.*lfw12.*(theta(6,1).*std1+mean1);
    va5_6_1 = va4_6_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(6,1).*std1+mean1) + lf1.*lfw15.*(theta(6,1).*std1+mean1);
    va6_6_1 = va5_6_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(6,1).*std1+mean1) + lf1.*lfw18.*(theta(6,1).*std1+mean1);
    va7_6_1 = va6_6_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(6,1).*std1+mean1) + lf1.*lfw21.*(theta(6,1).*std1+mean1);
    va1_7_1 = b(kh+kx1+1,1)              + lf1       .*(theta(7,1).*std1+mean1)                                       ;
    va2_7_1 = va1_7_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(7,1).*std1+mean1) + lf1.*lfw6 .*(theta(7,1).*std1+mean1);
    va3_7_1 = va2_7_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(7,1).*std1+mean1) + lf1.*lfw9 .*(theta(7,1).*std1+mean1);
    va4_7_1 = va3_7_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(7,1).*std1+mean1) + lf1.*lfw12.*(theta(7,1).*std1+mean1);
    va5_7_1 = va4_7_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(7,1).*std1+mean1) + lf1.*lfw15.*(theta(7,1).*std1+mean1);
    va6_7_1 = va5_7_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(7,1).*std1+mean1) + lf1.*lfw18.*(theta(7,1).*std1+mean1);
    va7_7_1 = va6_7_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(7,1).*std1+mean1) + lf1.*lfw21.*(theta(7,1).*std1+mean1);
    va1_8_1 = b(kh+kx1+1,1)              + lf1       .*(theta(8,1).*std1+mean1)                                       ;
    va2_8_1 = va1_8_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(8,1).*std1+mean1) + lf1.*lfw6 .*(theta(8,1).*std1+mean1);
    va3_8_1 = va2_8_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(8,1).*std1+mean1) + lf1.*lfw9 .*(theta(8,1).*std1+mean1);
    va4_8_1 = va3_8_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(8,1).*std1+mean1) + lf1.*lfw12.*(theta(8,1).*std1+mean1);
    va5_8_1 = va4_8_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(8,1).*std1+mean1) + lf1.*lfw15.*(theta(8,1).*std1+mean1);
    va6_8_1 = va5_8_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(8,1).*std1+mean1) + lf1.*lfw18.*(theta(8,1).*std1+mean1);
    va7_8_1 = va6_8_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(8,1).*std1+mean1) + lf1.*lfw21.*(theta(8,1).*std1+mean1);                                                               
    va1_9_1 = b(kh+kx1+1,1)              + lf1       .*(theta(9,1).*std1+mean1)                                       ;
    va2_9_1 = va1_9_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(9,1).*std1+mean1) + lf1.*lfw6 .*(theta(9,1).*std1+mean1);
    va3_9_1 = va2_9_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(9,1).*std1+mean1) + lf1.*lfw9 .*(theta(9,1).*std1+mean1);
    va4_9_1 = va3_9_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(9,1).*std1+mean1) + lf1.*lfw12.*(theta(9,1).*std1+mean1);
    va5_9_1 = va4_9_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(9,1).*std1+mean1) + lf1.*lfw15.*(theta(9,1).*std1+mean1);
    va6_9_1 = va5_9_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(9,1).*std1+mean1) + lf1.*lfw18.*(theta(9,1).*std1+mean1);
    va7_9_1 = va6_9_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(9,1).*std1+mean1) + lf1.*lfw21.*(theta(9,1).*std1+mean1);        
    va1_10_1= b(kh+kx1+1,1)               + lf1       .*(theta(10,1).*std1+mean1)                                       ;
    va2_10_1= va1_10_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(10,1).*std1+mean1) + lf1.*lfw6 .*(theta(10,1).*std1+mean1);
    va3_10_1= va2_10_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(10,1).*std1+mean1) + lf1.*lfw9 .*(theta(10,1).*std1+mean1);
    va4_10_1= va3_10_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(10,1).*std1+mean1) + lf1.*lfw12.*(theta(10,1).*std1+mean1);
    va5_10_1= va4_10_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(10,1).*std1+mean1) + lf1.*lfw15.*(theta(10,1).*std1+mean1);
    va6_10_1= va5_10_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(10,1).*std1+mean1) + lf1.*lfw18.*(theta(10,1).*std1+mean1);
    va7_10_1= va6_10_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(10,1).*std1+mean1) + lf1.*lfw21.*(theta(10,1).*std1+mean1);       
    va1_11_1= b(kh+kx1+1,1)               + lf1       .*(theta(11,1).*std1+mean1)                                       ;
    va2_11_1= va1_11_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(11,1).*std1+mean1) + lf1.*lfw6 .*(theta(11,1).*std1+mean1);
    va3_11_1= va2_11_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(11,1).*std1+mean1) + lf1.*lfw9 .*(theta(11,1).*std1+mean1);
    va4_11_1= va3_11_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(11,1).*std1+mean1) + lf1.*lfw12.*(theta(11,1).*std1+mean1);
    va5_11_1= va4_11_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(11,1).*std1+mean1) + lf1.*lfw15.*(theta(11,1).*std1+mean1);
    va6_11_1= va5_11_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(11,1).*std1+mean1) + lf1.*lfw18.*(theta(11,1).*std1+mean1);
    va7_11_1= va6_11_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(11,1).*std1+mean1) + lf1.*lfw21.*(theta(11,1).*std1+mean1);       
    va1_12_1= b(kh+kx1+1,1)               + lf1       .*(theta(12,1).*std1+mean1)                                       ;
    va2_12_1= va1_12_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(12,1).*std1+mean1) + lf1.*lfw6 .*(theta(12,1).*std1+mean1);
    va3_12_1= va2_12_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(12,1).*std1+mean1) + lf1.*lfw9 .*(theta(12,1).*std1+mean1);
    va4_12_1= va3_12_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(12,1).*std1+mean1) + lf1.*lfw12.*(theta(12,1).*std1+mean1);
    va5_12_1= va4_12_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(12,1).*std1+mean1) + lf1.*lfw15.*(theta(12,1).*std1+mean1);
    va6_12_1= va5_12_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(12,1).*std1+mean1) + lf1.*lfw18.*(theta(12,1).*std1+mean1);
    va7_12_1= va6_12_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(12,1).*std1+mean1) + lf1.*lfw21.*(theta(12,1).*std1+mean1);   
    va1_13_1= b(kh+kx1+1,1)               + lf1       .*(theta(13,1).*std1+mean1)                                       ;
    va2_13_1= va1_13_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(13,1).*std1+mean1) + lf1.*lfw6 .*(theta(13,1).*std1+mean1);
    va3_13_1= va2_13_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(13,1).*std1+mean1) + lf1.*lfw9 .*(theta(13,1).*std1+mean1);
    va4_13_1= va3_13_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(13,1).*std1+mean1) + lf1.*lfw12.*(theta(13,1).*std1+mean1);
    va5_13_1= va4_13_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(13,1).*std1+mean1) + lf1.*lfw15.*(theta(13,1).*std1+mean1);
    va6_13_1= va5_13_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(13,1).*std1+mean1) + lf1.*lfw18.*(theta(13,1).*std1+mean1);
    va7_13_1= va6_13_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(13,1).*std1+mean1) + lf1.*lfw21.*(theta(13,1).*std1+mean1);
      
    va1_1_2 = b(kh+kx1+1,1)              + lf1       .*(theta(1,1).*std2+mean2)                                       ;
    va2_1_2 = va1_1_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(1,1).*std2+mean2) + lf1.*lfw6 .*(theta(1,1).*std2+mean2);
    va3_1_2 = va2_1_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(1,1).*std2+mean2) + lf1.*lfw9 .*(theta(1,1).*std2+mean2);
    va4_1_2 = va3_1_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(1,1).*std2+mean2) + lf1.*lfw12.*(theta(1,1).*std2+mean2);
    va5_1_2 = va4_1_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(1,1).*std2+mean2) + lf1.*lfw15.*(theta(1,1).*std2+mean2);
    va6_1_2 = va5_1_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(1,1).*std2+mean2) + lf1.*lfw18.*(theta(1,1).*std2+mean2);
    va7_1_2 = va6_1_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(1,1).*std2+mean2) + lf1.*lfw21.*(theta(1,1).*std2+mean2);
    va1_2_2 = b(kh+kx1+1,1)              + lf1       .*(theta(2,1).*std2+mean2)                                       ;
    va2_2_2 = va1_2_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(2,1).*std2+mean2) + lf1.*lfw6 .*(theta(2,1).*std2+mean2);
    va3_2_2 = va2_2_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(2,1).*std2+mean2) + lf1.*lfw9 .*(theta(2,1).*std2+mean2);
    va4_2_2 = va3_2_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(2,1).*std2+mean2) + lf1.*lfw12.*(theta(2,1).*std2+mean2);
    va5_2_2 = va4_2_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(2,1).*std2+mean2) + lf1.*lfw15.*(theta(2,1).*std2+mean2);
    va6_2_2 = va5_2_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(2,1).*std2+mean2) + lf1.*lfw18.*(theta(2,1).*std2+mean2);
    va7_2_2 = va6_2_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(2,1).*std2+mean2) + lf1.*lfw21.*(theta(2,1).*std2+mean2);     
    va1_3_2 = b(kh+kx1+1,1)              + lf1       .*(theta(3,1).*std2+mean2)                                       ;
    va2_3_2 = va1_3_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(3,1).*std2+mean2) + lf1.*lfw6 .*(theta(3,1).*std2+mean2);
    va3_3_2 = va2_3_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(3,1).*std2+mean2) + lf1.*lfw9 .*(theta(3,1).*std2+mean2);
    va4_3_2 = va3_3_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(3,1).*std2+mean2) + lf1.*lfw12.*(theta(3,1).*std2+mean2);
    va5_3_2 = va4_3_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(3,1).*std2+mean2) + lf1.*lfw15.*(theta(3,1).*std2+mean2);
    va6_3_2 = va5_3_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(3,1).*std2+mean2) + lf1.*lfw18.*(theta(3,1).*std2+mean2);
    va7_3_2 = va6_3_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(3,1).*std2+mean2) + lf1.*lfw21.*(theta(3,1).*std2+mean2);  
    va1_4_2 = b(kh+kx1+1,1)              + lf1       .*(theta(4,1).*std2+mean2)                                       ;
    va2_4_2 = va1_4_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(4,1).*std2+mean2) + lf1.*lfw6 .*(theta(4,1).*std2+mean2);
    va3_4_2 = va2_4_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(4,1).*std2+mean2) + lf1.*lfw9 .*(theta(4,1).*std2+mean2);
    va4_4_2 = va3_4_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(4,1).*std2+mean2) + lf1.*lfw12.*(theta(4,1).*std2+mean2);
    va5_4_2 = va4_4_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(4,1).*std2+mean2) + lf1.*lfw15.*(theta(4,1).*std2+mean2);
    va6_4_2 = va5_4_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(4,1).*std2+mean2) + lf1.*lfw18.*(theta(4,1).*std2+mean2);
    va7_4_2 = va6_4_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(4,1).*std2+mean2) + lf1.*lfw21.*(theta(4,1).*std2+mean2); 
    va1_5_2 = b(kh+kx1+1,1)              + lf1       .*(theta(5,1).*std2+mean2)                                       ;
    va2_5_2 = va1_5_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(5,1).*std2+mean2) + lf1.*lfw6 .*(theta(5,1).*std2+mean2);
    va3_5_2 = va2_5_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(5,1).*std2+mean2) + lf1.*lfw9 .*(theta(5,1).*std2+mean2);
    va4_5_2 = va3_5_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(5,1).*std2+mean2) + lf1.*lfw12.*(theta(5,1).*std2+mean2);
    va5_5_2 = va4_5_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(5,1).*std2+mean2) + lf1.*lfw15.*(theta(5,1).*std2+mean2);
    va6_5_2 = va5_5_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(5,1).*std2+mean2) + lf1.*lfw18.*(theta(5,1).*std2+mean2);
    va7_5_2 = va6_5_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(5,1).*std2+mean2) + lf1.*lfw21.*(theta(5,1).*std2+mean2); 
    va1_6_2 = b(kh+kx1+1,1)              + lf1       .*(theta(6,1).*std2+mean2)                                       ;
    va2_6_2 = va1_6_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(6,1).*std2+mean2) + lf1.*lfw6 .*(theta(6,1).*std2+mean2);
    va3_6_2 = va2_6_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(6,1).*std2+mean2) + lf1.*lfw9 .*(theta(6,1).*std2+mean2);
    va4_6_2 = va3_6_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(6,1).*std2+mean2) + lf1.*lfw12.*(theta(6,1).*std2+mean2);
    va5_6_2 = va4_6_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(6,1).*std2+mean2) + lf1.*lfw15.*(theta(6,1).*std2+mean2);
    va6_6_2 = va5_6_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(6,1).*std2+mean2) + lf1.*lfw18.*(theta(6,1).*std2+mean2);
    va7_6_2 = va6_6_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(6,1).*std2+mean2) + lf1.*lfw21.*(theta(6,1).*std2+mean2); 
    va1_7_2 = b(kh+kx1+1,1)              + lf1       .*(theta(7,1).*std2+mean2)                                       ;
    va2_7_2 = va1_7_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(7,1).*std2+mean2) + lf1.*lfw6 .*(theta(7,1).*std2+mean2);
    va3_7_2 = va2_7_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(7,1).*std2+mean2) + lf1.*lfw9 .*(theta(7,1).*std2+mean2);
    va4_7_2 = va3_7_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(7,1).*std2+mean2) + lf1.*lfw12.*(theta(7,1).*std2+mean2);
    va5_7_2 = va4_7_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(7,1).*std2+mean2) + lf1.*lfw15.*(theta(7,1).*std2+mean2);
    va6_7_2 = va5_7_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(7,1).*std2+mean2) + lf1.*lfw18.*(theta(7,1).*std2+mean2);
    va7_7_2 = va6_7_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(7,1).*std2+mean2) + lf1.*lfw21.*(theta(7,1).*std2+mean2); 
    va1_8_2 = b(kh+kx1+1,1)              + lf1       .*(theta(8,1).*std2+mean2)                                       ;
    va2_8_2 = va1_8_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(8,1).*std2+mean2) + lf1.*lfw6 .*(theta(8,1).*std2+mean2);
    va3_8_2 = va2_8_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(8,1).*std2+mean2) + lf1.*lfw9 .*(theta(8,1).*std2+mean2);
    va4_8_2 = va3_8_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(8,1).*std2+mean2) + lf1.*lfw12.*(theta(8,1).*std2+mean2);
    va5_8_2 = va4_8_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(8,1).*std2+mean2) + lf1.*lfw15.*(theta(8,1).*std2+mean2);
    va6_8_2 = va5_8_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(8,1).*std2+mean2) + lf1.*lfw18.*(theta(8,1).*std2+mean2);
    va7_8_2 = va6_8_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(8,1).*std2+mean2) + lf1.*lfw21.*(theta(8,1).*std2+mean2);                                                              
    va1_9_2 = b(kh+kx1+1,1)              + lf1       .*(theta(9,1).*std2+mean2)                                       ;
    va2_9_2 = va1_9_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(9,1).*std2+mean2) + lf1.*lfw6 .*(theta(9,1).*std2+mean2);
    va3_9_2 = va2_9_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(9,1).*std2+mean2) + lf1.*lfw9 .*(theta(9,1).*std2+mean2);
    va4_9_2 = va3_9_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(9,1).*std2+mean2) + lf1.*lfw12.*(theta(9,1).*std2+mean2);
    va5_9_2 = va4_9_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(9,1).*std2+mean2) + lf1.*lfw15.*(theta(9,1).*std2+mean2);
    va6_9_2 = va5_9_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(9,1).*std2+mean2) + lf1.*lfw18.*(theta(9,1).*std2+mean2);
    va7_9_2 = va6_9_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(9,1).*std2+mean2) + lf1.*lfw21.*(theta(9,1).*std2+mean2);       
    va1_10_2= b(kh+kx1+1,1)               + lf1       .*(theta(10,1).*std2+mean2)                                       ;
    va2_10_2= va1_10_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(10,1).*std2+mean2) + lf1.*lfw6 .*(theta(10,1).*std2+mean2);
    va3_10_2= va2_10_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(10,1).*std2+mean2) + lf1.*lfw9 .*(theta(10,1).*std2+mean2);
    va4_10_2= va3_10_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(10,1).*std2+mean2) + lf1.*lfw12.*(theta(10,1).*std2+mean2);
    va5_10_2= va4_10_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(10,1).*std2+mean2) + lf1.*lfw15.*(theta(10,1).*std2+mean2);
    va6_10_2= va5_10_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(10,1).*std2+mean2) + lf1.*lfw18.*(theta(10,1).*std2+mean2);
    va7_10_2= va6_10_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(10,1).*std2+mean2) + lf1.*lfw21.*(theta(10,1).*std2+mean2);       
    va1_11_2= b(kh+kx1+1,1)               + lf1       .*(theta(11,1).*std2+mean2)                                       ;
    va2_11_2= va1_11_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(11,1).*std2+mean2) + lf1.*lfw6 .*(theta(11,1).*std2+mean2);
    va3_11_2= va2_11_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(11,1).*std2+mean2) + lf1.*lfw9 .*(theta(11,1).*std2+mean2);
    va4_11_2= va3_11_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(11,1).*std2+mean2) + lf1.*lfw12.*(theta(11,1).*std2+mean2);
    va5_11_2= va4_11_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(11,1).*std2+mean2) + lf1.*lfw15.*(theta(11,1).*std2+mean2);
    va6_11_2= va5_11_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(11,1).*std2+mean2) + lf1.*lfw18.*(theta(11,1).*std2+mean2);
    va7_11_2= va6_11_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(11,1).*std2+mean2) + lf1.*lfw21.*(theta(11,1).*std2+mean2);       
    va1_12_2= b(kh+kx1+1,1)               + lf1       .*(theta(12,1).*std2+mean2)                                       ;
    va2_12_2= va1_12_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(12,1).*std2+mean2) + lf1.*lfw6 .*(theta(12,1).*std2+mean2);
    va3_12_2= va2_12_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(12,1).*std2+mean2) + lf1.*lfw9 .*(theta(12,1).*std2+mean2);
    va4_12_2= va3_12_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(12,1).*std2+mean2) + lf1.*lfw12.*(theta(12,1).*std2+mean2);
    va5_12_2= va4_12_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(12,1).*std2+mean2) + lf1.*lfw15.*(theta(12,1).*std2+mean2);
    va6_12_2= va5_12_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(12,1).*std2+mean2) + lf1.*lfw18.*(theta(12,1).*std2+mean2);
    va7_12_2= va6_12_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(12,1).*std2+mean2) + lf1.*lfw21.*(theta(12,1).*std2+mean2);   
    va1_13_2= b(kh+kx1+1,1)               + lf1       .*(theta(13,1).*std2+mean2)                                       ;
    va2_13_2= va1_13_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(13,1).*std2+mean2) + lf1.*lfw6 .*(theta(13,1).*std2+mean2);
    va3_13_2= va2_13_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(13,1).*std2+mean2) + lf1.*lfw9 .*(theta(13,1).*std2+mean2);
    va4_13_2= va3_13_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(13,1).*std2+mean2) + lf1.*lfw12.*(theta(13,1).*std2+mean2);
    va5_13_2= va4_13_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(13,1).*std2+mean2) + lf1.*lfw15.*(theta(13,1).*std2+mean2);
    va6_13_2= va5_13_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(13,1).*std2+mean2) + lf1.*lfw18.*(theta(13,1).*std2+mean2);
    va7_13_2= va6_13_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(13,1).*std2+mean2) + lf1.*lfw21.*(theta(13,1).*std2+mean2);
 
    va1_1_3 = b(kh+kx1+1,1)              + lf1       .*(theta(1,1).*std3+mean3)                                       ;
    va2_1_3 = va1_1_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(1,1).*std3+mean3) + lf1.*lfw6 .*(theta(1,1).*std3+mean3);
    va3_1_3 = va2_1_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(1,1).*std3+mean3) + lf1.*lfw9 .*(theta(1,1).*std3+mean3);
    va4_1_3 = va3_1_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(1,1).*std3+mean3) + lf1.*lfw12.*(theta(1,1).*std3+mean3);
    va5_1_3 = va4_1_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(1,1).*std3+mean3) + lf1.*lfw15.*(theta(1,1).*std3+mean3);
    va6_1_3 = va5_1_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(1,1).*std3+mean3) + lf1.*lfw18.*(theta(1,1).*std3+mean3);
    va7_1_3 = va6_1_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(1,1).*std3+mean3) + lf1.*lfw21.*(theta(1,1).*std3+mean3);
    va1_2_3 = b(kh+kx1+1,1)              + lf1       .*(theta(2,1).*std3+mean3)                                       ;
    va2_2_3 = va1_2_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(2,1).*std3+mean3) + lf1.*lfw6 .*(theta(2,1).*std3+mean3);
    va3_2_3 = va2_2_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(2,1).*std3+mean3) + lf1.*lfw9 .*(theta(2,1).*std3+mean3);
    va4_2_3 = va3_2_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(2,1).*std3+mean3) + lf1.*lfw12.*(theta(2,1).*std3+mean3);
    va5_2_3 = va4_2_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(2,1).*std3+mean3) + lf1.*lfw15.*(theta(2,1).*std3+mean3);
    va6_2_3 = va5_2_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(2,1).*std3+mean3) + lf1.*lfw18.*(theta(2,1).*std3+mean3);
    va7_2_3 = va6_2_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(2,1).*std3+mean3) + lf1.*lfw21.*(theta(2,1).*std3+mean3);    
    va1_3_3 = b(kh+kx1+1,1)              + lf1       .*(theta(3,1).*std3+mean3)                                       ;
    va2_3_3 = va1_3_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(3,1).*std3+mean3) + lf1.*lfw6 .*(theta(3,1).*std3+mean3);
    va3_3_3 = va2_3_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(3,1).*std3+mean3) + lf1.*lfw9 .*(theta(3,1).*std3+mean3);
    va4_3_3 = va3_3_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(3,1).*std3+mean3) + lf1.*lfw12.*(theta(3,1).*std3+mean3);
    va5_3_3 = va4_3_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(3,1).*std3+mean3) + lf1.*lfw15.*(theta(3,1).*std3+mean3);
    va6_3_3 = va5_3_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(3,1).*std3+mean3) + lf1.*lfw18.*(theta(3,1).*std3+mean3);
    va7_3_3 = va6_3_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(3,1).*std3+mean3) + lf1.*lfw21.*(theta(3,1).*std3+mean3); 
    va1_4_3 = b(kh+kx1+1,1)              + lf1       .*(theta(4,1).*std3+mean3)                                       ;
    va2_4_3 = va1_4_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(4,1).*std3+mean3) + lf1.*lfw6 .*(theta(4,1).*std3+mean3);
    va3_4_3 = va2_4_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(4,1).*std3+mean3) + lf1.*lfw9 .*(theta(4,1).*std3+mean3);
    va4_4_3 = va3_4_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(4,1).*std3+mean3) + lf1.*lfw12.*(theta(4,1).*std3+mean3);
    va5_4_3 = va4_4_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(4,1).*std3+mean3) + lf1.*lfw15.*(theta(4,1).*std3+mean3);
    va6_4_3 = va5_4_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(4,1).*std3+mean3) + lf1.*lfw18.*(theta(4,1).*std3+mean3);
    va7_4_3 = va6_4_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(4,1).*std3+mean3) + lf1.*lfw21.*(theta(4,1).*std3+mean3);
    va1_5_3 = b(kh+kx1+1,1)              + lf1       .*(theta(5,1).*std3+mean3)                                       ;
    va2_5_3 = va1_5_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(5,1).*std3+mean3) + lf1.*lfw6 .*(theta(5,1).*std3+mean3);
    va3_5_3 = va2_5_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(5,1).*std3+mean3) + lf1.*lfw9 .*(theta(5,1).*std3+mean3);
    va4_5_3 = va3_5_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(5,1).*std3+mean3) + lf1.*lfw12.*(theta(5,1).*std3+mean3);
    va5_5_3 = va4_5_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(5,1).*std3+mean3) + lf1.*lfw15.*(theta(5,1).*std3+mean3);
    va6_5_3 = va5_5_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(5,1).*std3+mean3) + lf1.*lfw18.*(theta(5,1).*std3+mean3);
    va7_5_3 = va6_5_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(5,1).*std3+mean3) + lf1.*lfw21.*(theta(5,1).*std3+mean3);
    va1_6_3 = b(kh+kx1+1,1)              + lf1       .*(theta(6,1).*std3+mean3)                                       ;
    va2_6_3 = va1_6_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(6,1).*std3+mean3) + lf1.*lfw6 .*(theta(6,1).*std3+mean3);
    va3_6_3 = va2_6_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(6,1).*std3+mean3) + lf1.*lfw9 .*(theta(6,1).*std3+mean3);
    va4_6_3 = va3_6_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(6,1).*std3+mean3) + lf1.*lfw12.*(theta(6,1).*std3+mean3);
    va5_6_3 = va4_6_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(6,1).*std3+mean3) + lf1.*lfw15.*(theta(6,1).*std3+mean3);
    va6_6_3 = va5_6_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(6,1).*std3+mean3) + lf1.*lfw18.*(theta(6,1).*std3+mean3);
    va7_6_3 = va6_6_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(6,1).*std3+mean3) + lf1.*lfw21.*(theta(6,1).*std3+mean3);
    va1_7_3 = b(kh+kx1+1,1)              + lf1       .*(theta(7,1).*std3+mean3)                                		  ;
    va2_7_3 = va1_7_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(7,1).*std3+mean3) + lf1.*lfw6 .*(theta(7,1).*std3+mean3);
    va3_7_3 = va2_7_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(7,1).*std3+mean3) + lf1.*lfw9 .*(theta(7,1).*std3+mean3);
    va4_7_3 = va3_7_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(7,1).*std3+mean3) + lf1.*lfw12.*(theta(7,1).*std3+mean3);
    va5_7_3 = va4_7_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(7,1).*std3+mean3) + lf1.*lfw15.*(theta(7,1).*std3+mean3);
    va6_7_3 = va5_7_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(7,1).*std3+mean3) + lf1.*lfw18.*(theta(7,1).*std3+mean3);
    va7_7_3 = va6_7_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(7,1).*std3+mean3) + lf1.*lfw21.*(theta(7,1).*std3+mean3);
    va1_8_3 = b(kh+kx1+1,1)              + lf1       .*(theta(8,1).*std3+mean3)                                       ;
    va2_8_3 = va1_8_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(8,1).*std3+mean3) + lf1.*lfw6 .*(theta(8,1).*std3+mean3);
    va3_8_3 = va2_8_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(8,1).*std3+mean3) + lf1.*lfw9 .*(theta(8,1).*std3+mean3);
    va4_8_3 = va3_8_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(8,1).*std3+mean3) + lf1.*lfw12.*(theta(8,1).*std3+mean3);
    va5_8_3 = va4_8_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(8,1).*std3+mean3) + lf1.*lfw15.*(theta(8,1).*std3+mean3);
    va6_8_3 = va5_8_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(8,1).*std3+mean3) + lf1.*lfw18.*(theta(8,1).*std3+mean3);
    va7_8_3 = va6_8_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(8,1).*std3+mean3) + lf1.*lfw21.*(theta(8,1).*std3+mean3);                                                              
    va1_9_3 = b(kh+kx1+1,1)              + lf1       .*(theta(9,1).*std3+mean3)                                       ;
    va2_9_3 = va1_9_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(9,1).*std3+mean3) + lf1.*lfw6 .*(theta(9,1).*std3+mean3);
    va3_9_3 = va2_9_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(9,1).*std3+mean3) + lf1.*lfw9 .*(theta(9,1).*std3+mean3);
    va4_9_3 = va3_9_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(9,1).*std3+mean3) + lf1.*lfw12.*(theta(9,1).*std3+mean3);
    va5_9_3 = va4_9_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(9,1).*std3+mean3) + lf1.*lfw15.*(theta(9,1).*std3+mean3);
    va6_9_3 = va5_9_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(9,1).*std3+mean3) + lf1.*lfw18.*(theta(9,1).*std3+mean3);
    va7_9_3 = va6_9_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(9,1).*std3+mean3) + lf1.*lfw21.*(theta(9,1).*std3+mean3);       
    va1_10_3= b(kh+kx1+1,1)               + lf1       .*(theta(10,1).*std3+mean3)                                       ;
    va2_10_3= va1_10_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(10,1).*std3+mean3) + lf1.*lfw6 .*(theta(10,1).*std3+mean3);
    va3_10_3= va2_10_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(10,1).*std3+mean3) + lf1.*lfw9 .*(theta(10,1).*std3+mean3);
    va4_10_3= va3_10_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(10,1).*std3+mean3) + lf1.*lfw12.*(theta(10,1).*std3+mean3);
    va5_10_3= va4_10_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(10,1).*std3+mean3) + lf1.*lfw15.*(theta(10,1).*std3+mean3);
    va6_10_3= va5_10_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(10,1).*std3+mean3) + lf1.*lfw18.*(theta(10,1).*std3+mean3);
    va7_10_3= va6_10_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(10,1).*std3+mean3) + lf1.*lfw21.*(theta(10,1).*std3+mean3);       
    va1_11_3= b(kh+kx1+1,1)               + lf1       .*(theta(11,1).*std3+mean3)                                       ;
    va2_11_3= va1_11_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(11,1).*std3+mean3) + lf1.*lfw6 .*(theta(11,1).*std3+mean3);
    va3_11_3= va2_11_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(11,1).*std3+mean3) + lf1.*lfw9 .*(theta(11,1).*std3+mean3);
    va4_11_3= va3_11_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(11,1).*std3+mean3) + lf1.*lfw12.*(theta(11,1).*std3+mean3);
    va5_11_3= va4_11_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(11,1).*std3+mean3) + lf1.*lfw15.*(theta(11,1).*std3+mean3);
    va6_11_3= va5_11_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(11,1).*std3+mean3) + lf1.*lfw18.*(theta(11,1).*std3+mean3);
    va7_11_3= va6_11_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(11,1).*std3+mean3) + lf1.*lfw21.*(theta(11,1).*std3+mean3);       
    va1_12_3= b(kh+kx1+1,1)               + lf1       .*(theta(12,1).*std3+mean3)                                       ;
    va2_12_3= va1_12_1+exp(b(kh+kx1+2,1)) - lf1       .*(theta(12,1).*std3+mean3) + lf1.*lfw6 .*(theta(12,1).*std3+mean3);
    va3_12_3= va2_12_1+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(12,1).*std3+mean3) + lf1.*lfw9 .*(theta(12,1).*std3+mean3);
    va4_12_3= va3_12_1+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(12,1).*std3+mean3) + lf1.*lfw12.*(theta(12,1).*std3+mean3);
    va5_12_3= va4_12_1+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(12,1).*std3+mean3) + lf1.*lfw15.*(theta(12,1).*std3+mean3);
    va6_12_3= va5_12_1+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(12,1).*std3+mean3) + lf1.*lfw18.*(theta(12,1).*std3+mean3);
    va7_12_3= va6_12_1+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(12,1).*std3+mean3) + lf1.*lfw21.*(theta(12,1).*std3+mean3);   
    va1_13_3= b(kh+kx1+1,1)               + lf1       .*(theta(13,1).*std3+mean3)                                       ;
    va2_13_3= va1_13_2+exp(b(kh+kx1+2,1)) - lf1       .*(theta(13,1).*std3+mean3) + lf1.*lfw6 .*(theta(13,1).*std3+mean3);
    va3_13_3= va2_13_2+exp(b(kh+kx1+3,1)) - lf1.*lfw6 .*(theta(13,1).*std3+mean3) + lf1.*lfw9 .*(theta(13,1).*std3+mean3);
    va4_13_3= va3_13_2+exp(b(kh+kx1+4,1)) - lf1.*lfw9 .*(theta(13,1).*std3+mean3) + lf1.*lfw12.*(theta(13,1).*std3+mean3);
    va5_13_3= va4_13_2+exp(b(kh+kx1+5,1)) - lf1.*lfw12.*(theta(13,1).*std3+mean3) + lf1.*lfw15.*(theta(13,1).*std3+mean3);
    va6_13_3= va5_13_2+exp(b(kh+kx1+6,1)) - lf1.*lfw15.*(theta(13,1).*std3+mean3) + lf1.*lfw18.*(theta(13,1).*std3+mean3);
    va7_13_3= va6_13_2+exp(b(kh+kx1+7,1)) - lf1.*lfw18.*(theta(13,1).*std3+mean3) + lf1.*lfw21.*(theta(13,1).*std3+mean3);   
    kh  = kh+kx1+7;    
%--------------------------------------------------------------------------
%1.2 Assign b to 2nd childbirth equation
%--------------------------------------------------------------------------
    bX2 = [b(kh+1:kh+2,1); bX1];
    vb1_1_1 = b(kh+3,1)              + lf2       .*(theta(1,1).*std1+mean1)                                       ;
    vb2_1_1 = vb1_1_1+exp(b(kh+4,1)) - lf2       .*(theta(1,1).*std1+mean1) + lf2.*lfw9 .*(theta(1,1).*std1+mean1);
    vb3_1_1 = vb2_1_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(1,1).*std1+mean1) + lf2.*lfw12.*(theta(1,1).*std1+mean1);
    vb4_1_1 = vb3_1_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(1,1).*std1+mean1) + lf2.*lfw15.*(theta(1,1).*std1+mean1);
    vb5_1_1 = vb4_1_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(1,1).*std1+mean1) + lf2.*lfw18.*(theta(1,1).*std1+mean1);
    vb6_1_1 = vb5_1_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(1,1).*std1+mean1) + lf2.*lfw21.*(theta(1,1).*std1+mean1);
    vb1_2_1 = b(kh+3,1)              + lf2       .*(theta(2,1).*std1+mean1)                                       ;
    vb2_2_1 = vb1_2_1+exp(b(kh+4,1)) - lf2       .*(theta(2,1).*std1+mean1) + lf2.*lfw9 .*(theta(2,1).*std1+mean1);
    vb3_2_1 = vb2_2_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(2,1).*std1+mean1) + lf2.*lfw12.*(theta(2,1).*std1+mean1);
    vb4_2_1 = vb3_2_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(2,1).*std1+mean1) + lf2.*lfw15.*(theta(2,1).*std1+mean1);
    vb5_2_1 = vb4_2_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(2,1).*std1+mean1) + lf2.*lfw18.*(theta(2,1).*std1+mean1);
    vb6_2_1 = vb5_2_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(2,1).*std1+mean1) + lf2.*lfw21.*(theta(2,1).*std1+mean1);
    vb1_3_1 = b(kh+3,1)              + lf2       .*(theta(3,1).*std1+mean1)                                       ;
    vb2_3_1 = vb1_3_1+exp(b(kh+4,1)) - lf2       .*(theta(3,1).*std1+mean1) + lf2.*lfw9 .*(theta(3,1).*std1+mean1);
    vb3_3_1 = vb2_3_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(3,1).*std1+mean1) + lf2.*lfw12.*(theta(3,1).*std1+mean1);
    vb4_3_1 = vb3_3_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(3,1).*std1+mean1) + lf2.*lfw15.*(theta(3,1).*std1+mean1);
    vb5_3_1 = vb4_3_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(3,1).*std1+mean1) + lf2.*lfw18.*(theta(3,1).*std1+mean1);
    vb6_3_1 = vb5_3_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(3,1).*std1+mean1) + lf2.*lfw21.*(theta(3,1).*std1+mean1);
    vb1_4_1 = b(kh+3,1)              + lf2       .*(theta(4,1).*std1+mean1)                                       ;
    vb2_4_1 = vb1_4_1+exp(b(kh+4,1)) - lf2       .*(theta(4,1).*std1+mean1) + lf2.*lfw9 .*(theta(4,1).*std1+mean1);
    vb3_4_1 = vb2_4_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(4,1).*std1+mean1) + lf2.*lfw12.*(theta(4,1).*std1+mean1);
    vb4_4_1 = vb3_4_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(4,1).*std1+mean1) + lf2.*lfw15.*(theta(4,1).*std1+mean1);
    vb5_4_1 = vb4_4_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(4,1).*std1+mean1) + lf2.*lfw18.*(theta(4,1).*std1+mean1);
    vb6_4_1 = vb5_4_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(4,1).*std1+mean1) + lf2.*lfw21.*(theta(4,1).*std1+mean1);
    vb1_5_1 = b(kh+3,1)              + lf2       .*(theta(5,1).*std1+mean1)                                       ;
    vb2_5_1 = vb1_5_1+exp(b(kh+4,1)) - lf2       .*(theta(5,1).*std1+mean1) + lf2.*lfw9 .*(theta(5,1).*std1+mean1);
    vb3_5_1 = vb2_5_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(5,1).*std1+mean1) + lf2.*lfw12.*(theta(5,1).*std1+mean1);
    vb4_5_1 = vb3_5_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(5,1).*std1+mean1) + lf2.*lfw15.*(theta(5,1).*std1+mean1);
    vb5_5_1 = vb4_5_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(5,1).*std1+mean1) + lf2.*lfw18.*(theta(5,1).*std1+mean1);
    vb6_5_1 = vb5_5_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(5,1).*std1+mean1) + lf2.*lfw21.*(theta(5,1).*std1+mean1);
    vb1_6_1 = b(kh+3,1)              + lf2       .*(theta(6,1).*std1+mean1)                                       ;
    vb2_6_1 = vb1_6_1+exp(b(kh+4,1)) - lf2       .*(theta(6,1).*std1+mean1) + lf2.*lfw9 .*(theta(6,1).*std1+mean1);
    vb3_6_1 = vb2_6_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(6,1).*std1+mean1) + lf2.*lfw12.*(theta(6,1).*std1+mean1);
    vb4_6_1 = vb3_6_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(6,1).*std1+mean1) + lf2.*lfw15.*(theta(6,1).*std1+mean1);
    vb5_6_1 = vb4_6_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(6,1).*std1+mean1) + lf2.*lfw18.*(theta(6,1).*std1+mean1);
    vb6_6_1 = vb5_6_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(6,1).*std1+mean1) + lf2.*lfw21.*(theta(6,1).*std1+mean1);
    vb1_7_1 = b(kh+3,1)              + lf2       .*(theta(7,1).*std1+mean1)                                       ;
    vb2_7_1 = vb1_7_1+exp(b(kh+4,1)) - lf2       .*(theta(7,1).*std1+mean1) + lf2.*lfw9 .*(theta(7,1).*std1+mean1);
    vb3_7_1 = vb2_7_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(7,1).*std1+mean1) + lf2.*lfw12.*(theta(7,1).*std1+mean1);
    vb4_7_1 = vb3_7_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(7,1).*std1+mean1) + lf2.*lfw15.*(theta(7,1).*std1+mean1);
    vb5_7_1 = vb4_7_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(7,1).*std1+mean1) + lf2.*lfw18.*(theta(7,1).*std1+mean1);
    vb6_7_1 = vb5_7_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(7,1).*std1+mean1) + lf2.*lfw21.*(theta(7,1).*std1+mean1);
    vb1_8_1 = b(kh+3,1)              + lf2       .*(theta(8,1).*std1+mean1)                                       ;
    vb2_8_1 = vb1_8_1+exp(b(kh+4,1)) - lf2       .*(theta(8,1).*std1+mean1) + lf2.*lfw9 .*(theta(8,1).*std1+mean1);
    vb3_8_1 = vb2_8_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(8,1).*std1+mean1) + lf2.*lfw12.*(theta(8,1).*std1+mean1);
    vb4_8_1 = vb3_8_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(8,1).*std1+mean1) + lf2.*lfw15.*(theta(8,1).*std1+mean1);
    vb5_8_1 = vb4_8_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(8,1).*std1+mean1) + lf2.*lfw18.*(theta(8,1).*std1+mean1);
    vb6_8_1 = vb5_8_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(8,1).*std1+mean1) + lf2.*lfw21.*(theta(8,1).*std1+mean1);  
    vb1_9_1 = b(kh+3,1)              + lf2       .*(theta(9,1).*std1+mean1)                                       ;
    vb2_9_1 = vb1_9_1+exp(b(kh+4,1)) - lf2       .*(theta(9,1).*std1+mean1) + lf2.*lfw9 .*(theta(9,1).*std1+mean1);
    vb3_9_1 = vb2_9_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(9,1).*std1+mean1) + lf2.*lfw12.*(theta(9,1).*std1+mean1);
    vb4_9_1 = vb3_9_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(9,1).*std1+mean1) + lf2.*lfw15.*(theta(9,1).*std1+mean1);
    vb5_9_1 = vb4_9_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(9,1).*std1+mean1) + lf2.*lfw18.*(theta(9,1).*std1+mean1);
    vb6_9_1 = vb5_9_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(9,1).*std1+mean1) + lf2.*lfw21.*(theta(9,1).*std1+mean1);
    vb1_10_1= b(kh+3,1)              + lf2       .*(theta(10,1).*std1+mean1)                                       ;
    vb2_10_1= vb1_10_1+exp(b(kh+4,1)) - lf2       .*(theta(10,1).*std1+mean1) + lf2.*lfw9 .*(theta(10,1).*std1+mean1);
    vb3_10_1= vb2_10_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(10,1).*std1+mean1) + lf2.*lfw12.*(theta(10,1).*std1+mean1);
    vb4_10_1= vb3_10_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(10,1).*std1+mean1) + lf2.*lfw15.*(theta(10,1).*std1+mean1);
    vb5_10_1= vb4_10_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(10,1).*std1+mean1) + lf2.*lfw18.*(theta(10,1).*std1+mean1);
    vb6_10_1= vb5_10_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(10,1).*std1+mean1) + lf2.*lfw21.*(theta(10,1).*std1+mean1);        
    vb1_11_1= b(kh+3,1)               + lf2       .*(theta(11,1).*std1+mean1)                                       ;
    vb2_11_1= vb1_11_1+exp(b(kh+4,1)) - lf2       .*(theta(11,1).*std1+mean1) + lf2.*lfw9 .*(theta(11,1).*std1+mean1);
    vb3_11_1= vb2_11_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(11,1).*std1+mean1) + lf2.*lfw12.*(theta(11,1).*std1+mean1);
    vb4_11_1= vb3_11_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(11,1).*std1+mean1) + lf2.*lfw15.*(theta(11,1).*std1+mean1);
    vb5_11_1= vb4_11_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(11,1).*std1+mean1) + lf2.*lfw18.*(theta(11,1).*std1+mean1);
    vb6_11_1= vb5_11_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(11,1).*std1+mean1) + lf2.*lfw21.*(theta(11,1).*std1+mean1);         
    vb1_12_1= b(kh+3,1)               + lf2       .*(theta(12,1).*std1+mean1)                                       ;
    vb2_12_1= vb1_12_1+exp(b(kh+4,1)) - lf2       .*(theta(12,1).*std1+mean1) + lf2.*lfw9 .*(theta(12,1).*std1+mean1);
    vb3_12_1= vb2_12_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(12,1).*std1+mean1) + lf2.*lfw12.*(theta(12,1).*std1+mean1);
    vb4_12_1= vb3_12_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(12,1).*std1+mean1) + lf2.*lfw15.*(theta(12,1).*std1+mean1);
    vb5_12_1= vb4_12_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(12,1).*std1+mean1) + lf2.*lfw18.*(theta(12,1).*std1+mean1);
    vb6_12_1= vb5_12_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(12,1).*std1+mean1) + lf2.*lfw21.*(theta(12,1).*std1+mean1);  
    vb1_13_1= b(kh+3,1)               + lf2       .*(theta(13,1).*std1+mean1)                                       ;
    vb2_13_1= vb1_13_1+exp(b(kh+4,1)) - lf2       .*(theta(13,1).*std1+mean1) + lf2.*lfw9 .*(theta(13,1).*std1+mean1);
    vb3_13_1= vb2_13_1+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(13,1).*std1+mean1) + lf2.*lfw12.*(theta(13,1).*std1+mean1);
    vb4_13_1= vb3_13_1+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(13,1).*std1+mean1) + lf2.*lfw15.*(theta(13,1).*std1+mean1);
    vb5_13_1= vb4_13_1+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(13,1).*std1+mean1) + lf2.*lfw18.*(theta(13,1).*std1+mean1);
    vb6_13_1= vb5_13_1+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(13,1).*std1+mean1) + lf2.*lfw21.*(theta(13,1).*std1+mean1);
     
    vb1_1_2 = b(kh+3,1)              + lf2       .*(theta(1,1).*std2+mean2)                                       ;
    vb2_1_2 = vb1_1_2+exp(b(kh+4,1)) - lf2       .*(theta(1,1).*std2+mean2) + lf2.*lfw9 .*(theta(1,1).*std2+mean2);
    vb3_1_2 = vb2_1_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(1,1).*std2+mean2) + lf2.*lfw12.*(theta(1,1).*std2+mean2);
    vb4_1_2 = vb3_1_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(1,1).*std2+mean2) + lf2.*lfw15.*(theta(1,1).*std2+mean2);
    vb5_1_2 = vb4_1_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(1,1).*std2+mean2) + lf2.*lfw18.*(theta(1,1).*std2+mean2);
    vb6_1_2 = vb5_1_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(1,1).*std2+mean2) + lf2.*lfw21.*(theta(1,1).*std2+mean2);
    vb1_2_2 = b(kh+3,1)              + lf2       .*(theta(2,1).*std2+mean2)                               		  ;
    vb2_2_2 = vb1_2_2+exp(b(kh+4,1)) - lf2       .*(theta(2,1).*std2+mean2) + lf2.*lfw9 .*(theta(2,1).*std2+mean2);
    vb3_2_2 = vb2_2_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(2,1).*std2+mean2) + lf2.*lfw12.*(theta(2,1).*std2+mean2);
    vb4_2_2 = vb3_2_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(2,1).*std2+mean2) + lf2.*lfw15.*(theta(2,1).*std2+mean2);
    vb5_2_2 = vb4_2_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(2,1).*std2+mean2) + lf2.*lfw18.*(theta(2,1).*std2+mean2);
    vb6_2_2 = vb5_2_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(2,1).*std2+mean2) + lf2.*lfw21.*(theta(2,1).*std2+mean2);
    vb1_3_2 = b(kh+3,1)              + lf2       .*(theta(3,1).*std2+mean2)                               		  ;
    vb2_3_2 = vb1_3_2+exp(b(kh+4,1)) - lf2       .*(theta(3,1).*std2+mean2) + lf2.*lfw9 .*(theta(3,1).*std2+mean2);
    vb3_3_2 = vb2_3_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(3,1).*std2+mean2) + lf2.*lfw12.*(theta(3,1).*std2+mean2);
    vb4_3_2 = vb3_3_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(3,1).*std2+mean2) + lf2.*lfw15.*(theta(3,1).*std2+mean2);
    vb5_3_2 = vb4_3_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(3,1).*std2+mean2) + lf2.*lfw18.*(theta(3,1).*std2+mean2);
    vb6_3_2 = vb5_3_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(3,1).*std2+mean2) + lf2.*lfw21.*(theta(3,1).*std2+mean2);
    vb1_4_2 = b(kh+3,1)              + lf2       .*(theta(4,1).*std2+mean2)                               		  ;
    vb2_4_2 = vb1_4_2+exp(b(kh+4,1)) - lf2       .*(theta(4,1).*std2+mean2) + lf2.*lfw9 .*(theta(4,1).*std2+mean2);
    vb3_4_2 = vb2_4_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(4,1).*std2+mean2) + lf2.*lfw12.*(theta(4,1).*std2+mean2);
    vb4_4_2 = vb3_4_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(4,1).*std2+mean2) + lf2.*lfw15.*(theta(4,1).*std2+mean2);
    vb5_4_2 = vb4_4_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(4,1).*std2+mean2) + lf2.*lfw18.*(theta(4,1).*std2+mean2);
    vb6_4_2 = vb5_4_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(4,1).*std2+mean2) + lf2.*lfw21.*(theta(4,1).*std2+mean2);
    vb1_5_2 = b(kh+3,1)              + lf2       .*(theta(5,1).*std2+mean2)                                       ;
    vb2_5_2 = vb1_5_2+exp(b(kh+4,1)) - lf2       .*(theta(5,1).*std2+mean2) + lf2.*lfw9 .*(theta(5,1).*std2+mean2);
    vb3_5_2 = vb2_5_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(5,1).*std2+mean2) + lf2.*lfw12.*(theta(5,1).*std2+mean2);
    vb4_5_2 = vb3_5_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(5,1).*std2+mean2) + lf2.*lfw15.*(theta(5,1).*std2+mean2);
    vb5_5_2 = vb4_5_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(5,1).*std2+mean2) + lf2.*lfw18.*(theta(5,1).*std2+mean2);
    vb6_5_2 = vb5_5_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(5,1).*std2+mean2) + lf2.*lfw21.*(theta(5,1).*std2+mean2);
    vb1_6_2 = b(kh+3,1)              + lf2       .*(theta(6,1).*std2+mean2)                                	      ;
    vb2_6_2 = vb1_6_2+exp(b(kh+4,1)) - lf2       .*(theta(6,1).*std2+mean2) + lf2.*lfw9 .*(theta(6,1).*std2+mean2);
    vb3_6_2 = vb2_6_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(6,1).*std2+mean2) + lf2.*lfw12.*(theta(6,1).*std2+mean2);
    vb4_6_2 = vb3_6_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(6,1).*std2+mean2) + lf2.*lfw15.*(theta(6,1).*std2+mean2);
    vb5_6_2 = vb4_6_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(6,1).*std2+mean2) + lf2.*lfw18.*(theta(6,1).*std2+mean2);
    vb6_6_2 = vb5_6_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(6,1).*std2+mean2) + lf2.*lfw21.*(theta(6,1).*std2+mean2);
    vb1_7_2 = b(kh+3,1)              + lf2       .*(theta(7,1).*std2+mean2)                               		  ;
    vb2_7_2 = vb1_7_2+exp(b(kh+4,1)) - lf2       .*(theta(7,1).*std2+mean2) + lf2.*lfw9 .*(theta(7,1).*std2+mean2);
    vb3_7_2 = vb2_7_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(7,1).*std2+mean2) + lf2.*lfw12.*(theta(7,1).*std2+mean2);
    vb4_7_2 = vb3_7_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(7,1).*std2+mean2) + lf2.*lfw15.*(theta(7,1).*std2+mean2);
    vb5_7_2 = vb4_7_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(7,1).*std2+mean2) + lf2.*lfw18.*(theta(7,1).*std2+mean2);
    vb6_7_2 = vb5_7_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(7,1).*std2+mean2) + lf2.*lfw21.*(theta(7,1).*std2+mean2); 
    vb1_8_2 = b(kh+3,1)              + lf2       .*(theta(8,1).*std2+mean2)                                       ;
    vb2_8_2 = vb1_8_2+exp(b(kh+4,1)) - lf2       .*(theta(8,1).*std2+mean2) + lf2.*lfw9 .*(theta(8,1).*std2+mean2);
    vb3_8_2 = vb2_8_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(8,1).*std2+mean2) + lf2.*lfw12.*(theta(8,1).*std2+mean2);
    vb4_8_2 = vb3_8_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(8,1).*std2+mean2) + lf2.*lfw15.*(theta(8,1).*std2+mean2);
    vb5_8_2 = vb4_8_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(8,1).*std2+mean2) + lf2.*lfw18.*(theta(8,1).*std2+mean2);
    vb6_8_2 = vb5_8_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(8,1).*std2+mean2) + lf2.*lfw21.*(theta(8,1).*std2+mean2);   
    vb1_9_2 = b(kh+3,1)              + lf2       .*(theta(9,1).*std2+mean2)                               		  ;
    vb2_9_2 = vb1_9_2+exp(b(kh+4,1)) - lf2       .*(theta(9,1).*std2+mean2) + lf2.*lfw9 .*(theta(9,1).*std2+mean2);
    vb3_9_2 = vb2_9_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(9,1).*std2+mean2) + lf2.*lfw12.*(theta(9,1).*std2+mean2);
    vb4_9_2 = vb3_9_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(9,1).*std2+mean2) + lf2.*lfw15.*(theta(9,1).*std2+mean2);
    vb5_9_2 = vb4_9_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(9,1).*std2+mean2) + lf2.*lfw18.*(theta(9,1).*std2+mean2);
    vb6_9_2 = vb5_9_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(9,1).*std2+mean2) + lf2.*lfw21.*(theta(9,1).*std2+mean2);
    vb1_10_2= b(kh+3,1)               + lf2       .*(theta(10,1).*std2+mean2)                               	     ;
    vb2_10_2= vb1_10_2+exp(b(kh+4,1)) - lf2       .*(theta(10,1).*std2+mean2) + lf2.*lfw9 .*(theta(10,1).*std2+mean2);
    vb3_10_2= vb2_10_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(10,1).*std2+mean2) + lf2.*lfw12.*(theta(10,1).*std2+mean2);
    vb4_10_2= vb3_10_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(10,1).*std2+mean2) + lf2.*lfw15.*(theta(10,1).*std2+mean2);
    vb5_10_2= vb4_10_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(10,1).*std2+mean2) + lf2.*lfw18.*(theta(10,1).*std2+mean2);
    vb6_10_2= vb5_10_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(10,1).*std2+mean2) + lf2.*lfw21.*(theta(10,1).*std2+mean2);         
    vb1_11_2= b(kh+3,1)               + lf2       .*(theta(11,1).*std2+mean2)                               	     ;
    vb2_11_2= vb1_11_2+exp(b(kh+4,1)) - lf2       .*(theta(11,1).*std2+mean2) + lf2.*lfw9 .*(theta(11,1).*std2+mean2);
    vb3_11_2= vb2_11_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(11,1).*std2+mean2) + lf2.*lfw12.*(theta(11,1).*std2+mean2);
    vb4_11_2= vb3_11_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(11,1).*std2+mean2) + lf2.*lfw15.*(theta(11,1).*std2+mean2);
    vb5_11_2= vb4_11_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(11,1).*std2+mean2) + lf2.*lfw18.*(theta(11,1).*std2+mean2);
    vb6_11_2= vb5_11_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(11,1).*std2+mean2) + lf2.*lfw21.*(theta(11,1).*std2+mean2);          
    vb1_12_2= b(kh+3,1)               + lf2       .*(theta(12,1).*std2+mean2)                                       ;
    vb2_12_2= vb1_12_2+exp(b(kh+4,1)) - lf2       .*(theta(12,1).*std2+mean2) + lf2.*lfw9 .*(theta(12,1).*std2+mean2);
    vb3_12_2= vb2_12_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(12,1).*std2+mean2) + lf2.*lfw12.*(theta(12,1).*std2+mean2);
    vb4_12_2= vb3_12_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(12,1).*std2+mean2) + lf2.*lfw15.*(theta(12,1).*std2+mean2);
    vb5_12_2= vb4_12_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(12,1).*std2+mean2) + lf2.*lfw18.*(theta(12,1).*std2+mean2);
    vb6_12_2= vb5_12_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(12,1).*std2+mean2) + lf2.*lfw21.*(theta(12,1).*std2+mean2);   
    vb1_13_2= b(kh+3,1)               + lf2       .*(theta(13,1).*std2+mean2)                                	     ;
    vb2_13_2= vb1_13_2+exp(b(kh+4,1)) - lf2       .*(theta(13,1).*std2+mean2) + lf2.*lfw9 .*(theta(13,1).*std2+mean2);
    vb3_13_2= vb2_13_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(13,1).*std2+mean2) + lf2.*lfw12.*(theta(13,1).*std2+mean2);
    vb4_13_2= vb3_13_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(13,1).*std2+mean2) + lf2.*lfw15.*(theta(13,1).*std2+mean2);
    vb5_13_2= vb4_13_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(13,1).*std2+mean2) + lf2.*lfw18.*(theta(13,1).*std2+mean2);
    vb6_13_2= vb5_13_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(13,1).*std2+mean2) + lf2.*lfw21.*(theta(13,1).*std2+mean2);
 
    vb1_1_3 = b(kh+3,1)              + lf2       .*(theta(1,1).*std3+mean3)                                       ;
    vb2_1_3 = vb1_1_2+exp(b(kh+4,1)) - lf2       .*(theta(1,1).*std3+mean3) + lf2.*lfw9 .*(theta(1,1).*std3+mean3);
    vb3_1_3 = vb2_1_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(1,1).*std3+mean3) + lf2.*lfw12.*(theta(1,1).*std3+mean3);
    vb4_1_3 = vb3_1_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(1,1).*std3+mean3) + lf2.*lfw15.*(theta(1,1).*std3+mean3);
    vb5_1_3 = vb4_1_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(1,1).*std3+mean3) + lf2.*lfw18.*(theta(1,1).*std3+mean3);
    vb6_1_3 = vb5_1_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(1,1).*std3+mean3) + lf2.*lfw21.*(theta(1,1).*std3+mean3);
    vb1_2_3 = b(kh+3,1)              + lf2       .*(theta(2,1).*std3+mean3)                                       ;
    vb2_2_3 = vb1_2_2+exp(b(kh+4,1)) - lf2       .*(theta(2,1).*std3+mean3) + lf2.*lfw9 .*(theta(2,1).*std3+mean3);
    vb3_2_3 = vb2_2_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(2,1).*std3+mean3) + lf2.*lfw12.*(theta(2,1).*std3+mean3);
    vb4_2_3 = vb3_2_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(2,1).*std3+mean3) + lf2.*lfw15.*(theta(2,1).*std3+mean3);
    vb5_2_3 = vb4_2_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(2,1).*std3+mean3) + lf2.*lfw18.*(theta(2,1).*std3+mean3);
    vb6_2_3 = vb5_2_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(2,1).*std3+mean3) + lf2.*lfw21.*(theta(2,1).*std3+mean3);
    vb1_3_3 = b(kh+3,1)              + lf2       .*(theta(3,1).*std3+mean3)                                       ;
    vb2_3_3 = vb1_3_2+exp(b(kh+4,1)) - lf2       .*(theta(3,1).*std3+mean3) + lf2.*lfw9 .*(theta(3,1).*std3+mean3);
    vb3_3_3 = vb2_3_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(3,1).*std3+mean3) + lf2.*lfw12.*(theta(3,1).*std3+mean3);
    vb4_3_3 = vb3_3_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(3,1).*std3+mean3) + lf2.*lfw15.*(theta(3,1).*std3+mean3);
    vb5_3_3 = vb4_3_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(3,1).*std3+mean3) + lf2.*lfw18.*(theta(3,1).*std3+mean3);
    vb6_3_3 = vb5_3_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(3,1).*std3+mean3) + lf2.*lfw21.*(theta(3,1).*std3+mean3);
    vb1_4_3 = b(kh+3,1)              + lf2       .*(theta(4,1).*std3+mean3)                                       ;
    vb2_4_3 = vb1_4_2+exp(b(kh+4,1)) - lf2       .*(theta(4,1).*std3+mean3) + lf2.*lfw9 .*(theta(4,1).*std3+mean3);
    vb3_4_3 = vb2_4_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(4,1).*std3+mean3) + lf2.*lfw12.*(theta(4,1).*std3+mean3);
    vb4_4_3 = vb3_4_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(4,1).*std3+mean3) + lf2.*lfw15.*(theta(4,1).*std3+mean3);
    vb5_4_3 = vb4_4_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(4,1).*std3+mean3) + lf2.*lfw18.*(theta(4,1).*std3+mean3);
    vb6_4_3 = vb5_4_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(4,1).*std3+mean3) + lf2.*lfw21.*(theta(4,1).*std3+mean3);
    vb1_5_3 = b(kh+3,1)              + lf2       .*(theta(5,1).*std3+mean3)                                       ;
    vb2_5_3 = vb1_5_2+exp(b(kh+4,1)) - lf2       .*(theta(5,1).*std3+mean3) + lf2.*lfw9 .*(theta(5,1).*std3+mean3);
    vb3_5_3 = vb2_5_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(5,1).*std3+mean3) + lf2.*lfw12.*(theta(5,1).*std3+mean3);
    vb4_5_3 = vb3_5_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(5,1).*std3+mean3) + lf2.*lfw15.*(theta(5,1).*std3+mean3);
    vb5_5_3 = vb4_5_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(5,1).*std3+mean3) + lf2.*lfw18.*(theta(5,1).*std3+mean3);
    vb6_5_3 = vb5_5_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(5,1).*std3+mean3) + lf2.*lfw21.*(theta(5,1).*std3+mean3);
    vb1_6_3 = b(kh+3,1)              + lf2       .*(theta(6,1).*std3+mean3)                                       ;
    vb2_6_3 = vb1_6_2+exp(b(kh+4,1)) - lf2       .*(theta(6,1).*std3+mean3) + lf2.*lfw9 .*(theta(6,1).*std3+mean3);
    vb3_6_3 = vb2_6_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(6,1).*std3+mean3) + lf2.*lfw12.*(theta(6,1).*std3+mean3);
    vb4_6_3 = vb3_6_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(6,1).*std3+mean3) + lf2.*lfw15.*(theta(6,1).*std3+mean3);
    vb5_6_3 = vb4_6_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(6,1).*std3+mean3) + lf2.*lfw18.*(theta(6,1).*std3+mean3);
    vb6_6_3 = vb5_6_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(6,1).*std3+mean3) + lf2.*lfw21.*(theta(6,1).*std3+mean3);
    vb1_7_3 = b(kh+3,1)              + lf2       .*(theta(7,1).*std3+mean3)                                       ;
    vb2_7_3 = vb1_7_2+exp(b(kh+4,1)) - lf2       .*(theta(7,1).*std3+mean3) + lf2.*lfw9 .*(theta(7,1).*std3+mean3);
    vb3_7_3 = vb2_7_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(7,1).*std3+mean3) + lf2.*lfw12.*(theta(7,1).*std3+mean3);
    vb4_7_3 = vb3_7_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(7,1).*std3+mean3) + lf2.*lfw15.*(theta(7,1).*std3+mean3);
    vb5_7_3 = vb4_7_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(7,1).*std3+mean3) + lf2.*lfw18.*(theta(7,1).*std3+mean3);
    vb6_7_3 = vb5_7_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(7,1).*std3+mean3) + lf2.*lfw21.*(theta(7,1).*std3+mean3); 
    vb1_8_3 = b(kh+3,1)              + lf2       .*(theta(8,1).*std3+mean3)                                       ;
    vb2_8_3 = vb1_8_2+exp(b(kh+4,1)) - lf2       .*(theta(8,1).*std3+mean3) + lf2.*lfw9 .*(theta(8,1).*std3+mean3);
    vb3_8_3 = vb2_8_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(8,1).*std3+mean3) + lf2.*lfw12.*(theta(8,1).*std3+mean3);
    vb4_8_3 = vb3_8_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(8,1).*std3+mean3) + lf2.*lfw15.*(theta(8,1).*std3+mean3);
    vb5_8_3 = vb4_8_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(8,1).*std3+mean3) + lf2.*lfw18.*(theta(8,1).*std3+mean3);
    vb6_8_3 = vb5_8_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(8,1).*std3+mean3) + lf2.*lfw21.*(theta(8,1).*std3+mean3);  
    vb1_9_3 = b(kh+3,1)              + lf2       .*(theta(9,1).*std3+mean3)                                       ;
    vb2_9_3 = vb1_9_2+exp(b(kh+4,1)) - lf2       .*(theta(9,1).*std3+mean3) + lf2.*lfw9 .*(theta(9,1).*std3+mean3);
    vb3_9_3 = vb2_9_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(9,1).*std3+mean3) + lf2.*lfw12.*(theta(9,1).*std3+mean3);
    vb4_9_3 = vb3_9_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(9,1).*std3+mean3) + lf2.*lfw15.*(theta(9,1).*std3+mean3);
    vb5_9_3 = vb4_9_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(9,1).*std3+mean3) + lf2.*lfw18.*(theta(9,1).*std3+mean3);
    vb6_9_3 = vb5_9_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(9,1).*std3+mean3) + lf2.*lfw21.*(theta(9,1).*std3+mean3);
    vb1_10_3= b(kh+3,1)               + lf2       .*(theta(10,1).*std3+mean3)                                        ;
    vb2_10_3= vb1_10_2+exp(b(kh+4,1)) - lf2       .*(theta(10,1).*std3+mean3) + lf2.*lfw9 .*(theta(10,1).*std3+mean3);
    vb3_10_3= vb2_10_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(10,1).*std3+mean3) + lf2.*lfw12.*(theta(10,1).*std3+mean3);
    vb4_10_3= vb3_10_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(10,1).*std3+mean3) + lf2.*lfw15.*(theta(10,1).*std3+mean3);
    vb5_10_3= vb4_10_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(10,1).*std3+mean3) + lf2.*lfw18.*(theta(10,1).*std3+mean3);
    vb6_10_3= vb5_10_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(10,1).*std3+mean3) + lf2.*lfw21.*(theta(10,1).*std3+mean3);        
    vb1_11_3= b(kh+3,1)               + lf2       .*(theta(11,1).*std3+mean3)                                        ;
    vb2_11_3= vb1_11_2+exp(b(kh+4,1)) - lf2       .*(theta(11,1).*std3+mean3) + lf2.*lfw9 .*(theta(11,1).*std3+mean3);
    vb3_11_3= vb2_11_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(11,1).*std3+mean3) + lf2.*lfw12.*(theta(11,1).*std3+mean3);
    vb4_11_3= vb3_11_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(11,1).*std3+mean3) + lf2.*lfw15.*(theta(11,1).*std3+mean3);
    vb5_11_3= vb4_11_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(11,1).*std3+mean3) + lf2.*lfw18.*(theta(11,1).*std3+mean3);
    vb6_11_3= vb5_11_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(11,1).*std3+mean3) + lf2.*lfw21.*(theta(11,1).*std3+mean3);         
    vb1_12_3= b(kh+3,1)               + lf2       .*(theta(12,1).*std3+mean3)                                        ;
    vb2_12_3= vb1_12_2+exp(b(kh+4,1)) - lf2       .*(theta(12,1).*std3+mean3) + lf2.*lfw9 .*(theta(12,1).*std3+mean3);
    vb3_12_3= vb2_12_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(12,1).*std3+mean3) + lf2.*lfw12.*(theta(12,1).*std3+mean3);
    vb4_12_3= vb3_12_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(12,1).*std3+mean3) + lf2.*lfw15.*(theta(12,1).*std3+mean3);
    vb5_12_3= vb4_12_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(12,1).*std3+mean3) + lf2.*lfw18.*(theta(12,1).*std3+mean3);
    vb6_12_3= vb5_12_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(12,1).*std3+mean3) + lf2.*lfw21.*(theta(12,1).*std3+mean3);  
    vb1_13_3= b(kh+3,1)               + lf2       .*(theta(13,1).*std3+mean3)                                        ;
    vb2_13_3= vb1_13_2+exp(b(kh+4,1)) - lf2       .*(theta(13,1).*std3+mean3) + lf2.*lfw9 .*(theta(13,1).*std3+mean3);
    vb3_13_3= vb2_13_2+exp(b(kh+5,1)) - lf2.*lfw9 .*(theta(13,1).*std3+mean3) + lf2.*lfw12.*(theta(13,1).*std3+mean3);
    vb4_13_3= vb3_13_2+exp(b(kh+6,1)) - lf2.*lfw12.*(theta(13,1).*std3+mean3) + lf2.*lfw15.*(theta(13,1).*std3+mean3);
    vb5_13_3= vb4_13_2+exp(b(kh+7,1)) - lf2.*lfw15.*(theta(13,1).*std3+mean3) + lf2.*lfw18.*(theta(13,1).*std3+mean3);
    vb6_13_3= vb5_13_2+exp(b(kh+8,1)) - lf2.*lfw18.*(theta(13,1).*std3+mean3) + lf2.*lfw21.*(theta(13,1).*std3+mean3);
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.3 Assign b to 3rd childbirth equation
%--------------------------------------------------------------------------
    bX3 = [b(kh+1:kh+3,1); bX1];
    vc1_1_1 = b(kh+4,1)              + lf3        .*(theta(1,1).*std1+mean1)                                       ;
    vc2_1_1 = vc1_1_1+exp(b(kh+5,1)) - lf3        .*(theta(1,1).*std1+mean1) + lf3.*lfw15.*(theta(1,1).*std1+mean1);
    vc3_1_1 = vc2_1_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(1,1).*std1+mean1) + lf3.*lfw18.*(theta(1,1).*std1+mean1);
    vc1_2_1 = b(kh+4,1)              + lf3        .*(theta(2,1).*std1+mean1)                                       ;
    vc2_2_1 = vc1_2_1+exp(b(kh+5,1)) - lf3        .*(theta(2,1).*std1+mean1) + lf3.*lfw15.*(theta(2,1).*std1+mean1);
    vc3_2_1 = vc2_2_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(2,1).*std1+mean1) + lf3.*lfw18.*(theta(2,1).*std1+mean1);
    vc1_3_1 = b(kh+4,1)              + lf3        .*(theta(3,1).*std1+mean1)                                       ;
    vc2_3_1 = vc1_3_1+exp(b(kh+5,1)) - lf3        .*(theta(3,1).*std1+mean1) + lf3.*lfw15.*(theta(3,1).*std1+mean1);
    vc3_3_1 = vc2_3_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(3,1).*std1+mean1) + lf3.*lfw18.*(theta(3,1).*std1+mean1);
    vc1_4_1 = b(kh+4,1)              + lf3        .*(theta(4,1).*std1+mean1)                                       ;
    vc2_4_1 = vc1_4_1+exp(b(kh+5,1)) - lf3        .*(theta(4,1).*std1+mean1) + lf3.*lfw15.*(theta(4,1).*std1+mean1);
    vc3_4_1 = vc2_4_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(4,1).*std1+mean1) + lf3.*lfw18.*(theta(4,1).*std1+mean1);
    vc1_5_1 = b(kh+4,1)              + lf3        .*(theta(5,1).*std1+mean1)                                       ;
    vc2_5_1 = vc1_5_1+exp(b(kh+5,1)) - lf3        .*(theta(5,1).*std1+mean1) + lf3.*lfw15.*(theta(5,1).*std1+mean1);
    vc3_5_1 = vc2_5_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(5,1).*std1+mean1) + lf3.*lfw18.*(theta(5,1).*std1+mean1);
    vc1_6_1 = b(kh+4,1)              + lf3        .*(theta(6,1).*std1+mean1)                                       ;
    vc2_6_1 = vc1_6_1+exp(b(kh+5,1)) - lf3        .*(theta(6,1).*std1+mean1) + lf3.*lfw15.*(theta(6,1).*std1+mean1);
    vc3_6_1 = vc2_6_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(6,1).*std1+mean1) + lf3.*lfw18.*(theta(6,1).*std1+mean1);
    vc1_7_1 = b(kh+4,1)              + lf3        .*(theta(7,1).*std1+mean1)                                       ;
    vc2_7_1 = vc1_7_1+exp(b(kh+5,1)) - lf3        .*(theta(7,1).*std1+mean1) + lf3.*lfw15.*(theta(7,1).*std1+mean1);
    vc3_7_1 = vc2_7_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(7,1).*std1+mean1) + lf3.*lfw18.*(theta(7,1).*std1+mean1);
    vc1_8_1 = b(kh+4,1)              + lf3        .*(theta(8,1).*std1+mean1)                                       ;
    vc2_8_1 = vc1_8_1+exp(b(kh+5,1)) - lf3        .*(theta(8,1).*std1+mean1) + lf3.*lfw15.*(theta(8,1).*std1+mean1);
    vc3_8_1 = vc2_8_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(8,1).*std1+mean1) + lf3.*lfw18.*(theta(8,1).*std1+mean1);
    vc1_9_1 = b(kh+4,1)              + lf3        .*(theta(9,1).*std1+mean1)                                       ;
    vc2_9_1 = vc1_8_1+exp(b(kh+5,1)) - lf3        .*(theta(9,1).*std1+mean1) + lf3.*lfw15.*(theta(9,1).*std1+mean1);
    vc3_9_1 = vc2_9_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(9,1).*std1+mean1) + lf3.*lfw18.*(theta(9,1).*std1+mean1);
    vc1_10_1= b(kh+4,1)               + lf3        .*(theta(10,1).*std1+mean1)                                        ;
    vc2_10_1= vc1_10_1+exp(b(kh+5,1)) - lf3        .*(theta(10,1).*std1+mean1) + lf3.*lfw15.*(theta(10,1).*std1+mean1);
    vc3_10_1= vc2_10_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(10,1).*std1+mean1) + lf3.*lfw18.*(theta(10,1).*std1+mean1);  
    vc1_11_1= b(kh+4,1)               + lf3        .*(theta(11,1).*std1+mean1)                                        ;
    vc2_11_1= vc1_11_1+exp(b(kh+5,1)) - lf3        .*(theta(11,1).*std1+mean1) + lf3.*lfw15.*(theta(11,1).*std1+mean1);
    vc3_11_1= vc2_11_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(11,1).*std1+mean1) + lf3.*lfw18.*(theta(11,1).*std1+mean1);         
    vc1_12_1= b(kh+4,1)               + lf3        .*(theta(12,1).*std1+mean1)                                        ;
    vc2_12_1= vc1_12_1+exp(b(kh+5,1)) - lf3        .*(theta(12,1).*std1+mean1) + lf3.*lfw15.*(theta(12,1).*std1+mean1);
    vc3_12_1= vc2_12_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(12,1).*std1+mean1) + lf3.*lfw18.*(theta(12,1).*std1+mean1);        
    vc1_13_1= b(kh+4,1)               + lf3        .*(theta(13,1).*std1+mean1)                                        ;
    vc2_13_1= vc1_13_1+exp(b(kh+5,1)) - lf3        .*(theta(13,1).*std1+mean1) + lf3.*lfw15.*(theta(13,1).*std1+mean1);
    vc3_13_1= vc2_13_1+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(13,1).*std1+mean1) + lf3.*lfw18.*(theta(13,1).*std1+mean1);
    
    
    vc1_1_2 = b(kh+4,1)              + lf3        .*(theta(1,1).*std2+mean2)                                       ;
    vc2_1_2 = vc1_1_2+exp(b(kh+5,1)) - lf3        .*(theta(1,1).*std2+mean2) + lf3.*lfw15.*(theta(1,1).*std2+mean2);
    vc3_1_2 = vc2_1_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(1,1).*std2+mean2) + lf3.*lfw18.*(theta(1,1).*std2+mean2);
    vc1_2_2 = b(kh+4,1)              + lf3        .*(theta(2,1).*std2+mean2)                                       ;
    vc2_2_2 = vc1_2_2+exp(b(kh+5,1)) - lf3        .*(theta(2,1).*std2+mean2) + lf3.*lfw15.*(theta(2,1).*std2+mean2);
    vc3_2_2 = vc2_2_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(2,1).*std2+mean2) + lf3.*lfw18.*(theta(2,1).*std2+mean2);
    vc1_3_2 = b(kh+4,1)              + lf3        .*(theta(3,1).*std2+mean2)                                       ;
    vc2_3_2 = vc1_3_2+exp(b(kh+5,1)) - lf3        .*(theta(3,1).*std2+mean2) + lf3.*lfw15.*(theta(3,1).*std2+mean2);
    vc3_3_2 = vc2_3_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(3,1).*std2+mean2) + lf3.*lfw18.*(theta(3,1).*std2+mean2);
    vc1_4_2 = b(kh+4,1)              + lf3        .*(theta(4,1).*std2+mean2)                                       ;
    vc2_4_2 = vc1_4_2+exp(b(kh+5,1)) - lf3        .*(theta(4,1).*std2+mean2) + lf3.*lfw15.*(theta(4,1).*std2+mean2);
    vc3_4_2 = vc2_4_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(4,1).*std2+mean2) + lf3.*lfw18.*(theta(4,1).*std2+mean2);
    vc1_5_2 = b(kh+4,1)              + lf3        .*(theta(5,1).*std2+mean2)                                       ;
    vc2_5_2 = vc1_5_2+exp(b(kh+5,1)) - lf3        .*(theta(5,1).*std2+mean2) + lf3.*lfw15.*(theta(5,1).*std2+mean2);
    vc3_5_2 = vc2_5_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(5,1).*std2+mean2) + lf3.*lfw18.*(theta(5,1).*std2+mean2);
    vc1_6_2 = b(kh+4,1)              + lf3        .*(theta(6,1).*std2+mean2)                                       ;
    vc2_6_2 = vc1_6_2+exp(b(kh+5,1)) - lf3        .*(theta(6,1).*std2+mean2) + lf3.*lfw15.*(theta(6,1).*std2+mean2);
    vc3_6_2 = vc2_6_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(6,1).*std2+mean2) + lf3.*lfw18.*(theta(6,1).*std2+mean2);
    vc1_7_2 = b(kh+4,1)              + lf3        .*(theta(7,1).*std2+mean2)                                       ;
    vc2_7_2 = vc1_7_2+exp(b(kh+5,1)) - lf3        .*(theta(7,1).*std2+mean2) + lf3.*lfw15.*(theta(7,1).*std2+mean2);
    vc3_7_2 = vc2_7_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(7,1).*std2+mean2) + lf3.*lfw18.*(theta(7,1).*std2+mean2);
    vc1_8_2 = b(kh+4,1)              + lf3        .*(theta(8,1).*std2+mean2)                                       ;
    vc2_8_2 = vc1_8_2+exp(b(kh+5,1)) - lf3        .*(theta(8,1).*std2+mean2) + lf3.*lfw15.*(theta(8,1).*std2+mean2);
    vc3_8_2 = vc2_8_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(8,1).*std2+mean2) + lf3.*lfw18.*(theta(8,1).*std2+mean2);
    vc1_9_2 = b(kh+4,1)              + lf3        .*(theta(9,1).*std2+mean2)                                       ;
    vc2_9_2 = vc1_9_2+exp(b(kh+5,1)) - lf3        .*(theta(9,1).*std2+mean2) + lf3.*lfw15.*(theta(9,1).*std2+mean2);
    vc3_9_2 = vc2_9_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(9,1).*std2+mean2) + lf3.*lfw18.*(theta(9,1).*std2+mean2);
    vc1_10_2= b(kh+4,1)              + lf3        .*(theta(10,1).*std2+mean2)                                         ;
    vc2_10_2= vc1_10_2+exp(b(kh+5,1)) - lf3        .*(theta(10,1).*std2+mean2) + lf3.*lfw15.*(theta(10,1).*std2+mean2);
    vc3_10_2= vc2_10_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(10,1).*std2+mean2) + lf3.*lfw18.*(theta(10,1).*std2+mean2);    
    vc1_11_2= b(kh+4,1)               + lf3        .*(theta(11,1).*std2+mean2)                                        ;
    vc2_11_2= vc1_11_2+exp(b(kh+5,1)) - lf3        .*(theta(11,1).*std2+mean2) + lf3.*lfw15.*(theta(11,1).*std2+mean2);
    vc3_11_2= vc2_11_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(11,1).*std2+mean2) + lf3.*lfw18.*(theta(11,1).*std2+mean2);           
    vc1_12_2= b(kh+4,1)               + lf3        .*(theta(12,1).*std2+mean2)                                        ;
    vc2_12_2= vc1_12_2+exp(b(kh+5,1)) - lf3        .*(theta(12,1).*std2+mean2) + lf3.*lfw15.*(theta(12,1).*std2+mean2);
    vc3_12_2= vc2_12_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(12,1).*std2+mean2) + lf3.*lfw18.*(theta(12,1).*std2+mean2);          
    vc1_13_2= b(kh+4,1)               + lf3        .*(theta(13,1).*std2+mean2)                                        ;
    vc2_13_2= vc1_13_2+exp(b(kh+5,1)) - lf3        .*(theta(13,1).*std2+mean2) + lf3.*lfw15.*(theta(13,1).*std2+mean2);
    vc3_13_2= vc2_13_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(13,1).*std2+mean2) + lf3.*lfw18.*(theta(13,1).*std2+mean2);

    vc1_1_3 = b(kh+4,1)              + lf3        .*(theta(1,1).*std3+mean3)                                       ;
    vc2_1_3 = vc1_1_2+exp(b(kh+5,1)) - lf3        .*(theta(1,1).*std3+mean3) + lf3.*lfw15.*(theta(1,1).*std3+mean3);
    vc3_1_3 = vc2_1_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(1,1).*std3+mean3) + lf3.*lfw18.*(theta(1,1).*std3+mean3);
    vc1_2_3 = b(kh+4,1)              + lf3        .*(theta(2,1).*std3+mean3)                               		   ;
    vc2_2_3 = vc1_2_2+exp(b(kh+5,1)) - lf3        .*(theta(2,1).*std3+mean3) + lf3.*lfw15.*(theta(2,1).*std3+mean3);
    vc3_2_3 = vc2_2_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(2,1).*std3+mean3) + lf3.*lfw18.*(theta(2,1).*std3+mean3);
    vc1_3_3 = b(kh+4,1)              + lf3        .*(theta(3,1).*std3+mean3)                                       ;
    vc2_3_3 = vc1_3_2+exp(b(kh+5,1)) - lf3        .*(theta(3,1).*std3+mean3) + lf3.*lfw15.*(theta(3,1).*std3+mean3);
    vc3_3_3 = vc2_3_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(3,1).*std3+mean3) + lf3.*lfw18.*(theta(3,1).*std3+mean3);
    vc1_4_3 = b(kh+4,1)              + lf3        .*(theta(4,1).*std3+mean3)                                       ;
    vc2_4_3 = vc1_4_2+exp(b(kh+5,1)) - lf3        .*(theta(4,1).*std3+mean3) + lf3.*lfw15.*(theta(4,1).*std3+mean3);
    vc3_4_3 = vc2_4_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(4,1).*std3+mean3) + lf3.*lfw18.*(theta(4,1).*std3+mean3);
    vc1_5_3 = b(kh+4,1)              + lf3        .*(theta(5,1).*std3+mean3)                                       ;
    vc2_5_3 = vc1_5_2+exp(b(kh+5,1)) - lf3        .*(theta(5,1).*std3+mean3) + lf3.*lfw15.*(theta(5,1).*std3+mean3);
    vc3_5_3 = vc2_5_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(5,1).*std3+mean3) + lf3.*lfw18.*(theta(5,1).*std3+mean3);
    vc1_6_3 = b(kh+4,1)              + lf3        .*(theta(6,1).*std3+mean3)                                       ;
    vc2_6_3 = vc1_6_2+exp(b(kh+5,1)) - lf3        .*(theta(6,1).*std3+mean3) + lf3.*lfw15.*(theta(6,1).*std3+mean3);
    vc3_6_3 = vc2_6_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(6,1).*std3+mean3) + lf3.*lfw18.*(theta(6,1).*std3+mean3);
    vc1_7_3 = b(kh+4,1)              + lf3        .*(theta(7,1).*std3+mean3)                                       ;
    vc2_7_3 = vc1_7_2+exp(b(kh+5,1)) - lf3        .*(theta(7,1).*std3+mean3) + lf3.*lfw15.*(theta(7,1).*std3+mean3);
    vc3_7_3 = vc2_7_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(7,1).*std3+mean3) + lf3.*lfw18.*(theta(7,1).*std3+mean3);
    vc1_8_3 = b(kh+4,1)              + lf3        .*(theta(8,1).*std3+mean3)                                       ;
    vc2_8_3 = vc1_8_2+exp(b(kh+5,1)) - lf3        .*(theta(8,1).*std3+mean3) + lf3.*lfw15.*(theta(8,1).*std3+mean3);
    vc3_8_3 = vc2_8_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(8,1).*std3+mean3) + lf3.*lfw18.*(theta(8,1).*std3+mean3);
    vc1_9_3 = b(kh+4,1)              + lf3        .*(theta(9,1).*std3+mean3)                               		   ;
    vc2_9_3 = vc1_9_2+exp(b(kh+5,1)) - lf3        .*(theta(9,1).*std3+mean3) + lf3.*lfw15.*(theta(9,1).*std3+mean3);
    vc3_9_3 = vc2_9_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(9,1).*std3+mean3) + lf3.*lfw18.*(theta(9,1).*std3+mean3);
    vc1_10_3= b(kh+4,1)               + lf3        .*(theta(10,1).*std3+mean3)                                        ;
    vc2_10_3= vc1_10_2+exp(b(kh+5,1)) - lf3        .*(theta(10,1).*std3+mean3) + lf3.*lfw15.*(theta(10,1).*std3+mean3);
    vc3_10_3= vc2_10_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(10,1).*std3+mean3) + lf3.*lfw18.*(theta(10,1).*std3+mean3);    
    vc1_11_3= b(kh+4,1)               + lf3        .*(theta(11,1).*std3+mean3)                                        ;
    vc2_11_3= vc1_11_2+exp(b(kh+5,1)) - lf3        .*(theta(11,1).*std3+mean3) + lf3.*lfw15.*(theta(11,1).*std3+mean3);
    vc3_11_3= vc2_11_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(11,1).*std3+mean3) + lf3.*lfw18.*(theta(11,1).*std3+mean3);           
    vc1_12_3= b(kh+4,1)               + lf3        .*(theta(12,1).*std3+mean3)                                        ;
    vc2_12_3= vc1_12_2+exp(b(kh+5,1)) - lf3        .*(theta(12,1).*std3+mean3) + lf3.*lfw15.*(theta(12,1).*std3+mean3);
    vc3_12_3= vc2_12_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(12,1).*std3+mean3) + lf3.*lfw18.*(theta(12,1).*std3+mean3);          
    vc1_13_3= b(kh+4,1)               + lf3        .*(theta(13,1).*std3+mean3)                                        ;
    vc2_13_3= vc1_13_2+exp(b(kh+5,1)) - lf3        .*(theta(13,1).*std3+mean3) + lf3.*lfw15.*(theta(13,1).*std3+mean3);
    vc3_13_3= vc2_13_2+exp(b(kh+6,1)) - lf3.*lfw15 .*(theta(13,1).*std3+mean3) + lf3.*lfw18.*(theta(13,1).*std3+mean3);
    kh  = kh+6;    
%--------------------------------------------------------------------------
%1.4 Assign b to earnings equation 3 years after diploma
%--------------------------------------------------------------------------
    bW3 = [b(kh+1,1); b(kh+1,1); b(kh+1,1); b(kh+2:kh+kw3-2,1)];
    vw3_1_1  = b(kh+kw3-2+1,1)   + (theta(1,1).*std1+mean1);
    vw3_2_1  = b(kh+kw3-2+1,1)   + (theta(2,1).*std1+mean1);
    vw3_3_1  = b(kh+kw3-2+1,1)   + (theta(3,1).*std1+mean1);
    vw3_4_1  = b(kh+kw3-2+1,1)   + (theta(4,1).*std1+mean1);
    vw3_5_1  = b(kh+kw3-2+1,1)   + (theta(5,1).*std1+mean1);
    vw3_6_1  = b(kh+kw3-2+1,1)   + (theta(6,1).*std1+mean1);
    vw3_7_1  = b(kh+kw3-2+1,1)   + (theta(7,1).*std1+mean1);
    vw3_8_1  = b(kh+kw3-2+1,1)   + (theta(8,1).*std1+mean1);
    vw3_9_1  = b(kh+kw3-2+1,1)   + (theta(9,1).*std1+mean1);
    vw3_10_1 = b(kh+kw3-2+1,1)   + (theta(10,1).*std1+mean1);
    vw3_11_1 = b(kh+kw3-2+1,1)   + (theta(11,1).*std1+mean1);
    vw3_12_1 = b(kh+kw3-2+1,1)   + (theta(12,1).*std1+mean1);
    vw3_13_1 = b(kh+kw3-2+1,1)   + (theta(13,1).*std1+mean1);
             
    vw3_1_2  = b(kh+kw3-2+1,1)   + (theta(1,1).*std2+mean2);
    vw3_2_2  = b(kh+kw3-2+1,1)   + (theta(2,1).*std2+mean2);
    vw3_3_2  = b(kh+kw3-2+1,1)   + (theta(3,1).*std2+mean2);
    vw3_4_2  = b(kh+kw3-2+1,1)   + (theta(4,1).*std2+mean2);
    vw3_5_2  = b(kh+kw3-2+1,1)   + (theta(5,1).*std2+mean2);
    vw3_6_2  = b(kh+kw3-2+1,1)   + (theta(6,1).*std2+mean2);
    vw3_7_2  = b(kh+kw3-2+1,1)   + (theta(7,1).*std2+mean2);
    vw3_8_2  = b(kh+kw3-2+1,1)   + (theta(8,1).*std2+mean2);
    vw3_9_2  = b(kh+kw3-2+1,1)   + (theta(9,1).*std2+mean2);
    vw3_10_2 = b(kh+kw3-2+1,1)   + (theta(10,1).*std2+mean2);
    vw3_11_2 = b(kh+kw3-2+1,1)   + (theta(11,1).*std2+mean2);
    vw3_12_2 = b(kh+kw3-2+1,1)   + (theta(12,1).*std2+mean2);
    vw3_13_2 = b(kh+kw3-2+1,1)   + (theta(13,1).*std2+mean2);
             
    vw3_1_3  = b(kh+kw3-2+1,1)   + (theta(1,1).*std3+mean3);
    vw3_2_3  = b(kh+kw3-2+1,1)   + (theta(2,1).*std3+mean3);
    vw3_3_3  = b(kh+kw3-2+1,1)   + (theta(3,1).*std3+mean3);
    vw3_4_3  = b(kh+kw3-2+1,1)   + (theta(4,1).*std3+mean3);
    vw3_5_3  = b(kh+kw3-2+1,1)   + (theta(5,1).*std3+mean3);
    vw3_6_3  = b(kh+kw3-2+1,1)   + (theta(6,1).*std3+mean3);
    vw3_7_3  = b(kh+kw3-2+1,1)   + (theta(7,1).*std3+mean3);
    vw3_8_3  = b(kh+kw3-2+1,1)   + (theta(8,1).*std3+mean3);
    vw3_9_3  = b(kh+kw3-2+1,1)   + (theta(9,1).*std3+mean3);
    vw3_10_3 = b(kh+kw3-2+1,1)   + (theta(10,1).*std3+mean3);
    vw3_11_3 = b(kh+kw3-2+1,1)   + (theta(11,1).*std3+mean3);
    vw3_12_3 = b(kh+kw3-2+1,1)   + (theta(12,1).*std3+mean3);
    vw3_13_3 = b(kh+kw3-2+1,1)   + (theta(13,1).*std3+mean3);
    sig3 = b(kh+kw3-2+2,1);
    kh  = kh+kw3-2+2;    
%--------------------------------------------------------------------------
%1.5 Assign b to earnings equation 6 years after diploma
%--------------------------------------------------------------------------
    bW6   = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); bW3(4:kw3)];
    vw6_1_1  = b(kh+4,1)  + lfw6.*(theta(1,1).*std1+mean1);
    vw6_2_1  = b(kh+4,1)  + lfw6.*(theta(2,1).*std1+mean1);
    vw6_3_1  = b(kh+4,1)  + lfw6.*(theta(3,1).*std1+mean1);
    vw6_4_1  = b(kh+4,1)  + lfw6.*(theta(4,1).*std1+mean1);
    vw6_5_1  = b(kh+4,1)  + lfw6.*(theta(5,1).*std1+mean1);
    vw6_6_1  = b(kh+4,1)  + lfw6.*(theta(6,1).*std1+mean1);
    vw6_7_1  = b(kh+4,1)  + lfw6.*(theta(7,1).*std1+mean1);
    vw6_8_1  = b(kh+4,1)  + lfw6.*(theta(8,1).*std1+mean1);
    vw6_9_1  = b(kh+4,1)  + lfw6.*(theta(9,1).*std1+mean1);
    vw6_10_1 = b(kh+4,1)  + lfw6.*(theta(10,1).*std1+mean1);
    vw6_11_1 = b(kh+4,1)  + lfw6.*(theta(11,1).*std1+mean1);
    vw6_12_1 = b(kh+4,1)  + lfw6.*(theta(12,1).*std1+mean1);
    vw6_13_1 = b(kh+4,1)  + lfw6.*(theta(13,1).*std1+mean1);
    
    vw6_1_2  = b(kh+4,1)  + lfw6.*(theta(1,1).*std2+mean2);
    vw6_2_2  = b(kh+4,1)  + lfw6.*(theta(2,1).*std2+mean2);
    vw6_3_2  = b(kh+4,1)  + lfw6.*(theta(3,1).*std2+mean2);
    vw6_4_2  = b(kh+4,1)  + lfw6.*(theta(4,1).*std2+mean2);
    vw6_5_2  = b(kh+4,1)  + lfw6.*(theta(5,1).*std2+mean2);
    vw6_6_2  = b(kh+4,1)  + lfw6.*(theta(6,1).*std2+mean2);
    vw6_7_2  = b(kh+4,1)  + lfw6.*(theta(7,1).*std2+mean2);
    vw6_8_2  = b(kh+4,1)  + lfw6.*(theta(8,1).*std2+mean2);
    vw6_9_2  = b(kh+4,1)  + lfw6.*(theta(9,1).*std2+mean2);
    vw6_10_2 = b(kh+4,1)  + lfw6.*(theta(10,1).*std2+mean2);
    vw6_11_2 = b(kh+4,1)  + lfw6.*(theta(11,1).*std2+mean2);
    vw6_12_2 = b(kh+4,1)  + lfw6.*(theta(12,1).*std2+mean2);
    vw6_13_2 = b(kh+4,1)  + lfw6.*(theta(13,1).*std2+mean2);

    vw6_1_3  = b(kh+4,1)  + lfw6.*(theta(1,1).*std3+mean3);
    vw6_2_3  = b(kh+4,1)  + lfw6.*(theta(2,1).*std3+mean3);
    vw6_3_3  = b(kh+4,1)  + lfw6.*(theta(3,1).*std3+mean3);
    vw6_4_3  = b(kh+4,1)  + lfw6.*(theta(4,1).*std3+mean3);
    vw6_5_3  = b(kh+4,1)  + lfw6.*(theta(5,1).*std3+mean3);
    vw6_6_3  = b(kh+4,1)  + lfw6.*(theta(6,1).*std3+mean3);
    vw6_7_3  = b(kh+4,1)  + lfw6.*(theta(7,1).*std3+mean3);
    vw6_8_3  = b(kh+4,1)  + lfw6.*(theta(8,1).*std3+mean3);
    vw6_9_3  = b(kh+4,1)  + lfw6.*(theta(9,1).*std3+mean3);
    vw6_10_3 = b(kh+4,1)  + lfw6.*(theta(10,1).*std3+mean3);
    vw6_11_3 = b(kh+4,1)  + lfw6.*(theta(11,1).*std3+mean3);
    vw6_12_3 = b(kh+4,1)  + lfw6.*(theta(12,1).*std3+mean3);
    vw6_13_3 = b(kh+4,1)  + lfw6.*(theta(13,1).*std3+mean3);
    sig6  = b(kh+5,1);
    kh  = kh+5;    
%--------------------------------------------------------------------------
%1.6 Assign b to earnings equation 9 years after diploma
%--------------------------------------------------------------------------
    bW9   = [b(kh+1,1); b(kh+2,1); b(kh+3,1);... %timing to 1st kid 3-years intervals
             b(kh+4,1); b(kh+4,1); b(kh+5,1);... %timing to 2nd kid 3-years intervals
             b(kh+6,1); b(kh+6,1); b(kh+6,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw9_1_1  = b(kh+7,1) + lfw9.*(theta(1,1).*std1+mean1);
    vw9_2_1  = b(kh+7,1) + lfw9.*(theta(2,1).*std1+mean1);
    vw9_3_1  = b(kh+7,1) + lfw9.*(theta(3,1).*std1+mean1);
    vw9_4_1  = b(kh+7,1) + lfw9.*(theta(4,1).*std1+mean1);   
    vw9_5_1  = b(kh+7,1) + lfw9.*(theta(5,1).*std1+mean1);   
    vw9_6_1  = b(kh+7,1) + lfw9.*(theta(6,1).*std1+mean1);   
    vw9_7_1  = b(kh+7,1) + lfw9.*(theta(7,1).*std1+mean1);
    vw9_8_1  = b(kh+7,1) + lfw9.*(theta(8,1).*std1+mean1);
    vw9_9_1  = b(kh+7,1) + lfw9.*(theta(9,1).*std1+mean1);
    vw9_10_1 = b(kh+7,1) + lfw9.*(theta(10,1).*std1+mean1);
    vw9_11_1 = b(kh+7,1) + lfw9.*(theta(11,1).*std1+mean1);
    vw9_12_1 = b(kh+7,1) + lfw9.*(theta(12,1).*std1+mean1);
    vw9_13_1 = b(kh+7,1) + lfw9.*(theta(13,1).*std1+mean1);
    
    vw9_1_2  = b(kh+7,1) + lfw9.*(theta(1,1).*std2+mean2);
    vw9_2_2  = b(kh+7,1) + lfw9.*(theta(2,1).*std2+mean2);
    vw9_3_2  = b(kh+7,1) + lfw9.*(theta(3,1).*std2+mean2);
    vw9_4_2  = b(kh+7,1) + lfw9.*(theta(4,1).*std2+mean2);   
    vw9_5_2  = b(kh+7,1) + lfw9.*(theta(5,1).*std2+mean2);   
    vw9_6_2  = b(kh+7,1) + lfw9.*(theta(6,1).*std2+mean2);   
    vw9_7_2  = b(kh+7,1) + lfw9.*(theta(7,1).*std2+mean2);
    vw9_8_2  = b(kh+7,1) + lfw9.*(theta(8,1).*std2+mean2);
    vw9_9_2  = b(kh+7,1) + lfw9.*(theta(9,1).*std2+mean2);
    vw9_10_2 = b(kh+7,1) + lfw9.*(theta(10,1).*std2+mean2);
    vw9_11_2 = b(kh+7,1) + lfw9.*(theta(11,1).*std2+mean2);
    vw9_12_2 = b(kh+7,1) + lfw9.*(theta(12,1).*std2+mean2);
    vw9_13_2 = b(kh+7,1) + lfw9.*(theta(13,1).*std2+mean2);
  
    vw9_1_3  = b(kh+7,1) + lfw9.*(theta(1,1).*std3+mean3);
    vw9_2_3  = b(kh+7,1) + lfw9.*(theta(2,1).*std3+mean3);
    vw9_3_3  = b(kh+7,1) + lfw9.*(theta(3,1).*std3+mean3);
    vw9_4_3  = b(kh+7,1) + lfw9.*(theta(4,1).*std3+mean3);  
    vw9_5_3  = b(kh+7,1) + lfw9.*(theta(5,1).*std3+mean3);  
    vw9_6_3  = b(kh+7,1) + lfw9.*(theta(6,1).*std3+mean3);  
    vw9_7_3  = b(kh+7,1) + lfw9.*(theta(7,1).*std3+mean3);
    vw9_8_3  = b(kh+7,1) + lfw9.*(theta(8,1).*std3+mean3);
    vw9_9_3  = b(kh+7,1) + lfw9.*(theta(9,1).*std3+mean3);
    vw9_10_3 = b(kh+7,1) + lfw9.*(theta(10,1).*std3+mean3);
    vw9_11_3 = b(kh+7,1) + lfw9.*(theta(11,1).*std3+mean3);
    vw9_12_3 = b(kh+7,1) + lfw9.*(theta(12,1).*std3+mean3);
    vw9_13_3 = b(kh+7,1) + lfw9.*(theta(13,1).*std3+mean3);
    
    sig9  = b(kh+8,1);
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.7 Assign b to earnings equation 12 years after diploma
%--------------------------------------------------------------------------
    bW12  = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+4,1);... %timing to 1st kid 3-years intervals
             b(kh+5,1); b(kh+5,1); b(kh+6,1); b(kh+7,1);... %timing to 2nd kid 3-years intervals
             b(kh+8,1); b(kh+8,1); b(kh+8,1); b(kh+8,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw12_1_1  = b(kh+9,1) + lfw12.*(theta(1,1).*std1+mean1);
    vw12_2_1  = b(kh+9,1) + lfw12.*(theta(2,1).*std1+mean1);
    vw12_3_1  = b(kh+9,1) + lfw12.*(theta(3,1).*std1+mean1);
    vw12_4_1  = b(kh+9,1) + lfw12.*(theta(4,1).*std1+mean1);
    vw12_5_1  = b(kh+9,1) + lfw12.*(theta(5,1).*std1+mean1);  
    vw12_6_1  = b(kh+9,1) + lfw12.*(theta(6,1).*std1+mean1);  
    vw12_7_1  = b(kh+9,1) + lfw12.*(theta(7,1).*std1+mean1);
    vw12_8_1  = b(kh+9,1) + lfw12.*(theta(8,1).*std1+mean1);
    vw12_9_1  = b(kh+9,1) + lfw12.*(theta(9,1).*std1+mean1);
    vw12_10_1 = b(kh+9,1) + lfw12.*(theta(10,1).*std1+mean1);
    vw12_11_1 = b(kh+9,1) + lfw12.*(theta(11,1).*std1+mean1);
    vw12_12_1 = b(kh+9,1) + lfw12.*(theta(12,1).*std1+mean1);
    vw12_13_1 = b(kh+9,1) + lfw12.*(theta(13,1).*std1+mean1);
    
    vw12_1_2  = b(kh+9,1) + lfw12.*(theta(1,1).*std2+mean2);
    vw12_2_2  = b(kh+9,1) + lfw12.*(theta(2,1).*std2+mean2);
    vw12_3_2  = b(kh+9,1) + lfw12.*(theta(3,1).*std2+mean2);
    vw12_4_2  = b(kh+9,1) + lfw12.*(theta(4,1).*std2+mean2);
    vw12_5_2  = b(kh+9,1) + lfw12.*(theta(5,1).*std2+mean2);   
    vw12_6_2  = b(kh+9,1) + lfw12.*(theta(6,1).*std2+mean2);   
    vw12_7_2  = b(kh+9,1) + lfw12.*(theta(7,1).*std2+mean2);   
    vw12_8_2  = b(kh+9,1) + lfw12.*(theta(8,1).*std2+mean2);   
    vw12_9_2  = b(kh+9,1) + lfw12.*(theta(9,1).*std2+mean2);   
    vw12_10_2 = b(kh+9,1) + lfw12.*(theta(10,1).*std2+mean2);    
    vw12_11_2 = b(kh+9,1) + lfw12.*(theta(11,1).*std2+mean2);    
    vw12_12_2 = b(kh+9,1) + lfw12.*(theta(12,1).*std2+mean2);    
    vw12_13_2 = b(kh+9,1) + lfw12.*(theta(13,1).*std2+mean2);    

    vw12_1_3  = b(kh+9,1) + lfw12.*(theta(1,1).*std3+mean3);
    vw12_2_3  = b(kh+9,1) + lfw12.*(theta(2,1).*std3+mean3);
    vw12_3_3  = b(kh+9,1) + lfw12.*(theta(3,1).*std3+mean3);
    vw12_4_3  = b(kh+9,1) + lfw12.*(theta(4,1).*std3+mean3);
    vw12_5_3  = b(kh+9,1) + lfw12.*(theta(5,1).*std3+mean3);   
    vw12_6_3  = b(kh+9,1) + lfw12.*(theta(6,1).*std3+mean3);   
    vw12_7_3  = b(kh+9,1) + lfw12.*(theta(7,1).*std3+mean3);   
    vw12_8_3  = b(kh+9,1) + lfw12.*(theta(8,1).*std3+mean3);   
    vw12_9_3  = b(kh+9,1) + lfw12.*(theta(9,1).*std3+mean3);   
    vw12_10_3 = b(kh+9,1) + lfw12.*(theta(10,1).*std3+mean3);    
    vw12_11_3 = b(kh+9,1) + lfw12.*(theta(11,1).*std3+mean3);    
    vw12_12_3 = b(kh+9,1) + lfw12.*(theta(12,1).*std3+mean3);    
    vw12_13_3 = b(kh+9,1) + lfw12.*(theta(13,1).*std3+mean3);    
    sig12 = b(kh+10,1);
    kh  = kh+10;
%--------------------------------------------------------------------------
%1.8 Assign b to earnings equation 15 years after diploma
%--------------------------------------------------------------------------
    bW15  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1);... %timing to 1st kid 3-years intervals
             b(kh+6,1);  b(kh+6,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);... %timing to 2nd kid 3-years intervals
             b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+11,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw15_1_1  = b(kh+12,1)  + lfw15.*(theta(1,1).*std1+mean1);
    vw15_2_1  = b(kh+12,1)  + lfw15.*(theta(2,1).*std1+mean1);
    vw15_3_1  = b(kh+12,1)  + lfw15.*(theta(3,1).*std1+mean1);
    vw15_4_1  = b(kh+12,1)  + lfw15.*(theta(4,1).*std1+mean1);
    vw15_5_1  = b(kh+12,1)  + lfw15.*(theta(5,1).*std1+mean1);    
    vw15_6_1  = b(kh+12,1)  + lfw15.*(theta(6,1).*std1+mean1);    
    vw15_7_1  = b(kh+12,1)  + lfw15.*(theta(7,1).*std1+mean1);
    vw15_8_1  = b(kh+12,1)  + lfw15.*(theta(8,1).*std1+mean1);
    vw15_9_1  = b(kh+12,1)  + lfw15.*(theta(9,1).*std1+mean1);
    vw15_10_1 = b(kh+12,1)  + lfw15.*(theta(10,1).*std1+mean1);
    vw15_11_1 = b(kh+12,1)  + lfw15.*(theta(11,1).*std1+mean1);
    vw15_12_1 = b(kh+12,1)  + lfw15.*(theta(12,1).*std1+mean1);
    vw15_13_1 = b(kh+12,1)  + lfw15.*(theta(13,1).*std1+mean1);
    
    vw15_1_2  = b(kh+12,1) + lfw15.*(theta(1,1).*std2+mean2);
    vw15_2_2  = b(kh+12,1) + lfw15.*(theta(2,1).*std2+mean2);
    vw15_3_2  = b(kh+12,1) + lfw15.*(theta(3,1).*std2+mean2);
    vw15_4_2  = b(kh+12,1) + lfw15.*(theta(4,1).*std2+mean2);
    vw15_5_2  = b(kh+12,1) + lfw15.*(theta(5,1).*std2+mean2);    
    vw15_6_2  = b(kh+12,1) + lfw15.*(theta(6,1).*std2+mean2);    
    vw15_7_2  = b(kh+12,1) + lfw15.*(theta(7,1).*std2+mean2);    
    vw15_8_2  = b(kh+12,1) + lfw15.*(theta(8,1).*std2+mean2);    
    vw15_9_2  = b(kh+12,1) + lfw15.*(theta(9,1).*std2+mean2);    
    vw15_10_2 = b(kh+12,1) + lfw15.*(theta(10,1).*std2+mean2);     
    vw15_11_2 = b(kh+12,1) + lfw15.*(theta(11,1).*std2+mean2);     
    vw15_12_2 = b(kh+12,1) + lfw15.*(theta(12,1).*std2+mean2);     
    vw15_13_2 = b(kh+12,1) + lfw15.*(theta(13,1).*std2+mean2);     

    vw15_1_3  = b(kh+12,1) + lfw15.*(theta(1,1).*std3+mean3);
    vw15_2_3  = b(kh+12,1) + lfw15.*(theta(2,1).*std3+mean3);
    vw15_3_3  = b(kh+12,1) + lfw15.*(theta(3,1).*std3+mean3);
    vw15_4_3  = b(kh+12,1) + lfw15.*(theta(4,1).*std3+mean3);
    vw15_5_3  = b(kh+12,1) + lfw15.*(theta(5,1).*std3+mean3);   
    vw15_6_3  = b(kh+12,1) + lfw15.*(theta(6,1).*std3+mean3);   
    vw15_7_3  = b(kh+12,1) + lfw15.*(theta(7,1).*std3+mean3);   
    vw15_8_3  = b(kh+12,1) + lfw15.*(theta(8,1).*std3+mean3);   
    vw15_9_3  = b(kh+12,1) + lfw15.*(theta(9,1).*std3+mean3);   
    vw15_10_3 = b(kh+12,1) + lfw15.*(theta(10,1).*std3+mean3);    
    vw15_11_3 = b(kh+12,1) + lfw15.*(theta(11,1).*std3+mean3);    
    vw15_12_3 = b(kh+12,1) + lfw15.*(theta(12,1).*std3+mean3);    
    vw15_13_3 = b(kh+12,1) + lfw15.*(theta(13,1).*std3+mean3);    
    sig15 = b(kh+13,1);
    kh  = kh+13;    
%--------------------------------------------------------------------------
%1.9 Assign b to earnings equation 18 years after diploma
%--------------------------------------------------------------------------
    bW18  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1) ;... %timing to 1st kid 3-years intervals
             b(kh+7,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1);... %timing to 2nd kid 3-years intervals
             b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+13,1); b(kh+14,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw18_1_1  = b(kh+15,1) + lfw18.*(theta(1,1).*std1+mean1);
    vw18_2_1  = b(kh+15,1) + lfw18.*(theta(2,1).*std1+mean1);
    vw18_3_1  = b(kh+15,1) + lfw18.*(theta(3,1).*std1+mean1);
    vw18_4_1  = b(kh+15,1) + lfw18.*(theta(4,1).*std1+mean1); 
    vw18_5_1  = b(kh+15,1) + lfw18.*(theta(5,1).*std1+mean1); 
    vw18_6_1  = b(kh+15,1) + lfw18.*(theta(6,1).*std1+mean1); 
    vw18_7_1  = b(kh+15,1) + lfw18.*(theta(7,1).*std1+mean1);
    vw18_8_1  = b(kh+15,1) + lfw18.*(theta(8,1).*std1+mean1);
    vw18_9_1  = b(kh+15,1) + lfw18.*(theta(9,1).*std1+mean1);
    vw18_10_1 = b(kh+15,1) + lfw18.*(theta(10,1).*std1+mean1);
    vw18_11_1 = b(kh+15,1) + lfw18.*(theta(11,1).*std1+mean1);
    vw18_12_1 = b(kh+15,1) + lfw18.*(theta(12,1).*std1+mean1);
    vw18_13_1 = b(kh+15,1) + lfw18.*(theta(13,1).*std1+mean1);
    
    vw18_1_2  = b(kh+15,1) + lfw18.*(theta(1,1).*std2+mean2);
    vw18_2_2  = b(kh+15,1) + lfw18.*(theta(2,1).*std2+mean2);
    vw18_3_2  = b(kh+15,1) + lfw18.*(theta(3,1).*std2+mean2);
    vw18_4_2  = b(kh+15,1) + lfw18.*(theta(4,1).*std2+mean2);  
    vw18_5_2  = b(kh+15,1) + lfw18.*(theta(5,1).*std2+mean2);  
    vw18_6_2  = b(kh+15,1) + lfw18.*(theta(6,1).*std2+mean2);  
    vw18_7_2  = b(kh+15,1) + lfw18.*(theta(7,1).*std2+mean2);
    vw18_8_2  = b(kh+15,1) + lfw18.*(theta(8,1).*std2+mean2);
    vw18_9_2  = b(kh+15,1) + lfw18.*(theta(9,1).*std2+mean2);
    vw18_10_2 = b(kh+15,1) + lfw18.*(theta(10,1).*std2+mean2); 
    vw18_11_2 = b(kh+15,1) + lfw18.*(theta(11,1).*std2+mean2); 
    vw18_12_2 = b(kh+15,1) + lfw18.*(theta(12,1).*std2+mean2); 
    vw18_13_2 = b(kh+15,1) + lfw18.*(theta(13,1).*std2+mean2); 

    vw18_1_3  = b(kh+15,1) + lfw18.*(theta(1,1).*std3+mean3);
    vw18_2_3  = b(kh+15,1) + lfw18.*(theta(2,1).*std3+mean3);
    vw18_3_3  = b(kh+15,1) + lfw18.*(theta(3,1).*std3+mean3);
    vw18_4_3  = b(kh+15,1) + lfw18.*(theta(4,1).*std3+mean3); 
    vw18_5_3  = b(kh+15,1) + lfw18.*(theta(5,1).*std3+mean3); 
    vw18_6_3  = b(kh+15,1) + lfw18.*(theta(6,1).*std3+mean3); 
    vw18_7_3  = b(kh+15,1) + lfw18.*(theta(7,1).*std3+mean3);
    vw18_8_3  = b(kh+15,1) + lfw18.*(theta(8,1).*std3+mean3);
    vw18_9_3  = b(kh+15,1) + lfw18.*(theta(9,1).*std3+mean3);
    vw18_10_3 = b(kh+15,1) + lfw18.*(theta(10,1).*std3+mean3);
    vw18_11_3 = b(kh+15,1) + lfw18.*(theta(11,1).*std3+mean3);
    vw18_12_3 = b(kh+15,1) + lfw18.*(theta(12,1).*std3+mean3);
    vw18_13_3 = b(kh+15,1) + lfw18.*(theta(13,1).*std3+mean3);
    sig18 = b(kh+16,1);
    kh  = kh+16;    
%--------------------------------------------------------------------------
%1.10 Assign b to earnings equation 21 years after diploma
%--------------------------------------------------------------------------
    bW21  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1);  b(kh+7,1) ;... %timing to 1st kid 3-years intervals
             b(kh+8,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1); b(kh+12,1); b(kh+13,1);... %timing to 2nd kid 3-years intervals
             b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+15,1); b(kh+16,1); b(kh+16,1);...   %timing to 3rd kid 3-years intervals
             bW3(4:kw3)];                        
    vw21_1_1  = b(kh+17,1) + lfw21.*(theta(1,1).*std1+mean1);
    vw21_2_1  = b(kh+17,1) + lfw21.*(theta(2,1).*std1+mean1);
    vw21_3_1  = b(kh+17,1) + lfw21.*(theta(3,1).*std1+mean1);
    vw21_4_1  = b(kh+17,1) + lfw21.*(theta(4,1).*std1+mean1);
    vw21_5_1  = b(kh+17,1) + lfw21.*(theta(5,1).*std1+mean1);
    vw21_6_1  = b(kh+17,1) + lfw21.*(theta(6,1).*std1+mean1);
    vw21_7_1  = b(kh+17,1) + lfw21.*(theta(7,1).*std1+mean1);
    vw21_8_1  = b(kh+17,1) + lfw21.*(theta(8,1).*std1+mean1);
    vw21_9_1  = b(kh+17,1) + lfw21.*(theta(9,1).*std1+mean1);
    vw21_10_1 = b(kh+17,1) + lfw21.*(theta(10,1).*std1+mean1);
    vw21_11_1 = b(kh+17,1) + lfw21.*(theta(11,1).*std1+mean1);
    vw21_12_1 = b(kh+17,1) + lfw21.*(theta(12,1).*std1+mean1);
    vw21_13_1 = b(kh+17,1) + lfw21.*(theta(13,1).*std1+mean1);
    
    vw21_1_2  = b(kh+17,1) + lfw21.*(theta(1,1).*std2+mean2);
    vw21_2_2  = b(kh+17,1) + lfw21.*(theta(2,1).*std2+mean2);
    vw21_3_2  = b(kh+17,1) + lfw21.*(theta(3,1).*std2+mean2);
    vw21_4_2  = b(kh+17,1) + lfw21.*(theta(4,1).*std2+mean2);
    vw21_5_2  = b(kh+17,1) + lfw21.*(theta(5,1).*std2+mean2);
    vw21_6_2  = b(kh+17,1) + lfw21.*(theta(6,1).*std2+mean2);
    vw21_7_2  = b(kh+17,1) + lfw21.*(theta(7,1).*std2+mean2);
    vw21_8_2  = b(kh+17,1) + lfw21.*(theta(8,1).*std2+mean2);
    vw21_9_2  = b(kh+17,1) + lfw21.*(theta(9,1).*std2+mean2);
    vw21_10_2 = b(kh+17,1) + lfw21.*(theta(10,1).*std2+mean2); 
    vw21_11_2 = b(kh+17,1) + lfw21.*(theta(11,1).*std2+mean2); 
    vw21_12_2 = b(kh+17,1) + lfw21.*(theta(12,1).*std2+mean2); 
    vw21_13_2 = b(kh+17,1) + lfw21.*(theta(13,1).*std2+mean2); 

    vw21_1_3  = b(kh+17,1) + lfw21.*(theta(1,1).*std3+mean3);
    vw21_2_3  = b(kh+17,1) + lfw21.*(theta(2,1).*std3+mean3);
    vw21_3_3  = b(kh+17,1) + lfw21.*(theta(3,1).*std3+mean3);
    vw21_4_3  = b(kh+17,1) + lfw21.*(theta(4,1).*std3+mean3);
    vw21_5_3  = b(kh+17,1) + lfw21.*(theta(5,1).*std3+mean3);
    vw21_6_3  = b(kh+17,1) + lfw21.*(theta(6,1).*std3+mean3);
    vw21_7_3  = b(kh+17,1) + lfw21.*(theta(7,1).*std3+mean3);  
    vw21_8_3  = b(kh+17,1) + lfw21.*(theta(8,1).*std3+mean3);  
    vw21_9_3  = b(kh+17,1) + lfw21.*(theta(9,1).*std3+mean3);  
    vw21_10_3 = b(kh+17,1) + lfw21.*(theta(10,1).*std3+mean3);   
    vw21_11_3 = b(kh+17,1) + lfw21.*(theta(11,1).*std3+mean3);   
    vw21_12_3 = b(kh+17,1) + lfw21.*(theta(12,1).*std3+mean3);   
    vw21_13_3 = b(kh+17,1) + lfw21.*(theta(13,1).*std3+mean3);   
    sig21 = b(kh+18,1);
    kh  = kh+18;    
%--------------------------------------------------------------------------
%1.11 Assign b to earnings equation 1 year before diploma
%--------------------------------------------------------------------------
    bZe    = b(kh+1:kh+kze,1);
    vze_1_1  = b(kh+kze+1,1) + lfe.*(theta(1,1).*std1+mean1);
    vze_2_1  = b(kh+kze+1,1) + lfe.*(theta(2,1).*std1+mean1);
    vze_3_1  = b(kh+kze+1,1) + lfe.*(theta(3,1).*std1+mean1);
    vze_4_1  = b(kh+kze+1,1) + lfe.*(theta(4,1).*std1+mean1);
    vze_5_1  = b(kh+kze+1,1) + lfe.*(theta(5,1).*std1+mean1);
    vze_6_1  = b(kh+kze+1,1) + lfe.*(theta(6,1).*std1+mean1);
    vze_7_1  = b(kh+kze+1,1) + lfe.*(theta(7,1).*std1+mean1);
    vze_8_1  = b(kh+kze+1,1) + lfe.*(theta(8,1).*std1+mean1);
    vze_9_1  = b(kh+kze+1,1) + lfe.*(theta(9,1).*std1+mean1);
    vze_10_1 = b(kh+kze+1,1) + lfe.*(theta(10,1).*std1+mean1);
    vze_11_1 = b(kh+kze+1,1) + lfe.*(theta(11,1).*std1+mean1);
    vze_12_1 = b(kh+kze+1,1) + lfe.*(theta(12,1).*std1+mean1);
    vze_13_1 = b(kh+kze+1,1) + lfe.*(theta(13,1).*std1+mean1);

    vze_1_2  = b(kh+kze+1,1) + lfe.*(theta(1,1).*std2+mean2);
    vze_2_2  = b(kh+kze+1,1) + lfe.*(theta(2,1).*std2+mean2);
    vze_3_2  = b(kh+kze+1,1) + lfe.*(theta(3,1).*std2+mean2);
    vze_4_2  = b(kh+kze+1,1) + lfe.*(theta(4,1).*std2+mean2);
    vze_5_2  = b(kh+kze+1,1) + lfe.*(theta(5,1).*std2+mean2);
    vze_6_2  = b(kh+kze+1,1) + lfe.*(theta(6,1).*std2+mean2);
    vze_7_2  = b(kh+kze+1,1) + lfe.*(theta(7,1).*std2+mean2);
    vze_8_2  = b(kh+kze+1,1) + lfe.*(theta(8,1).*std2+mean2);
    vze_9_2  = b(kh+kze+1,1) + lfe.*(theta(9,1).*std2+mean2);
    vze_10_2 = b(kh+kze+1,1) + lfe.*(theta(10,1).*std2+mean2);
    vze_11_2 = b(kh+kze+1,1) + lfe.*(theta(11,1).*std2+mean2);
    vze_12_2 = b(kh+kze+1,1) + lfe.*(theta(12,1).*std2+mean2);
    vze_13_2 = b(kh+kze+1,1) + lfe.*(theta(13,1).*std2+mean2);

    vze_1_3  = b(kh+kze+1,1) + lfe.*(theta(1,1).*std3+mean3);
    vze_2_3  = b(kh+kze+1,1) + lfe.*(theta(2,1).*std3+mean3);
    vze_3_3  = b(kh+kze+1,1) + lfe.*(theta(3,1).*std3+mean3);
    vze_4_3  = b(kh+kze+1,1) + lfe.*(theta(4,1).*std3+mean3);
    vze_5_3  = b(kh+kze+1,1) + lfe.*(theta(5,1).*std3+mean3);
    vze_6_3  = b(kh+kze+1,1) + lfe.*(theta(6,1).*std3+mean3);
    vze_7_3  = b(kh+kze+1,1) + lfe.*(theta(7,1).*std3+mean3);
    vze_8_3  = b(kh+kze+1,1) + lfe.*(theta(8,1).*std3+mean3);
    vze_9_3  = b(kh+kze+1,1) + lfe.*(theta(9,1).*std3+mean3);
    vze_10_3 = b(kh+kze+1,1) + lfe.*(theta(10,1).*std3+mean3);
    vze_11_3 = b(kh+kze+1,1) + lfe.*(theta(11,1).*std3+mean3);
    vze_12_3 = b(kh+kze+1,1) + lfe.*(theta(12,1).*std3+mean3);
    vze_13_3 = b(kh+kze+1,1) + lfe.*(theta(13,1).*std3+mean3);
    kh    = kh+kze+1;    
%--------------------------------------------------------------------------
%1.12 Assign b to siblings when 14 years old
%--------------------------------------------------------------------------
    bZs    = b(kh+1:kh+kzs,1);
    vzs_1_1  = b(kh+kzs+1,1) + lfs.*(theta(1,1).*std1+mean1);
    vzs_2_1  = b(kh+kzs+1,1) + lfs.*(theta(2,1).*std1+mean1);
    vzs_3_1  = b(kh+kzs+1,1) + lfs.*(theta(3,1).*std1+mean1);
    vzs_4_1  = b(kh+kzs+1,1) + lfs.*(theta(4,1).*std1+mean1);
    vzs_5_1  = b(kh+kzs+1,1) + lfs.*(theta(5,1).*std1+mean1);
    vzs_6_1  = b(kh+kzs+1,1) + lfs.*(theta(6,1).*std1+mean1);
    vzs_7_1  = b(kh+kzs+1,1) + lfs.*(theta(7,1).*std1+mean1);
    vzs_8_1  = b(kh+kzs+1,1) + lfs.*(theta(8,1).*std1+mean1);
    vzs_9_1  = b(kh+kzs+1,1) + lfs.*(theta(9,1).*std1+mean1);
    vzs_10_1 = b(kh+kzs+1,1) + lfs.*(theta(10,1).*std1+mean1);
    vzs_11_1 = b(kh+kzs+1,1) + lfs.*(theta(11,1).*std1+mean1);
    vzs_12_1 = b(kh+kzs+1,1) + lfs.*(theta(12,1).*std1+mean1);
    vzs_13_1 = b(kh+kzs+1,1) + lfs.*(theta(13,1).*std1+mean1);
    
    vzs_1_2  = b(kh+kzs+1,1) + lfs.*(theta(1,1).*std2+mean2);
    vzs_2_2  = b(kh+kzs+1,1) + lfs.*(theta(2,1).*std2+mean2);
    vzs_3_2  = b(kh+kzs+1,1) + lfs.*(theta(3,1).*std2+mean2);
    vzs_4_2  = b(kh+kzs+1,1) + lfs.*(theta(4,1).*std2+mean2);
    vzs_5_2  = b(kh+kzs+1,1) + lfs.*(theta(5,1).*std2+mean2);
    vzs_6_2  = b(kh+kzs+1,1) + lfs.*(theta(6,1).*std2+mean2);
    vzs_7_2  = b(kh+kzs+1,1) + lfs.*(theta(7,1).*std2+mean2);    
    vzs_8_2  = b(kh+kzs+1,1) + lfs.*(theta(8,1).*std2+mean2);    
    vzs_9_2  = b(kh+kzs+1,1) + lfs.*(theta(9,1).*std2+mean2);    
    vzs_10_2 = b(kh+kzs+1,1) + lfs.*(theta(10,1).*std2+mean2);     
    vzs_11_2 = b(kh+kzs+1,1) + lfs.*(theta(11,1).*std2+mean2);     
    vzs_12_2 = b(kh+kzs+1,1) + lfs.*(theta(12,1).*std2+mean2);     
    vzs_13_2 = b(kh+kzs+1,1) + lfs.*(theta(13,1).*std2+mean2);     

    vzs_1_3  = b(kh+kzs+1,1) + lfs.*(theta(1,1).*std3+mean3);
    vzs_2_3  = b(kh+kzs+1,1) + lfs.*(theta(2,1).*std3+mean3);
    vzs_3_3  = b(kh+kzs+1,1) + lfs.*(theta(3,1).*std3+mean3);
    vzs_4_3  = b(kh+kzs+1,1) + lfs.*(theta(4,1).*std3+mean3);
    vzs_5_3  = b(kh+kzs+1,1) + lfs.*(theta(5,1).*std3+mean3);
    vzs_6_3  = b(kh+kzs+1,1) + lfs.*(theta(6,1).*std3+mean3);
    vzs_7_3  = b(kh+kzs+1,1) + lfs.*(theta(7,1).*std3+mean3);  
    vzs_8_3  = b(kh+kzs+1,1) + lfs.*(theta(8,1).*std3+mean3);  
    vzs_9_3  = b(kh+kzs+1,1) + lfs.*(theta(9,1).*std3+mean3);  
    vzs_10_3 = b(kh+kzs+1,1) + lfs.*(theta(10,1).*std3+mean3);   
    vzs_11_3 = b(kh+kzs+1,1) + lfs.*(theta(11,1).*std3+mean3);   
    vzs_12_3 = b(kh+kzs+1,1) + lfs.*(theta(12,1).*std3+mean3);   
    vzs_13_3 = b(kh+kzs+1,1) + lfs.*(theta(13,1).*std3+mean3);     
    sig_zs = b(kh+kzs+2,1);
    kh    = kh+kzs+2;     
%--------------------------------------------------------------------------
%1.13 AssigEn b to employment equation 3 years after diploma
%--------------------------------------------------------------------------
    bE3 = [b(kh+1,1); b(kh+1,1); b(kh+1,1); b(kh+2:kh+kw3-2,1)];
    ve3_1_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(1,1).*std1+mean1);
    ve3_2_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(2,1).*std1+mean1);
    ve3_3_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(3,1).*std1+mean1);
    ve3_4_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(4,1).*std1+mean1);
    ve3_5_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(5,1).*std1+mean1);
    ve3_6_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(6,1).*std1+mean1);
    ve3_7_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(7,1).*std1+mean1);
    ve3_8_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(8,1).*std1+mean1);
    ve3_9_1  = b(kh+kw3-2+1,1)   + lE3.*(theta(9,1).*std1+mean1);
    ve3_10_1 = b(kh+kw3-2+1,1)   + lE3.*(theta(10,1).*std1+mean1);
    ve3_11_1 = b(kh+kw3-2+1,1)   + lE3.*(theta(11,1).*std1+mean1);
    ve3_12_1 = b(kh+kw3-2+1,1)   + lE3.*(theta(12,1).*std1+mean1);
    ve3_13_1 = b(kh+kw3-2+1,1)   + lE3.*(theta(13,1).*std1+mean1);
             
    ve3_1_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(1,1).*std2+mean2);
    ve3_2_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(2,1).*std2+mean2);
    ve3_3_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(3,1).*std2+mean2);
    ve3_4_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(4,1).*std2+mean2);
    ve3_5_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(5,1).*std2+mean2);
    ve3_6_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(6,1).*std2+mean2);
    ve3_7_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(7,1).*std2+mean2);
    ve3_8_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(8,1).*std2+mean2);
    ve3_9_2  = b(kh+kw3-2+1,1)   + lE3.*(theta(9,1).*std2+mean2);
    ve3_10_2 = b(kh+kw3-2+1,1)   + lE3.*(theta(10,1).*std2+mean2);
    ve3_11_2 = b(kh+kw3-2+1,1)   + lE3.*(theta(11,1).*std2+mean2);
    ve3_12_2 = b(kh+kw3-2+1,1)   + lE3.*(theta(12,1).*std2+mean2);
    ve3_13_2 = b(kh+kw3-2+1,1)   + lE3.*(theta(13,1).*std2+mean2);
             
    ve3_1_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(1,1).*std3+mean3);
    ve3_2_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(2,1).*std3+mean3);
    ve3_3_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(3,1).*std3+mean3);
    ve3_4_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(4,1).*std3+mean3);
    ve3_5_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(5,1).*std3+mean3);
    ve3_6_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(6,1).*std3+mean3);
    ve3_7_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(7,1).*std3+mean3);
    ve3_8_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(8,1).*std3+mean3);
    ve3_9_3  = b(kh+kw3-2+1,1)   + lE3.*(theta(9,1).*std3+mean3);
    ve3_10_3 = b(kh+kw3-2+1,1)   + lE3.*(theta(10,1).*std3+mean3);
    ve3_11_3 = b(kh+kw3-2+1,1)   + lE3.*(theta(11,1).*std3+mean3);
    ve3_12_3 = b(kh+kw3-2+1,1)   + lE3.*(theta(12,1).*std3+mean3);
    ve3_13_3 = b(kh+kw3-2+1,1)   + lE3.*(theta(13,1).*std3+mean3);
    sigE3 = b(kh+kw3-2+2,1);
    kh  = kh+kw3-2+2;    
%--------------------------------------------------------------------------
%1.14 AssigEn b to employment equation 6 years after diploma
%--------------------------------------------------------------------------
    bE6   = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); b(kh+3,1); bE3(4:kw3)];
    ve6_1_1  = b(kh+4,1)  + lE6.*(theta(1,1).*std1+mean1);
    ve6_2_1  = b(kh+4,1)  + lE6.*(theta(2,1).*std1+mean1);
    ve6_3_1  = b(kh+4,1)  + lE6.*(theta(3,1).*std1+mean1);
    ve6_4_1  = b(kh+4,1)  + lE6.*(theta(4,1).*std1+mean1);
    ve6_5_1  = b(kh+4,1)  + lE6.*(theta(5,1).*std1+mean1);
    ve6_6_1  = b(kh+4,1)  + lE6.*(theta(6,1).*std1+mean1);
    ve6_7_1  = b(kh+4,1)  + lE6.*(theta(7,1).*std1+mean1);
    ve6_8_1  = b(kh+4,1)  + lE6.*(theta(8,1).*std1+mean1);
    ve6_9_1  = b(kh+4,1)  + lE6.*(theta(9,1).*std1+mean1);
    ve6_10_1 = b(kh+4,1)  + lE6.*(theta(10,1).*std1+mean1);
    ve6_11_1 = b(kh+4,1)  + lE6.*(theta(11,1).*std1+mean1);
    ve6_12_1 = b(kh+4,1)  + lE6.*(theta(12,1).*std1+mean1);
    ve6_13_1 = b(kh+4,1)  + lE6.*(theta(13,1).*std1+mean1);
    
    ve6_1_2  = b(kh+4,1)  + lE6.*(theta(1,1).*std2+mean2);
    ve6_2_2  = b(kh+4,1)  + lE6.*(theta(2,1).*std2+mean2);
    ve6_3_2  = b(kh+4,1)  + lE6.*(theta(3,1).*std2+mean2);
    ve6_4_2  = b(kh+4,1)  + lE6.*(theta(4,1).*std2+mean2);
    ve6_5_2  = b(kh+4,1)  + lE6.*(theta(5,1).*std2+mean2);
    ve6_6_2  = b(kh+4,1)  + lE6.*(theta(6,1).*std2+mean2);
    ve6_7_2  = b(kh+4,1)  + lE6.*(theta(7,1).*std2+mean2);
    ve6_8_2  = b(kh+4,1)  + lE6.*(theta(8,1).*std2+mean2);
    ve6_9_2  = b(kh+4,1)  + lE6.*(theta(9,1).*std2+mean2);
    ve6_10_2 = b(kh+4,1)  + lE6.*(theta(10,1).*std2+mean2);
    ve6_11_2 = b(kh+4,1)  + lE6.*(theta(11,1).*std2+mean2);
    ve6_12_2 = b(kh+4,1)  + lE6.*(theta(12,1).*std2+mean2);
    ve6_13_2 = b(kh+4,1)  + lE6.*(theta(13,1).*std2+mean2);

    ve6_1_3  = b(kh+4,1)  + lE6.*(theta(1,1).*std3+mean3);
    ve6_2_3  = b(kh+4,1)  + lE6.*(theta(2,1).*std3+mean3);
    ve6_3_3  = b(kh+4,1)  + lE6.*(theta(3,1).*std3+mean3);
    ve6_4_3  = b(kh+4,1)  + lE6.*(theta(4,1).*std3+mean3);
    ve6_5_3  = b(kh+4,1)  + lE6.*(theta(5,1).*std3+mean3);
    ve6_6_3  = b(kh+4,1)  + lE6.*(theta(6,1).*std3+mean3);
    ve6_7_3  = b(kh+4,1)  + lE6.*(theta(7,1).*std3+mean3);
    ve6_8_3  = b(kh+4,1)  + lE6.*(theta(8,1).*std3+mean3);
    ve6_9_3  = b(kh+4,1)  + lE6.*(theta(9,1).*std3+mean3);
    ve6_10_3 = b(kh+4,1)  + lE6.*(theta(10,1).*std3+mean3);
    ve6_11_3 = b(kh+4,1)  + lE6.*(theta(11,1).*std3+mean3);
    ve6_12_3 = b(kh+4,1)  + lE6.*(theta(12,1).*std3+mean3);
    ve6_13_3 = b(kh+4,1)  + lE6.*(theta(13,1).*std3+mean3);
    sigE6  = b(kh+5,1);
    kh  = kh+5;    
%--------------------------------------------------------------------------
%1.15 AssigEn b to employment equation 9 years after diploma
%--------------------------------------------------------------------------
    bE9   = [b(kh+1,1); b(kh+2,1); b(kh+3,1);... %timing to 1st kid 3-years intervals
             b(kh+4,1); b(kh+4,1); b(kh+5,1);... %timing to 2nd kid 3-years intervals
             b(kh+6,1); b(kh+6,1); b(kh+6,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve9_1_1  = b(kh+7,1) + lE9.*(theta(1,1).*std1+mean1);
    ve9_2_1  = b(kh+7,1) + lE9.*(theta(2,1).*std1+mean1);
    ve9_3_1  = b(kh+7,1) + lE9.*(theta(3,1).*std1+mean1);
    ve9_4_1  = b(kh+7,1) + lE9.*(theta(4,1).*std1+mean1);   
    ve9_5_1  = b(kh+7,1) + lE9.*(theta(5,1).*std1+mean1);   
    ve9_6_1  = b(kh+7,1) + lE9.*(theta(6,1).*std1+mean1);   
    ve9_7_1  = b(kh+7,1) + lE9.*(theta(7,1).*std1+mean1);
    ve9_8_1  = b(kh+7,1) + lE9.*(theta(8,1).*std1+mean1);
    ve9_9_1  = b(kh+7,1) + lE9.*(theta(9,1).*std1+mean1);
    ve9_10_1 = b(kh+7,1) + lE9.*(theta(10,1).*std1+mean1);
    ve9_11_1 = b(kh+7,1) + lE9.*(theta(11,1).*std1+mean1);
    ve9_12_1 = b(kh+7,1) + lE9.*(theta(12,1).*std1+mean1);
    ve9_13_1 = b(kh+7,1) + lE9.*(theta(13,1).*std1+mean1);
    
    ve9_1_2  = b(kh+7,1) + lE9.*(theta(1,1).*std2+mean2);
    ve9_2_2  = b(kh+7,1) + lE9.*(theta(2,1).*std2+mean2);
    ve9_3_2  = b(kh+7,1) + lE9.*(theta(3,1).*std2+mean2);
    ve9_4_2  = b(kh+7,1) + lE9.*(theta(4,1).*std2+mean2);   
    ve9_5_2  = b(kh+7,1) + lE9.*(theta(5,1).*std2+mean2);   
    ve9_6_2  = b(kh+7,1) + lE9.*(theta(6,1).*std2+mean2);   
    ve9_7_2  = b(kh+7,1) + lE9.*(theta(7,1).*std2+mean2);
    ve9_8_2  = b(kh+7,1) + lE9.*(theta(8,1).*std2+mean2);
    ve9_9_2  = b(kh+7,1) + lE9.*(theta(9,1).*std2+mean2);
    ve9_10_2 = b(kh+7,1) + lE9.*(theta(10,1).*std2+mean2);
    ve9_11_2 = b(kh+7,1) + lE9.*(theta(11,1).*std2+mean2);
    ve9_12_2 = b(kh+7,1) + lE9.*(theta(12,1).*std2+mean2);
    ve9_13_2 = b(kh+7,1) + lE9.*(theta(13,1).*std2+mean2);
  
    ve9_1_3  = b(kh+7,1) + lE9.*(theta(1,1).*std3+mean3);
    ve9_2_3  = b(kh+7,1) + lE9.*(theta(2,1).*std3+mean3);
    ve9_3_3  = b(kh+7,1) + lE9.*(theta(3,1).*std3+mean3);
    ve9_4_3  = b(kh+7,1) + lE9.*(theta(4,1).*std3+mean3);  
    ve9_5_3  = b(kh+7,1) + lE9.*(theta(5,1).*std3+mean3);  
    ve9_6_3  = b(kh+7,1) + lE9.*(theta(6,1).*std3+mean3);  
    ve9_7_3  = b(kh+7,1) + lE9.*(theta(7,1).*std3+mean3);
    ve9_8_3  = b(kh+7,1) + lE9.*(theta(8,1).*std3+mean3);
    ve9_9_3  = b(kh+7,1) + lE9.*(theta(9,1).*std3+mean3);
    ve9_10_3 = b(kh+7,1) + lE9.*(theta(10,1).*std3+mean3);
    ve9_11_3 = b(kh+7,1) + lE9.*(theta(11,1).*std3+mean3);
    ve9_12_3 = b(kh+7,1) + lE9.*(theta(12,1).*std3+mean3);
    ve9_13_3 = b(kh+7,1) + lE9.*(theta(13,1).*std3+mean3);
    
    sigE9  = b(kh+8,1);
    kh  = kh+8;    
%--------------------------------------------------------------------------
%1.16 AssigEn b to employment equation 12 years after diploma
%--------------------------------------------------------------------------
    bE12  = [b(kh+1,1); b(kh+2,1); b(kh+3,1); b(kh+4,1);... %timing to 1st kid 3-years intervals
             b(kh+5,1); b(kh+5,1); b(kh+6,1); b(kh+7,1);... %timing to 2nd kid 3-years intervals
             b(kh+8,1); b(kh+8,1); b(kh+8,1); b(kh+8,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve12_1_1  = b(kh+9,1) + lE12.*(theta(1,1).*std1+mean1);
    ve12_2_1  = b(kh+9,1) + lE12.*(theta(2,1).*std1+mean1);
    ve12_3_1  = b(kh+9,1) + lE12.*(theta(3,1).*std1+mean1);
    ve12_4_1  = b(kh+9,1) + lE12.*(theta(4,1).*std1+mean1);
    ve12_5_1  = b(kh+9,1) + lE12.*(theta(5,1).*std1+mean1);  
    ve12_6_1  = b(kh+9,1) + lE12.*(theta(6,1).*std1+mean1);  
    ve12_7_1  = b(kh+9,1) + lE12.*(theta(7,1).*std1+mean1);
    ve12_8_1  = b(kh+9,1) + lE12.*(theta(8,1).*std1+mean1);
    ve12_9_1  = b(kh+9,1) + lE12.*(theta(9,1).*std1+mean1);
    ve12_10_1 = b(kh+9,1) + lE12.*(theta(10,1).*std1+mean1);
    ve12_11_1 = b(kh+9,1) + lE12.*(theta(11,1).*std1+mean1);
    ve12_12_1 = b(kh+9,1) + lE12.*(theta(12,1).*std1+mean1);
    ve12_13_1 = b(kh+9,1) + lE12.*(theta(13,1).*std1+mean1);
    
    ve12_1_2  = b(kh+9,1) + lE12.*(theta(1,1).*std2+mean2);
    ve12_2_2  = b(kh+9,1) + lE12.*(theta(2,1).*std2+mean2);
    ve12_3_2  = b(kh+9,1) + lE12.*(theta(3,1).*std2+mean2);
    ve12_4_2  = b(kh+9,1) + lE12.*(theta(4,1).*std2+mean2);
    ve12_5_2  = b(kh+9,1) + lE12.*(theta(5,1).*std2+mean2);   
    ve12_6_2  = b(kh+9,1) + lE12.*(theta(6,1).*std2+mean2);   
    ve12_7_2  = b(kh+9,1) + lE12.*(theta(7,1).*std2+mean2);   
    ve12_8_2  = b(kh+9,1) + lE12.*(theta(8,1).*std2+mean2);   
    ve12_9_2  = b(kh+9,1) + lE12.*(theta(9,1).*std2+mean2);   
    ve12_10_2 = b(kh+9,1) + lE12.*(theta(10,1).*std2+mean2);    
    ve12_11_2 = b(kh+9,1) + lE12.*(theta(11,1).*std2+mean2);    
    ve12_12_2 = b(kh+9,1) + lE12.*(theta(12,1).*std2+mean2);    
    ve12_13_2 = b(kh+9,1) + lE12.*(theta(13,1).*std2+mean2);    

    ve12_1_3  = b(kh+9,1) + lE12.*(theta(1,1).*std3+mean3);
    ve12_2_3  = b(kh+9,1) + lE12.*(theta(2,1).*std3+mean3);
    ve12_3_3  = b(kh+9,1) + lE12.*(theta(3,1).*std3+mean3);
    ve12_4_3  = b(kh+9,1) + lE12.*(theta(4,1).*std3+mean3);
    ve12_5_3  = b(kh+9,1) + lE12.*(theta(5,1).*std3+mean3);   
    ve12_6_3  = b(kh+9,1) + lE12.*(theta(6,1).*std3+mean3);   
    ve12_7_3  = b(kh+9,1) + lE12.*(theta(7,1).*std3+mean3);   
    ve12_8_3  = b(kh+9,1) + lE12.*(theta(8,1).*std3+mean3);   
    ve12_9_3  = b(kh+9,1) + lE12.*(theta(9,1).*std3+mean3);   
    ve12_10_3 = b(kh+9,1) + lE12.*(theta(10,1).*std3+mean3);    
    ve12_11_3 = b(kh+9,1) + lE12.*(theta(11,1).*std3+mean3);    
    ve12_12_3 = b(kh+9,1) + lE12.*(theta(12,1).*std3+mean3);    
    ve12_13_3 = b(kh+9,1) + lE12.*(theta(13,1).*std3+mean3);    
    sigE12 = b(kh+10,1);
    kh  = kh+10;
%--------------------------------------------------------------------------
%1.17 AssigEn b to employment equation 15 years after diploma
%--------------------------------------------------------------------------
    bE15  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1);... %timing to 1st kid 3-years intervals
             b(kh+6,1);  b(kh+6,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);... %timing to 2nd kid 3-years intervals
             b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+10,1); b(kh+11,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve15_1_1  = b(kh+12,1)  + lE15.*(theta(1,1).*std1+mean1);
    ve15_2_1  = b(kh+12,1)  + lE15.*(theta(2,1).*std1+mean1);
    ve15_3_1  = b(kh+12,1)  + lE15.*(theta(3,1).*std1+mean1);
    ve15_4_1  = b(kh+12,1)  + lE15.*(theta(4,1).*std1+mean1);
    ve15_5_1  = b(kh+12,1)  + lE15.*(theta(5,1).*std1+mean1);    
    ve15_6_1  = b(kh+12,1)  + lE15.*(theta(6,1).*std1+mean1);    
    ve15_7_1  = b(kh+12,1)  + lE15.*(theta(7,1).*std1+mean1);
    ve15_8_1  = b(kh+12,1)  + lE15.*(theta(8,1).*std1+mean1);
    ve15_9_1  = b(kh+12,1)  + lE15.*(theta(9,1).*std1+mean1);
    ve15_10_1 = b(kh+12,1)  + lE15.*(theta(10,1).*std1+mean1);
    ve15_11_1 = b(kh+12,1)  + lE15.*(theta(11,1).*std1+mean1);
    ve15_12_1 = b(kh+12,1)  + lE15.*(theta(12,1).*std1+mean1);
    ve15_13_1 = b(kh+12,1)  + lE15.*(theta(13,1).*std1+mean1);
    
    ve15_1_2  = b(kh+12,1) + lE15.*(theta(1,1).*std2+mean2);
    ve15_2_2  = b(kh+12,1) + lE15.*(theta(2,1).*std2+mean2);
    ve15_3_2  = b(kh+12,1) + lE15.*(theta(3,1).*std2+mean2);
    ve15_4_2  = b(kh+12,1) + lE15.*(theta(4,1).*std2+mean2);
    ve15_5_2  = b(kh+12,1) + lE15.*(theta(5,1).*std2+mean2);    
    ve15_6_2  = b(kh+12,1) + lE15.*(theta(6,1).*std2+mean2);    
    ve15_7_2  = b(kh+12,1) + lE15.*(theta(7,1).*std2+mean2);    
    ve15_8_2  = b(kh+12,1) + lE15.*(theta(8,1).*std2+mean2);    
    ve15_9_2  = b(kh+12,1) + lE15.*(theta(9,1).*std2+mean2);    
    ve15_10_2 = b(kh+12,1) + lE15.*(theta(10,1).*std2+mean2);     
    ve15_11_2 = b(kh+12,1) + lE15.*(theta(11,1).*std2+mean2);     
    ve15_12_2 = b(kh+12,1) + lE15.*(theta(12,1).*std2+mean2);     
    ve15_13_2 = b(kh+12,1) + lE15.*(theta(13,1).*std2+mean2);     

    ve15_1_3  = b(kh+12,1) + lE15.*(theta(1,1).*std3+mean3);
    ve15_2_3  = b(kh+12,1) + lE15.*(theta(2,1).*std3+mean3);
    ve15_3_3  = b(kh+12,1) + lE15.*(theta(3,1).*std3+mean3);
    ve15_4_3  = b(kh+12,1) + lE15.*(theta(4,1).*std3+mean3);
    ve15_5_3  = b(kh+12,1) + lE15.*(theta(5,1).*std3+mean3);   
    ve15_6_3  = b(kh+12,1) + lE15.*(theta(6,1).*std3+mean3);   
    ve15_7_3  = b(kh+12,1) + lE15.*(theta(7,1).*std3+mean3);   
    ve15_8_3  = b(kh+12,1) + lE15.*(theta(8,1).*std3+mean3);   
    ve15_9_3  = b(kh+12,1) + lE15.*(theta(9,1).*std3+mean3);   
    ve15_10_3 = b(kh+12,1) + lE15.*(theta(10,1).*std3+mean3);    
    ve15_11_3 = b(kh+12,1) + lE15.*(theta(11,1).*std3+mean3);    
    ve15_12_3 = b(kh+12,1) + lE15.*(theta(12,1).*std3+mean3);    
    ve15_13_3 = b(kh+12,1) + lE15.*(theta(13,1).*std3+mean3);    
    sigE15 = b(kh+13,1);
    kh  = kh+13;    
%--------------------------------------------------------------------------
%1.18 AssigEn b to employment equation 18 years after diploma
%--------------------------------------------------------------------------
    bE18  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1) ;... %timing to 1st kid 3-years intervals
             b(kh+7,1);  b(kh+7,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1);... %timing to 2nd kid 3-years intervals
             b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+12,1); b(kh+13,1); b(kh+14,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve18_1_1  = b(kh+15,1) + lE18.*(theta(1,1).*std1+mean1);
    ve18_2_1  = b(kh+15,1) + lE18.*(theta(2,1).*std1+mean1);
    ve18_3_1  = b(kh+15,1) + lE18.*(theta(3,1).*std1+mean1);
    ve18_4_1  = b(kh+15,1) + lE18.*(theta(4,1).*std1+mean1); 
    ve18_5_1  = b(kh+15,1) + lE18.*(theta(5,1).*std1+mean1); 
    ve18_6_1  = b(kh+15,1) + lE18.*(theta(6,1).*std1+mean1); 
    ve18_7_1  = b(kh+15,1) + lE18.*(theta(7,1).*std1+mean1);
    ve18_8_1  = b(kh+15,1) + lE18.*(theta(8,1).*std1+mean1);
    ve18_9_1  = b(kh+15,1) + lE18.*(theta(9,1).*std1+mean1);
    ve18_10_1 = b(kh+15,1) + lE18.*(theta(10,1).*std1+mean1);
    ve18_11_1 = b(kh+15,1) + lE18.*(theta(11,1).*std1+mean1);
    ve18_12_1 = b(kh+15,1) + lE18.*(theta(12,1).*std1+mean1);
    ve18_13_1 = b(kh+15,1) + lE18.*(theta(13,1).*std1+mean1);
    
    ve18_1_2  = b(kh+15,1) + lE18.*(theta(1,1).*std2+mean2);
    ve18_2_2  = b(kh+15,1) + lE18.*(theta(2,1).*std2+mean2);
    ve18_3_2  = b(kh+15,1) + lE18.*(theta(3,1).*std2+mean2);
    ve18_4_2  = b(kh+15,1) + lE18.*(theta(4,1).*std2+mean2);  
    ve18_5_2  = b(kh+15,1) + lE18.*(theta(5,1).*std2+mean2);  
    ve18_6_2  = b(kh+15,1) + lE18.*(theta(6,1).*std2+mean2);  
    ve18_7_2  = b(kh+15,1) + lE18.*(theta(7,1).*std2+mean2);
    ve18_8_2  = b(kh+15,1) + lE18.*(theta(8,1).*std2+mean2);
    ve18_9_2  = b(kh+15,1) + lE18.*(theta(9,1).*std2+mean2);
    ve18_10_2 = b(kh+15,1) + lE18.*(theta(10,1).*std2+mean2); 
    ve18_11_2 = b(kh+15,1) + lE18.*(theta(11,1).*std2+mean2); 
    ve18_12_2 = b(kh+15,1) + lE18.*(theta(12,1).*std2+mean2); 
    ve18_13_2 = b(kh+15,1) + lE18.*(theta(13,1).*std2+mean2); 

    ve18_1_3  = b(kh+15,1) + lE18.*(theta(1,1).*std3+mean3);
    ve18_2_3  = b(kh+15,1) + lE18.*(theta(2,1).*std3+mean3);
    ve18_3_3  = b(kh+15,1) + lE18.*(theta(3,1).*std3+mean3);
    ve18_4_3  = b(kh+15,1) + lE18.*(theta(4,1).*std3+mean3); 
    ve18_5_3  = b(kh+15,1) + lE18.*(theta(5,1).*std3+mean3); 
    ve18_6_3  = b(kh+15,1) + lE18.*(theta(6,1).*std3+mean3); 
    ve18_7_3  = b(kh+15,1) + lE18.*(theta(7,1).*std3+mean3);
    ve18_8_3  = b(kh+15,1) + lE18.*(theta(8,1).*std3+mean3);
    ve18_9_3  = b(kh+15,1) + lE18.*(theta(9,1).*std3+mean3);
    ve18_10_3 = b(kh+15,1) + lE18.*(theta(10,1).*std3+mean3);
    ve18_11_3 = b(kh+15,1) + lE18.*(theta(11,1).*std3+mean3);
    ve18_12_3 = b(kh+15,1) + lE18.*(theta(12,1).*std3+mean3);
    ve18_13_3 = b(kh+15,1) + lE18.*(theta(13,1).*std3+mean3);
    sigE18 = b(kh+16,1);
    kh  = kh+16;    
%--------------------------------------------------------------------------
%1.19 AssigEn b to employment equation 21 years after diploma
%--------------------------------------------------------------------------
    bE21  = [b(kh+1,1);  b(kh+2,1);  b(kh+3,1);  b(kh+4,1);  b(kh+5,1) ; b(kh+6,1);  b(kh+7,1) ;... %timing to 1st kid 3-years intervals
             b(kh+8,1);  b(kh+8,1);  b(kh+9,1);  b(kh+10,1); b(kh+11,1); b(kh+12,1); b(kh+13,1);... %timing to 2nd kid 3-years intervals
             b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+14,1); b(kh+15,1); b(kh+16,1); b(kh+16,1);...   %timing to 3rd kid 3-years intervals
             bE3(4:kw3)];                        
    ve21_1_1  = b(kh+17,1) + lE21.*(theta(1,1).*std1+mean1);
    ve21_2_1  = b(kh+17,1) + lE21.*(theta(2,1).*std1+mean1);
    ve21_3_1  = b(kh+17,1) + lE21.*(theta(3,1).*std1+mean1);
    ve21_4_1  = b(kh+17,1) + lE21.*(theta(4,1).*std1+mean1);
    ve21_5_1  = b(kh+17,1) + lE21.*(theta(5,1).*std1+mean1);
    ve21_6_1  = b(kh+17,1) + lE21.*(theta(6,1).*std1+mean1);
    ve21_7_1  = b(kh+17,1) + lE21.*(theta(7,1).*std1+mean1);
    ve21_8_1  = b(kh+17,1) + lE21.*(theta(8,1).*std1+mean1);
    ve21_9_1  = b(kh+17,1) + lE21.*(theta(9,1).*std1+mean1);
    ve21_10_1 = b(kh+17,1) + lE21.*(theta(10,1).*std1+mean1);
    ve21_11_1 = b(kh+17,1) + lE21.*(theta(11,1).*std1+mean1);
    ve21_12_1 = b(kh+17,1) + lE21.*(theta(12,1).*std1+mean1);
    ve21_13_1 = b(kh+17,1) + lE21.*(theta(13,1).*std1+mean1);
    
    ve21_1_2  = b(kh+17,1) + lE21.*(theta(1,1).*std2+mean2);
    ve21_2_2  = b(kh+17,1) + lE21.*(theta(2,1).*std2+mean2);
    ve21_3_2  = b(kh+17,1) + lE21.*(theta(3,1).*std2+mean2);
    ve21_4_2  = b(kh+17,1) + lE21.*(theta(4,1).*std2+mean2);
    ve21_5_2  = b(kh+17,1) + lE21.*(theta(5,1).*std2+mean2);
    ve21_6_2  = b(kh+17,1) + lE21.*(theta(6,1).*std2+mean2);
    ve21_7_2  = b(kh+17,1) + lE21.*(theta(7,1).*std2+mean2);
    ve21_8_2  = b(kh+17,1) + lE21.*(theta(8,1).*std2+mean2);
    ve21_9_2  = b(kh+17,1) + lE21.*(theta(9,1).*std2+mean2);
    ve21_10_2 = b(kh+17,1) + lE21.*(theta(10,1).*std2+mean2); 
    ve21_11_2 = b(kh+17,1) + lE21.*(theta(11,1).*std2+mean2); 
    ve21_12_2 = b(kh+17,1) + lE21.*(theta(12,1).*std2+mean2); 
    ve21_13_2 = b(kh+17,1) + lE21.*(theta(13,1).*std2+mean2); 

    ve21_1_3  = b(kh+17,1) + lE21.*(theta(1,1).*std3+mean3);
    ve21_2_3  = b(kh+17,1) + lE21.*(theta(2,1).*std3+mean3);
    ve21_3_3  = b(kh+17,1) + lE21.*(theta(3,1).*std3+mean3);
    ve21_4_3  = b(kh+17,1) + lE21.*(theta(4,1).*std3+mean3);
    ve21_5_3  = b(kh+17,1) + lE21.*(theta(5,1).*std3+mean3);
    ve21_6_3  = b(kh+17,1) + lE21.*(theta(6,1).*std3+mean3);
    ve21_7_3  = b(kh+17,1) + lE21.*(theta(7,1).*std3+mean3);  
    ve21_8_3  = b(kh+17,1) + lE21.*(theta(8,1).*std3+mean3);  
    ve21_9_3  = b(kh+17,1) + lE21.*(theta(9,1).*std3+mean3);  
    ve21_10_3 = b(kh+17,1) + lE21.*(theta(10,1).*std3+mean3);   
    ve21_11_3 = b(kh+17,1) + lE21.*(theta(11,1).*std3+mean3);   
    ve21_12_3 = b(kh+17,1) + lE21.*(theta(12,1).*std3+mean3);   
    ve21_13_3 = b(kh+17,1) + lE21.*(theta(13,1).*std3+mean3);   
    sigE21 = b(kh+18,1);      
    
%--------------------------------------------------------------------------
%2.1 Contribution to the likelihood function of 1st childbirth
%--------------------------------------------------------------------------
lf1_1=ones(n,3);
lf1_1(:,1) = (  normcdf(va1_1_1 - X1*bX1).^dur1_1...
            .* (normcdf(va2_1_1 - X1*bX1)-normcdf(va1_1_1 - X1*bX1)).^dur1_2...
            .* (normcdf(va3_1_1 - X1*bX1)-normcdf(va2_1_1 - X1*bX1)).^dur1_3...
            .* (normcdf(va4_1_1 - X1*bX1)-normcdf(va3_1_1 - X1*bX1)).^dur1_4...
            .* (normcdf(va5_1_1 - X1*bX1)-normcdf(va4_1_1 - X1*bX1)).^dur1_5...
            .* (normcdf(va6_1_1 - X1*bX1)-normcdf(va5_1_1 - X1*bX1)).^dur1_6...
            .* (normcdf(va7_1_1 - X1*bX1)-normcdf(va6_1_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
             (( 1-normcdf(va1_1_1 - X1*bX1)).^dur1_1...
            .* (1-normcdf(va2_1_1 - X1*bX1)).^dur1_2...
            .* (1-normcdf(va3_1_1 - X1*bX1)).^dur1_3...
            .* (1-normcdf(va4_1_1 - X1*bX1)).^dur1_4...
            .* (1-normcdf(va5_1_1 - X1*bX1)).^dur1_5...
            .* (1-normcdf(va6_1_1 - X1*bX1)).^dur1_6...
            .* (1-normcdf(va7_1_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_1(:,2) = (  normcdf(va1_1_2 - X1*bX1).^dur1_1...
            .* (normcdf(va2_1_2 - X1*bX1)-normcdf(va1_1_2 - X1*bX1)).^dur1_2...
            .* (normcdf(va3_1_2 - X1*bX1)-normcdf(va2_1_2 - X1*bX1)).^dur1_3...
            .* (normcdf(va4_1_2 - X1*bX1)-normcdf(va3_1_2 - X1*bX1)).^dur1_4...
            .* (normcdf(va5_1_2 - X1*bX1)-normcdf(va4_1_2 - X1*bX1)).^dur1_5...
            .* (normcdf(va6_1_2 - X1*bX1)-normcdf(va5_1_2 - X1*bX1)).^dur1_6...
            .* (normcdf(va7_1_2 - X1*bX1)-normcdf(va6_1_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
             (( 1-normcdf(va1_1_2 - X1*bX1)).^dur1_1...
            .* (1-normcdf(va2_1_2 - X1*bX1)).^dur1_2...
            .* (1-normcdf(va3_1_2 - X1*bX1)).^dur1_3...
            .* (1-normcdf(va4_1_2 - X1*bX1)).^dur1_4...
            .* (1-normcdf(va5_1_2 - X1*bX1)).^dur1_5...
            .* (1-normcdf(va6_1_2 - X1*bX1)).^dur1_6...
            .* (1-normcdf(va7_1_2 - X1*bX1)).^dur1_7).^(cens1);            

lf1_1(:,3) = (  normcdf(va1_1_3 - X1*bX1).^dur1_1...
            .* (normcdf(va2_1_3 - X1*bX1)-normcdf(va1_1_3 - X1*bX1)).^dur1_2...
            .* (normcdf(va3_1_3 - X1*bX1)-normcdf(va2_1_3 - X1*bX1)).^dur1_3...
            .* (normcdf(va4_1_3 - X1*bX1)-normcdf(va3_1_3 - X1*bX1)).^dur1_4...
            .* (normcdf(va5_1_3 - X1*bX1)-normcdf(va4_1_3 - X1*bX1)).^dur1_5...
            .* (normcdf(va6_1_3 - X1*bX1)-normcdf(va5_1_3 - X1*bX1)).^dur1_6...
            .* (normcdf(va7_1_3 - X1*bX1)-normcdf(va6_1_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
             (( 1-normcdf(va1_1_3 - X1*bX1)).^dur1_1...
            .* (1-normcdf(va2_1_3 - X1*bX1)).^dur1_2...
            .* (1-normcdf(va3_1_3 - X1*bX1)).^dur1_3...
            .* (1-normcdf(va4_1_3 - X1*bX1)).^dur1_4...
            .* (1-normcdf(va5_1_3 - X1*bX1)).^dur1_5...
            .* (1-normcdf(va6_1_3 - X1*bX1)).^dur1_6...
            .* (1-normcdf(va7_1_3 - X1*bX1)).^dur1_7).^(cens1);    
            
lf1_2=ones(n,3);
lf1_2(:,1) = (normcdf(va1_2_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_2_1 - X1*bX1)-normcdf(va1_2_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_2_1 - X1*bX1)-normcdf(va2_2_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_2_1 - X1*bX1)-normcdf(va3_2_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_2_1 - X1*bX1)-normcdf(va4_2_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_2_1 - X1*bX1)-normcdf(va5_2_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_2_1 - X1*bX1)-normcdf(va6_2_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_2_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_2_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_2_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_2_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_2_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_2_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_2_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_2(:,2) = (normcdf(va1_2_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_2_2 - X1*bX1)-normcdf(va1_2_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_2_2 - X1*bX1)-normcdf(va2_2_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_2_2 - X1*bX1)-normcdf(va3_2_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_2_2 - X1*bX1)-normcdf(va4_2_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_2_2 - X1*bX1)-normcdf(va5_2_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_2_2 - X1*bX1)-normcdf(va6_2_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_2_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_2_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_2_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_2_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_2_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_2_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_2_2 - X1*bX1)).^dur1_7).^(cens1);
          
lf1_2(:,3) = (normcdf(va1_2_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_2_3 - X1*bX1)-normcdf(va1_2_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_2_3 - X1*bX1)-normcdf(va2_2_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_2_3 - X1*bX1)-normcdf(va3_2_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_2_3 - X1*bX1)-normcdf(va4_2_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_2_3 - X1*bX1)-normcdf(va5_2_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_2_3 - X1*bX1)-normcdf(va6_2_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_2_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_2_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_2_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_2_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_2_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_2_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_2_3 - X1*bX1)).^dur1_7).^(cens1);
          
lf1_3=ones(n,3);
lf1_3(:,1) = (normcdf(va1_3_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_3_1 - X1*bX1)-normcdf(va1_3_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_3_1 - X1*bX1)-normcdf(va2_3_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_3_1 - X1*bX1)-normcdf(va3_3_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_3_1 - X1*bX1)-normcdf(va4_3_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_3_1 - X1*bX1)-normcdf(va5_3_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_3_1 - X1*bX1)-normcdf(va6_3_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_3_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_3_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_3_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_3_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_3_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_3_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_3_1 - X1*bX1)).^dur1_7).^(cens1);
          
lf1_3(:,2) = (normcdf(va1_3_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_3_2 - X1*bX1)-normcdf(va1_3_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_3_2 - X1*bX1)-normcdf(va2_3_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_3_2 - X1*bX1)-normcdf(va3_3_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_3_2 - X1*bX1)-normcdf(va4_3_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_3_2 - X1*bX1)-normcdf(va5_3_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_3_2 - X1*bX1)-normcdf(va6_3_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_3_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_3_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_3_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_3_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_3_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_3_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_3_2 - X1*bX1)).^dur1_7).^(cens1);      

lf1_3(:,3) = (normcdf(va1_3_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_3_3 - X1*bX1)-normcdf(va1_3_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_3_3 - X1*bX1)-normcdf(va2_3_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_3_3 - X1*bX1)-normcdf(va3_3_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_3_3 - X1*bX1)-normcdf(va4_3_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_3_3 - X1*bX1)-normcdf(va5_3_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_3_3 - X1*bX1)-normcdf(va6_3_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_3_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_3_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_3_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_3_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_3_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_3_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_3_3 - X1*bX1)).^dur1_7).^(cens1); 
          
lf1_4=ones(n,3);
lf1_4(:,1) = (normcdf(va1_4_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_4_1 - X1*bX1)-normcdf(va1_4_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_4_1 - X1*bX1)-normcdf(va2_4_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_4_1 - X1*bX1)-normcdf(va3_4_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_4_1 - X1*bX1)-normcdf(va4_4_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_4_1 - X1*bX1)-normcdf(va5_4_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_4_1 - X1*bX1)-normcdf(va6_4_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_4_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_4_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_4_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_4_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_4_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_4_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_4_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_4(:,2) = (normcdf(va1_4_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_4_2 - X1*bX1)-normcdf(va1_4_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_4_2 - X1*bX1)-normcdf(va2_4_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_4_2 - X1*bX1)-normcdf(va3_4_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_4_2 - X1*bX1)-normcdf(va4_4_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_4_2 - X1*bX1)-normcdf(va5_4_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_4_2 - X1*bX1)-normcdf(va6_4_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_4_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_4_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_4_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_4_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_4_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_4_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_4_2 - X1*bX1)).^dur1_7).^(cens1);  
          
lf1_4(:,3) = (normcdf(va1_4_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_4_3 - X1*bX1)-normcdf(va1_4_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_4_3 - X1*bX1)-normcdf(va2_4_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_4_3 - X1*bX1)-normcdf(va3_4_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_4_3 - X1*bX1)-normcdf(va4_4_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_4_3 - X1*bX1)-normcdf(va5_4_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_4_3 - X1*bX1)-normcdf(va6_4_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_4_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_4_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_4_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_4_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_4_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_4_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_4_3 - X1*bX1)).^dur1_7).^(cens1);          

lf1_5=ones(n,3);
lf1_5(:,1) = (normcdf(va1_5_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_5_1 - X1*bX1)-normcdf(va1_5_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_5_1 - X1*bX1)-normcdf(va2_5_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_5_1 - X1*bX1)-normcdf(va3_5_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_5_1 - X1*bX1)-normcdf(va4_5_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_5_1 - X1*bX1)-normcdf(va5_5_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_5_1 - X1*bX1)-normcdf(va6_5_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_5_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_5_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_5_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_5_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_5_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_5_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_5_1 - X1*bX1)).^dur1_7).^(cens1);
          
lf1_5(:,2) = (normcdf(va1_5_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_5_2 - X1*bX1)-normcdf(va1_5_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_5_2 - X1*bX1)-normcdf(va2_5_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_5_2 - X1*bX1)-normcdf(va3_5_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_5_2 - X1*bX1)-normcdf(va4_5_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_5_2 - X1*bX1)-normcdf(va5_5_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_5_2 - X1*bX1)-normcdf(va6_5_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_5_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_5_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_5_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_5_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_5_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_5_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_5_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_5(:,3) = (normcdf(va1_5_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_5_3 - X1*bX1)-normcdf(va1_5_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_5_3 - X1*bX1)-normcdf(va2_5_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_5_3 - X1*bX1)-normcdf(va3_5_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_5_3 - X1*bX1)-normcdf(va4_5_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_5_3 - X1*bX1)-normcdf(va5_5_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_5_3 - X1*bX1)-normcdf(va6_5_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_5_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_5_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_5_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_5_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_5_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_5_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_5_3 - X1*bX1)).^dur1_7).^(cens1);          
   
lf1_6=ones(n,3);
lf1_6(:,1) = (normcdf(va1_6_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_6_1 - X1*bX1)-normcdf(va1_6_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_6_1 - X1*bX1)-normcdf(va2_6_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_6_1 - X1*bX1)-normcdf(va3_6_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_6_1 - X1*bX1)-normcdf(va4_6_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_6_1 - X1*bX1)-normcdf(va5_6_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_6_1 - X1*bX1)-normcdf(va6_6_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_6_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_6_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_6_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_6_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_6_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_6_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_6_1 - X1*bX1)).^dur1_7).^(cens1);
          
lf1_6(:,2) = (normcdf(va1_6_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_6_2 - X1*bX1)-normcdf(va1_6_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_6_2 - X1*bX1)-normcdf(va2_6_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_6_2 - X1*bX1)-normcdf(va3_6_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_6_2 - X1*bX1)-normcdf(va4_6_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_6_2 - X1*bX1)-normcdf(va5_6_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_6_2 - X1*bX1)-normcdf(va6_6_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_6_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_6_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_6_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_6_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_6_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_6_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_6_2 - X1*bX1)).^dur1_7).^(cens1);
          
lf1_6(:,3) = (normcdf(va1_6_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_6_3 - X1*bX1)-normcdf(va1_6_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_6_3 - X1*bX1)-normcdf(va2_6_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_6_3 - X1*bX1)-normcdf(va3_6_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_6_3 - X1*bX1)-normcdf(va4_6_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_6_3 - X1*bX1)-normcdf(va5_6_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_6_3 - X1*bX1)-normcdf(va6_6_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_6_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_6_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_6_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_6_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_6_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_6_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_6_3 - X1*bX1)).^dur1_7).^(cens1);
          
lf1_7=ones(n,3);
lf1_7(:,1) = (normcdf(va1_7_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_7_1 - X1*bX1)-normcdf(va1_7_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_7_1 - X1*bX1)-normcdf(va2_7_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_7_1 - X1*bX1)-normcdf(va3_7_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_7_1 - X1*bX1)-normcdf(va4_7_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_7_1 - X1*bX1)-normcdf(va5_7_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_7_1 - X1*bX1)-normcdf(va6_7_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_7_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_7_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_7_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_7_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_7_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_7_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_7_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_7(:,2) = (normcdf(va1_7_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_7_2 - X1*bX1)-normcdf(va1_7_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_7_2 - X1*bX1)-normcdf(va2_7_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_7_2 - X1*bX1)-normcdf(va3_7_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_7_2 - X1*bX1)-normcdf(va4_7_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_7_2 - X1*bX1)-normcdf(va5_7_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_7_2 - X1*bX1)-normcdf(va6_7_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_7_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_7_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_7_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_7_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_7_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_7_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_7_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_7(:,3) = (normcdf(va1_7_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_7_3 - X1*bX1)-normcdf(va1_7_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_7_3 - X1*bX1)-normcdf(va2_7_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_7_3 - X1*bX1)-normcdf(va3_7_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_7_3 - X1*bX1)-normcdf(va4_7_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_7_3 - X1*bX1)-normcdf(va5_7_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_7_3 - X1*bX1)-normcdf(va6_7_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_7_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_7_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_7_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_7_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_7_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_7_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_7_3 - X1*bX1)).^dur1_7).^(cens1);          

          
lf1_8=ones(n,3);
lf1_8(:,1) = (normcdf(va1_8_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_8_1 - X1*bX1)-normcdf(va1_8_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_8_1 - X1*bX1)-normcdf(va2_8_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_8_1 - X1*bX1)-normcdf(va3_8_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_8_1 - X1*bX1)-normcdf(va4_8_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_8_1 - X1*bX1)-normcdf(va5_8_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_8_1 - X1*bX1)-normcdf(va6_8_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_8_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_8_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_8_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_8_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_8_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_8_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_8_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_8(:,2) = (normcdf(va1_8_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_8_2 - X1*bX1)-normcdf(va1_8_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_8_2 - X1*bX1)-normcdf(va2_8_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_8_2 - X1*bX1)-normcdf(va3_8_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_8_2 - X1*bX1)-normcdf(va4_8_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_8_2 - X1*bX1)-normcdf(va5_8_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_8_2 - X1*bX1)-normcdf(va6_8_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_8_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_8_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_8_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_8_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_8_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_8_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_8_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_8(:,3) = (normcdf(va1_8_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_8_3 - X1*bX1)-normcdf(va1_8_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_8_3 - X1*bX1)-normcdf(va2_8_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_8_3 - X1*bX1)-normcdf(va3_8_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_8_3 - X1*bX1)-normcdf(va4_8_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_8_3 - X1*bX1)-normcdf(va5_8_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_8_3 - X1*bX1)-normcdf(va6_8_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_8_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_8_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_8_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_8_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_8_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_8_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_8_3 - X1*bX1)).^dur1_7).^(cens1);          

lf1_9=ones(n,3);
lf1_9(:,1) = (normcdf(va1_9_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_9_1 - X1*bX1)-normcdf(va1_9_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_9_1 - X1*bX1)-normcdf(va2_9_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_9_1 - X1*bX1)-normcdf(va3_9_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_9_1 - X1*bX1)-normcdf(va4_9_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_9_1 - X1*bX1)-normcdf(va5_9_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_9_1 - X1*bX1)-normcdf(va6_9_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_9_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_9_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_9_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_9_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_9_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_9_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_9_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_9(:,2) = (normcdf(va1_9_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_9_2 - X1*bX1)-normcdf(va1_9_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_9_2 - X1*bX1)-normcdf(va2_9_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_9_2 - X1*bX1)-normcdf(va3_9_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_9_2 - X1*bX1)-normcdf(va4_9_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_9_2 - X1*bX1)-normcdf(va5_9_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_9_2 - X1*bX1)-normcdf(va6_9_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_9_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_9_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_9_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_9_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_9_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_9_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_9_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_9(:,3) = (normcdf(va1_9_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_9_3 - X1*bX1)-normcdf(va1_9_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_9_3 - X1*bX1)-normcdf(va2_9_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_9_3 - X1*bX1)-normcdf(va3_9_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_9_3 - X1*bX1)-normcdf(va4_9_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_9_3 - X1*bX1)-normcdf(va5_9_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_9_3 - X1*bX1)-normcdf(va6_9_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_9_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_9_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_9_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_9_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_9_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_9_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_9_3 - X1*bX1)).^dur1_7).^(cens1);          

lf1_10=ones(n,3);
lf1_10(:,1) = (normcdf(va1_10_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_10_1 - X1*bX1)-normcdf(va1_10_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_10_1 - X1*bX1)-normcdf(va2_10_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_10_1 - X1*bX1)-normcdf(va3_10_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_10_1 - X1*bX1)-normcdf(va4_10_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_10_1 - X1*bX1)-normcdf(va5_10_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_10_1 - X1*bX1)-normcdf(va6_10_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_10_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_10_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_10_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_10_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_10_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_10_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_10_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_10(:,2) = (normcdf(va1_10_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_10_2 - X1*bX1)-normcdf(va1_10_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_10_2 - X1*bX1)-normcdf(va2_10_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_10_2 - X1*bX1)-normcdf(va3_10_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_10_2 - X1*bX1)-normcdf(va4_10_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_10_2 - X1*bX1)-normcdf(va5_10_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_10_2 - X1*bX1)-normcdf(va6_10_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_10_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_10_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_10_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_10_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_10_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_10_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_10_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_10(:,3) = (normcdf(va1_10_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_10_3 - X1*bX1)-normcdf(va1_10_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_10_3 - X1*bX1)-normcdf(va2_10_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_10_3 - X1*bX1)-normcdf(va3_10_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_10_3 - X1*bX1)-normcdf(va4_10_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_10_3 - X1*bX1)-normcdf(va5_10_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_10_3 - X1*bX1)-normcdf(va6_10_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_10_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_10_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_10_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_10_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_10_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_10_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_10_3 - X1*bX1)).^dur1_7).^(cens1);          

lf1_11=ones(n,3);
lf1_11(:,1) = (normcdf(va1_11_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_11_1 - X1*bX1)-normcdf(va1_11_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_11_1 - X1*bX1)-normcdf(va2_11_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_11_1 - X1*bX1)-normcdf(va3_11_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_11_1 - X1*bX1)-normcdf(va4_11_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_11_1 - X1*bX1)-normcdf(va5_11_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_11_1 - X1*bX1)-normcdf(va6_11_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_11_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_11_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_11_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_11_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_11_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_11_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_11_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_11(:,2) = (normcdf(va1_11_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_11_2 - X1*bX1)-normcdf(va1_11_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_11_2 - X1*bX1)-normcdf(va2_11_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_11_2 - X1*bX1)-normcdf(va3_11_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_11_2 - X1*bX1)-normcdf(va4_11_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_11_2 - X1*bX1)-normcdf(va5_11_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_11_2 - X1*bX1)-normcdf(va6_11_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_11_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_11_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_11_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_11_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_11_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_11_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_11_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_11(:,3) = (normcdf(va1_11_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_11_3 - X1*bX1)-normcdf(va1_11_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_11_3 - X1*bX1)-normcdf(va2_11_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_11_3 - X1*bX1)-normcdf(va3_11_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_11_3 - X1*bX1)-normcdf(va4_11_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_11_3 - X1*bX1)-normcdf(va5_11_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_11_3 - X1*bX1)-normcdf(va6_11_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_11_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_11_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_11_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_11_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_11_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_11_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_11_3 - X1*bX1)).^dur1_7).^(cens1);          

lf1_12=ones(n,3);
lf1_12(:,1) = (normcdf(va1_12_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_12_1 - X1*bX1)-normcdf(va1_12_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_12_1 - X1*bX1)-normcdf(va2_12_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_12_1 - X1*bX1)-normcdf(va3_12_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_12_1 - X1*bX1)-normcdf(va4_12_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_12_1 - X1*bX1)-normcdf(va5_12_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_12_1 - X1*bX1)-normcdf(va6_12_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_12_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_12_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_12_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_12_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_12_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_12_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_12_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_12(:,2) = (normcdf(va1_12_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_12_2 - X1*bX1)-normcdf(va1_12_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_12_2 - X1*bX1)-normcdf(va2_12_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_12_2 - X1*bX1)-normcdf(va3_12_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_12_2 - X1*bX1)-normcdf(va4_12_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_12_2 - X1*bX1)-normcdf(va5_12_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_12_2 - X1*bX1)-normcdf(va6_12_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_12_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_12_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_12_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_12_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_12_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_12_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_12_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_12(:,3) = (normcdf(va1_12_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_12_3 - X1*bX1)-normcdf(va1_12_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_12_3 - X1*bX1)-normcdf(va2_12_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_12_3 - X1*bX1)-normcdf(va3_12_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_12_3 - X1*bX1)-normcdf(va4_12_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_12_3 - X1*bX1)-normcdf(va5_12_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_12_3 - X1*bX1)-normcdf(va6_12_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_12_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_12_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_12_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_12_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_12_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_12_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_12_3 - X1*bX1)).^dur1_7).^(cens1);          

lf1_13=ones(n,3);
lf1_13(:,1) = (normcdf(va1_13_1 - X1*bX1).^dur1_1...
          .* (normcdf(va2_13_1 - X1*bX1)-normcdf(va1_13_1 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_13_1 - X1*bX1)-normcdf(va2_13_1 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_13_1 - X1*bX1)-normcdf(va3_13_1 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_13_1 - X1*bX1)-normcdf(va4_13_1 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_13_1 - X1*bX1)-normcdf(va5_13_1 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_13_1 - X1*bX1)-normcdf(va6_13_1 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_13_1 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_13_1 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_13_1 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_13_1 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_13_1 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_13_1 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_13_1 - X1*bX1)).^dur1_7).^(cens1);

lf1_13(:,2) = (normcdf(va1_13_2 - X1*bX1).^dur1_1...
          .* (normcdf(va2_13_2 - X1*bX1)-normcdf(va1_13_2 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_13_2 - X1*bX1)-normcdf(va2_13_2 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_13_2 - X1*bX1)-normcdf(va3_13_2 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_13_2 - X1*bX1)-normcdf(va4_13_2 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_13_2 - X1*bX1)-normcdf(va5_13_2 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_13_2 - X1*bX1)-normcdf(va6_13_2 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_13_2 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_13_2 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_13_2 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_13_2 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_13_2 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_13_2 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_13_2 - X1*bX1)).^dur1_7).^(cens1);          

lf1_13(:,3) = (normcdf(va1_13_3 - X1*bX1).^dur1_1...
          .* (normcdf(va2_13_3 - X1*bX1)-normcdf(va1_13_3 - X1*bX1)).^dur1_2...
          .* (normcdf(va3_13_3 - X1*bX1)-normcdf(va2_13_3 - X1*bX1)).^dur1_3...
          .* (normcdf(va4_13_3 - X1*bX1)-normcdf(va3_13_3 - X1*bX1)).^dur1_4...
          .* (normcdf(va5_13_3 - X1*bX1)-normcdf(va4_13_3 - X1*bX1)).^dur1_5...
          .* (normcdf(va6_13_3 - X1*bX1)-normcdf(va5_13_3 - X1*bX1)).^dur1_6...
          .* (normcdf(va7_13_3 - X1*bX1)-normcdf(va6_13_3 - X1*bX1)).^dur1_7).^(1-cens1).*...
           (( 1-normcdf(va1_13_3 - X1*bX1)).^dur1_1...
          .* (1-normcdf(va2_13_3 - X1*bX1)).^dur1_2...
          .* (1-normcdf(va3_13_3 - X1*bX1)).^dur1_3...
          .* (1-normcdf(va4_13_3 - X1*bX1)).^dur1_4...
          .* (1-normcdf(va5_13_3 - X1*bX1)).^dur1_5...
          .* (1-normcdf(va6_13_3 - X1*bX1)).^dur1_6...
          .* (1-normcdf(va7_13_3 - X1*bX1)).^dur1_7).^(cens1);          
          
%--------------------------------------------------------------------------
%2.2 Contribution to the likelihood function of 2nd childbirth
%--------------------------------------------------------------------------
lf2_1=ones(n,3);
lf2_1(:,1) =(((  normcdf(vb1_1_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_1_1 - X2*bX2)-normcdf(vb1_1_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_1_1 - X2*bX2)-normcdf(vb2_1_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_1_1 - X2*bX2)-normcdf(vb3_1_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_1_1 - X2*bX2)-normcdf(vb4_1_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_1_1 - X2*bX2)-normcdf(vb5_1_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_1_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_1_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_1_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_1_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_1_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_1_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_1(:,2) =(((  normcdf(vb1_1_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_1_2 - X2*bX2)-normcdf(vb1_1_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_1_2 - X2*bX2)-normcdf(vb2_1_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_1_2 - X2*bX2)-normcdf(vb3_1_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_1_2 - X2*bX2)-normcdf(vb4_1_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_1_2 - X2*bX2)-normcdf(vb5_1_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_1_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_1_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_1_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_1_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_1_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_1_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_1(:,3) =(((  normcdf(vb1_1_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_1_3 - X2*bX2)-normcdf(vb1_1_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_1_3 - X2*bX2)-normcdf(vb2_1_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_1_3 - X2*bX2)-normcdf(vb3_1_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_1_3 - X2*bX2)-normcdf(vb4_1_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_1_3 - X2*bX2)-normcdf(vb5_1_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_1_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_1_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_1_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_1_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_1_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_1_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_2=ones(n,3);
lf2_2(:,1) =(((  normcdf(vb1_2_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_2_1 - X2*bX2)-normcdf(vb1_2_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_2_1 - X2*bX2)-normcdf(vb2_2_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_2_1 - X2*bX2)-normcdf(vb3_2_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_2_1 - X2*bX2)-normcdf(vb4_2_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_2_1 - X2*bX2)-normcdf(vb5_2_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_2_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_2_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_2_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_2_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_2_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_2_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_2(:,2) =(((  normcdf(vb1_2_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_2_2 - X2*bX2)-normcdf(vb1_2_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_2_2 - X2*bX2)-normcdf(vb2_2_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_2_2 - X2*bX2)-normcdf(vb3_2_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_2_2 - X2*bX2)-normcdf(vb4_2_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_2_2 - X2*bX2)-normcdf(vb5_2_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_2_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_2_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_2_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_2_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_2_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_2_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_2(:,3) =(((  normcdf(vb1_2_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_2_3 - X2*bX2)-normcdf(vb1_2_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_2_3 - X2*bX2)-normcdf(vb2_2_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_2_3 - X2*bX2)-normcdf(vb3_2_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_2_3 - X2*bX2)-normcdf(vb4_2_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_2_3 - X2*bX2)-normcdf(vb5_2_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_2_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_2_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_2_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_2_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_2_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_2_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_3=ones(n,3);
lf2_3(:,1) =(((  normcdf(vb1_3_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_3_1 - X2*bX2)-normcdf(vb1_3_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_3_1 - X2*bX2)-normcdf(vb2_3_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_3_1 - X2*bX2)-normcdf(vb3_3_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_3_1 - X2*bX2)-normcdf(vb4_3_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_3_1 - X2*bX2)-normcdf(vb5_3_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_3_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_3_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_3_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_3_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_3_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_3_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_3(:,2) =(((  normcdf(vb1_3_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_3_2 - X2*bX2)-normcdf(vb1_3_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_3_2 - X2*bX2)-normcdf(vb2_3_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_3_2 - X2*bX2)-normcdf(vb3_3_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_3_2 - X2*bX2)-normcdf(vb4_3_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_3_2 - X2*bX2)-normcdf(vb5_3_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_3_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_3_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_3_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_3_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_3_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_3_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_3(:,3) =(((  normcdf(vb1_3_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_3_3 - X2*bX2)-normcdf(vb1_3_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_3_3 - X2*bX2)-normcdf(vb2_3_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_3_3 - X2*bX2)-normcdf(vb3_3_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_3_3 - X2*bX2)-normcdf(vb4_3_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_3_3 - X2*bX2)-normcdf(vb5_3_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_3_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_3_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_3_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_3_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_3_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_3_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_4=ones(n,3);
lf2_4(:,1) =(((  normcdf(vb1_4_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_4_1 - X2*bX2)-normcdf(vb1_4_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_4_1 - X2*bX2)-normcdf(vb2_4_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_4_1 - X2*bX2)-normcdf(vb3_4_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_4_1 - X2*bX2)-normcdf(vb4_4_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_4_1 - X2*bX2)-normcdf(vb5_4_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_4_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_4_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_4_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_4_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_4_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_4_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_4(:,2) =(((  normcdf(vb1_4_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_4_2 - X2*bX2)-normcdf(vb1_4_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_4_2 - X2*bX2)-normcdf(vb2_4_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_4_2 - X2*bX2)-normcdf(vb3_4_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_4_2 - X2*bX2)-normcdf(vb4_4_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_4_2 - X2*bX2)-normcdf(vb5_4_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_4_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_4_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_4_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_4_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_4_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_4_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_4(:,3) =(((  normcdf(vb1_4_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_4_3 - X2*bX2)-normcdf(vb1_4_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_4_3 - X2*bX2)-normcdf(vb2_4_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_4_3 - X2*bX2)-normcdf(vb3_4_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_4_3 - X2*bX2)-normcdf(vb4_4_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_4_3 - X2*bX2)-normcdf(vb5_4_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_4_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_4_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_4_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_4_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_4_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_4_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_5=ones(n,3);
lf2_5(:,1) =(((  normcdf(vb1_5_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_5_1 - X2*bX2)-normcdf(vb1_5_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_5_1 - X2*bX2)-normcdf(vb2_5_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_5_1 - X2*bX2)-normcdf(vb3_5_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_5_1 - X2*bX2)-normcdf(vb4_5_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_5_1 - X2*bX2)-normcdf(vb5_5_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_5_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_5_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_5_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_5_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_5_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_5_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_5(:,2) =(((  normcdf(vb1_5_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_5_2 - X2*bX2)-normcdf(vb1_5_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_5_2 - X2*bX2)-normcdf(vb2_5_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_5_2 - X2*bX2)-normcdf(vb3_5_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_5_2 - X2*bX2)-normcdf(vb4_5_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_5_2 - X2*bX2)-normcdf(vb5_5_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_5_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_5_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_5_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_5_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_5_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_5_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_5(:,3) =(((  normcdf(vb1_5_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_5_3 - X2*bX2)-normcdf(vb1_5_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_5_3 - X2*bX2)-normcdf(vb2_5_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_5_3 - X2*bX2)-normcdf(vb3_5_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_5_3 - X2*bX2)-normcdf(vb4_5_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_5_3 - X2*bX2)-normcdf(vb5_5_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_5_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_5_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_5_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_5_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_5_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_5_3 - X2*bX2)).^dur2_6).^cens2)).^sam2; 

lf2_6=ones(n,3);               
lf2_6(:,1) =(((  normcdf(vb1_6_1 - X2*bX2).^dur2_1...   
             .* (normcdf(vb2_6_1 - X2*bX2)-normcdf(vb1_6_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_6_1 - X2*bX2)-normcdf(vb2_6_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_6_1 - X2*bX2)-normcdf(vb3_6_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_6_1 - X2*bX2)-normcdf(vb4_6_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_6_1 - X2*bX2)-normcdf(vb5_6_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_6_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_6_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_6_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_6_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_6_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_6_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_6(:,2) =(((  normcdf(vb1_6_2 - X2*bX2).^dur2_1...   
             .* (normcdf(vb2_6_2 - X2*bX2)-normcdf(vb1_6_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_6_2 - X2*bX2)-normcdf(vb2_6_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_6_2 - X2*bX2)-normcdf(vb3_6_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_6_2 - X2*bX2)-normcdf(vb4_6_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_6_2 - X2*bX2)-normcdf(vb5_6_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_6_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_6_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_6_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_6_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_6_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_6_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_6(:,3) =(((  normcdf(vb1_6_3 - X2*bX2).^dur2_1...   
             .* (normcdf(vb2_6_3 - X2*bX2)-normcdf(vb1_6_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_6_3 - X2*bX2)-normcdf(vb2_6_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_6_3 - X2*bX2)-normcdf(vb3_6_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_6_3 - X2*bX2)-normcdf(vb4_6_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_6_3 - X2*bX2)-normcdf(vb5_6_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_6_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_6_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_6_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_6_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_6_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_6_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_7=ones(n,3);
lf2_7(:,1) =(((  normcdf(vb1_7_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_7_1 - X2*bX2)-normcdf(vb1_7_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_7_1 - X2*bX2)-normcdf(vb2_7_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_7_1 - X2*bX2)-normcdf(vb3_7_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_7_1 - X2*bX2)-normcdf(vb4_7_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_7_1 - X2*bX2)-normcdf(vb5_7_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_7_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_7_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_7_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_7_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_7_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_7_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_7(:,2) =(((  normcdf(vb1_7_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_7_2 - X2*bX2)-normcdf(vb1_7_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_7_2 - X2*bX2)-normcdf(vb2_7_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_7_2 - X2*bX2)-normcdf(vb3_7_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_7_2 - X2*bX2)-normcdf(vb4_7_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_7_2 - X2*bX2)-normcdf(vb5_7_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_7_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_7_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_7_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_7_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_7_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_7_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_7(:,3) =(((  normcdf(vb1_7_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_7_3 - X2*bX2)-normcdf(vb1_7_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_7_3 - X2*bX2)-normcdf(vb2_7_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_7_3 - X2*bX2)-normcdf(vb3_7_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_7_3 - X2*bX2)-normcdf(vb4_7_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_7_3 - X2*bX2)-normcdf(vb5_7_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_7_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_7_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_7_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_7_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_7_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_7_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_8=ones(n,3);
lf2_8(:,1) =(((  normcdf(vb1_8_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_8_1 - X2*bX2)-normcdf(vb1_8_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_8_1 - X2*bX2)-normcdf(vb2_8_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_8_1 - X2*bX2)-normcdf(vb3_8_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_8_1 - X2*bX2)-normcdf(vb4_8_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_8_1 - X2*bX2)-normcdf(vb5_8_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_8_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_8_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_8_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_8_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_8_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_8_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_8(:,2) =(((  normcdf(vb1_8_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_8_2 - X2*bX2)-normcdf(vb1_8_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_8_2 - X2*bX2)-normcdf(vb2_8_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_8_2 - X2*bX2)-normcdf(vb3_8_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_8_2 - X2*bX2)-normcdf(vb4_8_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_8_2 - X2*bX2)-normcdf(vb5_8_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_8_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_8_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_8_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_8_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_8_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_8_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_8(:,3) =(((  normcdf(vb1_8_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_8_3 - X2*bX2)-normcdf(vb1_8_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_8_3 - X2*bX2)-normcdf(vb2_8_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_8_3 - X2*bX2)-normcdf(vb3_8_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_8_3 - X2*bX2)-normcdf(vb4_8_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_8_3 - X2*bX2)-normcdf(vb5_8_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_8_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_8_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_8_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_8_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_8_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_8_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_9=ones(n,3);
lf2_9(:,1) =(((  normcdf(vb1_9_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_9_1 - X2*bX2)-normcdf(vb1_9_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_9_1 - X2*bX2)-normcdf(vb2_9_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_9_1 - X2*bX2)-normcdf(vb3_9_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_9_1 - X2*bX2)-normcdf(vb4_9_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_9_1 - X2*bX2)-normcdf(vb5_9_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_9_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_9_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_9_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_9_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_9_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_9_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_9(:,2) =(((  normcdf(vb1_9_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_9_2 - X2*bX2)-normcdf(vb1_9_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_9_2 - X2*bX2)-normcdf(vb2_9_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_9_2 - X2*bX2)-normcdf(vb3_9_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_9_2 - X2*bX2)-normcdf(vb4_9_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_9_2 - X2*bX2)-normcdf(vb5_9_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_9_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_9_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_9_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_9_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_9_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_9_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_9(:,3) =(((  normcdf(vb1_9_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_9_3 - X2*bX2)-normcdf(vb1_9_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_9_3 - X2*bX2)-normcdf(vb2_9_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_9_3 - X2*bX2)-normcdf(vb3_9_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_9_3 - X2*bX2)-normcdf(vb4_9_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_9_3 - X2*bX2)-normcdf(vb5_9_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_9_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_9_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_9_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_9_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_9_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_9_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_10=ones(n,3);
lf2_10(:,1) =(((  normcdf(vb1_10_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_10_1 - X2*bX2)-normcdf(vb1_10_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_10_1 - X2*bX2)-normcdf(vb2_10_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_10_1 - X2*bX2)-normcdf(vb3_10_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_10_1 - X2*bX2)-normcdf(vb4_10_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_10_1 - X2*bX2)-normcdf(vb5_10_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_10_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_10_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_10_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_10_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_10_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_10_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_10(:,2) =(((  normcdf(vb1_10_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_10_2 - X2*bX2)-normcdf(vb1_10_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_10_2 - X2*bX2)-normcdf(vb2_10_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_10_2 - X2*bX2)-normcdf(vb3_10_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_10_2 - X2*bX2)-normcdf(vb4_10_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_10_2 - X2*bX2)-normcdf(vb5_10_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_10_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_10_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_10_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_10_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_10_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_10_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_10(:,3) =(((  normcdf(vb1_10_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_10_3 - X2*bX2)-normcdf(vb1_10_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_10_3 - X2*bX2)-normcdf(vb2_10_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_10_3 - X2*bX2)-normcdf(vb3_10_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_10_3 - X2*bX2)-normcdf(vb4_10_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_10_3 - X2*bX2)-normcdf(vb5_10_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_10_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_10_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_10_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_10_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_10_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_10_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_11=ones(n,3);
lf2_11(:,1) =(((  normcdf(vb1_11_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_11_1 - X2*bX2)-normcdf(vb1_11_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_11_1 - X2*bX2)-normcdf(vb2_11_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_11_1 - X2*bX2)-normcdf(vb3_11_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_11_1 - X2*bX2)-normcdf(vb4_11_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_11_1 - X2*bX2)-normcdf(vb5_11_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_11_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_11_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_11_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_11_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_11_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_11_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_11(:,2) =(((  normcdf(vb1_11_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_11_2 - X2*bX2)-normcdf(vb1_11_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_11_2 - X2*bX2)-normcdf(vb2_11_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_11_2 - X2*bX2)-normcdf(vb3_11_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_11_2 - X2*bX2)-normcdf(vb4_11_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_11_2 - X2*bX2)-normcdf(vb5_11_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_11_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_11_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_11_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_11_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_11_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_11_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_11(:,3) =(((  normcdf(vb1_11_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_11_3 - X2*bX2)-normcdf(vb1_11_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_11_3 - X2*bX2)-normcdf(vb2_11_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_11_3 - X2*bX2)-normcdf(vb3_11_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_11_3 - X2*bX2)-normcdf(vb4_11_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_11_3 - X2*bX2)-normcdf(vb5_11_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_11_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_11_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_11_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_11_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_11_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_11_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_12=ones(n,3);
lf2_12(:,1) =(((  normcdf(vb1_12_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_12_1 - X2*bX2)-normcdf(vb1_12_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_12_1 - X2*bX2)-normcdf(vb2_12_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_12_1 - X2*bX2)-normcdf(vb3_12_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_12_1 - X2*bX2)-normcdf(vb4_12_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_12_1 - X2*bX2)-normcdf(vb5_12_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_12_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_12_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_12_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_12_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_12_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_12_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_12(:,2) =(((  normcdf(vb1_12_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_12_2 - X2*bX2)-normcdf(vb1_12_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_12_2 - X2*bX2)-normcdf(vb2_12_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_12_2 - X2*bX2)-normcdf(vb3_12_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_12_2 - X2*bX2)-normcdf(vb4_12_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_12_2 - X2*bX2)-normcdf(vb5_12_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_12_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_12_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_12_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_12_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_12_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_12_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_12(:,3) =(((  normcdf(vb1_12_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_12_3 - X2*bX2)-normcdf(vb1_12_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_12_3 - X2*bX2)-normcdf(vb2_12_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_12_3 - X2*bX2)-normcdf(vb3_12_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_12_3 - X2*bX2)-normcdf(vb4_12_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_12_3 - X2*bX2)-normcdf(vb5_12_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_12_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_12_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_12_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_12_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_12_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_12_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_13=ones(n,3);
lf2_13(:,1) =(((  normcdf(vb1_13_1 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_13_1 - X2*bX2)-normcdf(vb1_13_1 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_13_1 - X2*bX2)-normcdf(vb2_13_1 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_13_1 - X2*bX2)-normcdf(vb3_13_1 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_13_1 - X2*bX2)-normcdf(vb4_13_1 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_13_1 - X2*bX2)-normcdf(vb5_13_1 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_13_1 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_13_1 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_13_1 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_13_1 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_13_1 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_13_1 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_13(:,2) =(((  normcdf(vb1_13_2 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_13_2 - X2*bX2)-normcdf(vb1_13_2 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_13_2 - X2*bX2)-normcdf(vb2_13_2 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_13_2 - X2*bX2)-normcdf(vb3_13_2 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_13_2 - X2*bX2)-normcdf(vb4_13_2 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_13_2 - X2*bX2)-normcdf(vb5_13_2 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_13_2 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_13_2 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_13_2 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_13_2 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_13_2 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_13_2 - X2*bX2)).^dur2_6).^cens2)).^sam2;

lf2_13(:,3) =(((  normcdf(vb1_13_3 - X2*bX2).^dur2_1...
             .* (normcdf(vb2_13_3 - X2*bX2)-normcdf(vb1_13_3 - X2*bX2)).^dur2_2...
             .* (normcdf(vb3_13_3 - X2*bX2)-normcdf(vb2_13_3 - X2*bX2)).^dur2_3...
             .* (normcdf(vb4_13_3 - X2*bX2)-normcdf(vb3_13_3 - X2*bX2)).^dur2_4...
             .* (normcdf(vb5_13_3 - X2*bX2)-normcdf(vb4_13_3 - X2*bX2)).^dur2_5...
             .* (normcdf(vb6_13_3 - X2*bX2)-normcdf(vb5_13_3 - X2*bX2)).^dur2_6).^(1-cens2)).*...
             ((( 1-normcdf(vb1_13_3 - X2*bX2)).^dur2_1...
             .* (1-normcdf(vb2_13_3 - X2*bX2)).^dur2_2...
             .* (1-normcdf(vb3_13_3 - X2*bX2)).^dur2_3...
             .* (1-normcdf(vb4_13_3 - X2*bX2)).^dur2_4...
             .* (1-normcdf(vb5_13_3 - X2*bX2)).^dur2_5...
             .* (1-normcdf(vb6_13_3 - X2*bX2)).^dur2_6).^cens2)).^sam2;



%--------------------------------------------------------------------------
%2.3 Contribution to the likelihood function of 3rd childbirth
%--------------------------------------------------------------------------
lf3_1=ones(n,3);
lf3_1(:,1) = ((( normcdf(vc1_1_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_1_1 - X3*bX3)-normcdf(vc1_1_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_1_1 - X3*bX3)-normcdf(vc2_1_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_1_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_1_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_1_1 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_1(:,2) = ((( normcdf(vc1_1_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_1_2 - X3*bX3)-normcdf(vc1_1_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_1_2 - X3*bX3)-normcdf(vc2_1_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_1_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_1_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_1_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_1(:,3) = ((( normcdf(vc1_1_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_1_3 - X3*bX3)-normcdf(vc1_1_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_1_3 - X3*bX3)-normcdf(vc2_1_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_1_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_1_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_1_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_2=ones(n,3);
lf3_2(:,1) = ((( normcdf(vc1_2_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_2_1 - X3*bX3)-normcdf(vc1_2_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_2_1 - X3*bX3)-normcdf(vc2_2_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_2_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_2_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_2_1 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_2(:,2) = ((( normcdf(vc1_2_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_2_2 - X3*bX3)-normcdf(vc1_2_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_2_2 - X3*bX3)-normcdf(vc2_2_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_2_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_2_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_2_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_2(:,3) = ((( normcdf(vc1_2_3- X3*bX3).^dur3_1...
              .*(normcdf(vc2_2_3- X3*bX3)-normcdf(vc1_2_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_2_3- X3*bX3)-normcdf(vc2_2_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_2_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_2_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_2_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_3=ones(n,3);
lf3_3(:,1) = ((( normcdf(vc1_3_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_3_1 - X3*bX3)-normcdf(vc1_3_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_3_1 - X3*bX3)-normcdf(vc2_3_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_3_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_3_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_3_1 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_3(:,2) = ((( normcdf(vc1_3_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_3_2 - X3*bX3)-normcdf(vc1_3_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_3_2 - X3*bX3)-normcdf(vc2_3_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_3_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_3_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_3_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;      

lf3_3(:,3) = ((( normcdf(vc1_3_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_3_3 - X3*bX3)-normcdf(vc1_3_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_3_3 - X3*bX3)-normcdf(vc2_3_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_3_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_3_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_3_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;      

lf3_4=ones(n,3);
lf3_4(:,1) = ((( normcdf(vc1_4_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_4_1 - X3*bX3)-normcdf(vc1_4_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_4_1 - X3*bX3)-normcdf(vc2_4_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_4_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_4_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_4_1 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_4(:,2) = ((( normcdf(vc1_4_2- X3*bX3).^dur3_1...
              .*(normcdf(vc2_4_2- X3*bX3)-normcdf(vc1_4_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_4_2- X3*bX3)-normcdf(vc2_4_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_4_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_4_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_4_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_4(:,3) = ((( normcdf(vc1_4_3- X3*bX3).^dur3_1...
              .*(normcdf(vc2_4_3- X3*bX3)-normcdf(vc1_4_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_4_3- X3*bX3)-normcdf(vc2_4_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_4_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_4_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_4_3 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_5=ones(n,3);
lf3_5(:,1) = ((( normcdf(vc1_5_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_5_1 - X3*bX3)-normcdf(vc1_5_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_5_1 - X3*bX3)-normcdf(vc2_5_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_5_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_5_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_5_1 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_5(:,2) = ((( normcdf(vc1_5_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_5_2 - X3*bX3)-normcdf(vc1_5_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_5_2 - X3*bX3)-normcdf(vc2_5_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_5_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_5_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_5_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_5(:,3) = ((( normcdf(vc1_5_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_5_3 - X3*bX3)-normcdf(vc1_5_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_5_3 - X3*bX3)-normcdf(vc2_5_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_5_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_5_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_5_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;
       
lf3_6=ones(n,3);
lf3_6(:,1) = ((( normcdf(vc1_6_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_6_1 - X3*bX3)-normcdf(vc1_6_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_6_1 - X3*bX3)-normcdf(vc2_6_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_6_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_6_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_6_1 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_6(:,2) = ((( normcdf(vc1_6_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_6_2 - X3*bX3)-normcdf(vc1_6_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_6_2 - X3*bX3)-normcdf(vc2_6_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_6_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_6_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_6_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_6(:,3) = ((( normcdf(vc1_6_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_6_3 - X3*bX3)-normcdf(vc1_6_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_6_3 - X3*bX3)-normcdf(vc2_6_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_6_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_6_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_6_3 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_7=ones(n,3);
lf3_7(:,1) = ((( normcdf(vc1_7_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_7_1 - X3*bX3)-normcdf(vc1_7_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_7_1 - X3*bX3)-normcdf(vc2_7_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_7_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_7_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_7_1 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_7(:,2) = ((( normcdf(vc1_7_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_7_2 - X3*bX3)-normcdf(vc1_7_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_7_2 - X3*bX3)-normcdf(vc2_7_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_7_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_7_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_7_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_7(:,3) = ((( normcdf(vc1_7_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_7_3 - X3*bX3)-normcdf(vc1_7_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_7_3 - X3*bX3)-normcdf(vc2_7_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_7_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_7_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_7_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_8=ones(n,3);
lf3_8(:,1) = ((( normcdf(vc1_8_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_8_1 - X3*bX3)-normcdf(vc1_8_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_8_1 - X3*bX3)-normcdf(vc2_8_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_8_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_8_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_8_1 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_8(:,2) = ((( normcdf(vc1_8_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_8_2 - X3*bX3)-normcdf(vc1_8_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_8_2 - X3*bX3)-normcdf(vc2_8_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_8_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_8_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_8_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_8(:,3) = ((( normcdf(vc1_8_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_8_3 - X3*bX3)-normcdf(vc1_8_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_8_3 - X3*bX3)-normcdf(vc2_8_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_8_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_8_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_8_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_9=ones(n,3);
lf3_9(:,1) = ((( normcdf(vc1_9_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_9_1 - X3*bX3)-normcdf(vc1_9_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_9_1 - X3*bX3)-normcdf(vc2_9_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_9_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_9_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_9_1 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_9(:,2) = ((( normcdf(vc1_9_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_9_2 - X3*bX3)-normcdf(vc1_9_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_9_2 - X3*bX3)-normcdf(vc2_9_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_9_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_9_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_9_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_9(:,3) = ((( normcdf(vc1_9_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_9_3 - X3*bX3)-normcdf(vc1_9_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_9_3 - X3*bX3)-normcdf(vc2_9_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_9_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_9_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_9_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_10=ones(n,3);
lf3_10(:,1) = ((( normcdf(vc1_10_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_10_1 - X3*bX3)-normcdf(vc1_10_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_10_1 - X3*bX3)-normcdf(vc2_10_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_10_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_10_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_10_1 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_10(:,2) = ((( normcdf(vc1_10_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_10_2 - X3*bX3)-normcdf(vc1_10_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_10_2 - X3*bX3)-normcdf(vc2_10_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_10_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_10_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_10_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_10(:,3) = ((( normcdf(vc1_10_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_10_3 - X3*bX3)-normcdf(vc1_10_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_10_3 - X3*bX3)-normcdf(vc2_10_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_10_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_10_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_10_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_11=ones(n,3);
lf3_11(:,1) = ((( normcdf(vc1_11_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_11_1 - X3*bX3)-normcdf(vc1_11_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_11_1 - X3*bX3)-normcdf(vc2_11_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_11_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_11_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_11_1 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_11(:,2) = ((( normcdf(vc1_11_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_11_2 - X3*bX3)-normcdf(vc1_11_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_11_2 - X3*bX3)-normcdf(vc2_11_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_11_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_11_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_11_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_11(:,3) = ((( normcdf(vc1_11_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_11_3 - X3*bX3)-normcdf(vc1_11_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_11_3 - X3*bX3)-normcdf(vc2_11_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_11_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_11_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_11_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_12=ones(n,3);
lf3_12(:,1) = ((( normcdf(vc1_12_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_12_1 - X3*bX3)-normcdf(vc1_12_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_12_1 - X3*bX3)-normcdf(vc2_12_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_12_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_12_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_12_1 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_12(:,2) = ((( normcdf(vc1_12_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_12_2 - X3*bX3)-normcdf(vc1_12_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_12_2 - X3*bX3)-normcdf(vc2_12_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_12_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_12_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_12_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_12(:,3) = ((( normcdf(vc1_12_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_12_3 - X3*bX3)-normcdf(vc1_12_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_12_3 - X3*bX3)-normcdf(vc2_12_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_12_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_12_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_12_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_13=ones(n,3);
lf3_13(:,1) = ((( normcdf(vc1_13_1 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_13_1 - X3*bX3)-normcdf(vc1_13_1 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_13_1 - X3*bX3)-normcdf(vc2_13_1 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_13_1 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_13_1 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_13_1 - X3*bX3)).^dur3_3).^cens3)).^sam3; 

lf3_13(:,2) = ((( normcdf(vc1_13_2 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_13_2 - X3*bX3)-normcdf(vc1_13_2 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_13_2 - X3*bX3)-normcdf(vc2_13_2 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_13_2 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_13_2 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_13_2 - X3*bX3)).^dur3_3).^cens3)).^sam3;

lf3_13(:,3) = ((( normcdf(vc1_13_3 - X3*bX3).^dur3_1...
              .*(normcdf(vc2_13_3 - X3*bX3)-normcdf(vc1_13_3 - X3*bX3)).^dur3_2...
              .*(normcdf(vc3_13_3 - X3*bX3)-normcdf(vc2_13_3 - X3*bX3)).^dur3_3).^(1-cens3)) .*...
             (( (1-normcdf(vc1_13_3 - X3*bX3)).^dur3_1...
             .* (1-normcdf(vc2_13_3 - X3*bX3)).^dur3_2...
             .* (1-normcdf(vc3_13_3 - X3*bX3)).^dur3_3).^cens3)).^sam3;

%--------------------------------------------------------------------------
%2.4 Contribution to the likelihood function of earnings 3 years after diploma
%--------------------------------------------------------------------------
lw3_1=ones(n,3);
lw3_1(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_1_1).^2)./(2.*exp(sig3)));
lw3_1(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_1_2).^2)./(2.*exp(sig3)));
lw3_1(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_1_3).^2)./(2.*exp(sig3)));
lw3_2=ones(n,3);
lw3_2(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_2_1).^2)./(2.*exp(sig3)));
lw3_2(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_2_2).^2)./(2.*exp(sig3)));
lw3_2(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_2_3).^2)./(2.*exp(sig3)));
lw3_3=ones(n,3);
lw3_3(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_3_1).^2)./(2.*exp(sig3)));
lw3_3(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_3_2).^2)./(2.*exp(sig3)));
lw3_3(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_3_3).^2)./(2.*exp(sig3)));
lw3_4=ones(n,3);
lw3_4(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_4_1).^2)./(2.*exp(sig3)));
lw3_4(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_4_2).^2)./(2.*exp(sig3)));
lw3_4(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_4_3).^2)./(2.*exp(sig3)));
lw3_5=ones(n,3);
lw3_5(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_5_1).^2)./(2.*exp(sig3)));
lw3_5(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_5_2).^2)./(2.*exp(sig3)));
lw3_5(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_5_3).^2)./(2.*exp(sig3)));
lw3_6=ones(n,3);
lw3_6(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_6_1).^2)./(2.*exp(sig3)));
lw3_6(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_6_2).^2)./(2.*exp(sig3)));
lw3_6(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_6_3).^2)./(2.*exp(sig3)));
lw3_7=ones(n,3);
lw3_7(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_7_1).^2)./(2.*exp(sig3)));
lw3_7(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_7_2).^2)./(2.*exp(sig3)));
lw3_7(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_7_3).^2)./(2.*exp(sig3)));
lw3_8=ones(n,3);
lw3_8(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_8_1).^2)./(2.*exp(sig3)));
lw3_8(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_8_2).^2)./(2.*exp(sig3)));
lw3_8(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_8_3).^2)./(2.*exp(sig3)));
lw3_9=ones(n,3);
lw3_9(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_9_1).^2)./(2.*exp(sig3)));
lw3_9(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_9_2).^2)./(2.*exp(sig3)));
lw3_9(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_9_3).^2)./(2.*exp(sig3)));
lw3_10=ones(n,3);
lw3_10(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_10_1).^2)./(2.*exp(sig3)));
lw3_10(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_10_2).^2)./(2.*exp(sig3)));
lw3_10(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_10_3).^2)./(2.*exp(sig3)));
lw3_11=ones(n,3);
lw3_11(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_11_1).^2)./(2.*exp(sig3)));
lw3_11(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_11_2).^2)./(2.*exp(sig3)));
lw3_11(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_11_3).^2)./(2.*exp(sig3)));
lw3_12=ones(n,3);
lw3_12(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_12_1).^2)./(2.*exp(sig3)));
lw3_12(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_12_2).^2)./(2.*exp(sig3)));
lw3_12(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_12_3).^2)./(2.*exp(sig3)));
lw3_13=ones(n,3);
lw3_13(:,1) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_13_1).^2)./(2.*exp(sig3)));
lw3_13(:,2) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_13_2).^2)./(2.*exp(sig3)));
lw3_13(:,3) = (1./((2.*pi.*exp(sig3)).^0.5)).*exp(-((lab_ear3 - W3*bW3 - vw3_13_3).^2)./(2.*exp(sig3)));

%--------------------------------------------------------------------------
%2.5 Contribution to the likelihood function of earnings 6 years after diploma
%--------------------------------------------------------------------------
lw6_1=ones(n,3);
lw6_1(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_1_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_1(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_1_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_1(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_1_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_2=ones(n,3);
lw6_2(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_2_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_2(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_2_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_2(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_2_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_3=ones(n,3);
lw6_3(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_3_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_3(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_3_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_3(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_3_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_4=ones(n,3);
lw6_4(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_4_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_4(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_4_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_4(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_4_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_5=ones(n,3);
lw6_5(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_5_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_5(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_5_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_5(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_5_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_6=ones(n,3);
lw6_6(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_6_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_6(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_6_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_6(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_6_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_7=ones(n,3);
lw6_7(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_7_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_7(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_7_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_7(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_7_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_8=ones(n,3);
lw6_8(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_8_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_8(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_8_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_8(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_8_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_9=ones(n,3);
lw6_9(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_9_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_9(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_9_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_9(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_9_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_10=ones(n,3);
lw6_10(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_10_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_10(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_10_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_10(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_10_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_11=ones(n,3);
lw6_11(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_11_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_11(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_11_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_11(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_11_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_12=ones(n,3);
lw6_12(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_12_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_12(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_12_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_12(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_12_3).^2)./(2.*exp(sig6)))).^samw6;
lw6_13=ones(n,3);
lw6_13(:,1) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_13_1).^2)./(2.*exp(sig6)))).^samw6;
lw6_13(:,2) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_13_2).^2)./(2.*exp(sig6)))).^samw6;
lw6_13(:,3) = ((1./((2.*pi.*exp(sig6)).^0.5)).*exp(-((lab_ear6 - W6*bW6 - vw6_13_3).^2)./(2.*exp(sig6)))).^samw6;
%--------------------------------------------------------------------------
%2.6 Contribution to the likelihood function of earnings 9 years after diploma
%--------------------------------------------------------------------------
lw9_1=ones(n,3);
lw9_1(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_1_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_1(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_1_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_1(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_1_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_2=ones(n,3);
lw9_2(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_2_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_2(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_2_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_2(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_2_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_3=ones(n,3);
lw9_3(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_3_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_3(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_3_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_3(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_3_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_4=ones(n,3);
lw9_4(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_4_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_4(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_4_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_4(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_4_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_5=ones(n,3);
lw9_5(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_5_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_5(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_5_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_5(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_5_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_6=ones(n,3);
lw9_6(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_6_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_6(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_6_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_6(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_6_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_7=ones(n,3);
lw9_7(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_7_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_7(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_7_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_7(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_7_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_8=ones(n,3);
lw9_8(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_8_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_8(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_8_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_8(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_8_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_9=ones(n,3);
lw9_9(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_9_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_9(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_9_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_9(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_9_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_10=ones(n,3);
lw9_10(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_10_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_10(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_10_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_10(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_10_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_11=ones(n,3);
lw9_11(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_11_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_11(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_11_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_11(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_11_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_12=ones(n,3);
lw9_12(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_12_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_12(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_12_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_12(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_12_3).^2)./(2.*exp(sig9)))).^samw9;
lw9_13=ones(n,3);
lw9_13(:,1) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_13_1).^2)./(2.*exp(sig9)))).^samw9;
lw9_13(:,2) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_13_2).^2)./(2.*exp(sig9)))).^samw9;
lw9_13(:,3) = ((1./((2.*pi.*exp(sig9)).^0.5)).*exp(-((lab_ear9 - W9*bW9 - vw9_13_3).^2)./(2.*exp(sig9)))).^samw9;

%--------------------------------------------------------------------------
%2.7 Contribution to the likelihood function of earnings 12 years after diploma
%--------------------------------------------------------------------------
lw12_1=ones(n,3);
lw12_1(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_1_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_1(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_1_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_1(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_1_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_2=ones(n,3);
lw12_2(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_2_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_2(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_2_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_2(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_2_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_3=ones(n,3);
lw12_3(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_3_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_3(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_3_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_3(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_3_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_4=ones(n,3);
lw12_4(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_4_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_4(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_4_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_4(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_4_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_5=ones(n,3);
lw12_5(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_5_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_5(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_5_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_5(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_5_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_6=ones(n,3);
lw12_6(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_6_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_6(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_6_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_6(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_6_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_7=ones(n,3);
lw12_7(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_7_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_7(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_7_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_7(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_7_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_8=ones(n,3);
lw12_8(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_8_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_8(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_8_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_8(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_8_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_9=ones(n,3);
lw12_9(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_9_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_9(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_9_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_9(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_9_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_10=ones(n,3);
lw12_10(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_10_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_10(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_10_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_10(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_10_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_11=ones(n,3);
lw12_11(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_11_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_11(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_11_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_11(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_11_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_12=ones(n,3);
lw12_12(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_12_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_12(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_12_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_12(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_12_3).^2)./(2.*exp(sig12)))).^samw12;
lw12_13=ones(n,3);
lw12_13(:,1) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_13_1).^2)./(2.*exp(sig12)))).^samw12;
lw12_13(:,2) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_13_2).^2)./(2.*exp(sig12)))).^samw12;
lw12_13(:,3) = ((1./((2.*pi.*exp(sig12)).^0.5)).*exp(-((lab_ear12 - W12*bW12 - vw12_13_3).^2)./(2.*exp(sig12)))).^samw12;

%--------------------------------------------------------------------------
%2.8 Contribution to the likelihood function of earnings 15 years after diploma
%--------------------------------------------------------------------------
lw15_1=ones(n,3);
lw15_1(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_1_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_1(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_1_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_1(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_1_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_2=ones(n,3);
lw15_2(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_2_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_2(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_2_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_2(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_2_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_3=ones(n,3);
lw15_3(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_3_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_3(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_3_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_3(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_3_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_4=ones(n,3);
lw15_4(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_4_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_4(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_4_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_4(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_4_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_5=ones(n,3);
lw15_5(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_5_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_5(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_5_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_5(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_5_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_6=ones(n,3);
lw15_6(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_6_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_6(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_6_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_6(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_6_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_7=ones(n,3);
lw15_7(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_7_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_7(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_7_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_7(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_7_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_8=ones(n,3);
lw15_8(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_8_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_8(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_8_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_8(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_8_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_9=ones(n,3);
lw15_9(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_9_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_9(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_9_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_9(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_9_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_10=ones(n,3);
lw15_10(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_10_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_10(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_10_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_10(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_10_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_11=ones(n,3);
lw15_11(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_11_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_11(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_11_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_11(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_11_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_12=ones(n,3);
lw15_12(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_12_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_12(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_12_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_12(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_12_3).^2)./(2.*exp(sig15)))).^samw15;
lw15_13=ones(n,3);
lw15_13(:,1) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_13_1).^2)./(2.*exp(sig15)))).^samw15;
lw15_13(:,2) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_13_2).^2)./(2.*exp(sig15)))).^samw15;
lw15_13(:,3) = ((1./((2.*pi.*exp(sig15)).^0.5)).*exp(-((lab_ear15 - W15*bW15 - vw15_13_3).^2)./(2.*exp(sig15)))).^samw15;

%--------------------------------------------------------------------------
%2.9 Contribution to the likelihood function of earnings 18 years after diploma
%--------------------------------------------------------------------------
lw18_1=ones(n,3);                                                                   
lw18_1(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_1_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_1(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_1_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_1(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_1_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_2=ones(n,3);
lw18_2(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_2_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_2(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_2_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_2(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_2_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_3=ones(n,3);
lw18_3(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_3_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_3(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_3_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_3(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_3_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_4=ones(n,3);
lw18_4(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_4_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_4(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_4_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_4(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_4_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_5=ones(n,3);
lw18_5(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_5_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_5(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_5_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_5(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_5_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_6=ones(n,3);
lw18_6(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_6_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_6(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_6_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_6(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_6_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_7=ones(n,3);
lw18_7(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_7_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_7(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_7_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_7(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_7_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_8=ones(n,3);
lw18_8(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_8_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_8(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_8_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_8(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_8_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_9=ones(n,3);
lw18_9(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_9_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_9(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_9_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_9(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_9_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_10=ones(n,3);
lw18_10(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_10_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_10(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_10_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_10(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_10_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_11=ones(n,3);
lw18_11(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_11_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_11(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_11_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_11(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_11_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_12=ones(n,3);
lw18_12(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_12_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_12(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_12_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_12(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_12_3).^2)./(2.*exp(sig18)))).^samw18;
lw18_13=ones(n,3);
lw18_13(:,1) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_13_1).^2)./(2.*exp(sig18)))).^samw18;
lw18_13(:,2) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_13_2).^2)./(2.*exp(sig18)))).^samw18;
lw18_13(:,3) = ((1./((2.*pi.*exp(sig18)).^0.5)).*exp(-((lab_ear18 - W18*bW18 - vw18_13_3).^2)./(2.*exp(sig18)))).^samw18;

%--------------------------------------------------------------------------
%2.10 Contribution to the likelihood function of earnings 21 years after diploma
%--------------------------------------------------------------------------
lw21_1=ones(n,3);
lw21_1(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_1_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_1(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_1_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_1(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_1_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_2=ones(n,3);
lw21_2(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_2_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_2(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_2_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_2(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_2_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_3=ones(n,3);
lw21_3(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_3_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_3(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_3_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_3(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_3_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_4=ones(n,3);
lw21_4(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_4_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_4(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_4_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_4(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_4_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_5=ones(n,3);
lw21_5(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_5_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_5(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_5_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_5(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_5_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_6=ones(n,3);
lw21_6(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_6_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_6(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_6_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_6(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_6_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_7=ones(n,3);
lw21_7(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_7_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_7(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_7_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_7(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_7_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_8=ones(n,3);
lw21_8(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_8_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_8(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_8_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_8(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_8_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_9=ones(n,3);
lw21_9(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_9_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_9(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_9_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_9(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_9_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_10=ones(n,3);
lw21_10(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_10_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_10(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_10_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_10(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_10_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_11=ones(n,3);
lw21_11(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_11_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_11(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_11_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_11(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_11_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_12=ones(n,3);
lw21_12(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_12_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_12(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_12_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_12(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_12_3).^2)./(2.*exp(sig21)))).^samw21;
lw21_13=ones(n,3);
lw21_13(:,1) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_13_1).^2)./(2.*exp(sig21)))).^samw21;
lw21_13(:,2) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_13_2).^2)./(2.*exp(sig21)))).^samw21;
lw21_13(:,3) = ((1./((2.*pi.*exp(sig21)).^0.5)).*exp(-((lab_ear21 - W21*bW21 - vw21_13_3).^2)./(2.*exp(sig21)))).^samw21;

%--------------------------------------------------------------------------
%2.11 Contribution to the likelihood function of employment 1 year before diploma
%--------------------------------------------------------------------------
le_1=ones(n,3);
le_1(:,1) = (normcdf(Ze*bZe + vze_1_1).^emp_1).*((1-normcdf(Ze*bZe + vze_1_1)).^(1-emp_1));
le_1(:,2) = (normcdf(Ze*bZe + vze_1_2).^emp_1).*((1-normcdf(Ze*bZe + vze_1_2)).^(1-emp_1));
le_1(:,3) = (normcdf(Ze*bZe + vze_1_3).^emp_1).*((1-normcdf(Ze*bZe + vze_1_3)).^(1-emp_1));
le_2=ones(n,3);
le_2(:,1) = (normcdf(Ze*bZe + vze_2_1).^emp_1).*((1-normcdf(Ze*bZe + vze_2_1)).^(1-emp_1));
le_2(:,2) = (normcdf(Ze*bZe + vze_2_2).^emp_1).*((1-normcdf(Ze*bZe + vze_2_2)).^(1-emp_1));
le_2(:,3) = (normcdf(Ze*bZe + vze_2_3).^emp_1).*((1-normcdf(Ze*bZe + vze_2_3)).^(1-emp_1));
le_3=ones(n,3);
le_3(:,1) = (normcdf(Ze*bZe + vze_3_1).^emp_1).*((1-normcdf(Ze*bZe + vze_3_1)).^(1-emp_1));
le_3(:,2) = (normcdf(Ze*bZe + vze_3_2).^emp_1).*((1-normcdf(Ze*bZe + vze_3_2)).^(1-emp_1));
le_3(:,3) = (normcdf(Ze*bZe + vze_3_3).^emp_1).*((1-normcdf(Ze*bZe + vze_3_3)).^(1-emp_1));
le_4=ones(n,3);
le_4(:,1) = (normcdf(Ze*bZe + vze_4_1).^emp_1).*((1-normcdf(Ze*bZe + vze_4_1)).^(1-emp_1));
le_4(:,2) = (normcdf(Ze*bZe + vze_4_2).^emp_1).*((1-normcdf(Ze*bZe + vze_4_2)).^(1-emp_1));
le_4(:,3) = (normcdf(Ze*bZe + vze_4_3).^emp_1).*((1-normcdf(Ze*bZe + vze_4_3)).^(1-emp_1));
le_5=ones(n,3);
le_5(:,1) = (normcdf(Ze*bZe + vze_5_1).^emp_1).*((1-normcdf(Ze*bZe + vze_5_1)).^(1-emp_1));
le_5(:,2) = (normcdf(Ze*bZe + vze_5_2).^emp_1).*((1-normcdf(Ze*bZe + vze_5_2)).^(1-emp_1));
le_5(:,3) = (normcdf(Ze*bZe + vze_5_3).^emp_1).*((1-normcdf(Ze*bZe + vze_5_3)).^(1-emp_1));
le_6=ones(n,3);
le_6(:,1) = (normcdf(Ze*bZe + vze_6_1).^emp_1).*((1-normcdf(Ze*bZe + vze_6_1)).^(1-emp_1));
le_6(:,2) = (normcdf(Ze*bZe + vze_6_2).^emp_1).*((1-normcdf(Ze*bZe + vze_6_2)).^(1-emp_1));
le_6(:,3) = (normcdf(Ze*bZe + vze_6_3).^emp_1).*((1-normcdf(Ze*bZe + vze_6_3)).^(1-emp_1));
le_7=ones(n,3);
le_7(:,1) = (normcdf(Ze*bZe + vze_7_1).^emp_1).*((1-normcdf(Ze*bZe + vze_7_1)).^(1-emp_1));
le_7(:,2) = (normcdf(Ze*bZe + vze_7_2).^emp_1).*((1-normcdf(Ze*bZe + vze_7_2)).^(1-emp_1));
le_7(:,3) = (normcdf(Ze*bZe + vze_7_3).^emp_1).*((1-normcdf(Ze*bZe + vze_7_3)).^(1-emp_1));
le_8=ones(n,3);
le_8(:,1) = (normcdf(Ze*bZe + vze_8_1).^emp_1).*((1-normcdf(Ze*bZe + vze_8_1)).^(1-emp_1));
le_8(:,2) = (normcdf(Ze*bZe + vze_8_2).^emp_1).*((1-normcdf(Ze*bZe + vze_8_2)).^(1-emp_1));
le_8(:,3) = (normcdf(Ze*bZe + vze_8_3).^emp_1).*((1-normcdf(Ze*bZe + vze_8_3)).^(1-emp_1));
le_9=ones(n,3);
le_9(:,1) = (normcdf(Ze*bZe + vze_9_1).^emp_1).*((1-normcdf(Ze*bZe + vze_9_1)).^(1-emp_1));
le_9(:,2) = (normcdf(Ze*bZe + vze_9_2).^emp_1).*((1-normcdf(Ze*bZe + vze_9_2)).^(1-emp_1));
le_9(:,3) = (normcdf(Ze*bZe + vze_9_3).^emp_1).*((1-normcdf(Ze*bZe + vze_9_3)).^(1-emp_1));
le_10=ones(n,3);
le_10(:,1) = (normcdf(Ze*bZe + vze_10_1).^emp_1).*((1-normcdf(Ze*bZe + vze_10_1)).^(1-emp_1));
le_10(:,2) = (normcdf(Ze*bZe + vze_10_2).^emp_1).*((1-normcdf(Ze*bZe + vze_10_2)).^(1-emp_1));
le_10(:,3) = (normcdf(Ze*bZe + vze_10_3).^emp_1).*((1-normcdf(Ze*bZe + vze_10_3)).^(1-emp_1));
le_11=ones(n,3);
le_11(:,1) = (normcdf(Ze*bZe + vze_11_1).^emp_1).*((1-normcdf(Ze*bZe + vze_11_1)).^(1-emp_1));
le_11(:,2) = (normcdf(Ze*bZe + vze_11_2).^emp_1).*((1-normcdf(Ze*bZe + vze_11_2)).^(1-emp_1));
le_11(:,3) = (normcdf(Ze*bZe + vze_11_3).^emp_1).*((1-normcdf(Ze*bZe + vze_11_3)).^(1-emp_1));
le_12=ones(n,3);
le_12(:,1) = (normcdf(Ze*bZe + vze_12_1).^emp_1).*((1-normcdf(Ze*bZe + vze_12_1)).^(1-emp_1));
le_12(:,2) = (normcdf(Ze*bZe + vze_12_2).^emp_1).*((1-normcdf(Ze*bZe + vze_12_2)).^(1-emp_1));
le_12(:,3) = (normcdf(Ze*bZe + vze_12_3).^emp_1).*((1-normcdf(Ze*bZe + vze_12_3)).^(1-emp_1));
le_13=ones(n,3);
le_13(:,1) = (normcdf(Ze*bZe + vze_13_1).^emp_1).*((1-normcdf(Ze*bZe + vze_13_1)).^(1-emp_1));
le_13(:,2) = (normcdf(Ze*bZe + vze_13_2).^emp_1).*((1-normcdf(Ze*bZe + vze_13_2)).^(1-emp_1));
le_13(:,3) = (normcdf(Ze*bZe + vze_13_3).^emp_1).*((1-normcdf(Ze*bZe + vze_13_3)).^(1-emp_1));

%--------------------------------------------------------------------------
%2.12 Contribution to the likelihood function of number of siblings at 14
%--------------------------------------------------------------------------
ls_1=ones(n,3);
ls_1(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_1_1).^2)./(2.*exp(sig_zs)));
ls_1(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_1_2).^2)./(2.*exp(sig_zs)));
ls_1(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_1_3).^2)./(2.*exp(sig_zs)));
ls_2=ones(n,3);
ls_2(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_2_1).^2)./(2.*exp(sig_zs)));
ls_2(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_2_2).^2)./(2.*exp(sig_zs)));
ls_2(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_2_3).^2)./(2.*exp(sig_zs)));
ls_3=ones(n,3);
ls_3(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_3_1).^2)./(2.*exp(sig_zs)));
ls_3(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_3_2).^2)./(2.*exp(sig_zs)));
ls_3(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_3_3).^2)./(2.*exp(sig_zs)));
ls_4=ones(n,3);
ls_4(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_4_1).^2)./(2.*exp(sig_zs)));
ls_4(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_4_2).^2)./(2.*exp(sig_zs)));
ls_4(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_4_3).^2)./(2.*exp(sig_zs)));
ls_5=ones(n,3);
ls_5(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_5_1).^2)./(2.*exp(sig_zs)));
ls_5(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_5_2).^2)./(2.*exp(sig_zs)));
ls_5(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_5_3).^2)./(2.*exp(sig_zs)));
ls_6=ones(n,3);
ls_6(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_6_1).^2)./(2.*exp(sig_zs)));
ls_6(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_6_2).^2)./(2.*exp(sig_zs)));
ls_6(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_6_3).^2)./(2.*exp(sig_zs)));
ls_7=ones(n,3);
ls_7(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_7_1).^2)./(2.*exp(sig_zs)));
ls_7(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_7_2).^2)./(2.*exp(sig_zs)));
ls_7(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_7_3).^2)./(2.*exp(sig_zs)));
ls_8=ones(n,3);
ls_8(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_8_1).^2)./(2.*exp(sig_zs)));
ls_8(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_8_2).^2)./(2.*exp(sig_zs)));
ls_8(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_8_3).^2)./(2.*exp(sig_zs)));
ls_9=ones(n,3);
ls_9(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_9_1).^2)./(2.*exp(sig_zs)));
ls_9(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_9_2).^2)./(2.*exp(sig_zs)));
ls_9(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_9_3).^2)./(2.*exp(sig_zs)));
ls_10=ones(n,3);
ls_10(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_10_1).^2)./(2.*exp(sig_zs)));
ls_10(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_10_2).^2)./(2.*exp(sig_zs)));
ls_10(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_10_3).^2)./(2.*exp(sig_zs)));
ls_11=ones(n,3);
ls_11(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_11_1).^2)./(2.*exp(sig_zs)));
ls_11(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_11_2).^2)./(2.*exp(sig_zs)));
ls_11(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_11_3).^2)./(2.*exp(sig_zs)));
ls_12=ones(n,3);
ls_12(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_12_1).^2)./(2.*exp(sig_zs)));
ls_12(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_12_2).^2)./(2.*exp(sig_zs)));
ls_12(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_12_3).^2)./(2.*exp(sig_zs)));
ls_13=ones(n,3);
ls_13(:,1) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_13_1).^2)./(2.*exp(sig_zs)));
ls_13(:,2) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_13_2).^2)./(2.*exp(sig_zs)));
ls_13(:,3) = (1./((2.*pi.*exp(sig_zs)).^0.5)).*exp(-((nsib - Zs*bZs - vzs_13_3).^2)./(2.*exp(sig_zs)));

%--------------------------------------------------------------------------
%2.13 Contribution to the likelihood function of employment 3 years after diploma
%--------------------------------------------------------------------------
lE3_1=ones(n,3);
lE3_1(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_1_1).^2)./(2.*exp(sigE3)));
lE3_1(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_1_2).^2)./(2.*exp(sigE3)));
lE3_1(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_1_3).^2)./(2.*exp(sigE3)));
lE3_2=ones(n,3);
lE3_2(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_2_1).^2)./(2.*exp(sigE3)));
lE3_2(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_2_2).^2)./(2.*exp(sigE3)));
lE3_2(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_2_3).^2)./(2.*exp(sigE3)));
lE3_3=ones(n,3);
lE3_3(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_3_1).^2)./(2.*exp(sigE3)));
lE3_3(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_3_2).^2)./(2.*exp(sigE3)));
lE3_3(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_3_3).^2)./(2.*exp(sigE3)));
lE3_4=ones(n,3);
lE3_4(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_4_1).^2)./(2.*exp(sigE3)));
lE3_4(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_4_2).^2)./(2.*exp(sigE3)));
lE3_4(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_4_3).^2)./(2.*exp(sigE3)));
lE3_5=ones(n,3);
lE3_5(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_5_1).^2)./(2.*exp(sigE3)));
lE3_5(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_5_2).^2)./(2.*exp(sigE3)));
lE3_5(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_5_3).^2)./(2.*exp(sigE3)));
lE3_6=ones(n,3);
lE3_6(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_6_1).^2)./(2.*exp(sigE3)));
lE3_6(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_6_2).^2)./(2.*exp(sigE3)));
lE3_6(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_6_3).^2)./(2.*exp(sigE3)));
lE3_7=ones(n,3);
lE3_7(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_7_1).^2)./(2.*exp(sigE3)));
lE3_7(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_7_2).^2)./(2.*exp(sigE3)));
lE3_7(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_7_3).^2)./(2.*exp(sigE3)));
lE3_8=ones(n,3);
lE3_8(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_8_1).^2)./(2.*exp(sigE3)));
lE3_8(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_8_2).^2)./(2.*exp(sigE3)));
lE3_8(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_8_3).^2)./(2.*exp(sigE3)));
lE3_9=ones(n,3);
lE3_9(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_9_1).^2)./(2.*exp(sigE3)));
lE3_9(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_9_2).^2)./(2.*exp(sigE3)));
lE3_9(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_9_3).^2)./(2.*exp(sigE3)));
lE3_10=ones(n,3);
lE3_10(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_10_1).^2)./(2.*exp(sigE3)));
lE3_10(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_10_2).^2)./(2.*exp(sigE3)));
lE3_10(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_10_3).^2)./(2.*exp(sigE3)));
lE3_11=ones(n,3);
lE3_11(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_11_1).^2)./(2.*exp(sigE3)));
lE3_11(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_11_2).^2)./(2.*exp(sigE3)));
lE3_11(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_11_3).^2)./(2.*exp(sigE3)));
lE3_12=ones(n,3);
lE3_12(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_12_1).^2)./(2.*exp(sigE3)));
lE3_12(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_12_2).^2)./(2.*exp(sigE3)));
lE3_12(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_12_3).^2)./(2.*exp(sigE3)));
lE3_13=ones(n,3);
lE3_13(:,1) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_13_1).^2)./(2.*exp(sigE3)));
lE3_13(:,2) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_13_2).^2)./(2.*exp(sigE3)));
lE3_13(:,3) = (1./((2.*pi.*exp(sigE3)).^0.5)).*exp(-((totday3 - W3*bE3 - ve3_13_3).^2)./(2.*exp(sigE3)));

%--------------------------------------------------------------------------
%2.14 Contribution to the likelihood function of employment 6 years after diploma
%--------------------------------------------------------------------------
lE6_1=ones(n,3);
lE6_1(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_1_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_1(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_1_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_1(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_1_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_2=ones(n,3);
lE6_2(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_2_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_2(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_2_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_2(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_2_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_3=ones(n,3);
lE6_3(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_3_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_3(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_3_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_3(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_3_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_4=ones(n,3);
lE6_4(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_4_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_4(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_4_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_4(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_4_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_5=ones(n,3);
lE6_5(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_5_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_5(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_5_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_5(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_5_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_6=ones(n,3);
lE6_6(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_6_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_6(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_6_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_6(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_6_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_7=ones(n,3);
lE6_7(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_7_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_7(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_7_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_7(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_7_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_8=ones(n,3);
lE6_8(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_8_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_8(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_8_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_8(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_8_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_9=ones(n,3);
lE6_9(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_9_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_9(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_9_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_9(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_9_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_10=ones(n,3);
lE6_10(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_10_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_10(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_10_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_10(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_10_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_11=ones(n,3);
lE6_11(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_11_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_11(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_11_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_11(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_11_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_12=ones(n,3);
lE6_12(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_12_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_12(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_12_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_12(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_12_3).^2)./(2.*exp(sigE6)))).^samw6;
lE6_13=ones(n,3);
lE6_13(:,1) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_13_1).^2)./(2.*exp(sigE6)))).^samw6;
lE6_13(:,2) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_13_2).^2)./(2.*exp(sigE6)))).^samw6;
lE6_13(:,3) = ((1./((2.*pi.*exp(sigE6)).^0.5)).*exp(-((totday6 - W6*bE6 - ve6_13_3).^2)./(2.*exp(sigE6)))).^samw6;
%--------------------------------------------------------------------------
%2.15 Contribution to the likelihood function of employment 9 years after diploma
%--------------------------------------------------------------------------
lE9_1=ones(n,3);
lE9_1(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_1_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_1(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_1_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_1(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_1_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_2=ones(n,3);
lE9_2(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_2_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_2(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_2_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_2(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_2_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_3=ones(n,3);
lE9_3(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_3_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_3(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_3_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_3(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_3_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_4=ones(n,3);
lE9_4(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_4_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_4(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_4_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_4(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_4_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_5=ones(n,3);
lE9_5(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_5_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_5(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_5_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_5(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_5_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_6=ones(n,3);
lE9_6(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_6_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_6(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_6_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_6(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_6_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_7=ones(n,3);
lE9_7(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_7_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_7(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_7_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_7(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_7_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_8=ones(n,3);
lE9_8(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_8_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_8(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_8_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_8(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_8_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_9=ones(n,3);
lE9_9(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_9_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_9(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_9_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_9(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_9_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_10=ones(n,3);
lE9_10(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_10_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_10(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_10_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_10(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_10_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_11=ones(n,3);
lE9_11(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_11_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_11(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_11_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_11(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_11_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_12=ones(n,3);
lE9_12(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_12_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_12(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_12_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_12(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_12_3).^2)./(2.*exp(sigE9)))).^samw9;
lE9_13=ones(n,3);
lE9_13(:,1) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_13_1).^2)./(2.*exp(sigE9)))).^samw9;
lE9_13(:,2) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_13_2).^2)./(2.*exp(sigE9)))).^samw9;
lE9_13(:,3) = ((1./((2.*pi.*exp(sigE9)).^0.5)).*exp(-((totday9 - W9*bE9 - ve9_13_3).^2)./(2.*exp(sigE9)))).^samw9;

%--------------------------------------------------------------------------
%2.16 Contribution to the likelihood function of employment 12 years after diploma
%--------------------------------------------------------------------------
lE12_1=ones(n,3);
lE12_1(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_1_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_1(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_1_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_1(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_1_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_2=ones(n,3);
lE12_2(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_2_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_2(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_2_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_2(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_2_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_3=ones(n,3);
lE12_3(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_3_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_3(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_3_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_3(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_3_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_4=ones(n,3);
lE12_4(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_4_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_4(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_4_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_4(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_4_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_5=ones(n,3);
lE12_5(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_5_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_5(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_5_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_5(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_5_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_6=ones(n,3);
lE12_6(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_6_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_6(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_6_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_6(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_6_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_7=ones(n,3);
lE12_7(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_7_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_7(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_7_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_7(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_7_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_8=ones(n,3);
lE12_8(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_8_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_8(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_8_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_8(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_8_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_9=ones(n,3);
lE12_9(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_9_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_9(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_9_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_9(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_9_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_10=ones(n,3);
lE12_10(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_10_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_10(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_10_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_10(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_10_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_11=ones(n,3);
lE12_11(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_11_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_11(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_11_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_11(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_11_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_12=ones(n,3);
lE12_12(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_12_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_12(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_12_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_12(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_12_3).^2)./(2.*exp(sigE12)))).^samw12;
lE12_13=ones(n,3);
lE12_13(:,1) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_13_1).^2)./(2.*exp(sigE12)))).^samw12;
lE12_13(:,2) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_13_2).^2)./(2.*exp(sigE12)))).^samw12;
lE12_13(:,3) = ((1./((2.*pi.*exp(sigE12)).^0.5)).*exp(-((totday12 - W12*bE12 - ve12_13_3).^2)./(2.*exp(sigE12)))).^samw12;

%--------------------------------------------------------------------------
%2.17 Contribution to the likelihood function of employment 15 years after diploma
%--------------------------------------------------------------------------
lE15_1=ones(n,3);
lE15_1(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_1_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_1(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_1_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_1(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_1_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_2=ones(n,3);
lE15_2(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_2_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_2(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_2_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_2(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_2_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_3=ones(n,3);
lE15_3(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_3_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_3(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_3_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_3(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_3_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_4=ones(n,3);
lE15_4(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_4_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_4(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_4_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_4(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_4_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_5=ones(n,3);
lE15_5(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_5_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_5(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_5_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_5(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_5_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_6=ones(n,3);
lE15_6(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_6_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_6(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_6_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_6(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_6_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_7=ones(n,3);
lE15_7(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_7_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_7(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_7_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_7(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_7_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_8=ones(n,3);
lE15_8(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_8_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_8(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_8_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_8(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_8_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_9=ones(n,3);
lE15_9(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_9_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_9(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_9_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_9(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_9_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_10=ones(n,3);
lE15_10(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_10_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_10(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_10_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_10(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_10_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_11=ones(n,3);
lE15_11(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_11_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_11(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_11_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_11(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_11_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_12=ones(n,3);
lE15_12(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_12_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_12(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_12_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_12(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_12_3).^2)./(2.*exp(sigE15)))).^samw15;
lE15_13=ones(n,3);
lE15_13(:,1) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_13_1).^2)./(2.*exp(sigE15)))).^samw15;
lE15_13(:,2) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_13_2).^2)./(2.*exp(sigE15)))).^samw15;
lE15_13(:,3) = ((1./((2.*pi.*exp(sigE15)).^0.5)).*exp(-((totday15 - W15*bE15 - ve15_13_3).^2)./(2.*exp(sigE15)))).^samw15;

%--------------------------------------------------------------------------
%2.18 Contribution to the likelihood function of employment 18 years after diploma
%--------------------------------------------------------------------------
lE18_1=ones(n,3);                                                                   
lE18_1(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_1_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_1(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_1_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_1(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_1_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_2=ones(n,3);
lE18_2(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_2_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_2(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_2_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_2(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_2_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_3=ones(n,3);
lE18_3(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_3_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_3(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_3_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_3(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_3_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_4=ones(n,3);
lE18_4(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_4_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_4(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_4_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_4(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_4_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_5=ones(n,3);
lE18_5(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_5_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_5(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_5_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_5(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_5_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_6=ones(n,3);
lE18_6(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_6_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_6(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_6_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_6(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_6_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_7=ones(n,3);
lE18_7(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_7_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_7(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_7_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_7(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_7_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_8=ones(n,3);
lE18_8(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_8_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_8(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_8_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_8(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_8_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_9=ones(n,3);
lE18_9(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_9_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_9(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_9_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_9(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_9_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_10=ones(n,3);
lE18_10(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_10_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_10(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_10_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_10(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_10_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_11=ones(n,3);
lE18_11(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_11_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_11(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_11_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_11(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_11_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_12=ones(n,3);
lE18_12(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_12_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_12(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_12_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_12(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_12_3).^2)./(2.*exp(sigE18)))).^samw18;
lE18_13=ones(n,3);
lE18_13(:,1) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_13_1).^2)./(2.*exp(sigE18)))).^samw18;
lE18_13(:,2) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_13_2).^2)./(2.*exp(sigE18)))).^samw18;
lE18_13(:,3) = ((1./((2.*pi.*exp(sigE18)).^0.5)).*exp(-((totday18 - W18*bE18 - ve18_13_3).^2)./(2.*exp(sigE18)))).^samw18;

%--------------------------------------------------------------------------
%2.19 Contribution to the likelihood function of employment 21 years after diploma
%--------------------------------------------------------------------------
lE21_1=ones(n,3);
lE21_1(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_1_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_1(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_1_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_1(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_1_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_2=ones(n,3);
lE21_2(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_2_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_2(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_2_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_2(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_2_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_3=ones(n,3);
lE21_3(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_3_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_3(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_3_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_3(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_3_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_4=ones(n,3);
lE21_4(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_4_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_4(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_4_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_4(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_4_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_5=ones(n,3);
lE21_5(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_5_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_5(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_5_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_5(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_5_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_6=ones(n,3);
lE21_6(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_6_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_6(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_6_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_6(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_6_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_7=ones(n,3);
lE21_7(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_7_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_7(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_7_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_7(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_7_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_8=ones(n,3);
lE21_8(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_8_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_8(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_8_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_8(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_8_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_9=ones(n,3);
lE21_9(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_9_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_9(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_9_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_9(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_9_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_10=ones(n,3);
lE21_10(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_10_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_10(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_10_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_10(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_10_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_11=ones(n,3);
lE21_11(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_11_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_11(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_11_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_11(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_11_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_12=ones(n,3);
lE21_12(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_12_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_12(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_12_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_12(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_12_3).^2)./(2.*exp(sigE21)))).^samw21;
lE21_13=ones(n,3);
lE21_13(:,1) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_13_1).^2)./(2.*exp(sigE21)))).^samw21;
lE21_13(:,2) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_13_2).^2)./(2.*exp(sigE21)))).^samw21;
lE21_13(:,3) = ((1./((2.*pi.*exp(sigE21)).^0.5)).*exp(-((totday21 - W21*bE21 - ve21_13_3).^2)./(2.*exp(sigE21)))).^samw21;



%--------------------------------------------------------------------------      
%3.1 Individual contribution to the likelihood      
%--------------------------------------------------------------------------
ll_1(:,1) =(lf1_1(:,1).*lf2_1(:,1).*lf3_1(:,1).*lw3_1(:,1).*lw6_1(:,1).*lw9_1(:,1).*lw12_1(:,1).*lw15_1(:,1).*lw18_1(:,1).*lw21_1(:,1).*le_1(:,1).*ls_1(:,1).*lE3_1(:,1).*lE6_1(:,1).*lE9_1(:,1).*lE12_1(:,1).*lE15_1(:,1).*lE18_1(:,1).*lE21_1(:,1)).*wei(1,1);      
ll_2(:,1) =(lf1_2(:,1).*lf2_2(:,1).*lf3_2(:,1).*lw3_2(:,1).*lw6_2(:,1).*lw9_2(:,1).*lw12_2(:,1).*lw15_2(:,1).*lw18_2(:,1).*lw21_2(:,1).*le_2(:,1).*ls_2(:,1).*lE3_2(:,1).*lE6_2(:,1).*lE9_2(:,1).*lE12_2(:,1).*lE15_2(:,1).*lE18_2(:,1).*lE21_2(:,1)).*wei(2,1);      
ll_3(:,1) =(lf1_3(:,1).*lf2_3(:,1).*lf3_3(:,1).*lw3_3(:,1).*lw6_3(:,1).*lw9_3(:,1).*lw12_3(:,1).*lw15_3(:,1).*lw18_3(:,1).*lw21_3(:,1).*le_3(:,1).*ls_3(:,1).*lE3_3(:,1).*lE6_3(:,1).*lE9_3(:,1).*lE12_3(:,1).*lE15_3(:,1).*lE18_3(:,1).*lE21_3(:,1)).*wei(3,1);      
ll_4(:,1) =(lf1_4(:,1).*lf2_4(:,1).*lf3_4(:,1).*lw3_4(:,1).*lw6_4(:,1).*lw9_4(:,1).*lw12_4(:,1).*lw15_4(:,1).*lw18_4(:,1).*lw21_4(:,1).*le_4(:,1).*ls_4(:,1).*lE3_4(:,1).*lE6_4(:,1).*lE9_4(:,1).*lE12_4(:,1).*lE15_4(:,1).*lE18_4(:,1).*lE21_4(:,1)).*wei(4,1);      
ll_5(:,1) =(lf1_5(:,1).*lf2_5(:,1).*lf3_5(:,1).*lw3_5(:,1).*lw6_5(:,1).*lw9_5(:,1).*lw12_5(:,1).*lw15_5(:,1).*lw18_5(:,1).*lw21_5(:,1).*le_5(:,1).*ls_5(:,1).*lE3_5(:,1).*lE6_5(:,1).*lE9_5(:,1).*lE12_5(:,1).*lE15_5(:,1).*lE18_5(:,1).*lE21_5(:,1)).*wei(5,1);      
ll_6(:,1) =(lf1_6(:,1).*lf2_6(:,1).*lf3_6(:,1).*lw3_6(:,1).*lw6_6(:,1).*lw9_6(:,1).*lw12_6(:,1).*lw15_6(:,1).*lw18_6(:,1).*lw21_6(:,1).*le_6(:,1).*ls_6(:,1).*lE3_6(:,1).*lE6_6(:,1).*lE9_6(:,1).*lE12_6(:,1).*lE15_6(:,1).*lE18_6(:,1).*lE21_6(:,1)).*wei(6,1);      
ll_7(:,1) =(lf1_7(:,1).*lf2_7(:,1).*lf3_7(:,1).*lw3_7(:,1).*lw6_7(:,1).*lw9_7(:,1).*lw12_7(:,1).*lw15_7(:,1).*lw18_7(:,1).*lw21_7(:,1).*le_7(:,1).*ls_7(:,1).*lE3_7(:,1).*lE6_7(:,1).*lE9_7(:,1).*lE12_7(:,1).*lE15_7(:,1).*lE18_7(:,1).*lE21_7(:,1)).*wei(7,1);
ll_8(:,1) =(lf1_8(:,1).*lf2_8(:,1).*lf3_8(:,1).*lw3_8(:,1).*lw6_8(:,1).*lw9_8(:,1).*lw12_8(:,1).*lw15_8(:,1).*lw18_8(:,1).*lw21_8(:,1).*le_8(:,1).*ls_8(:,1).*lE3_8(:,1).*lE6_8(:,1).*lE9_8(:,1).*lE12_8(:,1).*lE15_8(:,1).*lE18_8(:,1).*lE21_8(:,1)).*wei(8,1);
ll_9(:,1) =(lf1_9(:,1).*lf2_9(:,1).*lf3_9(:,1).*lw3_9(:,1).*lw6_9(:,1).*lw9_9(:,1).*lw12_9(:,1).*lw15_9(:,1).*lw18_9(:,1).*lw21_9(:,1).*le_9(:,1).*ls_9(:,1).*lE3_9(:,1).*lE6_9(:,1).*lE9_9(:,1).*lE12_9(:,1).*lE15_9(:,1).*lE18_9(:,1).*lE21_9(:,1)).*wei(9,1);
ll_10(:,1)=(lf1_10(:,1).*lf2_10(:,1).*lf3_10(:,1).*lw3_10(:,1).*lw6_10(:,1).*lw9_10(:,1).*lw12_10(:,1).*lw15_10(:,1).*lw18_10(:,1).*lw21_10(:,1).*le_10(:,1).*ls_10(:,1).*lE3_10(:,1).*lE6_10(:,1).*lE9_10(:,1).*lE12_10(:,1).*lE15_10(:,1).*lE18_10(:,1).*lE21_10(:,1)).*wei(10,1);
ll_11(:,1)=(lf1_11(:,1).*lf2_11(:,1).*lf3_11(:,1).*lw3_11(:,1).*lw6_11(:,1).*lw9_11(:,1).*lw12_11(:,1).*lw15_11(:,1).*lw18_11(:,1).*lw21_11(:,1).*le_11(:,1).*ls_11(:,1).*lE3_11(:,1).*lE6_11(:,1).*lE9_11(:,1).*lE12_11(:,1).*lE15_11(:,1).*lE18_11(:,1).*lE21_11(:,1)).*wei(11,1);
ll_12(:,1)=(lf1_12(:,1).*lf2_12(:,1).*lf3_12(:,1).*lw3_12(:,1).*lw6_12(:,1).*lw9_12(:,1).*lw12_12(:,1).*lw15_12(:,1).*lw18_12(:,1).*lw21_12(:,1).*le_12(:,1).*ls_12(:,1).*lE3_12(:,1).*lE6_12(:,1).*lE9_12(:,1).*lE12_12(:,1).*lE15_12(:,1).*lE18_12(:,1).*lE21_12(:,1)).*wei(12,1);
ll_13(:,1)=(lf1_13(:,1).*lf2_13(:,1).*lf3_13(:,1).*lw3_13(:,1).*lw6_13(:,1).*lw9_13(:,1).*lw12_13(:,1).*lw15_13(:,1).*lw18_13(:,1).*lw21_13(:,1).*le_13(:,1).*ls_13(:,1).*lE3_13(:,1).*lE6_13(:,1).*lE9_13(:,1).*lE12_13(:,1).*lE15_13(:,1).*lE18_13(:,1).*lE21_13(:,1)).*wei(13,1);
ll1=ll_1(:,1)+ll_2(:,1)+ll_3(:,1)+ll_4(:,1)+ll_5(:,1)+ll_6(:,1)+ll_7(:,1)+ll_8(:,1)+ll_9(:,1)+ll_10(:,1)+ll_11(:,1)+ll_12(:,1)+ll_13(:,1);

ll_1(:,2)=(lf1_1(:,2).*lf2_1(:,2).*lf3_1(:,2).*lw3_1(:,2).*lw6_1(:,2).*lw9_1(:,2).*lw12_1(:,2).*lw15_1(:,2).*lw18_1(:,2).*lw21_1(:,2).*le_1(:,2).*ls_1(:,2).*lE3_1(:,2).*lE6_1(:,2).*lE9_1(:,2).*lE12_1(:,2).*lE15_1(:,2).*lE18_1(:,2).*lE21_1(:,2)).*wei(1,1);      
ll_2(:,2)=(lf1_2(:,2).*lf2_2(:,2).*lf3_2(:,2).*lw3_2(:,2).*lw6_2(:,2).*lw9_2(:,2).*lw12_2(:,2).*lw15_2(:,2).*lw18_2(:,2).*lw21_2(:,2).*le_2(:,2).*ls_2(:,2).*lE3_2(:,2).*lE6_2(:,2).*lE9_2(:,2).*lE12_2(:,2).*lE15_2(:,2).*lE18_2(:,2).*lE21_2(:,2)).*wei(2,1);      
ll_3(:,2)=(lf1_3(:,2).*lf2_3(:,2).*lf3_3(:,2).*lw3_3(:,2).*lw6_3(:,2).*lw9_3(:,2).*lw12_3(:,2).*lw15_3(:,2).*lw18_3(:,2).*lw21_3(:,2).*le_3(:,2).*ls_3(:,2).*lE3_3(:,2).*lE6_3(:,2).*lE9_3(:,2).*lE12_3(:,2).*lE15_3(:,2).*lE18_3(:,2).*lE21_3(:,2)).*wei(3,1);      
ll_4(:,2)=(lf1_4(:,2).*lf2_4(:,2).*lf3_4(:,2).*lw3_4(:,2).*lw6_4(:,2).*lw9_4(:,2).*lw12_4(:,2).*lw15_4(:,2).*lw18_4(:,2).*lw21_4(:,2).*le_4(:,2).*ls_4(:,2).*lE3_4(:,2).*lE6_4(:,2).*lE9_4(:,2).*lE12_4(:,2).*lE15_4(:,2).*lE18_4(:,2).*lE21_4(:,2)).*wei(4,1);      
ll_5(:,2)=(lf1_5(:,2).*lf2_5(:,2).*lf3_5(:,2).*lw3_5(:,2).*lw6_5(:,2).*lw9_5(:,2).*lw12_5(:,2).*lw15_5(:,2).*lw18_5(:,2).*lw21_5(:,2).*le_5(:,2).*ls_5(:,2).*lE3_5(:,2).*lE6_5(:,2).*lE9_5(:,2).*lE12_5(:,2).*lE15_5(:,2).*lE18_5(:,2).*lE21_5(:,2)).*wei(5,1);      
ll_6(:,2)=(lf1_6(:,2).*lf2_6(:,2).*lf3_6(:,2).*lw3_6(:,2).*lw6_6(:,2).*lw9_6(:,2).*lw12_6(:,2).*lw15_6(:,2).*lw18_6(:,2).*lw21_6(:,2).*le_6(:,2).*ls_6(:,2).*lE3_6(:,2).*lE6_6(:,2).*lE9_6(:,2).*lE12_6(:,2).*lE15_6(:,2).*lE18_6(:,2).*lE21_6(:,2)).*wei(6,1);      
ll_7(:,2)=(lf1_7(:,2).*lf2_7(:,2).*lf3_7(:,2).*lw3_7(:,2).*lw6_7(:,2).*lw9_7(:,2).*lw12_7(:,2).*lw15_7(:,2).*lw18_7(:,2).*lw21_7(:,2).*le_7(:,2).*ls_7(:,2).*lE3_7(:,2).*lE6_7(:,2).*lE9_7(:,2).*lE12_7(:,2).*lE15_7(:,2).*lE18_7(:,2).*lE21_7(:,2)).*wei(7,1);
ll_8(:,2)=(lf1_8(:,2).*lf2_8(:,2).*lf3_8(:,2).*lw3_8(:,2).*lw6_8(:,2).*lw9_8(:,2).*lw12_8(:,2).*lw15_8(:,2).*lw18_8(:,2).*lw21_8(:,2).*le_8(:,2).*ls_8(:,2).*lE3_8(:,2).*lE6_8(:,2).*lE9_8(:,2).*lE12_8(:,2).*lE15_8(:,2).*lE18_8(:,2).*lE21_8(:,2)).*wei(8,1);
ll_9(:,2)=(lf1_9(:,2).*lf2_9(:,2).*lf3_9(:,2).*lw3_9(:,2).*lw6_9(:,2).*lw9_9(:,2).*lw12_9(:,2).*lw15_9(:,2).*lw18_9(:,2).*lw21_9(:,2).*le_9(:,2).*ls_9(:,2).*lE3_9(:,2).*lE6_9(:,2).*lE9_9(:,2).*lE12_9(:,2).*lE15_9(:,2).*lE18_9(:,2).*lE21_9(:,2)).*wei(9,1);
ll_10(:,2)=(lf1_10(:,2).*lf2_10(:,2).*lf3_10(:,2).*lw3_10(:,2).*lw6_10(:,2).*lw9_10(:,2).*lw12_10(:,2).*lw15_10(:,2).*lw18_10(:,2).*lw21_10(:,2).*le_10(:,2).*ls_10(:,2).*lE3_10(:,2).*lE6_10(:,2).*lE9_10(:,2).*lE12_10(:,2).*lE15_10(:,2).*lE18_10(:,2).*lE21_10(:,2)).*wei(10,1);
ll_11(:,2)=(lf1_11(:,2).*lf2_11(:,2).*lf3_11(:,2).*lw3_11(:,2).*lw6_11(:,2).*lw9_11(:,2).*lw12_11(:,2).*lw15_11(:,2).*lw18_11(:,2).*lw21_11(:,2).*le_11(:,2).*ls_11(:,2).*lE3_11(:,2).*lE6_11(:,2).*lE9_11(:,2).*lE12_11(:,2).*lE15_11(:,2).*lE18_11(:,2).*lE21_11(:,2)).*wei(11,1);
ll_12(:,2)=(lf1_12(:,2).*lf2_12(:,2).*lf3_12(:,2).*lw3_12(:,2).*lw6_12(:,2).*lw9_12(:,2).*lw12_12(:,2).*lw15_12(:,2).*lw18_12(:,2).*lw21_12(:,2).*le_12(:,2).*ls_12(:,2).*lE3_12(:,2).*lE6_12(:,2).*lE9_12(:,2).*lE12_12(:,2).*lE15_12(:,2).*lE18_12(:,2).*lE21_12(:,2)).*wei(12,1);
ll_13(:,2)=(lf1_13(:,2).*lf2_13(:,2).*lf3_13(:,2).*lw3_13(:,2).*lw6_13(:,2).*lw9_13(:,2).*lw12_13(:,2).*lw15_13(:,2).*lw18_13(:,2).*lw21_13(:,2).*le_13(:,2).*ls_13(:,2).*lE3_13(:,2).*lE6_13(:,2).*lE9_13(:,2).*lE12_13(:,2).*lE15_13(:,2).*lE18_13(:,2).*lE21_13(:,2)).*wei(13,1);
ll2=ll_1(:,2)+ll_2(:,2)+ll_3(:,2)+ll_4(:,2)+ll_5(:,2)+ll_6(:,2)+ll_7(:,2)+ll_8(:,2)+ll_9(:,2)+ll_10(:,2)+ll_11(:,2)+ll_12(:,2)+ll_13(:,2);

ll_1(:,3)=(lf1_1(:,3).*lf2_1(:,3).*lf3_1(:,3).*lw3_1(:,3).*lw6_1(:,3).*lw9_1(:,3).*lw12_1(:,3).*lw15_1(:,3).*lw18_1(:,3).*lw21_1(:,3).*le_1(:,3).*ls_1(:,3).*lE3_1(:,3).*lE6_1(:,3).*lE9_1(:,3).*lE12_1(:,3).*lE15_1(:,3).*lE18_1(:,3).*lE21_1(:,3)).*wei(1,1);      
ll_2(:,3)=(lf1_2(:,3).*lf2_2(:,3).*lf3_2(:,3).*lw3_2(:,3).*lw6_2(:,3).*lw9_2(:,3).*lw12_2(:,3).*lw15_2(:,3).*lw18_2(:,3).*lw21_2(:,3).*le_2(:,3).*ls_2(:,3).*lE3_2(:,3).*lE6_2(:,3).*lE9_2(:,3).*lE12_2(:,3).*lE15_2(:,3).*lE18_2(:,3).*lE21_2(:,3)).*wei(2,1);      
ll_3(:,3)=(lf1_3(:,3).*lf2_3(:,3).*lf3_3(:,3).*lw3_3(:,3).*lw6_3(:,3).*lw9_3(:,3).*lw12_3(:,3).*lw15_3(:,3).*lw18_3(:,3).*lw21_3(:,3).*le_3(:,3).*ls_3(:,3).*lE3_3(:,3).*lE6_3(:,3).*lE9_3(:,3).*lE12_3(:,3).*lE15_3(:,3).*lE18_3(:,3).*lE21_3(:,3)).*wei(3,1);      
ll_4(:,3)=(lf1_4(:,3).*lf2_4(:,3).*lf3_4(:,3).*lw3_4(:,3).*lw6_4(:,3).*lw9_4(:,3).*lw12_4(:,3).*lw15_4(:,3).*lw18_4(:,3).*lw21_4(:,3).*le_4(:,3).*ls_4(:,3).*lE3_4(:,3).*lE6_4(:,3).*lE9_4(:,3).*lE12_4(:,3).*lE15_4(:,3).*lE18_4(:,3).*lE21_4(:,3)).*wei(4,1);      
ll_5(:,3)=(lf1_5(:,3).*lf2_5(:,3).*lf3_5(:,3).*lw3_5(:,3).*lw6_5(:,3).*lw9_5(:,3).*lw12_5(:,3).*lw15_5(:,3).*lw18_5(:,3).*lw21_5(:,3).*le_5(:,3).*ls_5(:,3).*lE3_5(:,3).*lE6_5(:,3).*lE9_5(:,3).*lE12_5(:,3).*lE15_5(:,3).*lE18_5(:,3).*lE21_5(:,3)).*wei(5,1);      
ll_6(:,3)=(lf1_6(:,3).*lf2_6(:,3).*lf3_6(:,3).*lw3_6(:,3).*lw6_6(:,3).*lw9_6(:,3).*lw12_6(:,3).*lw15_6(:,3).*lw18_6(:,3).*lw21_6(:,3).*le_6(:,3).*ls_6(:,3).*lE3_6(:,3).*lE6_6(:,3).*lE9_6(:,3).*lE12_6(:,3).*lE15_6(:,3).*lE18_6(:,3).*lE21_6(:,3)).*wei(6,1);      
ll_7(:,3)=(lf1_7(:,3).*lf2_7(:,3).*lf3_7(:,3).*lw3_7(:,3).*lw6_7(:,3).*lw9_7(:,3).*lw12_7(:,3).*lw15_7(:,3).*lw18_7(:,3).*lw21_7(:,3).*le_7(:,3).*ls_7(:,3).*lE3_7(:,3).*lE6_7(:,3).*lE9_7(:,3).*lE12_7(:,3).*lE15_7(:,3).*lE18_7(:,3).*lE21_7(:,3)).*wei(7,1);
ll_8(:,3)=(lf1_8(:,3).*lf2_8(:,3).*lf3_8(:,3).*lw3_8(:,3).*lw6_8(:,3).*lw9_8(:,3).*lw12_8(:,3).*lw15_8(:,3).*lw18_8(:,3).*lw21_8(:,3).*le_8(:,3).*ls_8(:,3).*lE3_8(:,3).*lE6_8(:,3).*lE9_8(:,3).*lE12_8(:,3).*lE15_8(:,3).*lE18_8(:,3).*lE21_8(:,3)).*wei(8,1);
ll_9(:,3)=(lf1_9(:,3).*lf2_9(:,3).*lf3_9(:,3).*lw3_9(:,3).*lw6_9(:,3).*lw9_9(:,3).*lw12_9(:,3).*lw15_9(:,3).*lw18_9(:,3).*lw21_9(:,3).*le_9(:,3).*ls_9(:,3).*lE3_9(:,3).*lE6_9(:,3).*lE9_9(:,3).*lE12_9(:,3).*lE15_9(:,3).*lE18_9(:,3).*lE21_9(:,3)).*wei(9,1);
ll_10(:,3)=(lf1_10(:,3).*lf2_10(:,3).*lf3_10(:,3).*lw3_10(:,3).*lw6_10(:,3).*lw9_10(:,3).*lw12_10(:,3).*lw15_10(:,3).*lw18_10(:,3).*lw21_10(:,3).*le_10(:,3).*ls_10(:,3).*lE3_10(:,3).*lE6_10(:,3).*lE9_10(:,3).*lE12_10(:,3).*lE15_10(:,3).*lE18_10(:,3).*lE21_10(:,3)).*wei(10,1);
ll_11(:,3)=(lf1_11(:,3).*lf2_11(:,3).*lf3_11(:,3).*lw3_11(:,3).*lw6_11(:,3).*lw9_11(:,3).*lw12_11(:,3).*lw15_11(:,3).*lw18_11(:,3).*lw21_11(:,3).*le_11(:,3).*ls_11(:,3).*lE3_11(:,3).*lE6_11(:,3).*lE9_11(:,3).*lE12_11(:,3).*lE15_11(:,3).*lE18_11(:,3).*lE21_11(:,3)).*wei(11,1);
ll_12(:,3)=(lf1_12(:,3).*lf2_12(:,3).*lf3_12(:,3).*lw3_12(:,3).*lw6_12(:,3).*lw9_12(:,3).*lw12_12(:,3).*lw15_12(:,3).*lw18_12(:,3).*lw21_12(:,3).*le_12(:,3).*ls_12(:,3).*lE3_12(:,3).*lE6_12(:,3).*lE9_12(:,3).*lE12_12(:,3).*lE15_12(:,3).*lE18_12(:,3).*lE21_12(:,3)).*wei(12,1);
ll_13(:,3)=(lf1_13(:,3).*lf2_13(:,3).*lf3_13(:,3).*lw3_13(:,3).*lw6_13(:,3).*lw9_13(:,3).*lw12_13(:,3).*lw15_13(:,3).*lw18_13(:,3).*lw21_13(:,3).*le_13(:,3).*ls_13(:,3).*lE3_13(:,3).*lE6_13(:,3).*lE9_13(:,3).*lE12_13(:,3).*lE15_13(:,3).*lE18_13(:,3).*lE21_13(:,3)).*wei(13,1);
ll3=ll_1(:,3)+ll_2(:,3)+ll_3(:,3)+ll_4(:,3)+ll_5(:,3)+ll_6(:,3)+ll_7(:,3)+ll_8(:,3)+ll_9(:,3)+ll_10(:,3)+ll_11(:,3)+ll_12(:,3)+ll_13(:,3);

%-------------------------------------------------------------------------- 
%3.2 LOG-LIKELIHOOD FUNCTION
%--------------------------------------------------------------------------
NL = -sum(log(P1.*ll1+P2.*ll2+P3.*ll3));

% %{{{Derive the score an the gradient and compute the Hessian
% [nbr,nrc]=size(b);
% 
% %read the score:
% sc = zeros(n,nbr);
% sctemp=g_tmp_log_00000;
% sc = [sctemp{:}];
% 
% %read the gradient:
% gt = zeros(nbr,1);
% gtemp= g_NL(1);
% gt=[gtemp{:}]; 
% 
% g  = gt;					%gradient
% H  = sc'*sc;				%outer product
% %}}}
% 
% %EOF
