clearvars
close all
date_string = '20210529';
fpath = ['.\results_theory\',date_string,'\'];
figpath = '.\paper\figs\';

Nset = [10000, 50000, 100000];
Tplot = 200;

for Ni = 1:length(Nset)
    N = Nset(Ni);
    if N==10000
        fname = [fpath,'ER_exact']; 
    else
        fname = [fpath,'ER_N',num2str(N),'_exact']; 
    end
    results = load(fname);
    fprintf('cmax = %.2f, Tend = %.0f days.\n', results.results(1)/100, results.results(4))
    dcT_plot = results.dcT(:,1:Tplot-1).*100;
    dlmwrite([fpath,'ER_N',num2str(N),'_dcT.csv'],dcT_plot,'precision','%4.16f');
end

%%
Tplot = 200;
N = 10000;
results_PL = load([fpath,'PL_exact']);
fprintf('cmax = %.2f, Tend = %.0f days.\n', results_PL.results(1)/100, results_PL.results(4))
dcT_plot_PL = results_PL.dcT(:,1:Tplot-1).*100;
dlmwrite([fpath,'PL_N',num2str(N),'_dcT.csv'],dcT_plot_PL,'precision','%4.16f');

%% compare ER and PL networks
N = 10000;
results_ER = load([fpath,'ER_exact']);
dcT_avg_plot = [results_ER.dcT_avg; results_PL.dcT_avg];
[h1,hl] = fn_plot_theory_dc(dcT_avg_plot, Tplot);
hl.String = {'Random network','Power law network'};
ylim(gca, [0, 3.5])
xtickangle(0)
colormap = get(groot,'defaultAxesColorOrder');
hLines = findobj(h1, 'Type', 'line');
hLines(2).Color = colormap(2,:);
hLines(1).Color = colormap(3,:);
figname = 'theory_cmp_ER_PL';    
saveas(h1,[figpath, figname,'.png'])
