clearvars
close all
figpath = '.\paper\figs\';

N = 50;
k_mean = 10;
kmin=5;
kmax=N-1;
p = k_mean/(N-1);
fun = @(a) (1/sum([kmin:kmax].^(-a))) * sum([kmin:kmax].^(1-a)) - k_mean;
exponent = fsolve(fun,1.5);
seed_D = 112;
seed_PowLaw_kseq = 43;
seed_PowLaw_graph = 31;
colormap = get(groot,'defaultAxesColorOrder');

%% plot ER random graph
[D_ER,nEdge] = fn_gen_ER_graph(N,p,seed_D);    
G_ER = graph(D_ER);
h_ER = figure(1);
g = plot(G_ER,'NodeLabel',{},'EdgeColor',105*ones(1,3)/255,'NodeColor',colormap(2,:));
g.Marker = 's';
g.MarkerSize = 8;
box off
set(gca,'XColor', 'none','YColor','none')
set(h_ER,'position', [1000  800  600  600])

%% plot power law graph
[kseq,kmean_target] = fn_gen_PowLaw(N,exponent,kmin,kmax,seed_PowLaw_kseq);
[G_PL,D_PL,count_droplink] = fn_gen_Config_graph(kseq,seed_PowLaw_graph);  
h_PL = figure(2);
g = plot(G_PL,'NodeLabel',{},'EdgeColor',105*ones(1,3)/255,'NodeColor',colormap(1,:));
g.MarkerSize = 8;
box off
set(gca,'XColor', 'none','YColor','none')
set(h_PL,'position', [1600  800  600  600])

%% save figures
saveas(h_ER,[figpath, 'ER-graph-example.png'])
saveas(h_PL,[figpath, 'PL-graph-example.png'])
