function [parm, results_sim] = fn_sim_empirical_cont_par(myStream, betaT, N, nsimul, x_ini, y_ini)

% ============ INITIALIZATION ==============
k_mean = 10;
kmin = 5;
kmax = 50;
choice_network = 1; % 1=ER; 2=power law
%============================================
options = optimset('Display','off');
fun = @(a) (1/sum([kmin:kmax].^(-a))) * sum([kmin:kmax].^(1-a)) - k_mean;
exponent = fsolve(fun,1.5,options); 

T = length(betaT);
CT = zeros(nsimul,T);
RT = zeros(nsimul,T);
IT = zeros(nsimul,T);
x_end = zeros(N, nsimul);
y_end = zeros(N, nsimul);

xc = parallel.pool.Constant(x_ini);
yc = parallel.pool.Constant(y_ini);
sc = parallel.pool.Constant(myStream);
parfor iter = 1:nsimul
    stream = sc.Value;
    stream.Substream = iter;
    RandStream.setGlobalStream(stream)

    if isempty(x_ini)
        x_ini_iter = [];
        y_ini_iter = [];
    else
        x_ini_iter = xc.Value(:,iter);
        y_ini_iter = yc.Value(:,iter);
    end

    [CT_iter, IT_iter, RT_iter, x_end_iter, y_end_iter] = ...
        fn_sim_empirical_each_iter(betaT, N, x_ini_iter, y_ini_iter, choice_network, k_mean, kmin, kmax, exponent);
    
    CT(iter,:) = CT_iter; 
    IT(iter,:) = IT_iter; 
    RT(iter,:) = RT_iter;
    x_end(:,iter) = x_end_iter;
    y_end(:,iter) = y_end_iter;
end

cT = CT./N; rT = RT./N; iT = IT./N;    

%% ----------save results--------------
parm.nsimul = nsimul;
parm.betaT = betaT;

results_sim.cT = cT;
results_sim.rT = rT;
results_sim.iT = iT;
results_sim.x_end = x_end;
results_sim.y_end = y_end;

end
