function h = fn_plot_empirical_dc(tmax, dc)

h = figure;
tmin = tmax - length(dc)+1;
plot(tmin:tmax,dc,'Linewidth',2, 'Color', [0, 0, 0.502]);
ylabel('Daily new cases (\Delta c_t, per 100k population)', 'Color','black')
box('off')
ax = gca;
ax.LineWidth = 1.2;
ax.FontSize = 12;
ax.TickDir = 'out';
xlim([tmin,tmax])
xticks(tmin:21:tmax)
xtickformat('MMM dd')
xtickangle(90)

pbaspect([1.8 1 1])  
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 4.3750*2 4.3750])
set(gcf,'Position',[1441 919 420*2 420])

end