function [h, results] = fn_plot_empirical_Re_lockdown(tmax, ReT, country)

Tplot = length(ReT);
tmin = tmax - Tplot + 1;
t_ini = 21; % add to the beginning of plot
h = figure;
plot(tmin:tmax,ReT,'Linewidth',2);
hold on;
plot(tmin-t_ini : tmax, ones(1,Tplot+t_ini),'--','Color',ones(1,3)*150/255,'Linewidth',1.5) 
ylabel('${\hat{\mathcal{R}}_{et}}$','Interpreter','Latex','Color','black')
box('off')
xlim([tmin-t_ini,tmax])
xticks(tmin-t_ini:21:tmax)
ylim([0,3.5])
ax = gca;
ax.LineWidth = 1.2;
ax.FontSize = 12;
ax.TickDir = 'out';
xtickformat('MMM dd')
xtickangle(90)

idx_fallcross1 = find(ReT<1,1,'first');
t_fallcross1 = tmin+idx_fallcross1-1;
idx_risecross1 = find(ReT(idx_fallcross1:end)>1,1,'first')+idx_fallcross1-1;
days_below1 = idx_risecross1 - idx_fallcross1;

% the textarrow coordinates are [end_x, head_x], [end_y, head_y]
if strcmp(country,'Austria') 
    lockdown_start1 = datetime(2020,3,16);
    lockdown_end1 = datetime(2020,4,13);
    fn_mark_lockdown(lockdown_start1, lockdown_end1, tmin, t_ini, ReT, country)
    lockdown_start2 = datetime(2020,11,3);
    lockdown_end2 = datetime(2020,11,30);
    fn_mark_lockdown(lockdown_start2, lockdown_end2, tmin, t_ini, ReT, country)
    lockdown_start3 = datetime(2020,12,26);
    lockdown_end3 = datetime(2021,2,7);
    fn_mark_lockdown(lockdown_start3, lockdown_end3, tmin, t_ini, ReT, country)
    
elseif strcmp(country,'France')
    lockdown_start1 = datetime(2020,3,17);
    lockdown_end1 = datetime(2020,5,11);
    fn_mark_lockdown(lockdown_start1, lockdown_end1, tmin, t_ini, ReT, country)
    lockdown_start2 = datetime(2020,10,30);
    lockdown_end2 = datetime(2020,12,14);
    fn_mark_lockdown(lockdown_start2, lockdown_end2, tmin, t_ini, ReT, country)
    lockdown_start3 = datetime(2021,4,4);
    lockdown_end3 = datetime(2021,5,3);
    fn_mark_lockdown(lockdown_start3, lockdown_end3, tmin, t_ini, ReT, country)        
    
elseif strcmp(country,'Germany')
    lockdown_start1 = datetime(2020,3,23);
    lockdown_end1 = datetime(2020,4,20);
    fn_mark_lockdown(lockdown_start1, lockdown_end1, tmin, t_ini, ReT, country)
    lockdown_start2 = datetime(2020,11,2);
    lockdown_end2 = datetime(2021,4,19);
    fn_mark_lockdown(lockdown_start2, lockdown_end2, tmin, t_ini, ReT, country)   

elseif strcmp(country,'Italy')
    lockdown_start1 = datetime(2020,3,9);
    lockdown_end1 = datetime(2020,5,18);
    fn_mark_lockdown(lockdown_start1, lockdown_end1, tmin, t_ini, ReT, country)
    lockdown_start2 = datetime(2020,12,24);
    lockdown_end2 = datetime(2021,1,6);
    fn_mark_lockdown(lockdown_start2, lockdown_end2, tmin, t_ini, ReT, country) 
    lockdown_start3 = datetime(2021,3,15);
    lockdown_end3 = datetime(2021,4,30);
    fn_mark_lockdown(lockdown_start3, lockdown_end3, tmin, t_ini, ReT, country)    
    
elseif strcmp(country,'Spain')
    lockdown_start1 = datetime(2020,3,14);
    lockdown_end1 = datetime(2020,5,9);
    fn_mark_lockdown(lockdown_start1, lockdown_end1, tmin, t_ini, ReT, country)   

elseif strcmp(country,'UK')
    lockdown_start1 = datetime(2020,3,23);
    lockdown_end1 = datetime(2020,7,4);
    fn_mark_lockdown(lockdown_start1, lockdown_end1, tmin, t_ini, ReT, country)
    lockdown_start2 = datetime(2020,11,5);
    lockdown_end2 = datetime(2020,12,2);
    fn_mark_lockdown(lockdown_start2, lockdown_end2, tmin, t_ini, ReT, country)
    lockdown_start3 = datetime(2021,1,5);
    lockdown_end3 = datetime(2021,3,29);
    fn_mark_lockdown(lockdown_start3, lockdown_end3, tmin, t_ini, ReT, country)   
    
end

results.days_downto1 = days(t_fallcross1-lockdown_start1);
results.days_below1 = days_below1; 
end