function result = fn_mcout(parmhatBIG,seBIG,parm,epsilon)
% Monte Carlo output: bias, rmse, size, power
% read in parmhatBIG and seBIG
% parm: 1*k vector of true parameters
% epsilon: 1*k vector of deviations to compute power

[nsimul,k] = size(parmhatBIG);
% bias
bias = mean(parmhatBIG) - parm;
% rmse
dev = parmhatBIG - repmat(parm,nsimul,1);
mse = mean(dev.*dev);
rmse = sqrt(mse);

% size
zsim = dev./seBIG;
siz = mean(abs(zsim)>norminv(0.975));

% power
parm1 = parm - epsilon;
dev1 = parmhatBIG - repmat(parm1,nsimul,1);
z1sim = dev1./seBIG;
pow = mean(abs(z1sim)>norminv(0.975));

result = [bias;rmse;siz;pow];

end
