function [G,D,count_droplink] = fn_gen_Config_graph(kseq,seed)

if mod(sum(kseq),2)~=0
    error("Invalid degree sequence");
end

n = length(kseq);
stublist = repelem(1:n,kseq);
nstub = length(stublist);
if nargin>1
    rng(seed);
end
idx = randperm(nstub);
i = stublist(idx(1:nstub/2));
j = stublist(idx(nstub/2+1:end));
G0 = graph(i,j);

if ismultigraph(G0)
    G = simplify(G0);
end
count_droplink = size(G0.Edges,1)-size(G.Edges,1);
D = adjacency(G);

end

