function betahat_rollT = fn_est_beta_states(cmtx,imtx,roll_window,MF)
% rolling estimation of beta for N states
% cT: T by N
[T,N] = size(cmtx);
T_roll = T-1-roll_window+1;
betahat_rollT = zeros(T_roll,N);

ymtx = (1 - MF.*cmtx(2:T,:))./(1 - MF.*cmtx(1:T-1,:));
xmtx = MF.*imtx(1:T-1,:);
model_beta = @(b,x)( exp(-b.*x));
beta_ini = 0.2;
for j = 1:N
    for t=1:T_roll
        Y = ymtx(t:t+roll_window-1,j);
        X = xmtx(t:t+roll_window-1,j);
        [betahat,uhat,J,CovB,MSE,ErrorModelInfo] = nlinfit(X,Y,model_beta,beta_ini);
        betahat_rollT(t,j) = betahat;     
    end
end

end