clearvars
close all
date_string = '20210529';
fpath = ['.\results_theory\',date_string,'\'];

Nset = [10000,50000,100000];
roll_window = 14;
wbeg = 4;  % estimation starts from the 4th week
wend = 15; % ends in the 15th week

gamma = 1/14;
R0 = 3;
tbeg = wbeg*7 + 1 - roll_window;
tend = (wend+1)*7;
nsimul = 1000;

%%
tab = [];
for Ni = 1:length(Nset)
    N = Nset(Ni);
    if N==10000
        fname = [fpath,'ER_exact']; 
    else
        fname = [fpath,'ER_N',num2str(N),'_exact']; 
    end
    load(fname);  % load saved results

    %% estimation
    idx_fail = cT(:,end)<=0.2;  % "Failed" epidemic exists if N=5000
    pct_fail = sum(idx_fail)/nsimul;
    if pct_fail~=0
        cT = cT(idx_fail==0,:);
        iT = iT(idx_fail==0,:);
        nsimul_success = length(cT);
    else
        nsimul_success = nsimul;
    end
    
    RhatBIG = zeros(nsimul_success,tend-tbeg+1-roll_window);
    for iter = 1:nsimul_success
%         if mod(iter,100)==0
%             disp(iter)
%         end
        cT_sample = cT(iter,tbeg:tend);
        iT_sample = iT(iter,tbeg:tend);
        betahat = fn_est_beta(cT_sample,iT_sample,roll_window,1);
        Rhat = betahat/gamma;
        RhatBIG(iter,:) = Rhat';
    end
    
    %% compute bias and RMSE
    result_roll = fn_mcout(RhatBIG,1,R0,0.1);
    nsub = 4;
    result = zeros(2,nsub); 
    for j = 1:nsub
        sel = (3*j-3)*7+1 : 3*j*7;
        result(:,j) = mean(result_roll(1:2,sel),2);
    end
    tab = [tab;result];
end    
tab
dlmwrite([fpath,'estimation_const_beta_',num2str(roll_window/7),'W.csv'],tab,'precision','%4.16f');


