% Owyang, Piger, and Soques -- "Contagious Switching"

% This code generates all Tables and Figures after running OPS_Main.m

% Note: This code uses the following MATLAB toolboxes:
% "Statistics and Machine Learning"
% "Econometrics"

clear all; clc;

cd(fileparts(matlab.desktop.editor.getActiveFilename)) 
addpath(genpath(fileparts(matlab.desktop.editor.getActiveFilename)))

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Table 1: Priors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% See "priors" structure

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Table 2: Marginal Effects (full sample, S observed)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('OPS_Sknown1_NAFTA0.mat')

USeffect_1Q = 100*squeeze(post.ME(:,1,1,:));
CAeffect_1Q = 100*squeeze(post.ME(:,1,2,:));
MXeffect_1Q = 100*squeeze(post.ME(:,1,3,:));

USeffect_4Q = 100*squeeze(post.ME(:,5,1,:));
CAeffect_4Q = 100*squeeze(post.ME(:,5,2,:));
MXeffect_4Q = 100*squeeze(post.ME(:,5,3,:));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Table 3: AUROC
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('OPS_Sknown0_NAFTA0.mat')
[AUCOPS] = OPS_AUROC(priors,post,data);
[AUCUMS] = OPS_UMS_Main; % estimate univariate MS model

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Table 4: Marginal Effects Pre- and Post-NAFTA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('OPS_Sknown0_NAFTA1.mat')
USeffect_4Q_Pre = 100*squeeze(post.MEpre(:,5,1,:));
CAeffect_4Q_Pre = 100*squeeze(post.MEpre(:,5,2,:));
MXeffect_4Q_Pre = 100*squeeze(post.MEpre(:,5,3,:));

load('OPS_Sknown0_NAFTA2.mat')
USeffect_4Q_Post = 100*squeeze(post.MEpost(:,5,1,:));
CAeffect_4Q_Post = 100*squeeze(post.MEpost(:,5,2,:));
MXeffect_4Q_Post = 100*squeeze(post.MEpost(:,5,3,:));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Figure 1: Continuous Recession Variables (full sample, S observed)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('OPS_Sknown1_NAFTA0.mat')
startdate = 77;

[Data,Labels] = xlsread(priors.loadfile,'Dates');
Dates = datenum('30-Dec-1899') + datenum(Data(startdate:end,1));
xL = [ Dates(1,1), Dates(end,1)];
recessions = [];
% Recession Dates
for n = 1:priors.N
    index = 1;
    if data.S(n,1) == 1
        recessions{n}(index,1) = Dates(1,1);
    end
    for t = 2:priors.T
        if data.S(n,t) == 1
            if data.S(n,t-1) == 0
                recessions{n}(index,1) = Dates(t,1);
            end
        else
            if data.S(n,t-1) == 1
                recessions{n}(index,2) = Dates(t,1);
                index = index + 1;
            end
        end
    end
    if data.S(n,priors.T) == 1
        recessions{n}(index,2) = Dates(priors.T,1);
    end
end

% y-axis limits
ymin = min(min(squeeze(post.z(:,:,1))'));
ymax = max(max(squeeze(post.z(:,:,3))'));

figure;
set(gcf, 'Position', [00 00 800 800]);
subplot(3,1,1);
hold on
plot(Dates(1:end,1),squeeze(post.z(1,:,2))','b-','LineWidth',1.5);
plot(Dates(1:end,1),squeeze(post.z(1,:,[1 3]))','b-.','LineWidth',0.25);
plot(xL, [0 0], 'k--')
ylim([ymin ymax])
yticks([-4:2])
datetick('x','yyyy')
recessionplot('recessions',recessions{1});
hold off
title('US')

subplot(3,1,2);
hold on
plot(Dates(1:end,1),squeeze(post.z(2,:,2))','b-','LineWidth',1.5);
plot(Dates(1:end,1),squeeze(post.z(2,:,[1 3]))','b-.','LineWidth',0.25);
% xL = get(gca, 'XLim');
plot(xL, [0 0], 'k--')
ylim([ymin ymax])
yticks([-4:2])
datetick('x','yyyy')
recessionplot('recessions',recessions{2});
hold off
title('Canada')

subplot(3,1,3);
hold on
plot(Dates(1:end,1),squeeze(post.z(3,:,2))','b-','LineWidth',1.5);
plot(Dates(1:end,1),squeeze(post.z(3,:,[1 3]))','b-.','LineWidth',0.25);
% xL = get(gca, 'XLim');
plot(xL, [0 0], 'k--')
ylim([ymin ymax])
yticks([-4:2])
datetick('x','yyyy')
recessionplot('recessions',recessions{3});
hold off
title('Mexico')

set(gcf,'color','w')

fig = gcf;
fig.PaperPositionMode = 'auto';
fig_pos = fig.PaperPosition;
fig.PaperSize = [fig_pos(3) fig_pos(4)];
print(fig,'OPS_z_Sknown','-dpng','-r300');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Figure 2: GIRF for Country Shocks
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('OPS_Sknown1_NAFTA0.mat')
xL = [0 size(post.IRF{1}-2,1)]; % IRF steps ahead
xLgrid = [0:size(post.IRF{1},1)-2]';
ymin = 0;
ymax = 0;
for k = 1:3
    ymin = min(ymin,min(min(post.IRF{k}(:,1:3,1))));
    ymax = max(ymax,max(max(post.IRF{k}(:,1:3,3))));
end
figure;
set(gcf, 'Position', [00 00 1000 500]);
for n = 1:3
    for k = 1:3
        subplot(3,3,3*(n-1)+k);
        hold on
        boundedline(xLgrid,squeeze(post.IRF{k}(2:end,n,[2])),[-squeeze(post.IRF{k}(2:end,n,[1]))+squeeze(post.IRF{k}(2:end,n,[2])),squeeze(post.IRF{k}(2:end,n,[3])) - squeeze(post.IRF{k}(2:end,n,[2]))],'b','alpha');
        plot(xL, [0 0], 'k--')
        xlim(xL)
        if n == 1
            if k == 1
                title('US')
            elseif k == 2
                title('Can')
            else
                title('Mex')
            end
        end
        if k == 1
            if n == 1
                ylabel('z_{US}')
            elseif n == 2
                ylabel('z_{CA}')
            else
                ylabel('z_{MX}')
            end
            
        end
        hold off
    end
end

set(gcf,'color','w')

ax = gca;
outerpos = ax.OuterPosition;
ti = ax.TightInset;
left = outerpos(1) + ti(1);
bottom = outerpos(2) + ti(2);
ax_width = outerpos(3) - ti(1) - ti(3);
ax_height = outerpos(4) - ti(2) - ti(4);
ax.Position = [left bottom ax_width ax_height];

fig = gcf;
fig.PaperPositionMode = 'auto';
fig_pos = fig.PaperPosition;
fig.PaperSize = [fig_pos(3) fig_pos(4)];
print(fig,'OPS_CountryShocks','-dpng','-r300')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Figure 3: GIRF for Monetary Policy Shock
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('OPS_Sknown1_NAFTA0.mat')
xL = [0 size(post.IRF{1}-2,1)]; % IRF steps ahead
xLgrid = [0 :size(post.IRF{1},1)-2]';
k = 5; % Variable to shock

ymax = max(max(post.IRF{k}(:,1:3,3)));
ymin = min(min(post.IRF{k}(:,1:3,1)));
figure;
set(gcf, 'Position', [00 00 1000 200]);
subplot(1,3,1);
hold on
n=1;
boundedline(xLgrid,squeeze(post.IRF{k}(2:end,n,[2])),[-squeeze(post.IRF{k}(2:end,n,[1]))+squeeze(post.IRF{k}(2:end,n,[2])),squeeze(post.IRF{k}(2:end,n,[3])) - squeeze(post.IRF{k}(2:end,n,[2]))],'b','alpha');
xlim(xL)
plot(xL, [0 0], 'k--')
ylim([ymin ymax]) % All same Scale
hold off
title('z_{US}')

subplot(1,3,2);
hold on
n=2;
boundedline(xLgrid,squeeze(post.IRF{k}(2:end,n,[2])),[-squeeze(post.IRF{k}(2:end,n,[1]))+squeeze(post.IRF{k}(2:end,n,[2])),squeeze(post.IRF{k}(2:end,n,[3])) - squeeze(post.IRF{k}(2:end,n,[2]))],'b','alpha');
xlim(xL)
plot(xL, [0 0], 'k--')
ylim([ymin ymax]) % All same Scale
hold off
title('z_{CA}')

subplot(1,3,3);
hold on
n=3;
boundedline(xLgrid,squeeze(post.IRF{k}(2:end,n,[2])),[-squeeze(post.IRF{k}(2:end,n,[1]))+squeeze(post.IRF{k}(2:end,n,[2])),squeeze(post.IRF{k}(2:end,n,[3])) - squeeze(post.IRF{k}(2:end,n,[2]))],'b','alpha');
xlim(xL)
plot(xL, [0 0], 'k--')
ylim([ymin ymax]) % All same Scale
hold off
title('z_{MX}')

set(gcf,'color','w')
fig = gcf;
fig.PaperPositionMode = 'auto';
fig_pos = fig.PaperPosition;
fig.PaperSize = [fig_pos(3) fig_pos(4)];
print(fig,'OPS_irf_ffr','-dpng','-r300');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Figure 4: Recession Probabilities
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
load('OPS_Sknown0_NAFTA0.mat')

startdate = 77;

[Data,Labels] = xlsread(priors.loadfile,'Dates');
Dates = datenum('30-Dec-1899') + datenum(Data(startdate:end,1));

data.S =  xlsread(priors.loadfile,'Recessions')';
data.S = data.S(:,startdate:end);

% Recession Dates
recessions = [];
for n = 1:priors.N
    index = 1;
    if data.S(n,1) == 1
        recessions{n}(index,1) = Dates(1,1);
    end
    for t = 2:priors.T
        if data.S(n,t) == 1
            if data.S(n,t-1) == 0
                recessions{n}(index,1) = Dates(t,1);
            end
        else
            if data.S(n,t-1) == 1
                recessions{n}(index,2) = Dates(t,1);
                index = index + 1;
            end
        end
    end
    if data.S(n,priors.T) == 1
        recessions{n}(index,2) = Dates(priors.T,1);
    end
end

figure;
set(gcf, 'Position', [00 00 800 600]);
subplot(3,1,1);
hold on
plot(Dates(1:end,1),squeeze(post.PrS(:,1,1))');
xL = get(gca, 'XLim');
plot(xL, [0 0], 'k--','HandleVisibility','off')
recessionplot;
hold off
title('US')
datetick('x','yyyy')

subplot(3,1,2);
hold on
plot(Dates(1:end,1),squeeze(post.PrS(:,1,2))');
xL = get(gca, 'XLim');
plot(xL, [0 0], 'k--','HandleVisibility','off')
recessionplot('recessions',recessions{2});
hold off
title('Canada')
datetick('x','yyyy')

subplot(3,1,3);
hold on
plot(Dates(1:end,1),squeeze(post.PrS(:,1,3))');
xL = get(gca, 'XLim');
plot(xL, [0 0], 'k--','HandleVisibility','off')
recessionplot('recessions',recessions{3});
hold off
title('Mexico')
datetick('x','yyyy')

set(gcf,'color','w')
fig = gcf;
fig.PaperPositionMode = 'auto';
fig_pos = fig.PaperPosition;
fig.PaperSize = [fig_pos(3) fig_pos(4)];
print(fig,'OPS_Fig_RecessionProbs','-dpng','-r300');
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Figure 5: GIRF Pre- and Post-NAFTA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

load('OPS_Sknown0_NAFTA1.mat');
preNAFTA_post = post;

load('OPS_Sknown0_NAFTA2.mat');
postNAFTA_post = post;

xL = [0 size(post.IRF{1}-2,1)]; % IRF steps ahead
xLgrid = [0:size(post.IRF{1},1)-2]';

figure;
set(gcf, 'Position', [00 00 1000 500]);
for n = 1:3
    for k = 1:3
        subplot(3,3,3*(n-1)+k);
        hold on
        boundedline(xLgrid,squeeze(preNAFTA_post.IRF{k}(2:end,n,[2])),[-squeeze(preNAFTA_post.IRF{k}(2:end,n,[1]))+squeeze(preNAFTA_post.IRF{k}(2:end,n,[2])),squeeze(preNAFTA_post.IRF{k}(2:end,n,[3])) - squeeze(preNAFTA_post.IRF{k}(2:end,n,[2]))],'b','alpha',xLgrid,squeeze(postNAFTA_post.IRF{k}(2:end,n,[2])),[-squeeze(postNAFTA_post.IRF{k}(2:end,n,[1]))+squeeze(postNAFTA_post.IRF{k}(2:end,n,[2])),squeeze(postNAFTA_post.IRF{k}(2:end,n,[3])) - squeeze(postNAFTA_post.IRF{k}(2:end,n,[2]))],'r','alpha')
        % xL = get(gca, 'XLim');
        plot(xL, [0 0], 'k--')
        xlim(xL)
        %     ylim([-0.5 1])
        if n == 1
            if k == 1
                title('US')
            elseif k == 2
                title('Can')
            else
                title('Mex')
            end
        end
        if k == 1
            if n == 1
                ylabel('z_{US}')
            elseif n == 2
                ylabel('z_{CA}')
            else
                ylabel('z_{MX}')
            end
            
        end
        hold off
    end
end
legend('Pre-NAFTA','Post-NAFTA');
set(gcf,'color','w')

ax = gca;
outerpos = ax.OuterPosition;
ti = ax.TightInset;
left = outerpos(1) + ti(1);
bottom = outerpos(2) + ti(2);
ax_width = outerpos(3) - ti(1) - ti(3);
ax_height = outerpos(4) - ti(2) - ti(4);
ax.Position = [left bottom ax_width ax_height];

fig = gcf;
fig.PaperPositionMode = 'auto';
fig_pos = fig.PaperPosition;
fig.PaperSize = [fig_pos(3) fig_pos(4)];
print(fig,'OPS_CountryShocks_Sunknown_NAFTA1_NAFTA2','-dpng','-r300');

