function [mu,rho,sigsq] = OPS_UMS_mu_rho_sig(draw,priors,data)
%UNTITLED Summary of this function goes here
%   Detailed explanation goes here

mu = zeros(priors.N,2);
rho = zeros(priors.N,1);
mu_hold = draw.mu;
rho_hold = draw.rho;
draw.S = draw.S';
for n = 1:priors.N
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Draw mu
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    Sn(:,1) = (draw.S(n,2:end)' == 1);
    Sn(:,2) = (draw.S(n,2:end)' == 2);
    Sn_sig = Sn * 1 ./ sqrt(draw.sigsq(n,:));
    
    x = Sn_sig .* Sn;
    y = sum(Sn_sig,2) .* (data.x(n,2:end)' - draw.rho(n,1)*data.x(n,1:end-1)');

    M = inv(inv(priors.M0) + x' * x);
    m = M * (priors.M0 \ priors.m0 + x'*y);
    accept = 0;wait = 1;
    while accept == 0
        mun = m + chol(M)' * normrnd(0,1,size(x,2),1);
        if (mun(1,1) > 0) && (mun(2,1) < 0)
            accept = 1;
            mu(n,:) = mun';
        else
            wait = wait + 1;
        end
        if wait > 100
            accept = 1;
            mu(n,:) = mu_hold(n,:);
        end
    end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Draw rho
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
    if priors.rho0 == 0
        x = sum(Sn_sig,2) .* (data.x(n,1:end-1)');
        y = sum(Sn_sig,2) .* (data.x(n,2:end)' - Sn * mu(n,:)');

        R = inv(inv(priors.R0) + x' * x);
        r = R * (priors.R0 \ priors.r0 + x'*y);
        accept = 0;wait = 1;
        while accept == 0
            rn = r + chol(R)' * normrnd(0,1,size(x,2),1);
            if abs(rn) < 1
                accept = 1;
                rho(n,:) = rn;
            else
                wait = wait + 1;
            end
            if wait > 100
                accept = 1;
                rho(n,:) = rho_hold(n,:);
            end
        end
    else
        rho = rho_hold;
    end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Draw sigma
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    
   e = data.x(n,2:end)' - draw.rho(n,1)*data.x(n,1:end-1)' - Sn * mu(n,:)';
   d = priors.d0 + e' * e;
   nu = priors.nu0 + priors.T;
   sigsq(n,:) = inv(gamrnd(nu/2,2/d));
   
   
   
end
        

end

