function [results] = OPS_Results(draw,priors,results,i)



results.z(:,:,i) = draw.z;
if priors.S_known == 0 
    results.accept_z(:,:,i) = draw.accept_z;
    results.S(:,:,i) = draw.S;
    results.mu(:,:,i) = draw.mu;
    results.rho(:,i) = draw.rho;
    results.sigsq(:,i) = draw.sigsq;
end
results.C(:,i) = draw.C;
results.B(:,:,i) = draw.B;
results.omega(:,:,i) = draw.omega;

results.lambda(:,i) = diag(draw.D);
results.L(:,:,i) = draw.L;
results.accept(:,i) = draw.accept;
results.h(:,i) = draw.h;

K = priors.N + priors.J;
for k = 1 : K
    CB = [draw.C, draw.B];
    A0 = chol(draw.omega);
    v = zeros(priors.IRF_length + priors.P,K);
    v(priors.P + 1, k) = 1;
    yhat = zeros(priors.IRF_length,K);
    for j = priors.P + 1 : priors.IRF_length + priors.P
        yhat_tm1 = 0;
        for p = 1: priors.P
            yhat_tm1 = [yhat_tm1 yhat(j-p,:)];
        end
        yhat_tm1 = yhat_tm1 * CB' + v(j,:)*A0;
        yhat(j,:) = yhat_tm1;
    end    
    results.IRF(:,:,k,i) = yhat(priors.P:end,:);
end


end

