function [priors,data,draw,results] = OPS_Priors(model)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Model Setup
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
priors = model;

% Import Recession Dates if S known
if priors.S_known == 1
    data.S =  xlsread(priors.loadfile,'Recessions')';
    data.S = data.S(:,2:end);
end

% Import principal components data
data.x =  xlsread(priors.loadfile,'PCA')';
data.z = data.x(:,1:end);

% Import other variables for the VAR
PCE_ALL = xlsread(priors.loadfile,'PCE');
PCE = 100*(log(PCE_ALL(2:end,1)) - log(PCE_ALL(1:end-1,1)));
FFR_ALL = xlsread(priors.loadfile,'FFR');
FFR = FFR_ALL(2:end,1);
PCOM_ALL = xlsread(priors.loadfile,'CRB');
PCOM = 100*(log(PCOM_ALL(2:end,1)) - log(PCOM_ALL(1:end-1,1)));
data.y = [PCE FFR PCOM]';

% Subsample selection
if priors.start_1980 == 1
    startdate = 76; % 1980 = 76, 1985 = 96
    if priors.NAFTA == 1 % Pre-NAFTA
        data.x = data.x(:,startdate:131);
        data.y = data.y(:,startdate:131);
        if priors.S_known == 1
            data.S = data.S(:,startdate:131);
        end
    elseif priors.NAFTA == 2 % Post-NAFTA
        data.x = data.x(:,132:end);
        data.y = data.y(:,132:end);
        if priors.S_known == 1
            data.S = data.S(:,132:end);
        end
    else % Full Sample
        data.x = data.x(:,startdate:end);
        data.y = data.y(:,startdate:end);
        if priors.S_known == 1
            data.S = data.S(:,startdate:end);
        end
    end
else
    if priors.NAFTA == 1
        data.x = data.x(:,1:131);
        data.y = data.y(:,1:131);
        if priors.S_known == 1
            data.S = data.S(:,1:131);
        end
    elseif priors.NAFTA == 2
        data.x = data.x(:,132:end);
        data.y = data.y(:,132:end);
        if priors.S_known == 1
            data.S = data.S(:,132:end);
        end
    end
    % Structural Break for Mexico
    if priors.Mex_break == 1
        if (priors.NAFTA == 0) || (priors.NAFTA ==1)
            priors.Dum = zeros(priors.T,1);
            priors.Dum(81:end,:) = 1;
        end
    end
end

priors.J = size(data.y,1);
priors.N = size(data.x,1);
priors.P = model.lags;
priors.T = size(data.x,2);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Prior Parameters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
K = priors.N+priors.J;

% Minnesota prior: Mean
c = zeros((priors.N + priors.J),1);
b1 = 0.5 * eye((priors.N + priors.J));
bp = zeros(priors.N + priors.J);
CB = [c,b1];
for p = 2:priors.P
    CB = [CB,bp];
end
CB = CB';
priors.b0 = CB(:);

% Minnesota prior: Variance
% Hyperparameters
priors.lam1 = 0.2;
priors.lam2 = 0.5;
priors.lam3 = 2;
if priors.S_known == 1
    priors.lam4 = 0.2;
else
    priors.lam4 = 0.05;
end

% Compute standard deviation of each series via AR1 regression
s0 = ones(priors.N+priors.J,1);
for j= 1:priors.J
    y0 =  data.y(j,:)';
    x0 = [ones(size(y0,1),1) lag0(y0,1)];
    b0 = inv(x0'*x0)*(x0'*y0);
    s0(priors.N+j,1) = sqrt(((y0-x0*b0)'*(y0-x0*b0))/(size(y0,1)-2));
end
cvar = (priors.lam4 * s0).^ 2;

bigb0var = [];
for l = 1:priors.P
    b0var = zeros(K,K);
    for i = 1:K
        for j = 1:K
            if i == j
                b0var(i,j) = (priors.lam1/(l^priors.lam3))^2;
            else
                b0var(i,j) = ((s0(i,1) * priors.lam1 * priors.lam2)/(s0(j,1) * (l^priors.lam3)) )^2;
            end
        end
    end
    bigb0var = [bigb0var,b0var];
end
CBvar = [cvar,bigb0var];
CBvar = CBvar';
CBvar = diag(CBvar(:));
priors.B0 = CBvar;

priors.S = eye(priors.N + priors.J);
priors.alpha = priors.N + priors.J + 1;

K = (priors.N + priors.J);

priors.nu_lambda = 2*10 * ones(K,1);
priors.S0 = 2*(s0.^2).*(priors.nu_lambda/2-1);

priors.Ak0 = (0.15)^2; % (0.10)^2
priors.ak0 = 0;
priors.tau = 1.5; % MH Tuning Parameters
priors.kappa = 10;


priors.m0 = [2; -5];
priors.M0 = 2 *eye(2);

priors.r0 = 0;
priors.R0 = 1;

priors.d0 = 1;
priors.nu0 = 1;

priors.h0 = 0;
priors.H0 = 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Initialize Draw Structure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
CB = reshape(priors.b0, 1+ (priors.N + priors.J) * priors.P,priors.N + priors.J)';
draw.C = CB(:,1);
draw.B = CB(:,2:end);

draw.mu = [5 * ones(priors.N,1), -10 * ones(priors.N,1)];
draw.rho = zeros(priors.N,1);
draw.sigsq = ones(priors.N,1);


draw.z = zeros(priors.N,priors.T);
draw.z(:,1) = 1 * randn(priors.N,1);
for t = 2:priors.T
    draw.z(:,t) = 0 * draw.z(:,t-1) + 1 * randn(priors.N,1);
end
S_logical = draw.z > 0;
draw.S = double(S_logical);

draw.L = eye(priors.N + priors.J);
draw.D = eye(priors.N + priors.J);

draw.omega = inv(draw.L) * draw.D * inv(draw.L)';

draw.accept_acc = 0;

draw.h = 0;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Results structure
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
results.B = zeros((priors.N + priors.J), (priors.N + priors.J) * priors.P, priors.Nkeep);
results.C = zeros((priors.N + priors.J), priors.Nkeep);
results.omega = zeros((priors.N + priors.J), (priors.N + priors.J), priors.Nkeep);
results.d = zeros(1,priors.Nkeep);
results.z = zeros(priors.N,priors.T,priors.Nkeep);
results.IRF = zeros(priors.IRF_length + 1, priors.N + priors.J , priors.N + priors.J , priors.Nkeep);

end

