function [omega,L,D,accept] = OPS_omega(draw,priors,data)

Lhold = draw.L;
invLhold = inv(Lhold);

% Calculate residuals from VAR
Y = [draw.z; data.y]';
K = size(Y,2);
X = ones(size(Y,1),1);
for p = 1:priors.P
    X = [X,lag0(Y,p)];
end
Y = Y(priors.P + 1 :end,:);
X = X(priors.P + 1:end,:);

T = size(X,1);

CB = [draw.C, draw.B];

e = Y - X * CB';

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Draw lambda given u and a
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lambda = diag(draw.D);

w =  draw.L * e';
newS = diag( w * w' ) + priors.S0;
newnu = priors.nu_lambda + T;
for i = priors.N +1 : K
    lambda(i,1) =  1 ./ gamrnd( newnu(i,1) / 2 , 2 ./ newS(i,1) );
end
D = diag( lambda );
Dhold = D;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Draw a given u and lambda
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
flag = 0; %get a valid candidate draw
wait = 0;
while flag == 0
    Lc = eye( K );
    for i = 2 : K
        Dk = inv( priors.Ak0 \ eye(i-1) + e(:, 1 : i-1 )' * e(:, 1 : i-1 ) /  D(i,i) ) ;
        dk = - e(:, 1 : i-1 )' * e(:, i ) / D(i,i);
        % Ensure Dk is positive definite
        s = sqrt(diag(Dk));
        if (any(s~=1))
            C = Dk ./ (s * s');
        end
        [~,p] = cholcov(C,0);
        if p ~= 0
            Lc( i, 1:i-1 ) =  Lhold (i, 1:i-1); % If not PD, then use old L
        else
%             Lc( i, 1:i-1 ) = mvnrnd( Dk*dk, priors.tau * Dk ); % Normal            
            Lc( i, 1:i-1 ) =  Dk * dk + priors.tau * Dk * mvtrnd( Dk , priors.kappa)'; % Multivariate t
        end
        
    end
    invLc = inv( Lc );
    % Recursive Equations for Lambda
    Dc(1,1) = 1;  % Equation 3.3
    for i = 2 : priors.N
        lambda_N = diag( Dc );
        ak = invLc( i, 1:i-1 );
        Dc(i,i) = 1 - (ak .^2 ) * lambda_N( 1 : i-1 ) ; % Eqution 3.4
    end
    for i = priors.N+1 : K
        Dc(i,i) = lambda(i,1);
    end
    if ( diag(Dc) > 10^(-3) * ones(K, 1) )
        flag = 1;
        Sigc = invLc*Dc*invLc';
        invSigc = inv(Sigc);
    else
        wait = wait + 1;
    end
    if wait > 1e6
        error('D Matrix Not Positive')
    end
end

lp = 0;
for i = 2 : K
    Dk = inv( priors.Ak0 \ eye(i-1) + e(:, 1 : i-1 )' * e(:, 1 : i-1 ) / D(i,i) );
    dk = - e(:, 1 : i-1 )' * e(:, i ) / D(i,i);
    % Normal:
%     lp = lp + lmvnpdf( Lc( i, 1:i-1 )', zeros(i-1,1), priors.Ak0 * eye(i-1)) - lmvnpdf( draw.L( i, 1:i-1 )',zeros(i-1,1), priors.Ak0 * eye(i-1)) + lmvnpdf( draw.L( i, 1:i-1 )', Dk*dk,  priors.tau * Dk ) - lmvnpdf( Lc( i, 1:i-1 )', Dk*dk, priors.tau * Dk);
    % Multivariate t:   
lp = lp + lmvnpdf( Lc( i, 1:i-1 )', zeros(i-1,1), priors.Ak0 * eye(i-1)) - lmvnpdf( draw.L( i, 1:i-1 )',zeros(i-1,1), priors.Ak0 * eye(i-1)) + log(mvtpdf( draw.L( i, 1:i-1 )'- Dk*dk, priors.tau * Dk, priors.kappa)) - log(mvtpdf( Lc( i, 1:i-1 )'- Dk*dk, priors.tau * Dk, priors.kappa));

end
Tnew = size(e,1);
KT = K * Tnew;
w  = reshape(draw.L * e',KT,1);
wc = reshape(Lc * e',KT,1);
llike = -Tnew/2*log(prod(diag(D))) - w'*kron(speye(Tnew),inv(sparse(D)))*w/2;
llikec= -Tnew/2*log(prod(diag(Dc))) -wc'*kron(speye(Tnew),inv(sparse(Dc)))*wc/2;
urand = rand;

if (exp(llikec-llike+lp)> urand)
    D = Dc;
    L = Lc;
    omega = Sigc;
    accept = 1;
else
    L = Lhold;
    D = Dhold;
    omega = invLhold*D*invLhold';
    accept = 0;
end


end

