function [priors,data,results,post,means] = OPS_mcmc(model)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Priors
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[priors,data,draw,results] = OPS_Priors(model);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Gibbs Sampler
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if model.disp == 1
    progressbar
end
for i = 1 : priors.Nburn + priors.Nkeep
    [draw.C,draw.B] = OPS_CB(draw,priors,data);
    [draw.omega, draw.L, draw.D,draw.accept] = OPS_omega(draw,priors,data);    
    if priors.S_known == 1
        draw.z = OPS_z(draw,priors,data);
    else
        [draw.mu, draw.rho, draw.sigsq, draw.h] = OPS_mu_rho_sig(draw,priors,data);
        [draw.z,draw.S,draw.accept_z] = OPS_z_S(draw,priors,data);
    end
    % Store draws
    if i > priors.Nburn
        results = OPS_Results(draw,priors,results,(i-priors.Nburn));
    end
    draw.accept_acc = draw.accept_acc + draw.accept;
    if model.disp == 1
        progressbar(i/(priors.Nburn+priors.Nkeep))
    end
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Posterior Analysis
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
post = OPS_Post(priors,results);
means = OPS_PostMeans(priors,results);

end

