function [girf,girfz1,girfz0, S_1,S_0] = OPS_MargEff(priors,data,results)

thin = 50; % Use only every (thin)th iteration
Q = 50; % Number of draws from reduced form shocks
index = 1; % Initialize index for the for loop
K = priors.N + priors.J; % Size of VAR

girf = zeros(priors.N,priors.IRF_length+priors.P,priors.N,priors.Nkeep/thin);
girfz1 = zeros(priors.N,priors.IRF_length+priors.P,priors.N,priors.Nkeep/thin);
girfz0 = zeros(priors.N,priors.IRF_length+priors.P,priors.N,priors.Nkeep/thin);
Gsize = priors.Nkeep/thin;

for g = 1:thin:priors.Nkeep
    
    disp(sprintf('GIRF Gibbs %.2f%% Done',round(100*index/Gsize,2)));
    Y_ALL = [squeeze(results.z(:,:,g)); data.y];
    if priors.S_known == 0
        S1_ALL = find(sum(results.S(:,priors.P+1:end-1,g))==0)+priors.P; % Find all histories in Expansion
    else
        S1_ALL = find(sum(data.S(:,priors.P+1:end-1))==0)+priors.P; % Start in Expansion
    end
    T1 = size(S1_ALL,2);
    
    Y_1 = zeros(K,priors.IRF_length+priors.P,T1,priors.N,Q);
    Y_0 = zeros(K,priors.IRF_length+priors.P,T1,priors.N,Q);
    
    A0 = chol(squeeze(results.omega(:,:,g)))';
    CB = [results.C(:,g), squeeze(results.B(:,:,g))];
    
    for t = 1:T1 % Histories
        for q = 1:Q
            u = randn(K,priors.IRF_length); % future shocks
            for k = 1:priors.N
                Y_1(:,1:priors.P,t,k,q) = Y_ALL(:,S1_ALL(1,t)-(priors.P-1):S1_ALL(1,t));
                Y_0(:,1:priors.P,t,k,q) = Y_ALL(:,S1_ALL(1,t)-(priors.P-1):S1_ALL(1,t));
                
                Yt = Y_ALL(:,S1_ALL(1,t)+1);
                
                for h = 1: priors.IRF_length
                    ytm1_1 = 1; % Intercept
                    ytm1_0 = 1; % Intercept
                    for p = 1: priors.P
                        ytm1_1 = [ytm1_1; Y_1(:,priors.P+h-p,t,k,q)]; % Lag terms
                        ytm1_0 = [ytm1_0; Y_0(:,priors.P+h-p,t,k,q)]; % Lag terms
                    end
                    if h ==1
                        vS = zeros(K,1);
                        vS(k, 1) = 3; % size of time 0 shock
                        v0 = zeros(K,1);
                        
                        Y_1(:,priors.P+h,t,k,q) = Yt + A0 * vS;
                        Y_0(:,priors.P+h,t,k,q) = Yt + A0 * v0;
                        
                    else
                        Y_1(:,priors.P+h,t,k,q) =  CB * ytm1_1 + A0 * u(:,h); % Future horizons with reduced form shocks
                        Y_0(:,priors.P+h,t,k,q) =  CB * ytm1_0 + A0 * u(:,h);  % Future horizons with reduced form shocks
                    end
                end
            end
        end
    end
    % Regimes
    S_1 = Y_1(1:priors.N,:,:,:,:) >= 0;
    S_0 = Y_0(1:priors.N,:,:,:,:) >= 0;
    S_1 = cumsum(S_1,2);
    S_0 = cumsum(S_0,2);
    S_1 = S_1 ~= 0;
    S_0 = S_0 ~= 0;
    
    % Average simulated future data over shock paths
    girf_R = mean(S_1,5) - mean(S_0,5);
    % Average over histories
    girf(:,:,:,index) = squeeze(mean(girf_R,3));
    
    % Continuous z
    z_1 = Y_1(1:priors.N,:,:,:,:);
    girfz1_R_Q = z_1;
    % Average simulated future data over shock paths
    girfz1_R = mean(girfz1_R_Q,5);
    % Average over histories
    girfz1(:,:,:,index) = squeeze(mean(girfz1_R,3));
    z_0 = Y_0(1:priors.N,:,:,:,:);
    % Difference between shocked and not-shocked IRFs
    girfz0_R_Q = z_0;
    % Average simulated future data over shock paths
    girfz0_R = mean(girfz0_R_Q,5);
    % Average over histories
    girfz0(:,:,:,index) = squeeze(mean(girfz0_R,3));
    
    index = index+1;
end

% Trim initial vector
girf = girf(:,2:end,:,:);
girfz1 = girfz1(:,2:end,:,:);
girfz0 = girfz0(:,2:end,:,:);

end

