function [AUCOPS] = OPS_AUROC(priors,post,data)
% Owyang, Piger, Soques "Contagious Switching"
% Computes AUROC

PrR=squeeze(post.PrS(:,1,:)); % Probability of Recession
% Load OECD Recession Dates
data.S =  xlsread(priors.loadfile,'Recessions')';

if priors.start_1980 == 1
    data.S = data.S(:,77:end)';
else
    data.S = data.S(:,2:end)';
end

for n = 1:priors.N
    targets = data.S(:,n);
    outputs = PrR(:,n);
    [X,Y,T1,AUC] = perfcurve(targets,outputs,1);
    XOPS{n} = X;
    YOPS{n} = Y;
    AUCOPS(n,1) = AUC;
end


end