% this function generates the lagged data mtrix for "S"

function Xlag = gen_x_trend(ddata,T,n,lag,ttrend,c)

Ylag = zeros(T,n*lag);

for i = 1:lag
    Ylag(lag+1:T,(n*(i-1)+1):n*i)=ddata(lag+1-i:T-i,1:n);
end


tt = zeros(T-lag,1);    % linear trend
    gg = 1;
    for i = 1 : T-lag
        tt(i,1) = gg;
        gg = gg + 1;
    end
    
tt2 = tt.^2;    % quadratic trend

if c == 1
    if ttrend == 1
        Xlag    = [ ones(T - lag,1) tt Ylag(lag+1:T , :) ];
    elseif ttrend == 2
        Xlag    = [ ones(T - lag,1) tt tt2 Ylag(lag+1:T , :) ];
    else
        Xlag    = [ ones(T - lag,1) Ylag(lag+1:T , :) ];
    end
else
    if ttrend == 1
        Xlag    = [ tt Ylag(lag+1:T , :) ];
    elseif ttrend == 2
        Xlag    = [ tt tt2 Ylag(lag+1:T , :) ];
    else
        Xlag    = [ Ylag(lag+1:T , :) ];
    end
end

