%% Now comes the forecast method
function ferror_fig = forecast_figure(n,normirf,nlagcompmax)

nn = size(normirf,4);

% ferror_fig = zeros(n,n,nlagcompmax,nn);
ferror_fig      = zeros(n,nlagcompmax,n,nn);

% we iterate over all the horizons
for i_draw = 1:nn
    
    for nlagcomp = 1:nlagcompmax
        
        sss2  = zeros(n*n,nlagcomp);
        TOT   = zeros(n,nlagcomp);     % that's for the total forecast variance
        SIRF  = zeros(n*n,nlagcomp);
        SIRF2 = zeros(n*n,nlagcomp);
        
%         DD_shock      = zeros(n,nlagcomp,n);
        
        for i=1:nlagcomp
            sss2(:,i)=reshape(normirf(:,:,i,i_draw),n*n,1);  % now sss2 is in the format of Sims-Barsky
        end
        
        SIRF(:,:) = sss2(:,:).^2; % This squares every element of the IRF
        
        for i = 1:n^2
            SIRF2(i,:) = cumsum(SIRF(i,:));
        end
        
        for i = 1:n
            for j = 1:nlagcomp
                TOT(i,j) = sum(SIRF2(i:n:n^2,j));    % this is the total forecast error variance for each variable at each horizon
            end
        end
        
        %let's calculate the forecast variance contribution of the volatility
        %shock to the volatility variable
        
        for j = 1:nlagcomp % goes through all the time horizons
            for j2 = 1:n   % goes through all the variables
                for j_shock = 1:n
                    ferror_fig(j_shock,j,j2,i_draw) = SIRF2(j2+(j_shock-1)*n,j)/TOT(j2,j);         % these are very sensitive to the ordering!
                end
            end
        end
        
%         for i_vari = 1:n
%             for i_shk = 1:n
%                 ferror_fig(i_vari,i_shk,nlagcomp,i_draw)  = squeeze(sum(DD_shock(i_vari,:,i_shk)))/nlagcomp;
%             end
%         end
    end
end
