% this code does the calculations in Nelson, Pinter and Theodoridis (2015),
% BoE-WP
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% written on Jun, 2014 by Gabor Pinter
% Last updated 25 Jan, 2015
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% close all;
clear all;
clc;
global n_count
rmpath('C:\Users\320610\Documents\Projects\gpm')
addpath('functions')
addpath('data')
tic;
%% Load my Data
% dataset = xlsread('\data\dataset_NPT2015_cleaned','matlab','B2:S171');

%% VAR Estimation
ttrend    = 0;        % (1): time trend; other values no time trend
c         = 1;        % number of deterministic variables
nlags     = 1;        % number of lags of the VAR.
nimp      = 40;       % number of impulses to be computed.
ho        = 4;        % number of horizons over which sign restrictions are imposed.
ndraws    = 1000;     % number of posterior draws for Bayesian
maxrot    = 100 ;      % how many random matrices (orthonormal)
LAMBDA    = 1;        % tightness of the prior
nlagplot  = 20;       % number of periods over which we plot the IRFs
n_count   = 1;        % counter of A0 matrices for sign restrictions
xmon      = 3;        % the choleski column for monetary policy shocks

% coloring for figures
colorgraydark = [120/255 120/255 120/255];
colorgray     = [176/255 176/255 176/255];
colorbluedark = [90/255 160/255 255/255];
colorblue     = [153/255 204/255 255/255];
% Bands for IRFs
bandtight     = [0.32 0.68];
bandwide      = [0.16  0.84];
% break;
% load baseline
% ddata = baseline;
% load basecpi
% ddata = basecpi;
% load basepiq
% ddata = basepiq;
% load baseabs 
% ddata = baseabs;
% load baseoriginal
% ddata = baseoriginal;
% load basebig
% ddata = basebig;
load romer69
ddata = romer69;
% load basebig_inf
% ddata = basebig_inf;
% lagvalues = [3 4];
% break;
%% start the estimation
% for ilag  = 1:2
    nlags = 4;
    [Traw, n ]     = size(ddata); % number of variables in the VAR
    Y1            = gen_y(ddata,Traw,nlags);
    X1            = gen_x_trend(ddata,Traw,n,nlags,ttrend,c);
    [T, K]         = size(X1);              % dimensions of the endogenous matrix
    [ALPHA, SIGMA] = ols_gabor(X1,Y1,Traw,n,nlags);
    %% -----------------Prior hyperparameters for bvar model
    %--------------------------Haroon dummy code----------
    lambdaP  = LAMBDA;
    tauP     = 10*lambdaP;       % this controls the tightness of the priors on sum of coefficients
    epsilonP = 1/1000;  % this controls tightness of the prior on the constant
    muP      = 1*mean(Y1)';
    %%  Robustness for lags
    [ALPHA_star, Y_star, X_star, SIGMA_star] = bvar_prior_haroon(lambdaP,tauP,epsilonP,muP,Y1,X1,n,nlags,ttrend,c);
    [ALPHA_draws, SIGMA_draws] = bvar_post_haroon(ndraws,n,nlags, X_star, Y_star, ALPHA_star, ttrend, c);
    %% Sign restriction - Robustness for lags
%     [histall2, sirall2, histall_trendy, errors_str] = sign_NPTinterest(ALPHA_draws, SIGMA_draws, n, nlags, ttrend, nimp, maxrot, Y1,X1, ndraws, ho,c,n_count);
%     [histall2, sirall2, histall_trendy, errors_str] = sign_NPT_demandshock(ALPHA_draws, SIGMA_draws, n, nlags, ttrend, nimp, maxrot, Y1,X1, ndraws, ho,c,n_count);
%     [histall2, sirall2, histall_trendy, errors_str] = sign_NPT_demandshock2(ALPHA_draws, SIGMA_draws, n, nlags, ttrend, nimp, maxrot, Y1,X1, ndraws, ho,c,n_count);
 
%      [histall2, sirall2, histall_trendy, errors_str] = sign_NPT_demandshockINTEREST(ALPHA_draws, SIGMA_draws, n, nlags, ttrend, nimp, maxrot, Y1,X1, ndraws, ho,c,n_count);

% histall_trend = histall_trendy;
%     histall       = histall2;
%     sirall        = sirall2;
    %% Choleski identification - Robustness for lags
    [histall_ch, sirall_ch, histall_trendy_chol, errors_chol] = leverage_choleski(ALPHA_draws, SIGMA_draws, n, nlags, ttrend, nimp,Y1,X1, ndraws, c);
    histall_trend_chol = histall_trendy_chol;
    histall_chol       = histall_ch;
    sirall_chol        = sirall_ch;
%     if ilag == 1
%         sirall_chol_lag = sirall_chol; sirall_chol=[];
%         sirall_lag = sirall; sirall=[];
%         display('Now I will re-estimate the VAR with more lags. Be patient...')
%     end
% end
% break;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Impulse responses
% extract Choleski
% sir_chol_lag    = sort(sirall_chol_lag,4);
sir_chol        = sort(sirall_chol,4);
% extract sign restriction
% sir        = sort(sirall,4);
% sir_lag    = sort(sirall_lag,4);
xsize      = size(sir_chol,1);

% me11 = zeros(nlagplot,xsize);
% % me11_lag = zeros(nlagplot,xsize);
% up11 = zeros(nlagplot,xsize);
% lo11 = zeros(nlagplot,xsize);
% up11wide = zeros(nlagplot,xsize);
% lo11wide = zeros(nlagplot,xsize);
me11_chol = zeros(nlagplot,xsize);
% me11_chol_lag = zeros(nlagplot,xsize);
up11_chol = zeros(nlagplot,xsize);
lo11_chol = zeros(nlagplot,xsize);
up11_cholwide = zeros(nlagplot,xsize);
lo11_cholwide = zeros(nlagplot,xsize);

models = 1;
    lab{1}='Output';lab{2}='Price Level';lab{3}='Interest Rate';lab{4}='Commercial Bank Assets';
    lab{5}='Shadow Bank Assets'; lab{6}='Spread';
% if models == 1
%     lab{1}='Output \newline ';lab{2}='Price Level \newline ';lab{3}='Interest Rate \newline ';lab{4}='Commercial \newline     Bank';
%     lab{5}='Shadow \newline   Bank \newline '; lab{6}='Spread';
% elseif models == 2
%     lab{1}='GDP';lab{2}='CPI';lab{3}='Interest Rate';lab{4}='Commercial Banks';
%     lab{5}='Shadow Banks';lab{6}='Broker-Dealers ';lab{7}='Term Spread';lab{8}='SP500';lab{9}='Schiller Index';
% end
colorred     = [245/255 179/255 179/255];
colorreddark     = [242/255 92/255 92/255];

%    break;
figure('Name','Choesky');
for i2=1:xsize
    me11(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*0.50)))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));          % Sign restriction -- monetary shock is the 3rd column!
    up11(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandtight(2))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    lo11(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandtight(1))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    up11wide(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandwide(2))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    lo11wide(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandwide(1))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    xx = linspace(1,nlagplot,nlagplot);
            plot_chol = subplot(3,2,i2);

    
    a_chol = shadedplot(xx, lo11(:,i2)', up11(:,i2)', colorreddark, colorreddark); axis tight,hold on;
    plot(me11(:,i2),'k-o', 'LineWidth',1), axis tight,hold on;
    
    a_chol = shadedplot(xx, lo11wide(:,i2)', lo11(:,i2)', colorred, colorred); hold on;
    a_chol = shadedplot(xx, up11(:,i2)', up11wide(:,i2)', colorred, colorred); axis tight, hold on;
%     plot(me11_lag(:,i2),'r--', 'LineWidth',2), axis tight, hold on
    
    %     plot(xx,zeros(1:nlagplot,1),'k-'), hold off;
    xlim = get(gca,'xlim');  %Get x range
    plot([xlim(1) xlim(2)],[0 0],'k')
    hold off
    
%     if i2 == 1
%         title('Choleski','FontSize',20);
%     end
    title(lab{i2},'FontSize',26)
    
    xlabel('Quarters','FontSize',18)

    ylabel('%','FontSize',20)
    set(gca,'FontSize',20)
end
break;

    labL{1}='Output';labL{2}='Price Level';labL{3}='Interest Rate';labL{4}='Commercial Bank Assets';
    labL{5}='Shadow Bank Assets';

figure('Name','Sign - demand');
for i2=1:xsize
    me11(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*0.50)))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));          % Sign restriction -- monetary shock is the 3rd column!
    up11(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandtight(2))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
    lo11(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandtight(1))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
    up11wide(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandwide(2))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
    lo11wide(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandwide(1))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
%     me11_lag(:,i2) = squeeze(sir_lag(i2,2,1:nlagplot,fix(ndraws*0.50)))/(squeeze(sir_lag(xmon,2,1,fix(ndraws*0.50))));          % Sign restriction -- monetary shock is the 3rd column!

    xx = linspace(1,nlagplot,nlagplot);
    if xsize <= 4
        plot_chol = subplot(2,2,i2);
    elseif xsize == 5 || xsize == 6
        plot_chol = subplot(3,2,i2);
    elseif xsize == 9
        plot_chol = subplot(3,3,i2);
    end
    
    a_chol = shadedplot(xx, lo11(:,i2)', up11(:,i2)', colorbluedark, colorbluedark); axis tight,hold on;
    plot(me11(:,i2),'k-o', 'LineWidth',1), axis tight,hold on;
    
    a_chol = shadedplot(xx, lo11wide(:,i2)', lo11(:,i2)', colorblue, colorblue); hold on;
    a_chol = shadedplot(xx, up11(:,i2)', up11wide(:,i2)', colorblue, colorblue); hold on;
%     plot(me11_lag(:,i2),'r--', 'LineWidth',2), axis tight, hold on
    
    %     plot(xx,zeros(1:nlagplot,1),'k-'), hold off;
    xlim = get(gca,'xlim');  %Get x range
    plot([xlim(1) xlim(2)],[0 0],'k')
    hold off
    
    if i2 == 1
        title('Choleski','FontSize',20);
    end
    title(labL{i2},'FontSize',18)
    
    if n == 6
        if i2==5
            xlabel('Quarters','FontSize',18)
        end
    elseif n == 9
        if i2==9
            xlabel('Quarters','FontSize',18)
        end
    end
    ylabel('%','FontSize',20)
    set(gca,'FontSize',20)
end

%% sign counterfactual

% figure('Name','Sign - Demand shock');
for i2=1:xsize
    me11(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*0.50)))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));          % Sign restriction -- monetary shock is the 3rd column!
    up11(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandtight(2))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
    lo11(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandtight(1))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
    up11wide(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandwide(2))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
    lo11wide(:,i2) = squeeze(sir(i2,2,1:nlagplot,fix(ndraws*bandwide(1))))/(squeeze(sir(xmon,2,1,fix(ndraws*0.50))));
%     me11_lag(:,i2) = squeeze(sir_lag(i2,2,1:nlagplot,fix(ndraws*0.50)))/(squeeze(sir_lag(xmon,2,1,fix(ndraws*0.50))));          % Sign restriction -- monetary shock is the 3rd column!
end

for i = 1:nlagplot
test(i)  = 0.5*squeeze(me11(i,3))/i;
end
err   = zeros(nlagplot+1, nlagplot);
spath = zeros(nlagplot, nlagplot);
sumpaths = zeros(1,nlagplot);
ssize = zeros(1,nlagplot);
paths = zeros(nlagplot, nlagplot);

% calculate the sizes of the series of MP shocks needed to achieve
% the interest rate target
for ii = 1:nlagplot
    % calculate the MP IRF starting ii to ii+20
    spath(ii,ii:end) = squeeze(sir(3,1,1:nlagplot+1-ii,fix(ndraws*0.50)));

    % calculate ratio of the "gap" that needs filling in with
    % the new MP shock
    ssize(ii) = (test(ii)-sumpaths(ii))/spath(ii,ii);
%   ssize(ii) = err(ii,ii)/spath(ii,ii);
    sumpaths = [];
    % use this "ssize" multiplier to calculate the MP IRF needed to
    % achieve the interest rate level at time ii
    paths(ii,ii:end) = spath(ii,ii:end) .* ssize(ii);
    sumpaths = sum(paths);
    % what's the error in the next period, which we have to offset
    % with a next period shock
%     err(ii+1,ii:end) = test(ii:nlagplot)' - err(ii,ii:nlagplot) - paths(ii,ii:end)  ;
%     err(ii+1,ii:end) = test(ii:nlagplot)' - sumpaths(1,ii:nlagplot)  ;

%     errsum = sum(err);
end

% figure; 
% plot(test(ii:end),'k-'), hold on,
% plot(sumpaths(ii:end),'b--'), hold off,
% plot(paths,'g-'), hold off

% use the calculate MP shock sizes to construct output paths
varpath = zeros(nlagplot,n,nlagplot);
for ii = 1:nlagplot
    mpsize = ssize(ii);
    for i2=1:n
    varpath(ii:end,i2,ii) =  mpsize*squeeze(sir(i2,1,1:nlagplot+1-ii,fix(ndraws*0.50)));          % Sign restriction -- monetary shock is the 3rd column!
    end
end
mpvars = sum(varpath,3);

figure;
plot(test,'k-'), hold on,
plot(mpvars(:,3)), hold off

cfactual = mpvars + me11;

figure('Name','Sign - demand - cfactual');
for i2=1:xsize
    if xsize <= 4
        plot_chol = subplot(2,2,i2);
    elseif xsize == 5 || xsize == 6
        plot_chol = subplot(3,2,i2);
    elseif xsize == 9
        plot_chol = subplot(3,3,i2);
    end
    plot(me11(1:10,i2),'k-o','MarkerSize',8, 'LineWidth',2), axis tight,hold on;
    plot(cfactual(1:10,i2),'r-x','MarkerSize',10, 'LineWidth',2), axis tight,hold on;
    if i2 == 1
        legend('Demand shock','Counterfactually Stronger Policy Response','FontSize',24)
    end
    %     plot(xx,zeros(1:nlagplot,1),'k-'), hold off;
    xlim = get(gca,'xlim');  %Get x range
    plot([xlim(1) xlim(2)],[0 0],'k')
    hold off
     title(labL{i2},'FontSize',26)
    ylabel('%','FontSize',24)
    set(gca,'FontSize',24)
end

%% Counterfactual historical
% this is the path for interest rate (2003Q3 - 2007Q2) I want to achieve
test2 = [0.7525; 1.4103; 1.8454; 2.5230; 2.8374; 2.9626; 3.0310 ; ...
3.1131; 2.50161; 2.0961; 1.6318; 0.75; 0.2; 0; 0; 0];
test2 = 0.5*test2/100;

ng2 = size(test2,1);

err2      = zeros(ng2+1, ng2);

spath2    = zeros(ng2, ng2);
sumpaths2 = zeros(1,ng2);
ssize2    = zeros(1,ng2);
paths2    = zeros(ng2, ng2);

spath2_sign     = zeros(ng2, ng2);
sumpaths2_sign  = zeros(1,ng2);
ssize2_sign     = zeros(1,ng2);
paths2_sign     = zeros(ng2, ng2);

% calculate the sizes of the series of MP shocks needed to achieve
% the interest rate target
for ii = 1:ng2
    % calculate the MP IRF starting ii to ii+20
    spath2(ii,ii:end)      = squeeze(sir_chol(3,3,1:ng2+1-ii,fix(ndraws*0.50)));
    spath2_sign(ii,ii:end) = squeeze(sir(3,1,1:ng2+1-ii,fix(ndraws*0.50)));

    % calculate ratio of the "gap" that needs filling in with
    % the new MP shock
    ssize2(ii)      = (test2(ii)-sumpaths2(ii))/spath2(ii,ii);
    ssize2_sign(ii) = (test2(ii)-sumpaths2_sign(ii))/spath2_sign(ii,ii);

%   ssize(ii) = err(ii,ii)/spath(ii,ii);
    sumpaths2 = [];
    sumpaths2_sign = [];
    % use this "ssize" multiplier to calculate the MP IRF needed to
    % achieve the interest rate level at time ii
    paths2(ii,ii:end)      = spath2(ii,ii:end)      .* ssize2(ii);
    paths2_sign(ii,ii:end) = spath2_sign(ii,ii:end) .* ssize2_sign(ii);

    sumpaths2      = sum(paths2);
    sumpaths2_sign = sum(paths2_sign);

    % what's the error in the next period, which we have to offset
    % with a next period shock
%     err(ii+1,ii:end) = test(ii:nlagplot)' - err(ii,ii:nlagplot) - paths(ii,ii:end)  ;
%     err(ii+1,ii:end) = test(ii:nlagplot)' - sumpaths(1,ii:nlagplot)  ;

%     errsum = sum(err);
end

% figure; 
% plot(test(ii:end),'k-'), hold on,
% plot(sumpaths(ii:end),'b--'), hold off,
% plot(paths,'g-'), hold off

% use the calculate MP shock sizes to construct output paths
varpath2      = zeros(ng2,n,ng2);
varpath2_sign = zeros(ng2,n,ng2);

for ii = 1:ng2
    mpsize2      = ssize2(ii);    
    mpsize2_sign = ssize2_sign(ii);

    for i2=1:n
    varpath2(ii:end,i2,ii)      =  mpsize2*squeeze(sir_chol(i2,3,1:ng2+1-ii,fix(ndraws*0.50)));          % Sign restriction -- monetary shock is the 3rd column!
    varpath2_sign(ii:end,i2,ii) =  mpsize2_sign*squeeze(sir(i2,1,1:ng2+1-ii,fix(ndraws*0.50)));          % Sign restriction -- monetary shock is the 3rd column!
    end
end
mpvars2 = sum(varpath2,3);
mpvars2_sign = sum(varpath2_sign,3);

% construct counterfactual series
t3      = size(mpvars2_sign,1);
cd_data = [ddata(end-(t3-1)-4:end-(t3-1)-1,:) ; ddata(end-(t3-1):end,:) + mpvars2_sign];
rr_data = ddata(end-(t3-1)-4:end,:);
d4_cd   = cd_data(5:end,:)-cd_data(1:end-4,:);
d4_rr   = rr_data(5:end,:)-rr_data(1:end-4,:);

figure(34);
datet = 2003.5:0.25:2007.25; datet=datet';
subplot(221),
plot(datet,d4_cd(:,1),'r--x','MarkerSize',10,'LineWidth',2.2),hold on,
plot(datet,d4_rr(:,1),'k-o','MarkerSize',8,'LineWidth',1.8),hold on, axis tight,
title('Annual GDP Growth','FontSize',26),
xlim = get(gca,'xlim');  %Get x range
plot([xlim(1) xlim(2)],[0 0],'k')
hold off
ylabel('%','FontSize',22)
set(gca,'FontSize',18)

subplot(222),
plot(datet,cd_data(5:end,3),'r--x','MarkerSize',10,'LineWidth',2.2),hold on,
plot(datet,rr_data(5:end,3),'k-o','MarkerSize',8,'LineWidth',1.8),hold on, axis tight,
leg = legend('Counterfactual','Data');
set(leg,'FontSize',24);
title('Interest Rate','FontSize',26),
xlim = get(gca,'xlim');  %Get x range
plot([xlim(1) xlim(2)],[0 0],'k')
hold off
ylabel('%','FontSize',22)
set(gca,'FontSize',18)

subplot(223),
plot(datet,d4_cd(:,4),'r--x','MarkerSize',10,'LineWidth',2.2),hold on,
plot(datet,d4_rr(:,4),'k-o','MarkerSize',8,'LineWidth',1.8),hold on, axis tight,
title('Annual Commercial Bank Asset Growth','FontSize',26),
xlim = get(gca,'xlim');  %Get x range
plot([xlim(1) xlim(2)],[0 0],'k')
hold off
ylabel('%','FontSize',22)
set(gca,'FontSize',18)

subplot(224),
plot(datet,d4_cd(:,5),'r--x','MarkerSize',10,'LineWidth',2.2),hold on,
plot(datet,d4_rr(:,5),'k-o','MarkerSize',8,'LineWidth',1.8),hold on, axis tight,
title('Annual Shadow Bank Asset Growth','FontSize',26),
xlim = get(gca,'xlim');  %Get x range
plot([xlim(1) xlim(2)],[0 0],'k')
hold off
ylabel('%','FontSize',22)
set(gca,'FontSize',18)



%% Counterfactual total bank assets! (Shadow+Commercial Bank assets)
cd_tot = log(exp(cd_data(:,4)) + exp(cd_data(:,5)));
rr_tot = log(exp(rr_data(:,4)) + exp(rr_data(:,5)));

d4T_cd   = cd_tot(5:end,:)-cd_tot(1:end-4,:);
d4T_rr   = rr_tot(5:end,:)-rr_tot(1:end-4,:);

figure(33);
datet = 2003.5:0.25:2007.25; datet=datet';
plot(datet,d4T_cd(:,1),'r--x','MarkerSize',12,'LineWidth',2.4),hold on,
plot(datet,d4T_rr(:,1),'k-o','MarkerSize',10,'LineWidth',2),hold on, axis tight,
leg = legend('Counterfactual','Data');
set(leg,'FontSize',28);
title('Annual Growth of Total (Commercial+Shadow) Bank Assets','FontSize',30),
xlim = get(gca,'xlim');  %Get x range
plot([xlim(1) xlim(2)],[0 0],'k')
hold off
ylabel('%','FontSize',26)
set(gca,'FontSize',24)



% figure;
% plot(test2,'k-'), hold on,
% plot(mpvars2(:,3)), hold on,
% plot(mpvars2_sign(:,3),'r-'), hold on,

 % plot the result

break;
cfactual = mpvars + me11;

figure('Name','Sign - demand - cfactual');
for i2=1:xsize
    if xsize <= 4
        plot_chol = subplot(2,2,i2);
    elseif xsize == 5 || xsize == 6
        plot_chol = subplot(3,2,i2);
    elseif xsize == 9
        plot_chol = subplot(3,3,i2);
    end
    plot(me11(1:10,i2),'k-o', 'LineWidth',2), axis tight,hold on;
    plot(cfactual(1:10,i2),'r-x', 'LineWidth',2), axis tight,hold on;
    if i2 == 1
        legend('Demand shock','Counterfactually Stronger Policy Response','FontSize',20)
    end
    %     plot(xx,zeros(1:nlagplot,1),'k-'), hold off;
    xlim = get(gca,'xlim');  %Get x range
    plot([xlim(1) xlim(2)],[0 0],'k')
    hold off
     title(labL{i2},'FontSize',24)
    ylabel('%','FontSize',24)
    set(gca,'FontSize',24)
end

%% IRF - cholesky

figure('Name','Choleski');
for i2=1:xsize
    
    me11_chol(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*0.50)))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50)))); % choleski monetary shock is the 3rd column!
    up11_chol(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandtight(2))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    lo11_chol(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandtight(1))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    up11_cholwide(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandwide(2))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    lo11_cholwide(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandwide(1))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
    
    xx = linspace(1,nlagplot,nlagplot);
    if xsize <= 4
        plot_chol = subplot(2,2,i2);
    elseif xsize == 5 || xsize == 6
        plot_chol = subplot(3,2,i2);
    elseif xsize == 9
        plot_chol = subplot(3,3,i2);
    end
    
    a_chol = shadedplot(xx, lo11_chol(:,i2)', up11_chol(:,i2)', colorgraydark, colorgraydark); hold on;
    plot(me11_chol(:,i2),'k-o', 'LineWidth',1), axis tight,grid on, hold on;
    
    a_chol = shadedplot(xx, lo11_cholwide(:,i2)', lo11_chol(:,i2)', colorgray, colorgray); hold on;
    a_chol = shadedplot(xx, up11_chol(:,i2)', up11_cholwide(:,i2)', colorgray, colorgray); hold on;
    plot(me11_chol_lag(:,i2),'r--', 'LineWidth',2), axis tight, hold on
    xlim = get(gca,'xlim');  %Get x range
    plot([xlim(1) xlim(2)],[0 0],'k')
    hold off
    
    if i2 == 1
        title('Choleski','FontSize',20);
    end
    title(lab{i2},'FontSize',20)
    
    if n == 6
        if i2==6
            xlabel('Quarters','FontSize',18)
        end
    elseif n == 9
        if i2==9
            xlabel('Quarters','FontSize',18)
        end
    end
    ylabel('%','FontSize',20)
    set(gca,'FontSize',20)
    
end
display('Now Im computing forecasting decomposition. Be patient, almost there..')
% break;
%% Forecast error variance decomposition
    
    ferror_figure_all      = forecast_figure_new(xsize,sir,nlagplot);
    ferror_figure_sort     = sort(ferror_figure_all,4);
        ferror_figure_med      = squeeze(ferror_figure_sort(:,:,:,fix(ndraws*0.50)));
        ferror_figure_up   = squeeze(ferror_figure_sort(:,:,:,fix(ndraws*0.84)));
    ferror_figure_low  = squeeze(ferror_figure_sort(:,:,:,fix(ndraws*0.16)));
    
    ferror_chol_all      = forecast_figure_new(xsize,sir_chol,nlagplot);
    ferror_figure_sort_chol     = sort(ferror_chol_all,4);
     ferror_figure_med_chol      = squeeze(ferror_figure_sort_chol(:,:,:,fix(ndraws*0.50)));
    ferror_figure_up_chol   = squeeze(ferror_figure_sort_chol(:,:,:,fix(ndraws*0.84)));
    ferror_figure_low_chol  = squeeze(ferror_figure_sort_chol(:,:,:,fix(ndraws*0.16)));
    iident =  2
    figure;
%     for iident = 1:1
        for i2=1:xsize
            if iident == 1
                med = 100*squeeze(ferror_figure_med_chol(xmon,:,i2))';
%                 med_lag = 100*squeeze(ferror_figure_med_chol_lag(xmon,:,i2))';
                
                up  = 100*squeeze(ferror_figure_up_chol(xmon,:,i2))';
                low = 100*squeeze(ferror_figure_low_chol(xmon,:,i2))';
                plot_chol = subplot(3,2,i2);
                
            elseif iident == 2
                
                med = 100*squeeze(ferror_figure_med(1,:,i2))';
%                 med_lag = 100*squeeze(ferror_figure_med_lag(1,:,i2))';
                up  = 100*squeeze(ferror_figure_up(1,:,i2))';
                low = 100*squeeze(ferror_figure_low(1,:,i2))';
                plot_sign = subplot(3,2,i2);
                
            end
            
%             ha = shadedplot(xx, low', up', [255/255 178/255 102/255], [255/255 178/255 102/255]); axis tight,hold on;
            ha = shadedplot(xx, low', up', [166/255 186/255 255/255], [166/255 186/255 255/255]); axis tight,hold on;
            plot(med(:),'k-o', 'LineWidth',1),axis tight,grid on,axis tight,  hold on,
            
            if i2 == xsize
                xlabel('Quarters','FontSize',22)
            end
            if iident == 1
                ylabel(lab{i2},'FontSize',20)
            end
            set(gca,'FontSize',22)
        end
%     end

break;
%% Historical decomposition
% define data axis
if GorL == 1
    axis_data = 1966.75+0.25*nlags:0.25:2007.25; axis_data = axis_data';
elseif GorL == 2
    axis_data = 1967.5 +0.25*nlags:0.25:2007.25; axis_data = axis_data';
elseif GorL == 3
    axis_data = 1966.5+0.25*nlags:0.25:2007.25; axis_data = axis_data';
end
% preallocate
hist_all      = zeros(Traw-nlags,n,n,ndraws);
hist_all_chol = zeros(Traw-nlags,n,n,ndraws);

% the following only rearranges the shocks and variables columns
for i_ndraws = 1:ndraws
    for i_tot = 1:n
        hist_all(:,:,i_tot,i_ndraws)      = squeeze(histall(nlags+1:end,i_tot,:,i_ndraws));
        hist_all_chol(:,:,i_tot,i_ndraws) = squeeze(histall_chol(nlags+1:end,i_tot,:,i_ndraws));
    end
end

% construct the ndraws number of datasets --> corresponding to each draw
for id = 1:ndraws
    for i_var = 1:n
        %         ddatatest(:,i_var,id) = sum((hist_all(:,:,i_var,id)),2)-hist_all(:,1,i_var,id) ;
        %         ddatatest_chol(:,i_var,id) = sum((hist_all_chol(:,:,i_var,id)),2)-hist_all_chol(:,xmon,i_var,id) ;
        ddatatest(:,i_var,id) =  hist_all(:,1,i_var,id) ;
        ddatatest_chol(:,i_var,id) =  hist_all_chol(:,xmon,i_var,id) ;
    end
end
 

%% calculate counterfactual paths
% sort to calculatre the "average" dataset
sorts  = sort(ddatatest,3);
sortc  = sort(ddatatest_chol,3);
% sort to calculatre the "average" time trend
sortts = sort(histall_trend,3);
sorttc = sort(histall_trend_chol,3);

% calculatre the "average" dataset
datas = squeeze(sorts(:,:,fix(ndraws*0.5)));
datac = squeeze(sortc(:,:,fix(ndraws*0.5)));
% calculatre the "average" time trend
ts = squeeze(sortts(:,:,fix(ndraws*0.5)));
tc = squeeze(sorttc(:,:,fix(ndraws*0.5)));

for iplot = 1:2
    if iplot == 1;
        figure('Name','Choleski shock');
    elseif iplot == 2;
        figure('Name','Sign shock');
    end
    for i_var = 1:n
        if xsize <= 4
            plot_chol = subplot(2,2,i_var);
        elseif xsize == 5 || xsize == 6
            plot_chol = subplot(3,2,i_var);
        elseif xsize == 9
            plot_chol = subplot(3,3,i_var);
        end
        if iplot == 1;
            plot(axis_data,ddata(nlags+1:end,i_var)-datac(:,i_var),'b--','LineWidth',2), hold on,axis tight,grid on,
            plot(axis_data,ddata(nlags+1:end,i_var) ,'k-','LineWidth',1.7), hold on,axis tight,grid on,
        elseif  iplot == 2;
            plot(axis_data,ddata(nlags+1:end,i_var)-datas(:,i_var),'r--','LineWidth',2), hold on,axis tight,grid on,
            plot(axis_data,ddata(nlags+1:end,i_var),'k-','LineWidth',1.7), hold on,axis tight,grid on,
%             plot(axis_data,datas(:,i_var),'r--','LineWidth',2), hold on,axis tight,grid on,
%             plot(axis_data,ddata(nlags+1:end,i_var)-ts(nlags+1:end,i_var),'k-','LineWidth',1.7), hold on,axis tight,grid on,
        end
        set(gca,'FontSize',20)
        title(lab{i_var});
        %         xlabel('Time');
        ylabel('%');
        if i_var == 1
            legend('Data-MP','Data','o')
        end
    end
end

%% Calculate the shock contributions  
% extract the MP shocks
mon_hist_all       = squeeze(hist_all(:,1,:,:));
mon_hist_all_chol  = squeeze(hist_all_chol(:,xmon,:,:));
% Sort the MP shocks to get the median
smon_hist_all      = sort(mon_hist_all,3);
smon_hist_all_chol = sort(mon_hist_all_chol,3);

% Get the median and upper lower bounds for SIGNS
monseries         =  squeeze(smon_hist_all(:,:,fix(ndraws*0.5)));
monseries_up      =  squeeze(smon_hist_all(:,:,fix(ndraws*0.68)));
monseries_lo      =  squeeze(smon_hist_all(:,:,fix(ndraws*0.32)));

% Get the median and upper lower bounds for CHOLESKY
monseries_chol    =  squeeze(smon_hist_all_chol(:,:,fix(ndraws*0.5)));
monseries_chol_up =  squeeze(smon_hist_all_chol(:,:,fix(ndraws*0.68)));
monseries_chol_lo =  squeeze(smon_hist_all_chol(:,:,fix(ndraws*0.32)));

%% Growth figure - IRF and shock contribution for 3 key variables
if models == 1
    figure('Name','Paper Figure');
    g2 = 1;
    for i_info = 1:2
        if i_info == 1
            for i2=3:5
                subplot(3,2,(i2-3)*2+1);
                
                me11_chol(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*0.50)))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50)))); % choleski monetary shock is the 3rd column!
                up11_chol(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandtight(2))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
                lo11_chol(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandtight(1))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
                
                up11_cholwide(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandwide(2))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
                lo11_cholwide(:,i2) = squeeze(sir_chol(i2,xmon,1:nlagplot,fix(ndraws*bandwide(1))))/(squeeze(sir_chol(xmon,xmon,1,fix(ndraws*0.50))));
                
                
                xx = linspace(1,nlagplot,nlagplot);
                a_chol = shadedplot(xx, lo11_chol(:,i2)', up11_chol(:,i2)', colorgraydark, colorgraydark); axis tight,hold on;
                plot(me11_chol(:,i2),'k-o', 'LineWidth',1.4), axis tight, hold on
                
                a_chol = shadedplot(xx, lo11_cholwide(:,i2)', lo11_chol(:,i2)', colorgray, colorgray); hold on;
                a_chol = shadedplot(xx, up11_chol(:,i2)', up11_cholwide(:,i2)', colorgray, colorgray); hold on;
                axis tight;
                
                xlim = get(gca,'xlim');  %Get x range
                plot([xlim(1) xlim(2)],[0 0],'k')
                hold off
                
                if i2==3
                    ylabel('Interest Rate','FontSize',23)
                elseif i2==4
                    ylabel('Commercial Bank \newline    Assets','FontSize',23)
                elseif i2==5
                    ylabel('Shadow Bank \newline    Assets','FontSize',23)
                end
                
                if i2 == 3
                    title('Impulse Responses','FontSize',22)
                end
                if i2 ==5
                    xlabel('Quarters','FontSize',20)
                end
                set(gca,'FontSize',22)
                g2 = g2+1;
            end
        elseif i_info == 2
            for i_var = 3:5
                subplot(3,2,(i_var-3)*2+2);
                bar(axis_data, (100*monseries_chol(:,i_var)),'k'), hold on,axis tight,grid on,
                if i_var == 3
                    title('Historical Contribution','FontSize',22)
                end
                set(gca,'FontSize',22)
                g2 = g2+1;
                if i_var ==5
                    xlabel('Quarters','FontSize',20)
                end
            end
        end
    end
end
%% Serutisation VAR - Bivariate models with Smets-Wouters and Romer-Romer shocks
labelshock = ['ABS-Issuers Asset Growth'
    '   GSE Asset Growth     ' ];
shockseries = ['Smets Wouters'
    ' Romer-Romer '];

% % Smets-Wouters 1966Q3 - 2004Q4
% % Romer shock (quarterly sum of monthly shocks, constructed by coibion) 1969/2 - 2008/4
auxdata_long = 1966.5:0.25:2008.75;
figure;
for ishock = 1:2
    
    nlagplot2 = 10;
    me11_secur_lag = [];
    for ivar = 1:2
        if ivar == 1 && ishock == 1
            % ABS and Smets wouters (1985q1-2004q4)
            sw_start = find(auxdata_long==1985);
            sw_end   = find(auxdata_long==2004.75);
            abs_start= find(auxdata_long==1984.75);
            abs_end  = find(auxdata_long==2004.75);
            data_rob = [swshock(sw_start:sw_end,:) diff(bank_abs(abs_start:abs_end))];
            
        elseif ivar == 1 && ishock == 2
            % ABS and Romerromer (1985q1-2008q4)
            rr_start = find(auxdata_long==1985);
            rr_end   = find(auxdata_long==2008.75);
            abs_start= find(auxdata_long==1984.75);
            abs_end  = find(auxdata_long==2008.75);
            data_rob = [rrshock(rr_start:rr_end,:) diff(bank_abs(abs_start:abs_end))];
            
        elseif ivar == 2 && ishock == 1
            % GSE and Smets wouters (1966q3-2004q4)
            sw_start = find(auxdata_long==1966.75);
            sw_end   = find(auxdata_long==2004.75);
            gse_start= find(auxdata_long==1966.5);
            gse_end  = find(auxdata_long==2004.75);
            data_rob = [swshock(sw_start:sw_end,:) diff(GSEMG(gse_start:gse_end))];
            
        elseif ivar == 2 && ishock == 2
            % GSE and Romerromer (1969q2-2008q4)
            rr_start = find(auxdata_long==1969.25);
            rr_end   = find(auxdata_long==2008.75);
            gse_start= find(auxdata_long==1969 );
            gse_end  = find(auxdata_long==2008.75);
            data_rob = [rrshock(rr_start:rr_end,:) diff(GSEMG(gse_start:gse_end))];
            
        end
        data_rob = [data_rob(:,1) data_rob(:,2).*100 ];
%            data_rob = [cumsum(data_rob(:,1)) cumsum(data_rob(:,2).*100) ];
            ttrend = 0;

        lagvalues=[2 1];
        for inlags = 1:2;
            nlags = lagvalues(inlags);
            [Traw,n]       = size(data_rob); % number of variables in the VAR
            xsize            = n;
            Y1             = gen_y(data_rob,Traw,nlags);
            X1             = gen_x_trend(data_rob,Traw,n,nlags,ttrend,c);
            [T, K]         = size(X1);              % dimensions of the endogenous matrix
            [ALPHA, SIGMA] = ols_gabor(X1,Y1,Traw,n,nlags);
            muP      = mean(Y1)';
            [ALPHA_star, Y_star, X_star, SIGMA_star] = bvar_prior_haroon(lambdaP,tauP,epsilonP,muP,Y1,X1,n,nlags,ttrend,c);
            [ALPHA_draws, SIGMA_draws] = bvar_post_haroon(ndraws,n,nlags, X_star, Y_star, ALPHA_star, ttrend, c);
            % Choleski_identification
            [histall_ch, sirall_ch, histall_trendy_chol, errors_chol] = leverage_choleski(ALPHA_draws, SIGMA_draws, n, nlags, ttrend, nimp,Y1,X1, ndraws, c);
            sirall_chol = sirall_ch ;
            if inlags == 1 ;
                sirall_chol_lag = sirall_chol;
                sir_chol2_lag   = sort(sirall_chol_lag,4);
                me11_chol2_lag  = zeros(nlagplot2,xsize);
                for i2 = 1:n
                    me11_secur_lag(:,i2) = squeeze(sir_chol2_lag(i2,1,1:nlagplot2,fix(ndraws*0.50)))./(squeeze(sir_chol2_lag(1,1,1 ,fix(ndraws*0.50)))  ); % choleski monetary shock is the 3rd column!
                end
            end
            %% Impulse responses
            % extract Choleski
            sir_chol2        = sort(sirall_chol,4);
            me11_chol2       = zeros(nlagplot2,xsize);
            up11_chol2       = zeros(nlagplot2,xsize);
            lo11_chol2       = zeros(nlagplot2,xsize);
            up11_chol2wide       = zeros(nlagplot2,xsize);
            lo11_chol2wide       = zeros(nlagplot2,xsize);
            % figure('Name','Choleski');
            for i2=1:n
                % if i2 == 1
                me11_chol2(:,i2) = squeeze(sir_chol2(i2,1,1:nlagplot2,fix(ndraws*0.50)))./(squeeze(sir_chol2(1,1,1 ,fix(ndraws*0.50)))  ); % choleski monetary shock is the 3rd column!
                up11_chol2(:,i2) = squeeze(sir_chol2(i2,1,1:nlagplot2,fix(ndraws*bandtight(2))))./(squeeze(sir_chol2(1,1,1 ,fix(ndraws*0.50)))  );
                lo11_chol2(:,i2) = squeeze(sir_chol2(i2,1,1:nlagplot2,fix(ndraws*bandtight(1))))./(squeeze(sir_chol2(1,1,1 ,fix(ndraws*0.50)))  );
                up11_chol2wide(:,i2) = squeeze(sir_chol2(i2,1,1:nlagplot2,fix(ndraws*bandwide(2))))./(squeeze(sir_chol2(1,1,1 ,fix(ndraws*0.50)))  );
                lo11_chol2wide(:,i2) = squeeze(sir_chol2(i2,1,1:nlagplot2,fix(ndraws*bandwide(1))))./(squeeze(sir_chol2(1,1,1 ,fix(ndraws*0.50)))  );
            end
            
            
        end
        results.melag = me11_secur_lag;
        results.me    = me11_chol2;
        results.up    = up11_chol2;
        results.lo    = lo11_chol2;
        results.upwide    = up11_chol2wide;
        results.lowide    = lo11_chol2wide;
        res{ivar}     = results;
    end
    
    for i = 1 :  2
        results = res{i};
        me11_chol2_lag=squeeze(results.melag(:,2));
        me11_chol2=squeeze(results.me(:,2)) ; % choleski monetary shock is the 2rd column!
        up11_chol2=squeeze(results.up(:,2) );
        lo11_chol2=squeeze(results.lo(:,2)) ;
        up11_chol2wide=squeeze(results.upwide(:,2) );
        lo11_chol2wide=squeeze(results.lowide(:,2)) ;
        
        xx = linspace(1,nlagplot2,nlagplot2);
        plot_chol = subplot(2,2,i+(ishock-1)*2);
        a_chol = shadedplot(xx, lo11_chol2', up11_chol2', colorgraydark, colorgraydark);  hold on;
        plot(me11_chol2,'k-o', 'LineWidth',1),   hold on,
        
        a_chol = shadedplot(xx, lo11_chol2wide', lo11_chol2', colorgray, colorgray); hold on;
        a_chol = shadedplot(xx, up11_chol2', up11_chol2wide', colorgray, colorgray); hold on;
        plot(me11_chol2_lag,'r--', 'LineWidth',2), axis tight, hold on
        
        xlim = get(gca,'xlim');  %Get x range
        plot([xlim(1) xlim(2)],[0 0],'k')
        hold off
        
        if ishock == 1
            title(labelshock(i,:),'FontSize',26)
        elseif ishock == 2
            xlabel('Quarters','FontSize',24)
        end
        if i ~= 1
            ylabel('%','FontSize',24)
        elseif i == 1 && ishock == 1
            ylabel('Smets-Wouters \newline         %','FontSize',24)
        elseif i == 1 && ishock == 2
            ylabel('Romer-Romer \newline         %','FontSize',24)
        end
        set(gca,'FontSize',24)
    end
end
toc;
