%% Creates matrices of dummy observations [...];
% lamda tightness parameter
% tau prior on sum of coefficients
% delta prior mean for VAR coefficients
% epsilon tigtness of the prior around constant
% mu sample mean of the data
% sigma AR residual variances for the data
% Initialise output (necessary for final concatenation to work when tau=0):

%%
function [y,x] = create_dummies_gabor(lamda,tau,delta,epsilon,p,mu,sigma,n,ttrend,constant)

x   = [];
y   = [];
yd1 = [];
yd2 = [];
xd1 = [];
xd2 = [];

%% Get dummy matrices in equation (5) of Banbura et al. 2007:
if lamda>0
    if epsilon > 0
        yd1 = [diag(sigma.*delta)./lamda;
            zeros(n*(p-1),n);
            diag(sigma);
            zeros(1,n)];
        jp = diag(1:p);
        
        if constant == 1       % add constant
            if ttrend == 1     % if trend, add an extra column
                xd1 = [zeros((n*p),2) kron(jp,diag(sigma)./lamda) ;
                    zeros(n,(n*p)+2);
                    epsilon epsilon zeros(1,n*p) ];
            elseif ttrend == 2    % if trend, and quadratic trend, then add two extra columns
                xd1 = [zeros((n*p),3) kron(jp,diag(sigma)./lamda)  ;
                    zeros(n,(n*p)+3);
                    epsilon epsilon epsilon zeros(1,n*p) ];
            elseif ttrend == 0
                xd1 = [zeros((n*p),1) kron(jp,diag(sigma)./lamda) ;
                    zeros(n,(n*p)+1);
                     epsilon zeros(1,n*p) ];
            end
        else                   % no constant in the VAR!
            if ttrend == 1     % if trend, add an extra column
                xd1 = [zeros((n*p),1) kron(jp,diag(sigma)./lamda) ;
                    zeros(n,(n*p)+1);
                    epsilon zeros(1,n*p) ];
            elseif ttrend == 2    % if trend, and quadratic trend, then add two extra columns
                xd1 = [zeros((n*p),2) kron(jp,diag(sigma)./lamda) ;
                    zeros(n,(n*p)+2);
                    epsilon epsilon zeros(1,n*p) ];
            elseif ttrend == 0
                xd1 = [ kron(jp,diag(sigma)./lamda) ;
                    zeros(n,(n*p));
                    zeros(1,n*p) ];
            end
        end
        
%                 if constant == 1       % add constant
%             if ttrend == 1     % if trend, add an extra column
%                 xd1 = [kron(jp,diag(sigma)./lamda) zeros((n*p),2);
%                     zeros(n,(n*p)+2);
%                     zeros(1,n*p) epsilon epsilon];
%             elseif ttrend == 2    % if trend, and quadratic trend, then add two extra columns
%                 xd1 = [kron(jp,diag(sigma)./lamda) zeros((n*p),3) ;
%                     zeros(n,(n*p)+3);
%                     zeros(1,n*p) epsilon epsilon epsilon];
%             else
%                 xd1 = [ kron(jp,diag(sigma)./lamda) zeros((n*p),1);
%                     zeros(n,(n*p)+1);
%                      zeros(1,n*p) epsilon];
%             end
%         else                   % no constant in the VAR!
%             if ttrend == 1     % if trend, add an extra column
%                 xd1 = [kron(jp,diag(sigma)./lamda) zeros((n*p),1);
%                     zeros(n,(n*p)+1);
%                     zeros(1,n*p) epsilon];
%             elseif ttrend == 2    % if trend, and quadratic trend, then add two extra columns
%                 xd1 = [kron(jp,diag(sigma)./lamda) zeros((n*p),2);
%                     zeros(n,(n*p)+2);
%                     zeros(1,n*p) epsilon epsilon];
%             else
%                 xd1 = [ kron(jp,diag(sigma)./lamda) ;
%                     zeros(n,(n*p));
%                     zeros(1,n*p) ];
%             end
%         end
        
    else
        yd1=[diag(sigma.*delta)./lamda;
            zeros(n*(p-1),n);
            diag(sigma)];
        jp=diag(1:p);
        
        xd1=[kron(jp,diag(sigma)./lamda);
            zeros(n,(n*p))]; 
    end
end
%% Get additional dummy matrices - see equation (9) of Banbura et al. 2007:
if tau>0
    if epsilon>0
        yd2=diag(delta.*mu)./tau;
        if constant == 1 
        if ttrend == 1
            xd2=[zeros(n,2) kron(ones(1,p),yd2)];
        elseif ttrend == 0
            xd2=[zeros(n,1) kron(ones(1,p),yd2)];
        elseif ttrend == 2
            xd2=[zeros(n,3) kron(ones(1,p),yd2)];
        end
        elseif constant == 0
        if ttrend == 1
            xd2=[zeros(n,1) kron(ones(1,p),yd2)];
        elseif ttrend == 0
            xd2=[ kron(ones(1,p),yd2)];
        elseif ttrend == 2
            xd2=[zeros(n,2) kron(ones(1,p),yd2)];
        end  
        end
    else
        yd2=diag(delta.*mu)./tau;
        xd2=[kron(ones(1,p),yd2)];  
    end
end
     
%% 
y=[yd1;yd2];
x=[xd1;xd2];
 
         
 
 