function [ALPHA_star Y_star X_star SIGMA_star yd xd ixx] = bvar_prior_haroon(lamdaP, tauP, epsilonP, muP, Y1, X1,n,nlags, ttrend, constant)

sigmaP=[];
deltaP=[];

% calculate the AR coefficients

for i=1:n
    ytemp=Y1(:,i);
    xtemp=[lag0(ytemp,1) ones(rows(ytemp),1)];
    ytemp=ytemp(2:end,:);
    xtemp=xtemp(2:end,:);
    btemp=xtemp\ytemp;
    etemp=ytemp-xtemp*btemp;
    stemp=etemp'*etemp/rows(ytemp);
    deltaP=[deltaP;btemp(1)];
    sigmaP=[sigmaP;stemp];
end

deltaP(deltaP>1) = 1; % this changes the prior on the explosives ones to 1!
% imposte unit root because data in levels:
deltaP = ones((size(Y1,2)),1);

%dummy data to implement priors see http://ideas.repec.org/p/ecb/ecbwps/20080966.html
[yd,xd] = create_dummies_gabor(lamdaP,tauP,deltaP,epsilonP,nlags,muP,sigmaP,n,ttrend,constant);

%yd and xd are the dummy data. Append this to actual data
  Y_star = [Y1;yd];
  X_star = [X1;xd];
  ALPHA_star = X_star\Y_star;

xx=X_star'*X_star;
ixx=xx\eye(cols(xx)); %inv(X0'X0) to be used later in the Gibbs sampling algorithm
  
Tstar = size(Y_star,1);
  
SSE_star        = (Y_star - X_star * ALPHA_star)' * (Y_star - X_star * ALPHA_star);
SIGMA_star      = SSE_star./Tstar;