%% this file generates the posterior from inverse Wishart
function [ALPHA_draws,SIGMA_draws] = bvar_post_haroon(ndraws,n,nlags, X_star, Y_star, ALPHA_star,ttrend, constant)

Tstar = size(X_star,1);

if constant == 1
    if ttrend == 1
        K  = n * nlags + 2;
        c  = 2;
    elseif ttrend == 2
        K  = n * nlags + 3;
        c  = 3;
    else
        K  = n * nlags + 1;
        c  = 1;
    end
else
    if ttrend == 1
        K  = n * nlags + 1;
        c  = 1;
    elseif ttrend == 2
        K  = n * nlags + 2;
        c  = 2;
    else
        K  = n * nlags ;
        c  = 0;
    end
end

BURN = 10000;

ALPHA_draws = zeros(ndraws,K,n);
SIGMA_draws = zeros(ndraws,n,n);

% while ii<=ndraws
        
SSE_star   = (Y_star - X_star * ALPHA_star)' * (Y_star - X_star * ALPHA_star);
sigma      = SSE_star./Tstar;    % Haroon's initial value of sigma

ii = 1;         % this will be the actual saved matrix
ii_pass = 1;    % this will be the "burnt" matrices in-between
ii_alpha = 0;   % coordinate for saving the draw

while ii_alpha <  ndraws 
    M      = vec(ALPHA_star);
    V      = kron(sigma, inv(X_star'*X_star));
    beta   = M + (randn(1,n * (n*nlags + c))*chol(V))';
    e      = Y_star - X_star * reshape(beta,n*nlags+c,n);
    scale  = e' * e;
%     scale1 = scale+eye(n);
%     sigma  = inv(wish(inv(scale),Tstar));
     sigma  = iwpq(Tstar, inv(scale));
    
    ALPHA_test = reshape(beta,n*nlags+c,n);
    BB2        = companion2_trend(ALPHA_test,n,nlags,ttrend,constant);
    if abs(max(eig(BB2)))<1
        ii_pass = ii_pass + 1;
        if ii_pass > BURN   % we have burnt the first "BURN" number
            ii = ii + 1;    % start saving matrices
            if ii == 10      % but save only every 10th!
            ii_alpha = ii_alpha+1;
            ALPHA_draws(ii_alpha,:,:) = ALPHA_test;
            SIGMA_draws(ii_alpha,:,:) = sigma;
            ii = 1;         % reset the "4th"-measure
            end
        end
    end
end
% BVARout.ALPHA_draws = ALPHA_draws;
% BVARout.SIGMA_draws = SIGMA_draws;