%% this file generates the posterior from inverse Wishart
% using Haroon's code

function mlik = bvar_Mdensity(bvar)

bsave  = bvar.bsave;
ssave  = bvar.ssave;
fsave  = bvar.fsave;
ex     = bvar.ex;
L      = bvar.L   ;
c      = bvar.c      ;
ttrend = bvar.ttrend ;
N      = bvar.n   ;
xd     = bvar.xd      ;
yd     = bvar.yd      ;
ixx    = bvar.ixx;
Y      = bvar.Y ;
X      = bvar.X ;
Y0     = [Y;yd];
X0     = [X;xd];
mstar  = vec(X0\Y0);  %ols on the appended data

%% marginal likelihood
betam=squeeze(mean(bsave,1));
sigmam=squeeze(mean(ssave,1));

%% Step 1: evaluate priors
b0=vec(xd\yd);
b01=reshape(b0,N*L+ex,N);
e0=yd-xd*b01;
S=e0'*e0;

%evaluate log prior distribution for VAR coefficients
bp = multivariatenormal(betam',b0,kron(S,pinv(xd'*xd)));
%evaluate log prior for VAR covariance
sp = invwishpdf(sigmam,S,size(yd,1)-size(xd,2));

%% Step 2: likelihood
B00=[Y(1,:) zeros(1,N*(L-1))];
P00=eye(cols(B00)).*0.0001;
scle=1;
[beta_tt,lik]=kfiltervartest_gab(Y,vec(betam),sigmam,B00,P00,L,ex,scle);
%evaluate H(Bstar\sigmastar);
vstar1=kron(sigmam,ixx);
H1=multivariatenormal(betam',mstar,vstar1);
%evaluate H(sigmastar\beta[j])
Y0=[Y;yd];
X0=[X;xd];
H2i=[];
for j=1:size(bsave,1)
    betaj=bsave(j,:);
    e=Y0-X0*reshape(betaj,N*L+1,N);
    scale=e'*e;
    H2i= [H2i;invwishpdf(sigmam,scale,size(Y0,1))];
end
%take mean taking care of possible underflow/overflow with exp

H2m=safemean(H2i);

%% Step 3: marginal likelihood
mlik=lik+bp+sp-H1-H2m;

disp(sprintf('Log Marginal likelihood is %s',num2str(mlik)));