function [residual, g1, g2] = NKShadow_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                     columns: variables in declaration order
%                                                     rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 49, 1);

%
% Model equations
%

T222 = (1-params(30)-params(31))*params(14)*1/params(5);
T379 = (-((-params(2))*(1/(1-params(3))-params(3)/(1-params(3)))));
T396 = 1-(1/(1+params(5))+params(5)/(1+params(5)));
residual(1) = y(2)-y(3);
lhs =y(1);
rhs =(-params(2))*(1/(1-params(3))*y(4)-y(4)*params(3)/(1-params(3)));
residual(2)= lhs-rhs;
lhs =y(5);
rhs =1/params(4)*y(6)-y(1);
residual(3)= lhs-rhs;
lhs =y(7);
rhs =params(1)*y(8)+y(6)*(1-params(1));
residual(4)= lhs-rhs;
lhs =y(9);
rhs =y(5)-(y(7)-y(6));
residual(5)= lhs-rhs;
lhs =y(9);
rhs =y(14)-(y(7)-y(8));
residual(6)= lhs-rhs;
lhs =params(22)*(y(10)+y(11));
rhs =y(14)*(params(22)-(1-params(8)))+y(10)*(1-params(8));
residual(7)= lhs-rhs;
lhs =y(3)-y(3)*params(6);
rhs =(y(3)-y(3)*params(6))*params(5)+y(9)*params(7);
residual(8)= lhs-rhs;
lhs =y(12);
rhs =y(12)*1/(1+params(5))+y(12)*params(5)/(1+params(5))+y(10)*1/params(12);
residual(9)= lhs-rhs;
lhs =y(8);
rhs =y(8)*(1-params(8))+params(8)*y(12);
residual(10)= lhs-rhs;
lhs =y(7);
rhs =y(4)*params(27)+y(12)*(1-params(27));
residual(11)= lhs-rhs;
lhs =y(2)-y(3);
rhs =y(13);
residual(12)= lhs-rhs;
lhs =y(2);
rhs =y(2)*params(9)+(1-params(9))*(y(3)*params(10)+params(11)*y(26))+y(45);
residual(13)= lhs-rhs;
lhs =y(8);
rhs =params(41)*y(36)+(1-params(41))*y(27);
residual(14)= lhs-rhs;
lhs =y(10)+y(27);
rhs =params(13)*y(28)+(1-params(13))*(y(29)+y(30));
residual(15)= lhs-rhs;
lhs =params(13)*y(28);
rhs =params(22)*(params(14)+params(15))*(y(10)+y(11)+y(27))-(1-params(13))*params(14)*params(16)*(y(30)+y(29)+y(31));
residual(16)= lhs-rhs;
lhs =params(17)*params(18)*y(32)-params(18)*params(19)*(y(32)+y(33));
rhs =params(19)*y(33);
residual(17)= lhs-rhs;
lhs =(y(10)+y(27))*params(17)-params(19)*(y(27)+y(10)+y(33));
rhs =params(13)*params(20)*(y(28)+y(34));
residual(18)= lhs-rhs;
lhs =params(21)*y(35);
rhs =y(34)*params(20)*params(14)*(1+params(18))+y(32)*params(18)*params(14)*params(20);
residual(19)= lhs-rhs;
lhs =y(34);
rhs =y(31)+y(35);
residual(20)= lhs-rhs;
lhs =params(19)*y(33);
rhs =y(35)*params(5)*params(21)*(params(22)-params(16))+params(5)*params(21)*(params(22)*y(11)-params(16)*y(31));
residual(21)= lhs-rhs;
lhs =params(16)*(y(29)+y(31));
rhs =y(14)*(params(16)-(1-params(8)))+(1-params(8))*y(29);
residual(22)= lhs-rhs;
lhs =y(30);
rhs =y(37);
residual(23)= lhs-rhs;
lhs =y(10)+y(36)+params(30)*(y(29)+y(37));
rhs =(1-params(30)-params(31))*y(38)+params(31)*y(39);
residual(24)= lhs-rhs;
lhs =params(31)*y(39);
rhs =(params(14)+params(33))*(params(22)*(y(10)+y(11)+y(36))+params(16)*params(30)*(y(29)+y(31)+y(37)))-T222*(y(13)+y(38));
residual(25)= lhs-rhs;
lhs =params(34)*params(35)*params(36)*y(40)-params(36)*params(37)*(y(40)+y(41));
rhs =params(37)*y(41);
residual(26)= lhs-rhs;
lhs =(y(10)+y(36))*(params(34)*params(35)-params(37))-params(37)*y(41);
rhs =y(39)*params(31)*(params(38)-params(34)*(1-params(35)))+y(38)*(params(38)-params(39)-params(34)*(1-params(35)))*params(32)+params(38)*(params(31)+params(32))*y(42)-params(39)*params(32)*y(43);
residual(27)= lhs-rhs;
lhs =y(40)*params(36)*(params(38)-params(39))+(1+params(36))*(params(38)*y(42)-params(39)*y(43));
rhs =y(40)*params(36)*params(34)*(1-params(35));
residual(28)= lhs-rhs;
lhs =params(40)*y(44);
rhs =y(43)*params(39)*params(14)*(1+params(36))+y(40)*params(39)*params(14)*params(36);
residual(29)= lhs-rhs;
lhs =y(42);
rhs =y(31)+y(44);
residual(30)= lhs-rhs;
lhs =params(37)*y(41);
rhs =(params(22)*y(11)-params(16)*y(31))*params(5)*params(40)+y(44)*(params(22)-params(16))*params(5)*params(40);
residual(31)= lhs-rhs;
lhs =y(43);
rhs =y(13)+y(44);
residual(32)= lhs-rhs;
lhs =y(26);
rhs =y(7)-y(19);
residual(33)= lhs-rhs;
residual(34) = y(24);
lhs =y(15);
rhs =(-params(2))*(1/(1-params(3))*y(16)-params(3)/(1-params(3))*y(16));
residual(35)= lhs-rhs;
lhs =y(17);
rhs =1/params(4)*y(18)-y(15);
residual(36)= lhs-rhs;
lhs =y(19);
rhs =params(1)*y(20)+(1-params(1))*y(18);
residual(37)= lhs-rhs;
lhs =0;
rhs =y(17)-(y(19)-y(18));
residual(38)= lhs-rhs;
lhs =0;
rhs =y(25)-(y(19)-y(20));
residual(39)= lhs-rhs;
lhs =params(22)*(y(21)+y(22));
rhs =(params(22)-(1-params(8)))*y(25)+(1-params(8))*y(21);
residual(40)= lhs-rhs;
lhs =y(23);
rhs =1/(1+params(5))*y(23)+params(5)/(1+params(5))*y(23)+1/params(12)*y(21);
residual(41)= lhs-rhs;
lhs =y(20);
rhs =(1-params(8))*y(20)+params(8)*y(23);
residual(42)= lhs-rhs;
lhs =y(19);
rhs =params(27)*y(16)+(1-params(27))*y(23);
residual(43)= lhs-rhs;
lhs =y(22);
rhs =y(24);
residual(44)= lhs-rhs;
lhs =y(45);
rhs =params(42)*x(1);
residual(45)= lhs-rhs;
lhs =y(46);
rhs =y(11)-y(13);
residual(46)= lhs-rhs;
lhs =y(47);
rhs =y(10)+y(27);
residual(47)= lhs-rhs;
lhs =y(48);
rhs =y(10)+y(36);
residual(48)= lhs-rhs;
lhs =y(49);
rhs =y(36)*1/(1+params(30))+y(37)*params(30)/(1+params(30));
residual(49)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(49, 49);

  %
  % Jacobian matrix
  %

  g1(1,2)=1;
  g1(1,3)=(-1);
  g1(2,1)=1;
  g1(2,4)=T379;
  g1(3,1)=1;
  g1(3,5)=1;
  g1(3,6)=(-(1/params(4)));
  g1(4,6)=(-(1-params(1)));
  g1(4,7)=1;
  g1(4,8)=(-params(1));
  g1(5,5)=(-1);
  g1(5,6)=(-1);
  g1(5,7)=1;
  g1(5,9)=1;
  g1(6,7)=1;
  g1(6,8)=(-1);
  g1(6,9)=1;
  g1(6,14)=(-1);
  g1(7,10)=params(22)-(1-params(8));
  g1(7,11)=params(22);
  g1(7,14)=(-(params(22)-(1-params(8))));
  g1(8,3)=1-params(6)-params(5)*(1-params(6));
  g1(8,9)=(-params(7));
  g1(9,10)=(-(1/params(12)));
  g1(9,12)=T396;
  g1(10,8)=1-(1-params(8));
  g1(10,12)=(-params(8));
  g1(11,4)=(-params(27));
  g1(11,7)=1;
  g1(11,12)=(-(1-params(27)));
  g1(12,2)=1;
  g1(12,3)=(-1);
  g1(12,13)=(-1);
  g1(13,2)=1-params(9);
  g1(13,3)=(-((1-params(9))*params(10)));
  g1(13,26)=(-((1-params(9))*params(11)));
  g1(13,45)=(-1);
  g1(14,8)=1;
  g1(14,27)=(-(1-params(41)));
  g1(14,36)=(-params(41));
  g1(15,10)=1;
  g1(15,27)=1;
  g1(15,28)=(-params(13));
  g1(15,29)=(-(1-params(13)));
  g1(15,30)=(-(1-params(13)));
  g1(16,10)=(-(params(22)*(params(14)+params(15))));
  g1(16,11)=(-(params(22)*(params(14)+params(15))));
  g1(16,27)=(-(params(22)*(params(14)+params(15))));
  g1(16,28)=params(13);
  g1(16,29)=(1-params(13))*params(14)*params(16);
  g1(16,30)=(1-params(13))*params(14)*params(16);
  g1(16,31)=(1-params(13))*params(14)*params(16);
  g1(17,32)=params(17)*params(18)-params(18)*params(19);
  g1(17,33)=(-(params(18)*params(19)))-params(19);
  g1(18,10)=params(17)-params(19);
  g1(18,27)=params(17)-params(19);
  g1(18,28)=(-(params(13)*params(20)));
  g1(18,33)=(-params(19));
  g1(18,34)=(-(params(13)*params(20)));
  g1(19,32)=(-(params(18)*params(14)*params(20)));
  g1(19,34)=(-(params(20)*params(14)*(1+params(18))));
  g1(19,35)=params(21);
  g1(20,31)=(-1);
  g1(20,34)=1;
  g1(20,35)=(-1);
  g1(21,11)=(-(params(22)*params(5)*params(21)));
  g1(21,31)=(-(params(5)*params(21)*(-params(16))));
  g1(21,33)=params(19);
  g1(21,35)=(-(params(5)*params(21)*(params(22)-params(16))));
  g1(22,14)=(-(params(16)-(1-params(8))));
  g1(22,29)=params(16)-(1-params(8));
  g1(22,31)=params(16);
  g1(23,30)=1;
  g1(23,37)=(-1);
  g1(24,10)=1;
  g1(24,29)=params(30);
  g1(24,36)=1;
  g1(24,37)=params(30);
  g1(24,38)=(-(1-params(30)-params(31)));
  g1(24,39)=(-params(31));
  g1(25,10)=(-(params(22)*(params(14)+params(33))));
  g1(25,11)=(-(params(22)*(params(14)+params(33))));
  g1(25,13)=T222;
  g1(25,29)=(-((params(14)+params(33))*params(16)*params(30)));
  g1(25,31)=(-((params(14)+params(33))*params(16)*params(30)));
  g1(25,36)=(-(params(22)*(params(14)+params(33))));
  g1(25,37)=(-((params(14)+params(33))*params(16)*params(30)));
  g1(25,38)=T222;
  g1(25,39)=params(31);
  g1(26,40)=params(34)*params(35)*params(36)-params(36)*params(37);
  g1(26,41)=(-(params(36)*params(37)))-params(37);
  g1(27,10)=params(34)*params(35)-params(37);
  g1(27,36)=params(34)*params(35)-params(37);
  g1(27,38)=(-((params(38)-params(39)-params(34)*(1-params(35)))*params(32)));
  g1(27,39)=(-(params(31)*(params(38)-params(34)*(1-params(35)))));
  g1(27,41)=(-params(37));
  g1(27,42)=(-(params(38)*(params(31)+params(32))));
  g1(27,43)=params(39)*params(32);
  g1(28,40)=params(36)*(params(38)-params(39))-params(36)*params(34)*(1-params(35));
  g1(28,42)=params(38)*(1+params(36));
  g1(28,43)=(1+params(36))*(-params(39));
  g1(29,40)=(-(params(39)*params(14)*params(36)));
  g1(29,43)=(-(params(39)*params(14)*(1+params(36))));
  g1(29,44)=params(40);
  g1(30,31)=(-1);
  g1(30,42)=1;
  g1(30,44)=(-1);
  g1(31,11)=(-(params(22)*params(5)*params(40)));
  g1(31,31)=(-(params(5)*params(40)*(-params(16))));
  g1(31,41)=params(37);
  g1(31,44)=(-((params(22)-params(16))*params(5)*params(40)));
  g1(32,13)=(-1);
  g1(32,43)=1;
  g1(32,44)=(-1);
  g1(33,7)=(-1);
  g1(33,19)=1;
  g1(33,26)=1;
  g1(34,24)=1;
  g1(35,15)=1;
  g1(35,16)=T379;
  g1(36,15)=1;
  g1(36,17)=1;
  g1(36,18)=(-(1/params(4)));
  g1(37,18)=(-(1-params(1)));
  g1(37,19)=1;
  g1(37,20)=(-params(1));
  g1(38,17)=(-1);
  g1(38,18)=(-1);
  g1(38,19)=1;
  g1(39,19)=1;
  g1(39,20)=(-1);
  g1(39,25)=(-1);
  g1(40,21)=params(22)-(1-params(8));
  g1(40,22)=params(22);
  g1(40,25)=(-(params(22)-(1-params(8))));
  g1(41,21)=(-(1/params(12)));
  g1(41,23)=T396;
  g1(42,20)=1-(1-params(8));
  g1(42,23)=(-params(8));
  g1(43,16)=(-params(27));
  g1(43,19)=1;
  g1(43,23)=(-(1-params(27)));
  g1(44,22)=1;
  g1(44,24)=(-1);
  g1(45,45)=1;
  g1(46,11)=(-1);
  g1(46,13)=1;
  g1(46,46)=1;
  g1(47,10)=(-1);
  g1(47,27)=(-1);
  g1(47,47)=1;
  g1(48,10)=(-1);
  g1(48,36)=(-1);
  g1(48,48)=1;
  g1(49,36)=(-(1/(1+params(30))));
  g1(49,37)=(-(params(30)/(1+params(30))));
  g1(49,49)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],49,2401);
end
end
