% NK Macro model with commercial and shadow banks
% Ben Nelson, September 2016

close all

var
% macro
uc
i
pi
c
w
l
y
k
m
q
rk
in
r
z

% flex price
ucf
cf
wf
lf
yf
kf
qf
rkf
innf
rf
zf
ygap 

% add shadow banks
sb nb qm mb rm lambdab mub vb omgb

% add commercial banks
sc mc d nc lambdac muc vmc vdc omgc

% shocks
eps_i

% definitions
spr
sbq 
scq 
cbassets % commercial bank total assets (book value)
;

varexo shk_i ;

parameters calpha sigma h frisch cbeta gamma lambda delta rho_i phi_pi phi_y invelast
Nb_Sb SIGMA XIb Rm THETAb LAMBDAb MUb Vb OMEGAb Rk R K_Y K QM c_y Sc Sb
Mc_Sc Nc_Sc D_Sc XIc THETAc omega LAMBDAc MUc VMc VDc OMEGAc Sc_K

csigmashk_i;

% macro parameters
calpha   = 0.30  ;         % capital share
sigma   = 1.00  ;         % time preference
h       = 0.85  ;         % habit
frisch  = 1/0.30  ;         % inverse frisch
cbeta    = (1.04)^-(1/4);  % discount
gamma   = 0.15  ;         % inflation indexation
lambda  = 0.03  ;         % phillips curve slope
delta   = 0.025 ;         % capital depreciation
rho_i   = 0.80  ;         % interest rate smoothing
phi_pi  = 1.50  ;         % inflation response
phi_y   = 0.125 ;         % output gap response
invelast= 1.00  ;         % investment elasticity

% calibration targets for the banking blocks:
Nb_Sb = 0.1  ;            % Shadow bank capital ratio (1/leverage)
SIGMA = 0.9  ;            % Banker survival time (applies to both types -> may want to vary by type)
Rm = 0.0025/4 + cbeta^-1 ; % Return on ABS (spread over risk free)
Rk = 0.0100/4 + cbeta^-1 ; % Return on capital (spread over risk free)
Mc_Sc = 0.30 ;            % Share of ABS in commercial bank portfolio
Nc_Sc = 0.25 ;            % Capital ratio of "real economy" lending by commercial bank
csigmashk_i = 0.25;

% steady state values - shadow banks
XIb     = ( Nb_Sb + SIGMA*Rm*(1-Nb_Sb) - SIGMA*Rk ) / Rk ;
LAMBDAb = ( (Rk-Rm)/Rm )*(1/Nb_Sb) ;
OMEGAb  = (1-SIGMA)/(1 - SIGMA*(1+LAMBDAb)*cbeta*Rm ) ;
Vb      = cbeta*OMEGAb*Rm ;
MUb     = cbeta*OMEGAb*(Rk - Rm);
THETAb  = MUb + MUb/LAMBDAb ;

% steady state values - commercial banks
R = cbeta^-1 ;
D_Sc = 1 + Mc_Sc - Nc_Sc ;
XIc = (Nc_Sc + SIGMA*R*D_Sc - SIGMA*(Rk + Rm*Mc_Sc)) / (Rk + Rm*Mc_Sc) ;
omega = (Rk - Rm) / (Rk - R) ;
LAMBDAc = ( (Rk-R)/R )*( omega+ (1-omega)*(Nc_Sc + D_Sc))/Nc_Sc ;
OMEGAc = (1-SIGMA)/(1-SIGMA*(1+LAMBDAc)) ;
VMc = cbeta*OMEGAc*Rm ;
VDc = cbeta*OMEGAc*R ;
MUc = cbeta*OMEGAc*(Rk-Rm) ;
THETAc = (MUc/omega)*(1 + (1/LAMBDAc)) ;

% steady state values - macro stuff 
K_Y = calpha / (Rk - (1-delta)) ;
K = (2/3)*( K_Y^(1/(1-calpha)) ) ;
QM = K*(1 - Nb_Sb) / ( 1 + (1/Mc_Sc)*(1 - Nb_Sb) ) ;
Sc = (1/Mc_Sc)*QM ;
Sb = K - Sc ;
Sc_K = Sc / K ;
c_y = 1 - calpha*delta/(Rk - (1-delta)); 

model(linear);
% # Rk = cbeta^-1 ;

% sticky price model
uc(+1) - uc + i - pi(+1) = 0 ;

uc = -sigma*( (1/(1-h))*c - (h/(1-h))*c(-1) ) ;

w = (1/frisch)*l - uc ;

y = calpha*k(-1) + (1-calpha)*l ;

m = w - (y - l ) ;

m = z - (y - k(-1)) ;

Rk*(q(-1) + rk) = (Rk - (1-delta))*z + (1-delta)*q ;

pi - gamma*pi(-1) = cbeta*(pi(+1) - gamma*pi) + lambda*m ;

in = (1/(1+cbeta))*in(-1) + (cbeta/(1+cbeta))*in(+1) + (1/invelast)*q ;

k = (1-delta)*k(-1) + delta*in ;

y = c_y*c + (1-c_y)*in ;

i - pi(+1) = r ;

i = rho_i*i(-1) + (1-rho_i)*( phi_pi*pi + phi_y*ygap ) + eps_i ;

% rk(+1) = r ;
k = Sc_K*sc + (1-Sc_K)*sb ;

% shadow banks - parameters: Nb_Sb SIGMA XIb Rm THETAb LAMBDAb MUb Vb OMEGAb
q + sb = Nb_Sb*nb + (1-Nb_Sb)*( qm + mb ) ;

Nb_Sb*nb = (SIGMA+XIb)*Rk*( rk + q(-1) + sb(-1) ) - SIGMA*Rm*(1-Nb_Sb)*( rm + qm(-1) + mb(-1) ) ;

THETAb*LAMBDAb*lambdab - MUb*LAMBDAb*( mub + lambdab ) = MUb*mub ;

THETAb*(q + sb) - MUb*( mub + q + sb ) = Vb*Nb_Sb*( vb + nb ) ;

OMEGAb*omgb = SIGMA*(1+LAMBDAb)*Vb*vb + SIGMA*Vb*LAMBDAb*lambdab ;

vb = uc(+1) - uc + omgb(+1) + rm(+1) ;

MUb*mub = cbeta*OMEGAb*(Rk-Rm)*( uc(+1) - uc + omgb(+1) ) + cbeta*OMEGAb*(Rk*rk(+1) - Rm*rm(+1)) ;

Rm*(qm(-1) + rm ) = (Rm - (1-delta))*z + (1-delta)*qm ;

mb = mc ;

% commercial banks - sc mc d nc lambdac muc vmc vdc omgc
% parameters: Mc_Sc Nc_Sc D_Sc XIc THETAc omega LAMBDAc MUc VMc VDc OMEGAc
q + sc + Mc_Sc*( qm + mc ) = (1-Mc_Sc-Nc_Sc)*d + Nc_Sc*nc ;

Nc_Sc*nc = (SIGMA+XIc)*( Rk*(rk + q(-1) + sc(-1) ) + Rm*Mc_Sc*( rm + qm(-1) + mc(-1) ))
                  - SIGMA*(1/cbeta)*(1-Mc_Sc-Nc_Sc)*( r(-1) + d(-1) ) ;

THETAc*omega*LAMBDAc*lambdac - MUc*LAMBDAc*( muc + lambdac ) = MUc*muc ;
                  
(THETAc*omega - MUc)*(q + sc) - MUc*muc = (VMc - THETAc*(1-omega))*Nc_Sc*nc
 + (VMc - VDc - THETAc*(1-omega))*D_Sc*d + VMc*(Nc_Sc+D_Sc)*vmc - VDc*D_Sc*vdc ;
 
(VMc - VDc)*LAMBDAc*lambdac + (1+LAMBDAc)*(VMc*vmc - VDc*vdc) = THETAc*(1-omega)*LAMBDAc*lambdac ;

OMEGAc*omgc = SIGMA*(1+LAMBDAc)*VDc*vdc + SIGMA*LAMBDAc*VDc*lambdac ;

vmc = uc(+1) - uc + omgc(+1) + rm(+1) ;

MUc*muc = cbeta*OMEGAc*(Rk*rk(+1) - Rm*rm(+1)) + cbeta*OMEGAc*(Rk-Rm)*( uc(+1) - uc + omgc(+1) ) ;
 
vdc = uc(+1) - uc + omgc(+1) + r ;

% Flexible price economy / without financial frictions either
ygap = y - yf ;

ucf(+1) - ucf + rf = 0 ;

ucf = -sigma*( (1/(1-h))*cf - (h/(1-h))*cf(-1) ) ;

wf = (1/frisch)*lf - ucf ;

yf = calpha*kf(-1) + (1-calpha)*lf ;

0 = wf - (yf - lf ) ;

0 = zf - (yf - kf(-1)) ;

Rk*(qf(-1) + rkf) = (Rk - (1-delta))*zf + (1-delta)*qf ;

innf = (1/(1+cbeta))*innf(-1) + (cbeta/(1+cbeta))*innf(+1) + (1/invelast)*qf ;

kf = (1-delta)*kf(-1) + delta*innf ;

yf = c_y*cf + (1-c_y)*innf ;

rkf(+1) = rf ;

% Shock processes
eps_i = csigmashk_i * shk_i ;

% definitions
spr = rk(+1) - r ;

sbq = sb + q ;

scq = sc + q ;

cbassets = (1/(1+Mc_Sc))*sc + (Mc_Sc /(1 + Mc_Sc))*mc; % nb book value!!
end;

% initval; 
% y=0 ;
% c=0 ;
% end;


shocks;
var  shk_i = 1;%0.0025^2 ; %
end;

stoch_simul(order=1,irf=20,nograph,noprint) ;

% plot a picture
% cpi_shk_i = cumsum( pi_shk_i ) ; % define cpi level irf
% iann_shk_i = 4*i_shk_i         ; % annualise the policy rate

% vars = [ y_shk_i cpi_shk_i iann_shk_i cbassets_shk_i sb_shk_i ] ;
% labels={'GDP','CPI (level)','Interest rate (annual)','Commercial banks assets','Shadow bank assets'} ;

% figure('Name','The Badger'), 
% for i=1:5
%    subplot(3,2,i), hold all
%    plot( zeros(1,options_.irf), 'g')
%    plot( 100.*vars(:,i) ,'ko-')
%    title(labels(i))
%    ylabel('Per cent')
%    xlabel('Quarters')
% end

