main_path <- getwd()
setwd(paste0(main_path,"/data"))

data1 <- read.delim("earn1.dat", sep = " ", header = FALSE, stringsAsFactors = FALSE)
data1 <- unlist(data.frame(t(data1)))
data1 <- data1[!is.na(data1)]
data1 <- ifelse(data1 == "99999999.9", NA, data1)
data1 <- data.frame(matrix(data1, ncol = 9, byrow = TRUE))
colnames(data1) <- c("w", "Union", "UR", "Prod", "constant", "D7475", "D7579", "Wedge", "time_trend")
data1 <- ts(data1, start = c(1969, 01), frequency = 4)

data2 <- read.delim("earn2.dat", sep = " ", header = FALSE, stringsAsFactors = FALSE)
data2 <- unlist(data.frame(t(data2)))
data2 <- data2[!is.na(data2)]
data2 <- ifelse(data2 == "99999999.9", NA, data2)
data2 <- data.frame(matrix(data2, ncol = 26, byrow = TRUE))
colnames(data2) <- c("ERPR", "UDEN", "GDPMS", "FCAS", "CGGS", "PBRENT", "YOG", "RXD", "GDPA", "CGG",
                     "TYEM", "EENIC", "WFP", "YPROM", "YMF", "EMF", "ENMF", "EMPNIC", "NIS", "OCR",
                     "ILOU", "WFEMP", "RPIX", "PYNONG", "TE", "TD")

data_narrow <- ts(data.frame(w = log(data2$ERPR/data2$PYNONG), 
                      Prod = log((data2[, "YPROM"]+278.29 * data2[, "YMF"])/(data2[, "EMF"]+data2[, "ENMF"])), 
                      UR = log(100 * data2[, "ILOU"]/(data2[, "ILOU"]+data2[, "WFEMP"])), 
                      Wedge = log(1+data2[, "TE"]) + log(1-data2[, "TD"]) - log(data2[, "RPIX"]/data2[,"PYNONG"]), 
                      Union = log(data2[, "UDEN"]), 
                      D7475 = data1[, "D7475"], 
                      D7579 = data1[, "D7579"]), 
           start = c(1969, 01), frequency = 4)
data_narrow <- window(data_narrow, start = c(1970, 01))
data_clean_narrow <- cbind(time(data_narrow), data_narrow)
colnames(data_clean_narrow) <- c("time", colnames(data_narrow))

write.csv(data_clean_narrow, "data_clean_narrow.csv", row.names = FALSE)
rm(data1, data2, data_clean_narrow)

setwd(main_path)
