* This do-file constructs portfolios from SCF2004

* GENERATE AGGREGATE VARIABLES
gen irahead = x6551 + x6552 + x6553 + x6554 /* IRA-KEOGH accounts of the head */
gen irapart = x6559 + x6560 + x6561 + x6562 /* IRA-KEOGH accounts of the partner */
gen iraother = x6567 + x6568 + x6569 + x6570 /* IRA-KEOGH accounts of other household members */
gen retacc = x6462 + x6467 + x6472 + x6477 + x6482 + x6487 + x5604 + x5612 + x5620 + x5628 + x5636 + x5644 /* Retirement accounts */
gen ann = x6577 + x6587 /* Annuities */

************************************************************
* CONSTRUCT THE AGGREGATES TO BE CONSIDERED IN THE ANALYSIS

* TRANSACTION ACCOUNTS (DEPOSITS)
* includes checking accounts, savings accounts, brokerage accounts,
* and part of IRA-KEOGH and retirement accounts, annuities, and trust-managed accounts

gen tranchk = x3506 + x3510 + x3514 + x3518 + x3522 + x3526 + x3529 /* Checking accounts */
gen transav = x3730 + x3736 + x3742 + x3748 + x3754 + x3760 + x3765 /* Savings-money market accounts */
gen tranbrok = x3930 /* Brokerage accounts */
gen tranira = 0
replace tranira = tranira + irahead if x6555==2 /* IRA-KEOGH accounts invested in int. earning assets */
replace tranira = tranira + irapart if x6563==2 /* IRA-KEOGH accounts invested in int. earning assets */
replace tranira = tranira + iraother if x6571==2 /* IRA-KEOGH accounts invested in int. earning assets */
gen tranret = 0
replace tranret = tranret + x6462 if x6933==2 /* Retirement accounts invested in int. earning assets */
replace tranret = tranret + x6467 if x6937==2 /* Retirement accounts invested in int. earning assets */
replace tranret = tranret + x6472 if x6941==2 /* Retirement accounts invested in int. earning assets */
replace tranret = tranret + x6477 if x6945==2 /* Retirement accounts invested in int. earning assets */
replace tranret = tranret + x6482 if x6949==2 /* Retirement accounts invested in int. earning assets */
replace tranret = tranret + x6487 if x6953==2 /* Retirement accounts invested in int. earning assets */
replace tranret = tranret + x5604 if x6962==2 /* Previous retirement accounts invested in int. earning assets */
replace tranret = tranret + x5612 if x6968==2 /* Previous retirement accounts invested in int. earning assets */
replace tranret = tranret + x5620 if x6974==2 /* Previous retirement accounts invested in int. earning assets */
replace tranret = tranret + x5628 if x6980==2 /* Previous retirement accounts invested in int. earning assets */
replace tranret = tranret + x5636 if x6986==2 /* Previous retirement accounts invested in int. earning assets */
replace tranret = tranret + x5644 if x6992==2 /* Previous retirement accounts invested in int. earning assets */
gen tranann = 0
replace tranann = tranann + x6577 if x6581==2 /* Annuities invested in int. earning assets */
gen trantru = 0
replace trantru = trantru + x6587 if x6591==2 /* Trust-managed accounts invested in int. earning assets */

gen tran = tranchk + transav + tranbrok + tranira + tranret + tranann + trantru


* GOVERNMENT BONDS
* includes certificates of deposits, savings bonds, bond mutual funds, life insurance, mortgage, and lines of credit
* mortgage and lines of credit are negative

gen govcrt = x3721 /* Certificates of deposit */
gen govsav = x3902 /* Savings bonds (Gov't bonds) */
gen govtax = 0
replace govtax = govtax + x3824 /* Tax-free bond mutual funds */
gen govmut = 0
replace govmut = govmut + x3826 /* Gov't bond mutual funds */
gen govlif = x4006-x4010 /* Life insurance */

gen govbond = govcrt + govsav + govtax + govmut + govlif 


* CORPORATE BONDS
* includes market value of bonds, bond mutual funds, 1/2 balanced mutual funds,
* and part of IRA-KEOGH and retirement accounts, annuities and trust-managed accounts

gen cormkt = x7635 + x7636 + x7637 + x7638 + x7639 /* Market value corporate bonds */
gen coroth = x3828 /* Other bond mutual funds */
gen corbal = x3830/2 /* Balanced mutual funds */
gen corotm = x7787/2 /* Other mutual funds */
gen corira = 0
replace corira = corira + irahead*(1-x6556/10000) if x6555==3 /* IRA-KEOGH accounts invested in stocks and other assets */
replace corira = corira + irapart*(1-x6564/10000) if x6563==3 /* IRA-KEOGH accounts invested in stocks and other assets */
replace corira = corira + iraother*(1-x6572/10000) if x6571==3 /* IRA-KEOGH accounts invested in stocks and other assets */
replace corira = corira + irahead if x6555==6 /* IRA-KEOGH accounts invested in annuities */
replace corira = corira + irapart if x6563==6 /* IRA-KEOGH accounts invested in annuities */
replace corira = corira + iraother if x6571==6 /* IRA-KEOGH accounts invested in annuities */
replace corira = corira + irahead if x6555==-7 /* IRA-KEOGH accounts invested in other assets */
replace corira = corira + irapart if x6563==-7 /* IRA-KEOGH accounts invested in other assets */
replace corira = corira + iraother if x6571==-7 /* IRA-KEOGH accounts invested in other assets */
gen corret = 0
replace corret = corret + x6462*(1-x6934/10000) if x6933==3 /* Retirement accounts invested in stocks and other assets */
replace corret = corret + x6467*(1-x6938/10000) if x6937==3 /* Retirement accounts invested in stocks and other assets */
replace corret = corret + x6472*(1-x6942/10000) if x6941==3 /* Retirement accounts invested in stocks and other assets */
replace corret = corret + x6477*(1-x6946/10000) if x6945==3 /* Retirement accounts invested in stocks and other assets */
replace corret = corret + x6482*(1-x6950/10000) if x6949==3 /* Retirement accounts invested in stocks and other assets */
replace corret = corret + x6487*(1-x6954/10000) if x6953==3 /* Retirement accounts invested in stocks and other assets */
replace corret = corret + x6462 if x6933==6 /* Retirement accounts invested in annuities */
replace corret = corret + x6467 if x6937==6 /* Retirement accounts invested in annuities */
replace corret = corret + x6472 if x6941==6 /* Retirement accounts invested in annuities */
replace corret = corret + x6477 if x6945==6 /* Retirement accounts invested in annuities */
replace corret = corret + x6482 if x6949==6 /* Retirement accounts invested in annuities */
replace corret = corret + x6487 if x6953==6 /* Retirement accounts invested in annuities */
replace corret = corret + x6462 if x6933==-7 /* Retirement accounts invested in other assets */
replace corret = corret + x6467 if x6937==-7 /* Retirement accounts invested in other assets */
replace corret = corret + x6472 if x6941==-7 /* Retirement accounts invested in other assets */
replace corret = corret + x6477 if x6945==-7 /* Retirement accounts invested in other assets */
replace corret = corret + x6482 if x6949==-7 /* Retirement accounts invested in other assets */
replace corret = corret + x6487 if x6953==-7 /* Retirement accounts invested in other assets */
replace corret = corret + x5604*(1-x6963/10000) if x6962==3 /* Previous retirement accounts invested in stocks and other assets */
replace corret = corret + x5612*(1-x6969/10000) if x6968==3 /* Previous retirement accounts invested in stocks and other assets */
replace corret = corret + x5620*(1-x6975/10000) if x6974==3 /* Previous retirement accounts invested in stocks and other assets */
replace corret = corret + x5628*(1-x6981/10000) if x6980==3 /* Previous retirement accounts invested in stocks and other assets */
replace corret = corret + x5636*(1-x6987/10000) if x6986==3 /* Previous retirement accounts invested in stocks and other assets */
replace corret = corret + x5644*(1-x6993/10000) if x6992==3 /* Previous retirement accounts invested in stocks and other assets */
replace corret = corret + x5604 if x6962==6 /* Previous retirement accounts invested in annuities */
replace corret = corret + x5612 if x6968==6 /* Previous retirement accounts invested in annuities */
replace corret = corret + x5620 if x6974==6 /* Previous retirement accounts invested in annuities */
replace corret = corret + x5628 if x6980==6 /* Previous retirement accounts invested in annuities */
replace corret = corret + x5636 if x6986==6 /* Previous retirement accounts invested in annuities */
replace corret = corret + x5644 if x6992==6 /* Previous retirement accounts invested in annuities */
replace corret = corret + x5604 if x6962==-7 /* Previous retirement accounts invested in other assets */
replace corret = corret + x5612 if x6968==-7 /* Previous retirement accounts invested in other assets */
replace corret = corret + x5620 if x6974==-7 /* Previous retirement accounts invested in other assets  */
replace corret = corret + x5628 if x6980==-7 /* Previous retirement accounts invested in other assets  */
replace corret = corret + x5636 if x6986==-7 /* Previous retirement accounts invested in other assets  */
replace corret = corret + x5644 if x6992==-7 /* Previous retirement accounts invested in other assets */
gen corann = 0
replace corann = corann + x6577*(1-x6582/10000) if x6581==3 /* Annuities invested in stocks and other assets */
replace corann = corann + x6577 if x6581==6 /* Annuities invested in annuities */
replace corann = corann + x6577 if x6581==-7 /* Annuities invested in other assets */
gen cortru = 0
replace cortru = cortru + x6587*(1-x6592/10000) if x6591==3 /* Trust-managed accounts invested in stocks and other assets */
replace cortru = cortru + x6587 if x6591==6 /* Trust-managed accounts invested in annuities */
replace cortru = cortru + x6587 if x6591==-7 /* Trust-managed accounts invested in other assets */

gen corbond = cormkt + coroth + corbal + corotm + corira + corret + corann + cortru


* STOCKS
* includes directly held stocks, stock mutual funds, 1/2 balanced mutual funds,
* and part of IRA-KEOGH and retirement accounts, annuities and trust-managed accounts

gen stosh = x3915 /* Directly-held stocks */
gen stomut = x3822 /* Stock mutual funds */
gen stobal = x3830/2 /* Balanced mutual funds */
gen stooth = x7787/2 /* Other mutual funds */
gen stoira = 0
replace stoira = stoira + irahead if x6555==1 /* IRA-KEOGH accounts invested in stocks */
replace stoira = stoira + irapart if x6563==1 /* IRA-KEOGH accounts invested in stocks */
replace stoira = stoira + iraother if x6571==1 /* IRA-KEOGH accounts invested in stocks */
replace stoira = stoira + irahead*x6556/10000 if x6555==3 /* IRA-KEOGH accounts invested in stocks and other assets */
replace stoira = stoira + irapart*x6564/10000 if x6563==3 /* IRA-KEOGH accounts invested in stocks and other assets */
replace stoira = stoira + iraother*x6572/10000 if x6571==3 /* IRA-KEOGH accounts invested in stocks and other assets */
replace stoira = stoira + irahead if x6555==5 /* IRA-KEOGH accounts invested in hedge funds */
replace stoira = stoira + irapart if x6563==5 /* IRA-KEOGH accounts invested in hedge funds */
replace stoira = stoira + iraother if x6571==5 /* IRA-KEOGH accounts invested in hedge funds */
replace stoira = stoira + irahead if x6555==8 /* IRA-KEOGH accounts invested in mineral rights */
replace stoira = stoira + irapart if x6563==8 /* IRA-KEOGH accounts invested in mineral rights */
replace stoira = stoira + iraother if x6571==8 /* IRA-KEOGH accounts invested in mineral rights */
gen storet = 0
replace storet = storet + x6462 if x6933==1 /* Retirement accounts invested in stocks */
replace storet = storet + x6467 if x6937==1 /* Retirement accounts invested in stocks */
replace storet = storet + x6472 if x6941==1 /* Retirement accounts invested in stocks */
replace storet = storet + x6477 if x6945==1 /* Retirement accounts invested in stocks */
replace storet = storet + x6482 if x6949==1 /* Retirement accounts invested in stocks */
replace storet = storet + x6487 if x6953==1 /* Retirement accounts invested in stocks */
replace storet = storet + x6462*x6934/10000 if x6933==3 /* Retirement accounts invested in stocks and other assets */
replace storet = storet + x6467*x6938/10000 if x6937==3 /* Retirement accounts invested in stocks and other assets */
replace storet = storet + x6472*x6942/10000 if x6941==3 /* Retirement accounts invested in stocks and other assets */
replace storet = storet + x6477*x6946/10000 if x6945==3 /* Retirement accounts invested in stocks and other assets */
replace storet = storet + x6482*x6950/10000 if x6949==3 /* Retirement accounts invested in stocks and other assets */
replace storet = storet + x6487*x6954/10000 if x6953==3 /* Retirement accounts invested in stocks and other assets */
replace storet = storet + x6462 if x6933==5 /* Retirement accounts invested in hedge funds */
replace storet = storet + x6467 if x6937==5 /* Retirement accounts invested in hedge funds */
replace storet = storet + x6472 if x6941==5 /* Retirement accounts invested in hedge funds */
replace storet = storet + x6477 if x6945==5 /* Retirement accounts invested in hedge funds */
replace storet = storet + x6482 if x6949==5 /* Retirement accounts invested in hedge funds */
replace storet = storet + x6487 if x6953==5 /* Retirement accounts invested in hedge funds */
replace storet = storet + x6462 if x6933==8 /* Retirement accounts invested in mineral rights */
replace storet = storet + x6467 if x6937==8 /* Retirement accounts invested in mineral rights */
replace storet = storet + x6472 if x6941==8 /* Retirement accounts invested in mineral rights */
replace storet = storet + x6477 if x6945==8 /* Retirement accounts invested in mineral rights */
replace storet = storet + x6482 if x6949==8 /* Retirement accounts invested in mineral rights */
replace storet = storet + x6487 if x6953==8 /* Retirement accounts invested in mineral rights */
replace storet = storet + x5604 if x6962==1 /* Previous retirement accounts invested in stocks */
replace storet = storet + x5612 if x6968==1 /* Previous retirement accounts invested in stocks */
replace storet = storet + x5620 if x6974==1 /* Previous retirement accounts invested in stocks */
replace storet = storet + x5628 if x6980==1 /* Previous retirement accounts invested in stocks */
replace storet = storet + x5636 if x6986==1 /* Previous retirement accounts invested in stocks */
replace storet = storet + x5644 if x6992==1 /* Previous retirement accounts invested in stocks */
replace storet = storet + x5604*x6963/10000 if x6962==3 /* Previous retirement accounts invested in stocks and other assets */
replace storet = storet + x5612*x6969/10000 if x6968==3 /* Previous retirement accounts invested in stocks and other assets */
replace storet = storet + x5620*x6975/10000 if x6974==3 /* Previous retirement accounts invested in stocks and other assets */
replace storet = storet + x5628*x6981/10000 if x6980==3 /* Previous retirement accounts invested in stocks and other assets */
replace storet = storet + x5636*x6987/10000 if x6986==3 /* Previous retirement accounts invested in stocks and other assets */
replace storet = storet + x5644*x6993/10000 if x6992==3 /* Previous retirement accounts invested in stocks and other assets */
replace storet = storet + x5604 if x6962==5 /* Previous retirement accounts invested in hedge funds */
replace storet = storet + x5612 if x6968==5 /* Previous retirement accounts invested in hedge funds */
replace storet = storet + x5620 if x6974==5 /* Previous retirement accounts invested in hedge funds */
replace storet = storet + x5628 if x6980==5 /* Previous retirement accounts invested in hedge funds */
replace storet = storet + x5636 if x6986==5 /* Previous retirement accounts invested in hedge funds */
replace storet = storet + x5644 if x6992==5 /* Previous retirement accounts invested in hedge funds */
replace storet = storet + x5604 if x6962==8 /* Previous retirement accounts invested in mineral rights */
replace storet = storet + x5612 if x6968==8 /* Previous retirement accounts invested in mineral rights */
replace storet = storet + x5620 if x6974==8 /* Previous retirement accounts invested in mineral rights */
replace storet = storet + x5628 if x6980==8 /* Previous retirement accounts invested in mineral rights */
replace storet = storet + x5636 if x6986==8 /* Previous retirement accounts invested in mineral rights */
replace storet = storet + x5644 if x6992==8 /* Previous retirement accounts invested in mineral rights */
gen stoann = 0
replace stoann = stoann + x6577 if x6581==1 /* Annuities invested in stocks */
replace stoann = stoann + x6577*x6582/10000 if x6581==3 /* Annuities invested in stocks and other assets */
replace stoann = stoann + x6577 if x6581==5 /* Annuities invested in hedge funds */
replace stoann = stoann + x6577 if x6581==8 /* Annuities invested in mineral rights */
gen stotru = 0
replace stotru = stotru + x6587 if x6591==1 /* Trust-managed accounts invested in stocks */
replace stotru = stotru + x6587*x6592/10000 if x6591==3 /* Trust-managed invested in stocks and other assets */
replace stotru = stotru + x6587 if x6591==5 /* Trust-managed accounts invested in hedge funds */
replace stotru = stotru + x6587 if x6591==8 /* Trust-managed accounts invested in mineral rights */

gen stock = stosh + stomut + stobal + stooth + stoira + storet + stoann + stotru


************************************************************
* CONSTRUCT THE WEIGHTS FROM THESE AGGREGATES

gen wth = tran + govbond + corbond + stock
gen wtran = tran/wth
gen wgovbond = govbond/wth
gen wcorbond = corbond/wth
gen wstock = stock/wth


************************************************************
* DEFINE PORTFOLIO LABELS

label variable tran "Transaction accounts"
label variable govbond "Government bonds"
label variable corbond "Corporate bonds"
label variable stock "Stocks"
label variable wth "Household wealth"
label variable wtran "Transaction accounts weight"
label variable wgovbond "Government bond weight"
label variable wcorbond "Corporate bond weight"
label variable wstock "Stock weight"


************************************************************
* Drop some observations and save
gen flag = 0
replace flag = 1 if wth<=0 | wtran<0 | wgovbond<0 | wcorbond<0 | wstock<0 
egen eflag = sum(flag),by(id)
drop if eflag > 0

keep id imp x42001 x5702 x5729 x101 x8021 x8022 x8023 x5901 x6809 x6030 x4100 x4106 x7402 x7401 x4112 x4113 ///
x5306 x5307 x103 x104 x105 x6101 x6810 x6124 x4700 x4706 x7412 x7411 x4712 x4713 x5311 x5312 x301 x7112 ///
tran govbond corbond stock wth wtran wgovbond wcorbond wstock x30*



