* This do-file must be run after EXTRACT and collapse all the imputed values

sort id  /* observation id */
egen wgt = mean(x42001),by(id) /* sampling weight */
egen famimp = count(imp),by(id) /* number of observation imputations */
egen famlabinc = mean(x5702),by(id) /* family income before taxes, from wages and salaries */
replace famlabinc = 0 if famlabinc < 0
egen famtotinc = mean(x5729),by(id) /* total family income before taxes */
replace famtotinc = 0 if famtotinc < 0
ren x101 fammembers 	/* people in the household */
ren x301 futexp 		/* expectations for the future */
ren x302 intrateexp	/* interest rate expectations */
ren x3014 riskatt		/* risk attitude */
sort id
by id: egen invadv = mean(x7112) /* investment advisor */
by id: egen headsex = mean(x8021) /* sex head */
by id: egen headage = mean(x8022) /* age head */
by id: egen headmarr = mean(x8023) /* marital status head */
by id: egen headeduc = mean(x5901) /* education head */
by id: egen headrace = mean(x6809) /* race head */
by id: egen headhealth = mean(x6030) /* self-assessed health head */
by id: egen headwork = mean(x4100) /* work status of the head */
by id: egen headempl = mean(x4106) /* employed or self-employed status of the head */
by id: egen headbusi = mean(x7402) /* kind of business-industry of the head */
by id: egen headjob = mean(x7401) /* primary job position of the head */
by id: egen headinc = mean(x4112) /* income before taxes of the head */
by id: egen headincfreq = mean(x4113) /* income frequency of the head */
by id: egen headpens = mean(x5306) /* pension of the head */
by id: egen headpensfreq = mean(x5307) /* pension frequency of the head */
by id: egen partsex = mean(x103) /* sex partner */
by id: egen partage = mean(x104) /* age partner */
by id: egen partmarr = mean(x105) /* marital status partner */
by id: egen parteduc = mean(x6101) /* education partner */
by id: egen partrace = mean(x6810) /* race partner */
by id: egen parthealth = mean(x6124) /* self-assessed health partner */
by id: egen partwork = mean(x4700) /* work status of the partner */
by id: egen partempl = mean(x4706) /* employed or self-employed status of the partner */
by id: egen partbusi = mean(x7412) /* kind of business-industry of the partner */
by id: egen partjob = mean(x7411) /* primary job position of the partner */
by id: egen partinc = mean(x4712) /* income before taxes of the partner */
by id: egen partincfreq = mean(x4713) /* income frequency of the partner */
by id: egen partpens = mean(x5311) /* pension of the partner */
by id: egen partpensfreq = mean(x5312) /* pension frequency of the partner */

cap drop mtran mgovbnd mcorbnd mstock 
by id: egen mtran = mean(tran) /* transaction accounts (deposits) */
by id: egen mgovbnd = mean(govbond) /* government bonds */
by id: egen mcorbnd = mean(corbond) /* corporate bonds */
by id: egen mstock = mean(stock) /* stocks */
by id: egen mwth = mean(wth) /* household total wealth */
by id: egen mwtran = mean(wtran) /* weight trasaction accounts */
by id: egen mwgovbnd = mean(wgovbond) /* weight government bonds */
by id: egen mwcorbnd = mean(wcorbond) /* weight corporate bonds */
by id: egen mwstock = mean(wstock) /* weight stocks */

keep if imp == 1

keep id wgt fam* head* part* futexp intrateexp riskatt invadv mtran mgovbnd mcorbnd mstock mwth mwtran mwgovbnd mwcorbnd mwstock 

rename mtran tran
rename mgovbnd govbnd
rename mcorbnd corbnd
rename mstock stock
rename mwth wth
rename mwtran wtran
rename mwgovbnd wgovbnd
rename mwcorbnd wcorbnd
rename mwstock wstock

